/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.process;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Properties;
import java.util.TimeZone;
import java.util.logging.Level;
import jpiere.base.plugin.org.adempiere.model.X_I_GLJournalJP;
import org.adempiere.process.ImportProcess;
import org.adempiere.util.IProcessUI;
import org.compiere.model.MAccount;
import org.compiere.model.MCalendar;
import org.compiere.model.MJournal;
import org.compiere.model.MJournalLine;
import org.compiere.model.MPeriod;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;

public class JPiereImportGLJournal
extends SvrProcess
implements ImportProcess {
    private int m_AD_Client_ID = 0;
    private boolean p_deleteOldImported = false;
    private boolean p_IsValidateOnly = false;
    private String p_DocAction = "DR";
    public static final String JP_CollateGLJournalPolicy_Document = "DN";
    public static final String JP_CollateGLJournalPolicy_DataMigrationIdentifier = "MI";
    public static final String JP_CollateGLJournalPolicy_DoNotCollateWithExistingData = "NO";
    private String p_JP_CollateGLJournalPolicy = "DN";
    public static final String JP_ReimportPolicy_DeleteExistingData = "DD";
    public static final String JP_ReimportPolicy_NotImport = "NI";
    private String p_JP_ReimportPolicy = "NI";
    private boolean p_IsReleaseDocControlledJP = false;
    private IProcessUI processMonitor = null;
    private int[] releaseDocControll_ElementValue_IDs = null;
    private String message = null;
    private long startTime = System.currentTimeMillis();

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (name.equals("DeleteOldImported")) {
                this.p_deleteOldImported = "Y".equals(para[i].getParameter());
            } else if (name.equals("IsValidateOnly")) {
                this.p_IsValidateOnly = para[i].getParameterAsBoolean();
            } else if (name.equals("DocAction")) {
                this.p_DocAction = para[i].getParameterAsString();
            } else if (name.equals("JP_CollateGLJournalPolicy")) {
                this.p_JP_CollateGLJournalPolicy = para[i].getParameterAsString();
            } else if (name.equals("JP_ReimportPolicy")) {
                this.p_JP_ReimportPolicy = para[i].getParameterAsString();
            } else if (name.equals("IsReleaseDocControlledJP")) {
                this.p_IsReleaseDocControlledJP = para[i].getParameterAsBoolean();
            } else {
                this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
            }
            ++i;
        }
        this.m_AD_Client_ID = this.getProcessInfo().getAD_Client_ID();
    }

    protected String doIt() throws Exception {
        this.processMonitor = Env.getProcessUI((Properties)this.getCtx());
        StringBuilder sql = null;
        int no = 0;
        String clientCheck = this.getWhereClause();
        if (this.p_deleteOldImported) {
            sql = new StringBuilder("DELETE I_GLJournalJP ").append("WHERE I_IsImported='Y'").append(clientCheck);
            no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("Delete Old Impored =" + no);
            }
        }
        sql = new StringBuilder("UPDATE I_GLJournalJP ").append("SET I_ErrorMsg='' ").append(" WHERE I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine(String.valueOf(no));
            }
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + sql);
        }
        ModelValidationEngine.get().fireImportValidate((ImportProcess)this, null, null, 10);
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"C_AcctSchema_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        if (!this.reverseLookupC_AcctSchema_ID()) {
            return this.message;
        }
        this.commitEx();
        if (!this.p_JP_CollateGLJournalPolicy.equals(JP_CollateGLJournalPolicy_DoNotCollateWithExistingData)) {
            this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"GL_Journal_ID");
            if (this.processMonitor != null) {
                this.processMonitor.statusUpdate(this.message);
            }
            if (!this.reverseLookupGL_Journal_ID()) {
                return this.message;
            }
            this.commitEx();
            this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"GL_JournalLine_ID");
            if (this.processMonitor != null) {
                this.processMonitor.statusUpdate(this.message);
            }
            if (this.reverseLookupGL_JournalLine_ID()) {
                this.commitEx();
            } else {
                return this.message;
            }
        }
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"AD_Org_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        if (!this.reverseLookupAD_Org_ID()) {
            return this.message;
        }
        this.commitEx();
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"AD_OrgTrx_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        if (!this.reverseLookupAD_OrgTrx_ID()) {
            return this.message;
        }
        this.commitEx();
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"GL_Budget_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        if (!this.reverseLookupGL_Budget_ID()) {
            return this.message;
        }
        this.commitEx();
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"C_DocType_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        if (!this.reverseLookupC_DocType_ID()) {
            return this.message;
        }
        this.commitEx();
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"GL_Category_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        if (!this.reverseLookupGL_Category_ID()) {
            return this.message;
        }
        this.commitEx();
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"C_Currency_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        if (!this.reverseLookupC_Currency_ID()) {
            return this.message;
        }
        this.commitEx();
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"C_ConversionType_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        if (!this.reverseLookupC_ConversionType_ID()) {
            return this.message;
        }
        this.commitEx();
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"Account_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        if (!this.reverseLookupAccount_ID()) {
            return this.message;
        }
        this.commitEx();
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"C_SubAcct_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        if (!this.reverseLookupC_SubAcct_ID()) {
            return this.message;
        }
        this.commitEx();
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"C_UOM_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        if (!this.reverseLookupC_UOM_ID()) {
            return this.message;
        }
        this.commitEx();
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"C_BPartner_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        if (!this.reverseLookupC_BPartner_ID()) {
            return this.message;
        }
        this.commitEx();
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"M_Product_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        if (!this.reverseLookupM_Product_ID()) {
            return this.message;
        }
        this.commitEx();
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"C_Project_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        if (!this.reverseLookupC_Project_ID()) {
            return this.message;
        }
        this.commitEx();
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"C_ProjectPhase_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        if (!this.reverseLookupC_ProjectPhase_ID()) {
            return this.message;
        }
        this.commitEx();
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"C_ProjectTask_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        if (!this.reverseLookupC_ProjectTask_ID()) {
            return this.message;
        }
        this.commitEx();
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"C_SalesRegion_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        if (!this.reverseLookupC_SalesRegion_ID()) {
            return this.message;
        }
        this.commitEx();
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"C_Campaign_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        if (!this.reverseLookupC_Campaign_ID()) {
            return this.message;
        }
        this.commitEx();
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"C_Activity_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        if (!this.reverseLookupC_Activity_ID()) {
            return this.message;
        }
        this.commitEx();
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"C_LocFrom_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        if (!this.reverseLookupC_LocFrom_ID()) {
            return this.message;
        }
        this.commitEx();
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"C_LocTo_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        if (!this.reverseLookupC_LocTo_ID()) {
            return this.message;
        }
        this.commitEx();
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"User1_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        if (!this.reverseLookupUser1_ID()) {
            return this.message;
        }
        this.commitEx();
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"User2_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        if (!this.reverseLookupUser2_ID()) {
            return this.message;
        }
        this.commitEx();
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"A_Asset_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        if (!this.reverseLookupA_Asset_ID()) {
            return this.message;
        }
        this.commitEx();
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"M_Locator_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        if (!this.reverseLookupM_Locator_ID()) {
            return this.message;
        }
        this.commitEx();
        ModelValidationEngine.get().fireImportValidate((ImportProcess)this, null, null, 20);
        if (this.p_IsValidateOnly) {
            this.commitEx();
            return "Validated";
        }
        if (this.p_IsReleaseDocControlledJP) {
            this.releaseDocControll_ElementValue_IDs = PO.getAllIDs((String)"C_ElementValue", (String)("IsSummary='N' AND IsDocControlled='Y' AND AD_Client_ID=" + this.getAD_Client_ID()), (String)this.get_TrxName());
            String updateSQL = "UPDATE C_ElementValue SET IsDocControlled='N' WHERE IsSummary='N' AND IsDocControlled='Y' AND AD_Client_ID=?";
            int updateNum = DB.executeUpdate((String)updateSQL, (int)this.getAD_Client_ID(), (String)this.get_TrxName());
            this.commitEx();
        }
        sql = new StringBuilder("SELECT * FROM I_GLJournalJP WHERE I_IsImported='N' ").append(clientCheck);
        if (this.p_JP_CollateGLJournalPolicy.equals(JP_CollateGLJournalPolicy_Document)) {
            sql.append(" ORDER BY DocumentNo, Line ");
        } else if (this.p_JP_CollateGLJournalPolicy.equals(JP_CollateGLJournalPolicy_DataMigrationIdentifier)) {
            sql.append(" ORDER BY JP_DataMigration_Identifier, DocumentNo, Line ");
        } else if (this.p_JP_CollateGLJournalPolicy.equals(JP_CollateGLJournalPolicy_DoNotCollateWithExistingData)) {
            sql.append(" ORDER BY JP_DataMigration_Identifier, DocumentNo, Line ");
        } else {
            sql.append(" ORDER BY JP_DataMigration_Identifier, DocumentNo, Line ");
        }
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        int recordsNum = 0;
        int skipNum = 0;
        int errorNum = 0;
        int successNum = 0;
        int successCreateDocHeader = 0;
        int successCreateDocLine = 0;
        int failureCreateDocHeader = 0;
        int failureCreateDocLine = 0;
        String records = Msg.getMsg((Properties)this.getCtx(), (String)"JP_NumberOfRecords");
        String skipRecords = Msg.getMsg((Properties)this.getCtx(), (String)"JP_NumberOfSkipRecords");
        String errorRecords = Msg.getMsg((Properties)this.getCtx(), (String)"JP_NumberOfUnexpectedErrorRecords");
        String success = Msg.getMsg((Properties)this.getCtx(), (String)"JP_Success");
        String failure = Msg.getMsg((Properties)this.getCtx(), (String)"JP_Failure");
        String createHeader = Msg.getMsg((Properties)this.getCtx(), (String)"JP_CreateHeader");
        String createLine = Msg.getMsg((Properties)this.getCtx(), (String)"JP_CreateLine");
        String detail = Msg.getMsg((Properties)this.getCtx(), (String)"JP_DetailLog");
        try {
            try {
                pstmt = DB.prepareStatement((String)sql.toString(), (String)this.get_TrxName());
                rs = pstmt.executeQuery();
                String lastJP_DataMigration_Identifier = "";
                String lastDocumentNo = "";
                MJournal journal = null;
                MJournalLine journalLine = null;
                String deleteSQL_Fact_ACCT = "DELETE FACT_ACCT WHERE AD_Table_ID=224 AND Record_ID=?";
                String deleteSQL_JournalLine = "DELETE GL_JournalLine WHERE GL_Journal_ID=?";
                String deleteSQL_Journal = "DELETE GL_Journal WHERE GL_Journal_ID=?";
                while (rs.next()) {
                    ++recordsNum;
                    X_I_GLJournalJP imp = new X_I_GLJournalJP(this.getCtx(), rs, this.get_TrxName());
                    if (imp.getGL_Journal_ID() != 0 && this.p_JP_ReimportPolicy.equals(JP_ReimportPolicy_NotImport)) {
                        ++skipNum;
                        String msg = Msg.getMsg((Properties)this.getCtx(), (String)"AlreadyExists");
                        imp.setI_ErrorMsg(msg);
                        imp.setI_IsImported(false);
                        imp.setProcessed(false);
                        imp.saveEx(this.get_TrxName());
                        this.commitEx();
                        if (this.processMonitor == null) continue;
                        this.processMonitor.statusUpdate(String.valueOf(records) + " : " + recordsNum + " = " + skipRecords + " : " + skipNum + " + " + errorRecords + " : " + errorNum + " + " + success + " : " + successNum + "   [" + detail + " --> " + createHeader + "( " + success + " : " + successCreateDocHeader + "  /  " + failure + " : " + failureCreateDocHeader + " ) + " + createLine + " ( " + success + " : " + successCreateDocLine + "  /  " + failure + " : " + failureCreateDocLine + " ) ]");
                        continue;
                    }
                    boolean isCreateHeader = true;
                    if (this.p_JP_CollateGLJournalPolicy.equals(JP_CollateGLJournalPolicy_DataMigrationIdentifier)) {
                        if (!Util.isEmpty((String)lastJP_DataMigration_Identifier) && lastJP_DataMigration_Identifier.equals(imp.getJP_DataMigration_Identifier())) {
                            isCreateHeader = false;
                            if (journal.getGL_Journal_ID() == 0) {
                                ++errorNum;
                                String msg = Msg.getMsg((Properties)this.getCtx(), (String)"JP_UnexpectedError");
                                imp.setI_ErrorMsg(msg);
                                imp.setI_IsImported(false);
                                imp.setProcessed(false);
                                imp.saveEx(this.get_TrxName());
                                this.commitEx();
                                if (this.processMonitor == null) continue;
                                this.processMonitor.statusUpdate(String.valueOf(records) + " : " + recordsNum + " = " + skipRecords + " : " + skipNum + " + " + errorRecords + " : " + errorNum + " + " + success + " : " + successNum + "   [" + detail + " --> " + createHeader + "( " + success + " : " + successCreateDocHeader + "  /  " + failure + " : " + failureCreateDocHeader + " ) + " + createLine + " ( " + success + " : " + successCreateDocLine + "  /  " + failure + " : " + failureCreateDocLine + " ) ]");
                                continue;
                            }
                        } else {
                            if (journal != null && journal.getGL_Journal_ID() != 0) {
                                if (!Util.isEmpty((String)this.p_DocAction)) {
                                    journal.processIt(this.p_DocAction);
                                }
                                journal.saveEx(this.get_TrxName());
                                this.commitEx();
                            }
                            lastJP_DataMigration_Identifier = imp.getJP_DataMigration_Identifier();
                            lastDocumentNo = imp.getDocumentNo();
                        }
                    } else if (this.p_JP_CollateGLJournalPolicy.equals(JP_CollateGLJournalPolicy_Document)) {
                        if (!Util.isEmpty((String)lastDocumentNo) && lastDocumentNo.equals(imp.getDocumentNo())) {
                            isCreateHeader = false;
                            if (journal.getGL_Journal_ID() == 0) {
                                ++errorNum;
                                String msg = Msg.getMsg((Properties)this.getCtx(), (String)"JP_UnexpectedError");
                                imp.setI_ErrorMsg(msg);
                                imp.setI_IsImported(false);
                                imp.setProcessed(false);
                                imp.saveEx(this.get_TrxName());
                                this.commitEx();
                                if (this.processMonitor == null) continue;
                                this.processMonitor.statusUpdate(String.valueOf(records) + " : " + recordsNum + " = " + skipRecords + " : " + skipNum + " + " + errorRecords + " : " + errorNum + " + " + success + " : " + successNum + "   [" + detail + " --> " + createHeader + "( " + success + " : " + successCreateDocHeader + "  /  " + failure + " : " + failureCreateDocHeader + " ) + " + createLine + " ( " + success + " : " + successCreateDocLine + "  /  " + failure + " : " + failureCreateDocLine + " ) ]");
                                continue;
                            }
                        } else {
                            if (journal != null && journal.getGL_Journal_ID() != 0) {
                                if (!Util.isEmpty((String)this.p_DocAction)) {
                                    journal.processIt(this.p_DocAction);
                                }
                                journal.saveEx(this.get_TrxName());
                                this.commitEx();
                            }
                            lastJP_DataMigration_Identifier = imp.getJP_DataMigration_Identifier();
                            lastDocumentNo = imp.getDocumentNo();
                        }
                    } else if (this.p_JP_CollateGLJournalPolicy.equals(JP_CollateGLJournalPolicy_DoNotCollateWithExistingData)) {
                        if (!Util.isEmpty((String)lastJP_DataMigration_Identifier) && lastJP_DataMigration_Identifier.equals(imp.getJP_DataMigration_Identifier())) {
                            isCreateHeader = false;
                            if (journal.getGL_Journal_ID() == 0) {
                                ++errorNum;
                                String msg = Msg.getMsg((Properties)this.getCtx(), (String)"JP_UnexpectedError");
                                imp.setI_ErrorMsg(msg);
                                imp.setI_IsImported(false);
                                imp.setProcessed(false);
                                imp.saveEx(this.get_TrxName());
                                this.commitEx();
                                if (this.processMonitor == null) continue;
                                this.processMonitor.statusUpdate(String.valueOf(records) + " : " + recordsNum + " = " + skipRecords + " : " + skipNum + " + " + errorRecords + " : " + errorNum + " + " + success + " : " + successNum + "   [" + detail + " --> " + createHeader + "( " + success + " : " + successCreateDocHeader + "  /  " + failure + " : " + failureCreateDocHeader + " ) + " + createLine + " ( " + success + " : " + successCreateDocLine + "  /  " + failure + " : " + failureCreateDocLine + " ) ]");
                                continue;
                            }
                        } else if (!Util.isEmpty((String)lastDocumentNo) && lastDocumentNo.equals(imp.getDocumentNo())) {
                            isCreateHeader = false;
                            if (journal.getGL_Journal_ID() == 0) {
                                ++errorNum;
                                String msg = Msg.getMsg((Properties)this.getCtx(), (String)"JP_UnexpectedError");
                                imp.setI_ErrorMsg(msg);
                                imp.setI_IsImported(false);
                                imp.setProcessed(false);
                                imp.saveEx(this.get_TrxName());
                                this.commitEx();
                                if (this.processMonitor == null) continue;
                                this.processMonitor.statusUpdate(String.valueOf(records) + " : " + recordsNum + " = " + skipRecords + " : " + skipNum + " + " + errorRecords + " : " + errorNum + " + " + success + " : " + successNum + "   [" + detail + " --> " + createHeader + "( " + success + " : " + successCreateDocHeader + "  /  " + failure + " : " + failureCreateDocHeader + " ) + " + createLine + " ( " + success + " : " + successCreateDocLine + "  /  " + failure + " : " + failureCreateDocLine + " ) ]");
                                continue;
                            }
                        } else {
                            if (journal != null && journal.getGL_Journal_ID() != 0) {
                                if (!Util.isEmpty((String)this.p_DocAction)) {
                                    journal.processIt(this.p_DocAction);
                                }
                                journal.saveEx(this.get_TrxName());
                                this.commitEx();
                            }
                            lastJP_DataMigration_Identifier = imp.getJP_DataMigration_Identifier();
                            lastDocumentNo = imp.getDocumentNo();
                        }
                    }
                    if (isCreateHeader) {
                        if (this.p_JP_ReimportPolicy.equals(JP_ReimportPolicy_DeleteExistingData)) {
                            int deleteFactNum = DB.executeUpdate((String)deleteSQL_Fact_ACCT, (int)imp.getGL_Journal_ID(), (String)this.get_TrxName());
                            int deleteJournalLineNum = DB.executeUpdate((String)deleteSQL_JournalLine, (int)imp.getGL_Journal_ID(), (String)this.get_TrxName());
                            int n = DB.executeUpdate((String)deleteSQL_Journal, (int)imp.getGL_Journal_ID(), (String)this.get_TrxName());
                        }
                        if (this.createHeaderJournal(imp, journal = new MJournal(this.getCtx(), 0, this.get_TrxName()))) {
                            ++successCreateDocHeader;
                        } else {
                            ++failureCreateDocHeader;
                            ++errorNum;
                            this.rollback();
                            imp.setGL_Journal_ID(0);
                            imp.setI_ErrorMsg(this.message);
                            imp.setI_IsImported(false);
                            imp.setProcessed(false);
                            imp.saveEx(this.get_TrxName());
                            this.commitEx();
                            if (this.processMonitor == null) continue;
                            this.processMonitor.statusUpdate(String.valueOf(records) + " : " + recordsNum + " = " + skipRecords + " : " + skipNum + " + " + errorRecords + " : " + errorNum + " + " + success + " : " + successNum + "   [" + detail + " --> " + createHeader + "( " + success + " : " + successCreateDocHeader + "  /  " + failure + " : " + failureCreateDocHeader + " ) + " + createLine + " ( " + success + " : " + successCreateDocLine + "  /  " + failure + " : " + failureCreateDocLine + " ) ]");
                            continue;
                        }
                    }
                    journalLine = new MJournalLine(journal);
                    if (!isCreateHeader) {
                        imp.setGL_Journal_ID(journal.getGL_Journal_ID());
                    }
                    if (this.addJournalLine(imp, journal, journalLine)) {
                        ++successCreateDocLine;
                        ++successNum;
                    } else {
                        ++failureCreateDocLine;
                        ++errorNum;
                        this.rollback();
                        imp.setGL_Journal_ID(0);
                        imp.setGL_JournalLine_ID(0);
                        imp.setI_ErrorMsg(this.message);
                        imp.setI_IsImported(false);
                        imp.setProcessed(false);
                        imp.saveEx(this.get_TrxName());
                        this.commitEx();
                        if (this.processMonitor == null) continue;
                        this.processMonitor.statusUpdate(String.valueOf(records) + " : " + recordsNum + " = " + skipRecords + " : " + skipNum + " + " + errorRecords + " : " + errorNum + " + " + success + " : " + successNum + "   [" + detail + " --> " + createHeader + "( " + success + " : " + successCreateDocHeader + "  /  " + failure + " : " + failureCreateDocHeader + " ) + " + createLine + " ( " + success + " : " + successCreateDocLine + "  /  " + failure + " : " + failureCreateDocLine + " ) ]");
                        continue;
                    }
                    imp.setI_IsImported(true);
                    imp.setProcessed(true);
                    imp.saveEx(this.get_TrxName());
                    this.commitEx();
                    if (this.processMonitor == null) continue;
                    this.processMonitor.statusUpdate(String.valueOf(records) + " : " + recordsNum + " = " + skipRecords + " : " + skipNum + " + " + errorRecords + " : " + errorNum + " + " + success + " : " + successNum + "   [" + detail + " --> " + createHeader + "( " + success + " : " + successCreateDocHeader + "  /  " + failure + " : " + failureCreateDocHeader + " ) + " + createLine + " ( " + success + " : " + successCreateDocLine + "  /  " + failure + " : " + failureCreateDocLine + " ) ]");
                }
                if (journal != null && journal.getGL_Journal_ID() != 0) {
                    if (!Util.isEmpty((String)this.p_DocAction)) {
                        journal.processIt(this.p_DocAction);
                    }
                    journal.saveEx(this.get_TrxName());
                }
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, sql.toString(), (Throwable)e);
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (this.p_IsReleaseDocControlledJP) {
                this.returnDocControlled();
            }
            DB.close(rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        if (this.p_IsReleaseDocControlledJP) {
            this.returnDocControlled();
        }
        DB.close((ResultSet)rs, (Statement)pstmt);
        rs = null;
        pstmt = null;
        long endTime = System.currentTimeMillis();
        long time = endTime - this.startTime;
        SimpleDateFormat formatter = new SimpleDateFormat("HH:mm:ss.SSS");
        formatter.setTimeZone(TimeZone.getTimeZone("GMT"));
        String timeFormatted = formatter.format(time);
        return String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"ProcessOK")) + "  " + timeFormatted + "  " + records + " : " + recordsNum + " = " + skipRecords + " : " + skipNum + " + " + errorRecords + " : " + errorNum + " + " + success + " : " + successNum + "   [" + detail + " --> " + createHeader + "( " + success + " : " + successCreateDocHeader + "  /  " + failure + " : " + failureCreateDocHeader + " ) + " + createLine + " ( " + success + " : " + successCreateDocLine + "  /  " + failure + " : " + failureCreateDocLine + " ) ]";
    }

    private void returnDocControlled() {
        if (this.releaseDocControll_ElementValue_IDs == null) {
            return;
        }
        String updateSQL = "UPDATE C_ElementValue SET IsDocControlled='Y' WHERE C_ElementValue_ID=?";
        int i = 0;
        while (i < this.releaseDocControll_ElementValue_IDs.length) {
            DB.executeUpdate((String)updateSQL, (int)this.releaseDocControll_ElementValue_IDs[i], (String)this.get_TrxName());
            ++i;
        }
    }

    public String getImportTableName() {
        return "I_WarehouseJP";
    }

    public String getWhereClause() {
        StringBuilder msgreturn = new StringBuilder(" AND AD_Client_ID=").append(this.m_AD_Client_ID);
        return msgreturn.toString();
    }

    private boolean reverseLookupGL_Journal_ID() throws Exception {
        int no = 0;
        StringBuilder sql = null;
        if (this.p_JP_CollateGLJournalPolicy.equals(JP_CollateGLJournalPolicy_DataMigrationIdentifier)) {
            sql = new StringBuilder("UPDATE I_GLJournalJP i ").append("SET GL_Journal_ID=(SELECT GL_Journal_ID FROM GL_Journal p").append(" WHERE i.JP_DataMigration_Identifier=p.JP_DataMigration_Identifier AND p.C_AcctSchema_ID=i.C_AcctSchema_ID) ").append(" WHERE i.GL_Journal_ID IS NULL AND i.JP_DataMigration_Identifier IS NOT NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        } else if (this.p_JP_CollateGLJournalPolicy.equals(JP_CollateGLJournalPolicy_Document)) {
            sql = new StringBuilder("UPDATE I_GLJournalJP i ").append("SET GL_Journal_ID=(SELECT GL_Journal_ID FROM GL_Journal p").append(" WHERE i.DocumentNo=p.DocumentNo AND p.C_AcctSchema_ID=i.C_AcctSchema_ID) ").append(" WHERE i.GL_Journal_ID IS NULL AND i.DocumentNo IS NOT NULL AND i.JP_DataMigration_Identifier IS NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        }
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        return true;
    }

    private boolean reverseLookupGL_JournalLine_ID() throws Exception {
        int no = 0;
        StringBuilder sql = new StringBuilder("UPDATE I_GLJournalJP i ").append("SET GL_JournalLine_ID=(SELECT GL_JournalLine_ID FROM GL_JournalLine p").append(" WHERE p.GL_Journal_ID=i.GL_Journal_ID AND i.Line=p.Line ) ").append(" WHERE i.GL_JournalLine_ID IS NULL ").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        return true;
    }

    private boolean reverseLookupAD_Org_ID() throws Exception {
        int no = 0;
        StringBuilder sql = new StringBuilder("UPDATE I_GLJournalJP i ").append("SET AD_Org_ID=(SELECT AD_Org_ID FROM AD_Org p").append(" WHERE i.JP_Org_Value=p.Value AND (p.AD_Client_ID=i.AD_Client_ID or p.AD_Client_ID=0) AND p.IsSummary='N' ) ").append(" WHERE i.JP_Org_Value IS NOT NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + Msg.getMsg((Properties)this.getCtx(), (String)"Invalid") + Msg.getElement((Properties)this.getCtx(), (String)"JP_Org_Value");
        sql = new StringBuilder("UPDATE I_GLJournalJP ").append("SET I_ErrorMsg='" + this.message + "'").append(" WHERE AD_Org_ID = 0 AND JP_Org_Value IS NOT NULL AND JP_Org_Value <> '0' ").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(this.message) + " : " + e.toString() + " : " + sql);
        }
        return no <= 0;
    }

    private boolean reverseLookupAD_OrgTrx_ID() throws Exception {
        int no = 0;
        StringBuilder sql = new StringBuilder("UPDATE I_GLJournalJP i ").append("SET AD_OrgTrx_ID=(SELECT AD_Org_ID FROM AD_Org p").append(" WHERE i.JP_OrgTrx_Value=p.Value AND (p.AD_Client_ID=i.AD_Client_ID or p.AD_Client_ID=0) AND p.IsSummary='N' ) ").append(" WHERE i.JP_OrgTrx_Value IS NOT NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + Msg.getMsg((Properties)this.getCtx(), (String)"Invalid") + Msg.getElement((Properties)this.getCtx(), (String)"JP_OrgTrx_Value");
        sql = new StringBuilder("UPDATE I_GLJournalJP ").append("SET I_ErrorMsg='" + this.message + "'").append(" WHERE AD_OrgTrx_ID IS NULL AND JP_OrgTrx_Value IS NOT NULL ").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(this.message) + " : " + e.toString() + " : " + sql);
        }
        return no <= 0;
    }

    private boolean reverseLookupC_AcctSchema_ID() throws Exception {
        int no = 0;
        StringBuilder sql = new StringBuilder("UPDATE I_GLJournalJP i ").append("SET C_AcctSchema_ID=(SELECT C_AcctSchema_ID FROM C_AcctSchema p").append(" WHERE i.JP_AcctSchema_Name=p.Name AND p.AD_Client_ID=i.AD_Client_ID) ").append(" WHERE i.C_AcctSchema_ID IS NULL AND JP_AcctSchema_Name IS NOT NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + Msg.getMsg((Properties)this.getCtx(), (String)"Invalid") + Msg.getElement((Properties)this.getCtx(), (String)"JP_AcctSchema_Name");
        sql = new StringBuilder("UPDATE I_GLJournalJP ").append("SET I_ErrorMsg='" + this.message + "'").append(" WHERE C_AcctSchema_ID IS NULL AND JP_AcctSchema_Name IS NOT NULL ").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(this.message) + " : " + e.toString() + " : " + sql);
        }
        return no <= 0;
    }

    private boolean reverseLookupGL_Budget_ID() throws Exception {
        int no = 0;
        StringBuilder sql = new StringBuilder("UPDATE I_GLJournalJP i ").append("SET GL_Budget_ID=(SELECT GL_Budget_ID FROM GL_Budget p").append(" WHERE i.JP_GL_Budget_Name=p.Name AND i.AD_Client_ID=p.AD_Client_ID) ").append("WHERE i.GL_Budget_ID IS NULL AND i.JP_GL_Budget_Name IS NOT NULL ").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + Msg.getMsg((Properties)this.getCtx(), (String)"Invalid") + Msg.getElement((Properties)this.getCtx(), (String)"JP_GL_Budget_Name");
        sql = new StringBuilder("UPDATE I_GLJournalJP ").append("SET I_ErrorMsg='" + this.message + "'").append("WHERE GL_Budget_ID IS NULL AND JP_GL_Budget_Name IS NOT NULL").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(this.message) + " : " + e.toString() + " : " + sql);
        }
        return no <= 0;
    }

    private boolean reverseLookupC_DocType_ID() throws Exception {
        int no = 0;
        StringBuilder sql = new StringBuilder("UPDATE I_GLJournalJP i ").append("SET C_DocType_ID=(SELECT C_DocType_ID FROM C_DocType p").append(" WHERE i.JP_DocType_Name=p.Name AND i.AD_Client_ID=p.AD_Client_ID) ").append("WHERE i.C_DocType_ID IS NULL AND i.JP_DocType_Name IS NOT NULL ").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + Msg.getMsg((Properties)this.getCtx(), (String)"Invalid") + Msg.getElement((Properties)this.getCtx(), (String)"JP_DocType_Name");
        sql = new StringBuilder("UPDATE I_GLJournalJP ").append("SET I_ErrorMsg='" + this.message + "'").append("WHERE C_DocType_ID IS NULL AND JP_DocType_Name IS NOT NULL").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(this.message) + " : " + e.toString() + " : " + sql);
        }
        return no <= 0;
    }

    private boolean reverseLookupGL_Category_ID() throws Exception {
        int no = 0;
        StringBuilder sql = new StringBuilder("UPDATE I_GLJournalJP i ").append("SET GL_Category_ID=(SELECT GL_Category_ID FROM GL_Category p").append(" WHERE i.JP_GL_Category_Name=p.Name AND i.AD_Client_ID=p.AD_Client_ID) ").append("WHERE i.GL_Category_ID IS NULL AND i.JP_GL_Category_Name IS NOT NULL ").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        sql = new StringBuilder("UPDATE I_GLJournalJP i ").append("SET GL_Category_ID=(SELECT GL_Category_ID FROM C_DocType p").append(" WHERE i.C_DocType_ID=p.C_DocType_ID AND i.AD_Client_ID=p.AD_Client_ID) ").append(" WHERE i.GL_Category_ID IS NULL AND i.C_DocType_ID IS NOT NULL ").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        return true;
    }

    private boolean reverseLookupC_Currency_ID() throws Exception {
        int no = 0;
        StringBuilder sql = new StringBuilder("UPDATE I_GLJournalJP i ").append("SET C_Currency_ID=(SELECT C_Currency_ID FROM C_Currency p").append(" WHERE i.ISO_Code=p.ISO_Code AND (p.AD_Client_ID=i.AD_Client_ID OR p.AD_Client_ID=0) ) ").append(" WHERE i.C_Currency_ID IS NULL AND ISO_Code IS NOT NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + Msg.getMsg((Properties)this.getCtx(), (String)"Invalid") + Msg.getElement((Properties)this.getCtx(), (String)"ISO_Code");
        sql = new StringBuilder("UPDATE I_GLJournalJP ").append("SET I_ErrorMsg='" + this.message + "'").append(" WHERE C_Currency_ID IS NULL AND ISO_Code IS NOT NULL").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(this.message) + " : " + e.toString() + " : " + sql);
        }
        return no <= 0;
    }

    private boolean reverseLookupC_ConversionType_ID() throws Exception {
        int no = 0;
        StringBuilder sql = new StringBuilder("UPDATE I_GLJournalJP i ").append("SET C_ConversionType_ID=(SELECT C_ConversionType_ID FROM C_ConversionType p").append(" WHERE i.JP_ConversionType_Value=p.Value AND (p.AD_Client_ID=i.AD_Client_ID OR p.AD_Client_ID=0) ) ").append(" WHERE i.C_ConversionType_ID IS NULL AND JP_ConversionType_Value IS NOT NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + Msg.getMsg((Properties)this.getCtx(), (String)"Invalid") + Msg.getElement((Properties)this.getCtx(), (String)"JP_ConversionType_Value");
        sql = new StringBuilder("UPDATE I_GLJournalJP ").append("SET I_ErrorMsg='" + this.message + "'").append(" WHERE C_ConversionType_ID IS NULL AND JP_ConversionType_Value IS NOT NULL").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(this.message) + " : " + e.toString() + " : " + sql);
        }
        return no <= 0;
    }

    private boolean reverseLookupAccount_ID() throws Exception {
        int no = 0;
        StringBuilder sql = new StringBuilder("UPDATE I_GLJournalJP i ").append("SET Account_ID=(SELECT C_ElementValue_ID FROM C_ElementValue p").append(" WHERE i.JP_ElementValue_Value=p.Value AND i.AD_Client_ID=p.AD_Client_ID) ").append("WHERE i.Account_ID IS NULL AND i.JP_ElementValue_Value IS NOT NULL ").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + Msg.getMsg((Properties)this.getCtx(), (String)"Invalid") + Msg.getElement((Properties)this.getCtx(), (String)"JP_ElementValue_Value");
        sql = new StringBuilder("UPDATE I_GLJournalJP ").append("SET I_ErrorMsg='" + this.message + "'").append("WHERE Account_ID IS NULL AND JP_ElementValue_Value IS NOT NULL").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(this.message) + " : " + e.toString() + " : " + sql);
        }
        return no <= 0;
    }

    private boolean reverseLookupC_SubAcct_ID() throws Exception {
        int no = 0;
        StringBuilder sql = new StringBuilder("UPDATE I_GLJournalJP i ").append("SET C_SubAcct_ID=(SELECT C_SubAcct_ID FROM C_SubAcct p").append(" WHERE i.JP_SubAcct_Value=p.Value AND i.AD_Client_ID=p.AD_Client_ID) ").append("WHERE i.C_SubAcct_ID IS NULL AND i.JP_SubAcct_Value IS NOT NULL ").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + Msg.getMsg((Properties)this.getCtx(), (String)"Invalid") + Msg.getElement((Properties)this.getCtx(), (String)"JP_SubAcct_Value");
        sql = new StringBuilder("UPDATE I_GLJournalJP ").append("SET I_ErrorMsg='" + this.message + "'").append("WHERE C_SubAcct_ID IS NULL AND JP_SubAcct_Value IS NOT NULL").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(this.message) + " : " + e.toString() + " : " + sql);
        }
        return no <= 0;
    }

    private boolean reverseLookupC_UOM_ID() throws Exception {
        int no = 0;
        StringBuilder sql = new StringBuilder("UPDATE I_GLJournalJP i ").append("SET C_UOM_ID=(SELECT C_UOM_ID FROM C_UOM p").append(" WHERE i.X12DE355=p.X12DE355 AND (i.AD_Client_ID=p.AD_Client_ID OR p.AD_Client_ID = 0) ) ").append("WHERE X12DE355 IS NOT NULL").append(" AND I_IsImported='N'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + Msg.getMsg((Properties)this.getCtx(), (String)"Invalid") + Msg.getElement((Properties)this.getCtx(), (String)"X12DE355");
        sql = new StringBuilder("UPDATE I_GLJournalJP ").append("SET I_ErrorMsg='" + this.message + "'").append(" WHERE X12DE355 IS NOT NULL AND C_UOM_ID IS NULL ").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(this.message) + " : " + e.toString() + " : " + sql);
        }
        return no <= 0;
    }

    private boolean reverseLookupC_BPartner_ID() throws Exception {
        int no = 0;
        StringBuilder sql = new StringBuilder("UPDATE I_GLJournalJP i ").append("SET C_BPartner_ID=(SELECT C_BPartner_ID FROM C_BPartner p").append(" WHERE i.JP_BPartner_Value=p.Value AND i.AD_Client_ID=p.AD_Client_ID) ").append("WHERE i.C_BPartner_ID IS NULL AND i.JP_BPartner_Value IS NOT NULL ").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + Msg.getMsg((Properties)this.getCtx(), (String)"Invalid") + Msg.getElement((Properties)this.getCtx(), (String)"JP_BPartner_Value");
        sql = new StringBuilder("UPDATE I_GLJournalJP ").append("SET I_ErrorMsg='" + this.message + "'").append("WHERE C_BPartner_ID IS NULL AND JP_BPartner_Value IS NOT NULL").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(this.message) + " : " + e.toString() + " : " + sql);
        }
        return no <= 0;
    }

    private boolean reverseLookupM_Product_ID() throws Exception {
        int no = 0;
        StringBuilder sql = new StringBuilder("UPDATE I_GLJournalJP i ").append("SET M_Product_ID=(SELECT M_Product_ID FROM M_Product p").append(" WHERE i.JP_Product_Value=p.Value AND i.AD_Client_ID=p.AD_Client_ID) ").append("WHERE i.M_Product_ID IS NULL AND i.JP_Product_Value IS NOT NULL ").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + Msg.getMsg((Properties)this.getCtx(), (String)"Invalid") + Msg.getElement((Properties)this.getCtx(), (String)"JP_Product_Value");
        sql = new StringBuilder("UPDATE I_GLJournalJP ").append("SET I_ErrorMsg='" + this.message + "'").append("WHERE M_Product_ID IS NULL AND JP_Product_Value IS NOT NULL").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(this.message) + " : " + e.toString() + " : " + sql);
        }
        return no <= 0;
    }

    private boolean reverseLookupC_Project_ID() throws Exception {
        int no = 0;
        StringBuilder sql = new StringBuilder("UPDATE I_GLJournalJP i ").append("SET C_Project_ID=(SELECT C_Project_ID FROM C_Project p").append(" WHERE i.JP_Project_Value=p.Value AND i.AD_Client_ID=p.AD_Client_ID) ").append("WHERE i.C_Project_ID IS NULL AND i.JP_Project_Value IS NOT NULL ").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + Msg.getMsg((Properties)this.getCtx(), (String)"Invalid") + Msg.getElement((Properties)this.getCtx(), (String)"JP_Project_Value");
        sql = new StringBuilder("UPDATE I_GLJournalJP ").append("SET I_ErrorMsg='" + this.message + "'").append("WHERE C_Project_ID IS NULL AND JP_Project_Value IS NOT NULL").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(this.message) + " : " + e.toString() + " : " + sql);
        }
        return no <= 0;
    }

    private boolean reverseLookupC_ProjectPhase_ID() throws Exception {
        int no = 0;
        StringBuilder sql = new StringBuilder("UPDATE I_GLJournalJP i ").append("SET C_ProjectPhase_ID=(SELECT C_ProjectPhase_ID FROM C_ProjectPhase p").append(" WHERE i.JP_ProjectPhase_Name=p.Name AND i.C_Project_ID=p.C_Project_ID ) ").append("WHERE i.C_ProjectPhase_ID IS NULL AND i.JP_ProjectPhase_Name IS NOT NULL ").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + Msg.getMsg((Properties)this.getCtx(), (String)"Invalid") + Msg.getElement((Properties)this.getCtx(), (String)"JP_ProjectPhase_Name");
        sql = new StringBuilder("UPDATE I_GLJournalJP ").append("SET I_ErrorMsg='" + this.message + "'").append("WHERE C_ProjectPhase_ID IS NULL AND JP_ProjectPhase_Name IS NOT NULL").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(this.message) + " : " + e.toString() + " : " + sql);
        }
        return no <= 0;
    }

    private boolean reverseLookupC_ProjectTask_ID() throws Exception {
        int no = 0;
        StringBuilder sql = new StringBuilder("UPDATE I_GLJournalJP i ").append("SET C_ProjectTask_ID=(SELECT C_ProjectTask_ID FROM C_ProjectTask p").append(" WHERE i.JP_ProjectTask_Name=p.Name AND i.C_ProjectPhase_ID=p.C_ProjectPhase_ID ) ").append("WHERE i.C_ProjectTask_ID IS NULL AND i.JP_ProjectTask_Name IS NOT NULL ").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + Msg.getMsg((Properties)this.getCtx(), (String)"Invalid") + Msg.getElement((Properties)this.getCtx(), (String)"JP_ProjectTask_Name");
        sql = new StringBuilder("UPDATE I_GLJournalJP ").append("SET I_ErrorMsg='" + this.message + "'").append("WHERE C_ProjectTask_ID IS NULL AND JP_ProjectTask_Name IS NOT NULL").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(this.message) + " : " + e.toString() + " : " + sql);
        }
        return no <= 0;
    }

    private boolean reverseLookupC_SalesRegion_ID() throws Exception {
        int no = 0;
        StringBuilder sql = new StringBuilder("UPDATE I_GLJournalJP i ").append("SET C_SalesRegion_ID=(SELECT C_SalesRegion_ID FROM C_SalesRegion p").append(" WHERE i.JP_SalesRegion_Value=p.Value AND i.AD_Client_ID=p.AD_Client_ID) ").append("WHERE i.C_SalesRegion_ID IS NULL AND i.JP_SalesRegion_Value IS NOT NULL ").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + Msg.getMsg((Properties)this.getCtx(), (String)"Invalid") + Msg.getElement((Properties)this.getCtx(), (String)"JP_SalesRegion_Value");
        sql = new StringBuilder("UPDATE I_GLJournalJP ").append("SET I_ErrorMsg='" + this.message + "'").append("WHERE C_SalesRegion_ID IS NULL AND JP_SalesRegion_Value IS NOT NULL").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(this.message) + " : " + e.toString() + " : " + sql);
        }
        return no <= 0;
    }

    private boolean reverseLookupC_Campaign_ID() throws Exception {
        int no = 0;
        StringBuilder sql = new StringBuilder("UPDATE I_GLJournalJP i ").append("SET C_Campaign_ID=(SELECT C_Campaign_ID FROM C_Campaign p").append(" WHERE i.JP_Campaign_Value=p.Value AND i.AD_Client_ID=p.AD_Client_ID) ").append("WHERE i.C_Campaign_ID IS NULL AND i.JP_Campaign_Value IS NOT NULL ").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + Msg.getMsg((Properties)this.getCtx(), (String)"Invalid") + Msg.getElement((Properties)this.getCtx(), (String)"JP_Campaign_Value");
        sql = new StringBuilder("UPDATE I_GLJournalJP ").append("SET I_ErrorMsg='" + this.message + "'").append("WHERE C_Campaign_ID IS NULL AND JP_Campaign_Value IS NOT NULL").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(this.message) + " : " + e.toString() + " : " + sql);
        }
        return no <= 0;
    }

    private boolean reverseLookupC_Activity_ID() throws Exception {
        int no = 0;
        StringBuilder sql = new StringBuilder("UPDATE I_GLJournalJP i ").append("SET C_Activity_ID=(SELECT C_Activity_ID FROM C_Activity p").append(" WHERE i.JP_Activity_Value=p.Value AND i.AD_Client_ID=p.AD_Client_ID) ").append("WHERE i.C_Activity_ID IS NULL AND i.JP_Activity_Value IS NOT NULL ").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + Msg.getMsg((Properties)this.getCtx(), (String)"Invalid") + Msg.getElement((Properties)this.getCtx(), (String)"JP_Activity_Value");
        sql = new StringBuilder("UPDATE I_GLJournalJP ").append("SET I_ErrorMsg='" + this.message + "'").append("WHERE C_Activity_ID IS NULL AND JP_Activity_Value IS NOT NULL").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(this.message) + " : " + e.toString() + " : " + sql);
        }
        return no <= 0;
    }

    private boolean reverseLookupC_LocFrom_ID() throws Exception {
        int no = 0;
        StringBuilder sql = new StringBuilder("UPDATE I_GLJournalJP i ").append("SET C_LocFrom_ID=(SELECT C_Location_ID FROM C_Location p").append(" WHERE i.JP_LocFrom_Label= p.JP_Location_Label AND p.AD_Client_ID=i.AD_Client_ID) ").append(" WHERE i.C_LocFrom_ID IS NULL AND JP_LocFrom_Label IS NOT NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + Msg.getMsg((Properties)this.getCtx(), (String)"Invalid") + Msg.getElement((Properties)this.getCtx(), (String)"JP_LocFrom_Label");
        sql = new StringBuilder("UPDATE I_GLJournalJP ").append("SET I_ErrorMsg='" + this.message + "'").append("WHERE C_LocFrom_ID IS NULL AND JP_LocFrom_Label IS NOT NULL").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(this.message) + " : " + e.toString() + " : " + sql);
        }
        return no <= 0;
    }

    private boolean reverseLookupC_LocTo_ID() throws Exception {
        int no = 0;
        StringBuilder sql = new StringBuilder("UPDATE I_GLJournalJP i ").append("SET C_LocTo_ID=(SELECT C_Location_ID FROM C_Location p").append(" WHERE i.JP_LocTo_Label= p.JP_Location_Label AND p.AD_Client_ID=i.AD_Client_ID) ").append(" WHERE i.C_LocTo_ID IS NULL AND JP_LocTo_Label IS NOT NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + Msg.getMsg((Properties)this.getCtx(), (String)"Invalid") + Msg.getElement((Properties)this.getCtx(), (String)"JP_LocTo_Label");
        sql = new StringBuilder("UPDATE I_GLJournalJP ").append("SET I_ErrorMsg='" + this.message + "'").append("WHERE C_LocTo_ID IS NULL AND JP_LocTo_Label IS NOT NULL").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(this.message) + " : " + e.toString() + " : " + sql);
        }
        return no <= 0;
    }

    private boolean reverseLookupUser1_ID() throws Exception {
        int no = 0;
        StringBuilder sql = new StringBuilder("UPDATE I_GLJournalJP i ").append("SET User1_ID=(SELECT C_ElementValue_ID FROM C_ElementValue p").append(" WHERE i.JP_UserElement1_Value=p.Value AND i.AD_Client_ID=p.AD_Client_ID) ").append("WHERE i.User1_ID IS NULL AND i.JP_UserElement1_Value IS NOT NULL ").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + Msg.getMsg((Properties)this.getCtx(), (String)"Invalid") + Msg.getElement((Properties)this.getCtx(), (String)"JP_UserElement1_Value");
        sql = new StringBuilder("UPDATE I_GLJournalJP ").append("SET I_ErrorMsg='" + this.message + "'").append("WHERE User1_ID IS NULL AND JP_UserElement1_Value IS NOT NULL").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(this.message) + " : " + e.toString() + " : " + sql);
        }
        return no <= 0;
    }

    private boolean reverseLookupUser2_ID() throws Exception {
        int no = 0;
        StringBuilder sql = new StringBuilder("UPDATE I_GLJournalJP i ").append("SET User2_ID=(SELECT C_ElementValue_ID FROM C_ElementValue p").append(" WHERE i.JP_UserElement2_Value=p.Value AND i.AD_Client_ID=p.AD_Client_ID) ").append("WHERE i.User2_ID IS NULL AND i.JP_UserElement2_Value IS NOT NULL ").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + Msg.getMsg((Properties)this.getCtx(), (String)"Invalid") + Msg.getElement((Properties)this.getCtx(), (String)"JP_UserElement2_Value");
        sql = new StringBuilder("UPDATE I_GLJournalJP ").append("SET I_ErrorMsg='" + this.message + "'").append("WHERE User2_ID IS NULL AND JP_UserElement2_Value IS NOT NULL").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(this.message) + " : " + e.toString() + " : " + sql);
        }
        return no <= 0;
    }

    private boolean reverseLookupA_Asset_ID() throws Exception {
        int no = 0;
        StringBuilder sql = new StringBuilder("UPDATE I_GLJournalJP i ").append("SET A_Asset_ID=(SELECT A_Asset_ID FROM A_Asset p").append(" WHERE i.JP_Asset_Value=p.Value AND i.AD_Client_ID=p.AD_Client_ID) ").append("WHERE i.A_Asset_ID IS NULL AND i.JP_Asset_Value IS NOT NULL ").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + Msg.getMsg((Properties)this.getCtx(), (String)"Invalid") + Msg.getElement((Properties)this.getCtx(), (String)"JP_Asset_Value");
        sql = new StringBuilder("UPDATE I_GLJournalJP ").append("SET I_ErrorMsg='" + this.message + "'").append("WHERE A_Asset_ID IS NULL AND JP_Asset_Value IS NOT NULL").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(this.message) + " : " + e.toString() + " : " + sql);
        }
        return no <= 0;
    }

    private boolean reverseLookupM_Locator_ID() throws Exception {
        int no = 0;
        StringBuilder sql = new StringBuilder("UPDATE I_GLJournalJP i ").append("SET M_Locator_ID=(SELECT M_Locator_ID FROM M_Locator p").append(" WHERE i.JP_Locator_Value=p.Value AND i.AD_Client_ID=p.AD_Client_ID) ").append(" WHERE i.M_Locator_ID IS NULL AND i.JP_Locator_Value IS NOT NULL ").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + Msg.getMsg((Properties)this.getCtx(), (String)"Invalid") + Msg.getElement((Properties)this.getCtx(), (String)"JP_Locator_Value");
        sql = new StringBuilder("UPDATE I_GLJournalJP ").append("SET I_ErrorMsg='" + this.message + "'").append(" WHERE M_Locator_ID IS NULL AND JP_Locator_Value IS NOT NULL").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(this.message) + " : " + e.toString() + " : " + sql);
        }
        return no <= 0;
    }

    private boolean createHeaderJournal(X_I_GLJournalJP impJournal, MJournal newJournal) {
        if (impJournal.getAD_Org_ID() <= 0) {
            this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Invalid")) + Msg.getElement((Properties)this.getCtx(), (String)"JP_Org_Value");
            return false;
        }
        if (impJournal.getC_AcctSchema_ID() <= 0) {
            this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"JP_Null")) + Msg.getElement((Properties)this.getCtx(), (String)"C_AcctSchema_ID");
            return false;
        }
        if (impJournal.getC_DocType_ID() <= 0) {
            this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"JP_Null")) + Msg.getElement((Properties)this.getCtx(), (String)"C_DocType_ID");
            return false;
        }
        if (Util.isEmpty((String)impJournal.getPostingType())) {
            this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"JP_Null")) + Msg.getElement((Properties)this.getCtx(), (String)"PostingType");
            return false;
        }
        if (impJournal.getDateAcct() == null) {
            this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"JP_Null")) + Msg.getElement((Properties)this.getCtx(), (String)"DateAcct");
            return false;
        }
        MCalendar baseCalendar = MCalendar.getDefault((Properties)this.getCtx(), (int)this.m_AD_Client_ID);
        MPeriod period = MPeriod.findByCalendar((Properties)this.getCtx(), (Timestamp)impJournal.getDateAcct(), (int)baseCalendar.getC_Calendar_ID(), (String)this.get_TrxName());
        if (impJournal.getDateTrx() == null) {
            impJournal.setDateTrx(impJournal.getDateAcct());
        }
        if (impJournal.getC_Currency_ID() <= 0) {
            this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"JP_Null")) + Msg.getElement((Properties)this.getCtx(), (String)"C_Currency_ID");
            return false;
        }
        if (Util.isEmpty((String)impJournal.getJP_Description_Header())) {
            if (!Util.isEmpty((String)impJournal.getJP_Description_Line())) {
                impJournal.setJP_Description_Header(impJournal.getJP_Description_Line());
            } else {
                Object[] objs = new Object[]{Msg.getElement((Properties)Env.getCtx(), (String)"JP_Description_Header")};
                this.message = Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Mandatory", (Object[])objs);
                return false;
            }
        }
        ModelValidationEngine.get().fireImportValidate((ImportProcess)this, (PO)impJournal, (PO)newJournal, 30);
        PO.copyValues((PO)impJournal, (PO)newJournal);
        newJournal.setAD_Org_ID(impJournal.getAD_Org_ID());
        newJournal.setDateDoc(impJournal.getDateTrx());
        newJournal.setDateAcct(impJournal.getDateAcct());
        newJournal.setC_Period_ID(period.getC_Period_ID());
        newJournal.setGL_Journal_ID(0);
        newJournal.setDocumentNo(impJournal.getDocumentNo());
        newJournal.setDescription(impJournal.getJP_Description_Header());
        if (!Util.isEmpty((String)newJournal.getDescription())) {
            newJournal.setDescription(newJournal.getDescription().replaceAll("<CRLF>", "\r\n"));
            newJournal.setDescription(newJournal.getDescription().replaceAll("<CR>", "\r"));
            newJournal.setDescription(newJournal.getDescription().replaceAll("<LF>", "\n"));
        }
        ModelValidationEngine.get().fireImportValidate((ImportProcess)this, (PO)impJournal, (PO)newJournal, 40);
        try {
            newJournal.saveEx(this.get_TrxName());
        }
        catch (Exception e) {
            this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"SaveIgnored")) + Msg.getElement((Properties)this.getCtx(), (String)"GL_Journal_ID") + " : " + e.toString();
            return false;
        }
        impJournal.setGL_Journal_ID(newJournal.getGL_Journal_ID());
        return true;
    }

    private boolean addJournalLine(X_I_GLJournalJP impJournal, MJournal journal, MJournalLine journalLine) {
        MAccount validCombination;
        ModelValidationEngine.get().fireImportValidate((ImportProcess)this, (PO)impJournal, (PO)journalLine, 30);
        PO.copyValues((PO)impJournal, (PO)journalLine);
        journalLine.setGL_JournalLine_ID(0);
        journalLine.setGL_Journal_ID(journal.getGL_Journal_ID());
        if (impJournal.getGL_Journal_ID() == 0) {
            impJournal.setGL_Journal_ID(journal.getGL_Journal_ID());
        }
        if (!Util.isEmpty((String)impJournal.getJP_Description_Line())) {
            journalLine.setDescription(impJournal.getJP_Description_Line());
            journalLine.setDescription(journalLine.getDescription().replaceAll("<CRLF>", "\r\n"));
            journalLine.setDescription(journalLine.getDescription().replaceAll("<CR>", "\r"));
            journalLine.setDescription(journalLine.getDescription().replaceAll("<LF>", "\n"));
        }
        if ((validCombination = JPiereImportGLJournal.get(this.getCtx(), impJournal.getAD_Client_ID(), impJournal.getAD_Org_ID(), impJournal.getC_AcctSchema_ID(), impJournal.getAccount_ID(), impJournal.getC_SubAcct_ID(), impJournal.getM_Product_ID(), impJournal.getC_BPartner_ID(), impJournal.getAD_OrgTrx_ID(), impJournal.getC_LocFrom_ID(), impJournal.getC_LocTo_ID(), impJournal.getC_SalesRegion_ID(), impJournal.getC_Project_ID(), impJournal.getC_Campaign_ID(), impJournal.getC_Activity_ID(), impJournal.getUser1_ID(), impJournal.getUser2_ID(), impJournal.getUserElement1_ID(), impJournal.getUserElement2_ID(), this.get_TrxName())) != null) {
            journalLine.setC_ValidCombination_ID(validCombination.getC_ValidCombination_ID());
        }
        journalLine.setAD_OrgTrx_ID(impJournal.getAD_OrgTrx_ID());
        journalLine.setC_SubAcct_ID(impJournal.getC_SubAcct_ID());
        journalLine.setC_BPartner_ID(impJournal.getC_BPartner_ID());
        journalLine.setM_Product_ID(impJournal.getM_Product_ID());
        journalLine.setC_Project_ID(impJournal.getC_Project_ID());
        if (journalLine.get_ColumnIndex("C_ProjectPhase_ID") >= 0) {
            journalLine.set_ValueNoCheck("C_ProjectPhase_ID", (Object)impJournal.getC_ProjectPhase_ID());
        }
        if (journalLine.get_ColumnIndex("C_ProjectTask_ID") >= 0) {
            journalLine.set_ValueNoCheck("C_ProjectTask_ID", (Object)impJournal.getC_ProjectTask_ID());
        }
        journalLine.setC_SalesRegion_ID(impJournal.getC_SalesRegion_ID());
        journalLine.setC_Campaign_ID(impJournal.getC_Campaign_ID());
        journalLine.setC_Activity_ID(impJournal.getC_Activity_ID());
        journalLine.setC_LocFrom_ID(impJournal.getC_LocFrom_ID());
        journalLine.setC_LocTo_ID(impJournal.getC_LocTo_ID());
        journalLine.setUser1_ID(impJournal.getUser1_ID());
        journalLine.setUser2_ID(impJournal.getUser2_ID());
        journalLine.setA_Asset_ID(impJournal.getA_Asset_ID());
        if (journalLine.get_ColumnIndex("M_Locator_ID") >= 0) {
            journalLine.set_ValueNoCheck("M_Locator_ID", (Object)impJournal.getM_Locator_ID());
        }
        if (impJournal.getCurrencyRate().compareTo(Env.ZERO) == 0) {
            BigDecimal currencyRate = Env.ZERO;
            if (journal.getC_AcctSchema().getC_Currency_ID() == journalLine.getC_Currency_ID()) {
                currencyRate = Env.ONE;
            } else if (impJournal.getAmtSourceDr().compareTo(Env.ZERO) != 0 && impJournal.getAmtAcctDr().compareTo(Env.ZERO) != 0) {
                currencyRate = impJournal.getAmtAcctDr().divide(impJournal.getAmtSourceDr(), 12, RoundingMode.HALF_UP);
            } else if (impJournal.getAmtSourceCr().compareTo(Env.ZERO) != 0 && impJournal.getAmtAcctCr().compareTo(Env.ZERO) != 0) {
                currencyRate = impJournal.getAmtAcctCr().divide(impJournal.getAmtSourceCr(), 12, RoundingMode.HALF_UP);
            }
            impJournal.setCurrencyRate(currencyRate);
            journalLine.setCurrencyRate(currencyRate);
        }
        ModelValidationEngine.get().fireImportValidate((ImportProcess)this, (PO)impJournal, (PO)journalLine, 40);
        try {
            journalLine.saveEx(this.get_TrxName());
        }
        catch (Exception e) {
            this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"SaveIgnored")) + Msg.getElement((Properties)this.getCtx(), (String)"GL_JournalLine_ID") + " : " + e.toString();
            return false;
        }
        impJournal.setGL_JournalLine_ID(journalLine.getGL_JournalLine_ID());
        return true;
    }

    public static MAccount get(Properties ctx, int AD_Client_ID, int AD_Org_ID, int C_AcctSchema_ID, int Account_ID, int C_SubAcct_ID, int M_Product_ID, int C_BPartner_ID, int AD_OrgTrx_ID, int C_LocFrom_ID, int C_LocTo_ID, int C_SalesRegion_ID, int C_Project_ID, int C_Campaign_ID, int C_Activity_ID, int User1_ID, int User2_ID, int UserElement1_ID, int UserElement2_ID, String trxName) {
        StringBuilder info = new StringBuilder();
        info.append("AD_Client_ID=").append(AD_Client_ID).append(",AD_Org_ID=").append(AD_Org_ID);
        info.append(",C_AcctSchema_ID=").append(C_AcctSchema_ID);
        info.append(",Account_ID=").append(Account_ID).append(" ");
        ArrayList<Integer> params = new ArrayList<Integer>();
        StringBuilder whereClause = new StringBuilder("AD_Client_ID=?").append(" AND AD_Org_ID=?").append(" AND C_AcctSchema_ID=?").append(" AND Account_ID=?");
        params.add(AD_Client_ID);
        params.add(AD_Org_ID);
        params.add(C_AcctSchema_ID);
        params.add(Account_ID);
        if (C_SubAcct_ID == 0) {
            whereClause.append(" AND C_SubAcct_ID IS NULL");
        } else {
            whereClause.append(" AND C_SubAcct_ID=?");
            params.add(C_SubAcct_ID);
        }
        if (M_Product_ID == 0) {
            whereClause.append(" AND M_Product_ID IS NULL");
        } else {
            whereClause.append(" AND M_Product_ID=?");
            params.add(M_Product_ID);
        }
        if (C_BPartner_ID == 0) {
            whereClause.append(" AND C_BPartner_ID IS NULL");
        } else {
            whereClause.append(" AND C_BPartner_ID=?");
            params.add(C_BPartner_ID);
        }
        if (AD_OrgTrx_ID == 0) {
            whereClause.append(" AND AD_OrgTrx_ID IS NULL");
        } else {
            whereClause.append(" AND AD_OrgTrx_ID=?");
            params.add(AD_OrgTrx_ID);
        }
        if (C_LocFrom_ID == 0) {
            whereClause.append(" AND C_LocFrom_ID IS NULL");
        } else {
            whereClause.append(" AND C_LocFrom_ID=?");
            params.add(C_LocFrom_ID);
        }
        if (C_LocTo_ID == 0) {
            whereClause.append(" AND C_LocTo_ID IS NULL");
        } else {
            whereClause.append(" AND C_LocTo_ID=?");
            params.add(C_LocTo_ID);
        }
        if (C_SalesRegion_ID == 0) {
            whereClause.append(" AND C_SalesRegion_ID IS NULL");
        } else {
            whereClause.append(" AND C_SalesRegion_ID=?");
            params.add(C_SalesRegion_ID);
        }
        if (C_Project_ID == 0) {
            whereClause.append(" AND C_Project_ID IS NULL");
        } else {
            whereClause.append(" AND C_Project_ID=?");
            params.add(C_Project_ID);
        }
        if (C_Campaign_ID == 0) {
            whereClause.append(" AND C_Campaign_ID IS NULL");
        } else {
            whereClause.append(" AND C_Campaign_ID=?");
            params.add(C_Campaign_ID);
        }
        if (C_Activity_ID == 0) {
            whereClause.append(" AND C_Activity_ID IS NULL");
        } else {
            whereClause.append(" AND C_Activity_ID=?");
            params.add(C_Activity_ID);
        }
        if (User1_ID == 0) {
            whereClause.append(" AND User1_ID IS NULL");
        } else {
            whereClause.append(" AND User1_ID=?");
            params.add(User1_ID);
        }
        if (User2_ID == 0) {
            whereClause.append(" AND User2_ID IS NULL");
        } else {
            whereClause.append(" AND User2_ID=?");
            params.add(User2_ID);
        }
        if (UserElement1_ID == 0) {
            whereClause.append(" AND UserElement1_ID IS NULL");
        } else {
            whereClause.append(" AND UserElement1_ID=?");
            params.add(UserElement1_ID);
        }
        if (UserElement2_ID == 0) {
            whereClause.append(" AND UserElement2_ID IS NULL");
        } else {
            whereClause.append(" AND UserElement2_ID=?");
            params.add(UserElement2_ID);
        }
        MAccount existingAccount = (MAccount)new Query(ctx, "C_ValidCombination", whereClause.toString(), trxName).setParameters(params).setOnlyActiveRecords(true).first();
        if (existingAccount != null) {
            return existingAccount;
        }
        MAccount newAccount = new MAccount(ctx, 0, trxName);
        newAccount.setAD_Org_ID(AD_Org_ID);
        newAccount.setC_AcctSchema_ID(C_AcctSchema_ID);
        newAccount.setAccount_ID(Account_ID);
        newAccount.setC_SubAcct_ID(C_SubAcct_ID);
        newAccount.setM_Product_ID(M_Product_ID);
        newAccount.setC_BPartner_ID(C_BPartner_ID);
        newAccount.setAD_OrgTrx_ID(AD_OrgTrx_ID);
        newAccount.setC_LocFrom_ID(C_LocFrom_ID);
        newAccount.setC_LocTo_ID(C_LocTo_ID);
        newAccount.setC_SalesRegion_ID(C_SalesRegion_ID);
        newAccount.setC_Project_ID(C_Project_ID);
        newAccount.setC_Campaign_ID(C_Campaign_ID);
        newAccount.setC_Activity_ID(C_Activity_ID);
        newAccount.setUser1_ID(User1_ID);
        newAccount.setUser2_ID(User2_ID);
        newAccount.setUserElement1_ID(UserElement1_ID);
        newAccount.setUserElement2_ID(UserElement2_ID);
        if (!newAccount.save()) {
            return null;
        }
        return newAccount;
    }
}

