/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.process;

import java.sql.ResultSet;
import java.util.logging.Level;
import jpiere.base.plugin.org.adempiere.model.MCorporationGroup;
import jpiere.base.plugin.org.adempiere.model.MGroupCorporations;
import jpiere.base.plugin.org.adempiere.model.X_I_CorporationGroupJP;
import jpiere.base.plugin.org.adempiere.model.X_JP_CorporationGroup;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;

public class JPiereImportCorporationGroup
extends SvrProcess {
    private boolean p_deleteOldImported = false;
    private boolean p_IsValidateOnly = false;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (name.equals("DeleteOldImported")) {
                this.p_deleteOldImported = "Y".equals(para[i].getParameter());
            } else if (name.equals("IsValidateOnly")) {
                this.p_IsValidateOnly = para[i].getParameterAsBoolean();
            } else {
                this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
            }
            ++i;
        }
    }

    protected String doIt() throws Exception {
        StringBuilder sql = null;
        int no = 0;
        StringBuilder clientCheck = new StringBuilder(" AND AD_Client_ID=").append(this.getAD_Client_ID());
        if (this.p_deleteOldImported) {
            sql = new StringBuilder("DELETE I_CorporationGroupJP ").append("WHERE I_IsImported='Y'").append((CharSequence)clientCheck);
            no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("Delete Old Impored =" + no);
            }
        }
        sql = new StringBuilder("UPDATE I_CorporationGroupJP i ").append("SET JP_CorporationGroup_ID=(SELECT JP_CorporationGroup_ID FROM JP_CorporationGroup p").append(" WHERE i.Value=p.Value AND p.AD_Client_ID=i.AD_Client_ID) ").append(" WHERE JP_CorporationGroup_ID is Null AND Value IS NOT NULL").append(" AND I_IsImported='N'").append((CharSequence)clientCheck);
        no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Found Corporation Group=" + no);
        }
        this.commitEx();
        sql = new StringBuilder("UPDATE I_CorporationGroupJP i ").append("SET JP_Corporation_ID=(SELECT JP_Corporation_ID FROM JP_Corporation p").append(" WHERE i.CorporationValue=p.Value AND p.AD_Client_ID=i.AD_Client_ID) ").append(" WHERE JP_Corporation_ID is Null AND CorporationValue IS NOT NULL").append(" AND I_IsImported='N'").append((CharSequence)clientCheck);
        no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Found Corporation=" + no);
        }
        this.commitEx();
        if (this.p_IsValidateOnly) {
            return "Validated";
        }
        sql = new StringBuilder("SELECT * FROM I_CorporationGroupJP WHERE I_IsImported='N'").append((CharSequence)clientCheck);
        sql.append(" ORDER BY Value, CorporationValue");
        CPreparedStatement pstmt = DB.prepareStatement((String)sql.toString(), (String)this.get_TrxName());
        ResultSet rs = pstmt.executeQuery();
        String Old_CGValue = "";
        X_JP_CorporationGroup corpGroup = null;
        MGroupCorporations groupCorps = null;
        while (rs.next()) {
            String New_CGValue = rs.getString("Value");
            X_I_CorporationGroupJP imp = new X_I_CorporationGroupJP(this.getCtx(), rs, this.get_TrxName());
            if (!New_CGValue.equals(Old_CGValue)) {
                boolean isNew = true;
                if (imp.getJP_CorporationGroup_ID() != 0) {
                    isNew = false;
                }
                if (isNew) {
                    if (imp.getName() != null && !imp.getName().isEmpty()) {
                        corpGroup = new MCorporationGroup(this.getCtx(), 0, this.get_TrxName());
                        corpGroup.setValue(imp.getValue());
                        corpGroup.setName(imp.getName());
                        corpGroup.setName2(imp.getName2());
                        corpGroup.setDescription(imp.getDescription());
                        corpGroup.saveEx();
                        imp.setJP_CorporationGroup_ID(corpGroup.getJP_CorporationGroup_ID());
                        imp.setI_ErrorMsg("New Record");
                        imp.setI_IsImported(true);
                        imp.setProcessed(true);
                    } else {
                        imp.setI_ErrorMsg("No Name");
                        imp.setI_IsImported(false);
                        imp.setProcessed(false);
                    }
                } else {
                    corpGroup = new MCorporationGroup(this.getCtx(), imp.getJP_CorporationGroup_ID(), this.get_TrxName());
                    corpGroup.setName(imp.getName());
                    corpGroup.setName2(imp.getName2());
                    corpGroup.setDescription(imp.getDescription());
                    corpGroup.saveEx();
                    imp.setI_ErrorMsg("Update Record");
                    imp.setI_IsImported(true);
                    imp.setProcessed(true);
                }
                imp.saveEx();
            }
            if (imp.getJP_Corporation_ID() != 0) {
                groupCorps = new MGroupCorporations(this.getCtx(), 0, this.get_TrxName());
                groupCorps.setJP_CorporationGroup_ID(corpGroup.getJP_CorporationGroup_ID());
                groupCorps.setJP_Corporation_ID(imp.getJP_Corporation_ID());
                groupCorps.saveEx();
            }
            Old_CGValue = New_CGValue;
        }
        return "";
    }
}

