/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MInventory;
import org.compiere.model.MInventoryLine;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class InventoryUpdateQtyBookFromStorage
extends SvrProcess {
    int record_ID = 0;
    MInventory m_Inventory = null;

    protected void prepare() {
        this.record_ID = this.getRecord_ID();
    }

    protected String doIt() throws Exception {
        if (this.record_ID == 0) {
            return Msg.getElement((Properties)this.getCtx(), (String)"NoRecordID");
        }
        this.m_Inventory = new MInventory(this.getCtx(), this.record_ID, this.get_TrxName());
        if (this.m_Inventory.getDocStatus().equals("CO") || this.m_Inventory.getDocStatus().equals("CL") || this.m_Inventory.getDocStatus().equals("VO") || this.m_Inventory.getDocStatus().equals("RE")) {
            return Msg.getMsg((Properties)this.getCtx(), (String)"JP_NotValidDocStatus");
        }
        MInventoryLine[] inventoryLines = this.m_Inventory.getLines(true);
        if (inventoryLines.length == 0) {
            return Msg.getMsg((Properties)this.getCtx(), (String)"NoLines");
        }
        MInventoryLine line = null;
        BigDecimal qtyBook = Env.ZERO;
        int i = 0;
        while (i < inventoryLines.length) {
            qtyBook = Env.ZERO;
            line = inventoryLines[i];
            if (line.getM_Product_ID() > 0) {
                qtyBook = line.getM_AttributeSetInstance_ID() > 0 ? this.getQtyBookWithASI(line) : this.getQtyBookWithoutASI(line);
                line.setQtyBook(qtyBook);
                line.saveEx(this.get_TrxName());
            }
            ++i;
        }
        return Msg.getMsg((Properties)this.getCtx(), (String)"Success");
    }

    private BigDecimal getQtyBookWithASI(MInventoryLine line) {
        BigDecimal qtyBook;
        block6: {
            qtyBook = Env.ZERO;
            String sql = "SELECT SUM(t.QtyOnHand) FROM M_StorageOnHand t  WHERE t.M_Product_ID = ? AND t.M_Locator_ID = ? AND t.M_AttributeSetInstance_ID = ?   GROUP BY t.M_Product_ID, t.M_Locator_ID, t.M_AttributeSetInstance_ID";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
                    pstmt.setInt(1, line.getM_Product_ID());
                    pstmt.setInt(2, line.getM_Locator_ID());
                    pstmt.setInt(3, line.getM_AttributeSetInstance_ID());
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        qtyBook = rs.getBigDecimal(1);
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, sql, (Throwable)e);
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        return qtyBook;
    }

    private BigDecimal getQtyBookWithoutASI(MInventoryLine line) {
        BigDecimal qtyBook;
        block6: {
            qtyBook = Env.ZERO;
            String sql = "SELECT SUM(t.QtyOnHand) FROM M_StorageOnHand t  WHERE t.M_Product_ID = ? AND t.M_Locator_ID = ?   GROUP BY t.M_Product_ID, t.M_Locator_ID ";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
                    pstmt.setInt(1, line.getM_Product_ID());
                    pstmt.setInt(2, line.getM_Locator_ID());
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        qtyBook = rs.getBigDecimal(1);
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, sql, (Throwable)e);
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        return qtyBook;
    }
}

