/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.process;

import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Properties;
import jpiere.base.plugin.org.adempiere.model.MBill;
import jpiere.base.plugin.org.adempiere.model.MBillLine;
import jpiere.base.plugin.org.adempiere.model.MBillSchema;
import jpiere.base.plugin.org.adempiere.process.I_CreateBill;
import org.compiere.model.MInvoice;
import org.compiere.model.MPaymentTerm;
import org.compiere.model.Query;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class DefaultCreateBill
implements I_CreateBill {
    private int p_AD_Client_ID = 0;
    private int p_AD_Org_ID = 0;
    private int p_C_BP_Group_ID = 0;
    private Timestamp p_DateInvoiced_From = null;
    private Timestamp p_DateInvoiced_To = null;
    private Timestamp p_JPDateBilled = null;
    private Timestamp p_JPCutOffDate = null;
    MBillSchema m_BillSchema = null;
    MPaymentTerm m_paymentTerm = null;
    boolean p_IsSOTrx = false;
    String IsSOTrxString = "N";
    private String p_DocAction = "DR";
    boolean isCalledFromInfoWindow = false;
    ArrayList<MInvoice> invoiceList = new ArrayList();
    SvrProcess process = null;
    Properties ctx = null;
    int p_AD_PInstance_ID = 0;
    String trxName = null;

    @Override
    public String createBills(Properties ctx, int AD_PInstance_ID, SvrProcess process, ProcessInfoParameter[] para, MBillSchema billSchema, MPaymentTerm paymentTerm, boolean isSOTrx, boolean isCalledInfoWindow, String trxName) throws Exception {
        block29: {
            this.p_AD_Client_ID = process.getProcessInfo().getAD_Client_ID();
            this.ctx = ctx;
            this.p_AD_PInstance_ID = AD_PInstance_ID;
            this.process = process;
            this.m_BillSchema = billSchema;
            this.m_paymentTerm = paymentTerm;
            this.p_IsSOTrx = isSOTrx;
            this.isCalledFromInfoWindow = isCalledInfoWindow;
            this.trxName = trxName;
            this.IsSOTrxString = this.p_IsSOTrx ? "'Y'" : "'N'";
            if (isCalledInfoWindow) {
                int i = 0;
                while (i < para.length) {
                    String name = para[i].getParameterName();
                    if (name.equals("JPDateBilled")) {
                        this.p_JPDateBilled = (Timestamp)para[i].getParameter();
                    } else if (name.equals("DocAction")) {
                        this.p_DocAction = para[i].getParameterAsString();
                    } else if (name.equals("JPCutOffDate")) {
                        this.p_JPCutOffDate = (Timestamp)para[i].getParameter();
                    }
                    ++i;
                }
                String whereClause = "EXISTS (SELECT T_Selection_ID FROM T_Selection WHERE T_Selection.AD_PInstance_ID=? AND T_Selection.T_Selection_ID = C_Invoice.C_Invoice_ID)";
                List selectedInvoices = new Query(ctx, "C_Invoice", whereClause, trxName).setClient_ID().setParameters(new Object[]{AD_PInstance_ID}).setOrderBy(this.createOrderByClause()).list();
                this.invoiceList = (ArrayList)selectedInvoices;
                return this.createBills(this.invoiceList);
            }
            int i = 0;
            while (i < para.length) {
                String name = para[i].getParameterName();
                if (para[i].getParameter() != null) {
                    if (name.equals("AD_Org_ID")) {
                        this.p_AD_Org_ID = para[i].getParameterAsInt();
                    } else if (name.equals("C_BP_Group_ID")) {
                        this.p_C_BP_Group_ID = para[i].getParameterAsInt();
                    } else if (name.equals("DateInvoiced")) {
                        this.p_DateInvoiced_From = (Timestamp)para[i].getParameter();
                        this.p_DateInvoiced_To = (Timestamp)para[i].getParameter_To();
                        if (this.p_DateInvoiced_To != null) {
                            Calendar cal = Calendar.getInstance();
                            cal.setTimeInMillis(this.p_DateInvoiced_To.getTime());
                            cal.add(5, 1);
                            this.p_DateInvoiced_To = new Timestamp(cal.getTimeInMillis());
                        }
                    } else if (name.equals("JPCutOffDate")) {
                        this.p_JPCutOffDate = (Timestamp)para[i].getParameter();
                    } else if (name.equals("JPDateBilled")) {
                        this.p_JPDateBilled = (Timestamp)para[i].getParameter();
                    } else if (name.equals("DocAction")) {
                        this.p_DocAction = para[i].getParameterAsString();
                    }
                }
                ++i;
            }
            String selectSQL = new String("SELECT C_Invoice.* FROM C_Invoice INNER JOIN C_BPartner ON (C_Invoice.C_BPartner_ID = C_BPartner.C_BPartner_ID) ");
            String sql = String.valueOf(selectSQL) + this.createWhereClause() + this.createOrderByClause();
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, (String)trxName);
                    int i2 = 0;
                    if (this.p_AD_Org_ID != 0) {
                        pstmt.setInt(++i2, this.p_AD_Org_ID);
                    }
                    if (this.p_C_BP_Group_ID != 0) {
                        pstmt.setInt(++i2, this.p_C_BP_Group_ID);
                    }
                    pstmt.setTimestamp(++i2, this.p_DateInvoiced_From);
                    pstmt.setTimestamp(++i2, this.p_DateInvoiced_To);
                    pstmt.setInt(++i2, this.m_paymentTerm.getC_PaymentTerm_ID());
                    pstmt.setInt(++i2, this.m_BillSchema.getJP_BillSchema_ID());
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        this.invoiceList.add(new MInvoice(ctx, rs, trxName));
                    }
                }
                catch (Exception e) {
                    process.addLog(e.toString());
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block29;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        return this.createBills(this.invoiceList);
    }

    private String createWhereClause() {
        StringBuilder whereClause = new StringBuilder(" WHERE C_Invoice.AD_Client_ID =" + this.p_AD_Client_ID + " AND C_Invoice.Processed  = 'Y'" + " AND C_Invoice.IsPaid  = 'N'" + " AND C_Invoice.IsSOTrx  = " + this.IsSOTrxString + " AND C_Invoice.JP_Bill_ID is null");
        if (this.p_AD_Org_ID != 0) {
            whereClause.append(" AND C_Invoice.AD_Org_ID = ? ");
        }
        if (this.p_C_BP_Group_ID != 0) {
            whereClause.append(" AND C_BPartner.C_BP_Group_ID = ? ");
        }
        whereClause.append(" AND C_Invoice.DateInvoiced >= ?");
        whereClause.append(" AND C_Invoice.DateInvoiced < ?");
        whereClause.append(" AND C_Invoice.C_PaymentTerm_ID = ? ");
        if (this.p_IsSOTrx) {
            whereClause.append(" AND C_BPartner.JP_BillSchema_ID = ?  ");
        } else {
            whereClause.append(" AND C_BPartner.JP_BillSchemaPO_ID = ?  ");
        }
        return whereClause.toString();
    }

    private String createOrderByClause() {
        StringBuilder orderByClause = new StringBuilder("ORDER BY C_Invoice.C_BPartner_ID, C_Invoice.C_Currency_ID ,C_Invoice.PaymentRule,C_Invoice.C_BPartner_Location_ID,C_Invoice.AD_User_ID,C_Invoice.AD_Org_ID,C_Invoice.DocumentNo");
        return orderByClause.toString();
    }

    private String createBills(ArrayList<MInvoice> invoiceList) {
        MBill bill = null;
        MInvoice oldInvoice = null;
        int lineCounter = 0;
        int billCounter = 0;
        for (MInvoice invoice : invoiceList) {
            if (invoice.get_ValueAsInt("JP_Bill_ID") != 0) continue;
            if (oldInvoice == null) {
                oldInvoice = invoice;
                bill = this.createBillHeader(invoice, this.m_BillSchema);
                lineCounter = 0;
                ++billCounter;
            }
            if (oldInvoice.getC_BPartner_ID() != invoice.getC_BPartner_ID()) {
                bill.load(this.trxName);
                bill.processIt(this.p_DocAction);
                bill.saveEx(this.trxName);
                this.process.addBufferLog(0, null, null, String.valueOf(bill.getDocumentNo()) + ":" + bill.getC_BPartner().getName(), bill.get_Table_ID(), bill.getJP_Bill_ID());
                bill = this.createBillHeader(invoice, this.m_BillSchema);
                lineCounter = 0;
                ++billCounter;
            } else if (oldInvoice.getC_Currency_ID() != invoice.getC_Currency_ID()) {
                bill.load(this.trxName);
                bill.processIt(this.p_DocAction);
                bill.saveEx(this.trxName);
                this.process.addBufferLog(0, null, null, String.valueOf(bill.getDocumentNo()) + ":" + bill.getC_BPartner().getName(), bill.get_Table_ID(), bill.getJP_Bill_ID());
                bill = this.createBillHeader(invoice, this.m_BillSchema);
                lineCounter = 0;
                ++billCounter;
            } else if (!oldInvoice.getPaymentRule().equals(invoice.getPaymentRule())) {
                bill.load(this.trxName);
                bill.processIt(this.p_DocAction);
                bill.saveEx(this.trxName);
                this.process.addBufferLog(0, null, null, String.valueOf(bill.getDocumentNo()) + ":" + bill.getC_BPartner().getName(), bill.get_Table_ID(), bill.getJP_Bill_ID());
                bill = this.createBillHeader(invoice, this.m_BillSchema);
                lineCounter = 0;
                ++billCounter;
            } else if (oldInvoice.getC_BPartner_Location_ID() != invoice.getC_BPartner_Location_ID()) {
                bill.load(this.trxName);
                bill.processIt(this.p_DocAction);
                bill.saveEx(this.trxName);
                this.process.addBufferLog(0, null, null, String.valueOf(bill.getDocumentNo()) + ":" + bill.getC_BPartner().getName(), bill.get_Table_ID(), bill.getJP_Bill_ID());
                bill = this.createBillHeader(invoice, this.m_BillSchema);
                lineCounter = 0;
                ++billCounter;
            } else if (oldInvoice.getAD_User_ID() != invoice.getAD_User_ID()) {
                bill.load(this.trxName);
                bill.processIt(this.p_DocAction);
                bill.saveEx(this.trxName);
                this.process.addBufferLog(0, null, null, String.valueOf(bill.getDocumentNo()) + ":" + bill.getC_BPartner().getName(), bill.get_Table_ID(), bill.getJP_Bill_ID());
                bill = this.createBillHeader(invoice, this.m_BillSchema);
                lineCounter = 0;
                ++billCounter;
            } else if (this.m_BillSchema.isBillOrgJP() && oldInvoice.getAD_Org_ID() != invoice.getAD_Org_ID()) {
                bill.load(this.trxName);
                bill.processIt(this.p_DocAction);
                bill.saveEx(this.trxName);
                this.process.addBufferLog(0, null, null, String.valueOf(bill.getDocumentNo()) + ":" + invoice.getC_BPartner().getName(), bill.get_Table_ID(), bill.getJP_Bill_ID());
                bill = this.createBillHeader(invoice, this.m_BillSchema);
                lineCounter = 0;
                ++billCounter;
            }
            MBillLine bLine = new MBillLine(this.ctx, 0, this.trxName);
            bLine.setJP_Bill_ID(bill.getJP_Bill_ID());
            bLine.setLine(++lineCounter * 10);
            bLine.setC_Invoice_ID(invoice.getC_Invoice_ID());
            bLine.setAD_Org_ID(bill.getAD_Org_ID());
            bLine.saveEx(this.trxName);
            oldInvoice = invoice;
        }
        if (bill != null) {
            bill.load(this.trxName);
            bill.processIt(this.p_DocAction);
            bill.saveEx(this.trxName);
            this.process.addBufferLog(0, null, null, String.valueOf(bill.getDocumentNo()) + " : " + bill.getC_BPartner().getName(), bill.get_Table_ID(), bill.getJP_Bill_ID());
        }
        return String.valueOf(Msg.getElement((Properties)this.ctx, (String)"JP_Bill_ID", (boolean)this.p_IsSOTrx)) + " #" + billCounter;
    }

    private MBill createBillHeader(MInvoice invoice, MBillSchema billSchema) {
        String sql = new String("select jp_paymenttermduedate(?,?) from Dual");
        Timestamp dueDate = DB.getSQLValueTS((String)this.trxName, (String)sql, (Object[])new Object[]{this.m_paymentTerm.getC_PaymentTerm_ID(), this.p_JPCutOffDate});
        MBill bill = new MBill(this.ctx, 0, this.trxName);
        if (billSchema.isBillOrgJP()) {
            bill.setAD_Org_ID(invoice.getAD_Org_ID());
        } else {
            bill.setAD_Org_ID(billSchema.getJP_BillOrg_ID());
        }
        bill.setAD_OrgTrx_ID(invoice.getAD_OrgTrx_ID());
        bill.setJPDateBilled(this.p_JPDateBilled);
        bill.setJPCutOffDate(this.p_JPCutOffDate);
        bill.setDateAcct(this.p_JPCutOffDate);
        bill.setSalesRep_ID(Env.getAD_User_ID((Properties)this.ctx));
        bill.setC_DocType_ID(billSchema.getC_DocType_ID());
        bill.setC_BPartner_ID(invoice.getC_BPartner_ID());
        bill.setC_BPartner_Location_ID(invoice.getC_BPartner_Location_ID());
        bill.setAD_User_ID(invoice.getAD_User_ID());
        bill.setPaymentRule(invoice.getPaymentRule());
        bill.setC_PaymentTerm_ID(invoice.getC_PaymentTerm_ID());
        bill.setC_Currency_ID(invoice.getC_Currency_ID());
        if (billSchema.getC_BankAccount_ID() > 0) {
            bill.setC_BankAccount_ID(billSchema.getC_BankAccount_ID());
        }
        bill.setJP_PromisedPayDate(dueDate);
        bill.setIsSOTrx(this.p_IsSOTrx);
        bill.setDocStatus("DR");
        bill.setDocAction(this.p_DocAction);
        bill.saveEx(this.trxName);
        return bill;
    }
}

