/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.process;

import java.util.Properties;
import jpiere.base.plugin.org.adempiere.model.MContractLine;
import jpiere.base.plugin.org.adempiere.model.MOrderJP;
import jpiere.base.plugin.org.adempiere.process.AbstractContractProcess;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.PO;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;

public class DefaultContractProcessCreateBaseOrder
extends AbstractContractProcess {
    @Override
    protected void prepare() {
        super.prepare();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected String doIt() throws Exception {
        super.doIt();
        int JP_ContractProcPeriod_ID = 0;
        if (this.m_ContractContent.getParent().getJP_ContractType().equals("PDC")) {
            JP_ContractProcPeriod_ID = this.getJP_ContractProctPeriod_ID();
        }
        if (this.m_ContractContent.getParent().getJP_ContractType().equals("PDC") && JP_ContractProcPeriod_ID == 0) {
            String descriptionMsg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"NotFound")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"JP_ContractProcPeriod_ID");
            this.createContractLogDetail("ZZ", null, null, descriptionMsg);
            return "";
        }
        MOrder[] orders = this.m_ContractContent.getOrderByContractPeriod(Env.getCtx(), JP_ContractProcPeriod_ID, this.get_TrxName());
        if (orders != null && orders.length > 0) {
            this.createContractLogDetail("B1", null, (PO)orders[0], null);
            return "";
        }
        MContractLine[] m_lines = this.m_ContractContent.getLines();
        boolean isCreateDocLine = false;
        int i = 0;
        while (i < m_lines.length) {
            if (!this.isCreateDocLine(m_lines[i], JP_ContractProcPeriod_ID, false)) {
                ++i;
                continue;
            }
            isCreateDocLine = true;
            break;
        }
        if (!isCreateDocLine) {
            this.createContractLogDetail("B2", null, null, null);
            return "";
        }
        MOrderJP order = new MOrderJP(this.getCtx(), 0, this.get_TrxName());
        PO.copyValues((PO)this.m_ContractContent, (PO)order);
        order.setProcessed(false);
        order.setDocStatus("DR");
        order.setAD_Org_ID(this.m_ContractContent.getAD_Org_ID());
        order.setAD_OrgTrx_ID(this.m_ContractContent.getAD_OrgTrx_ID());
        order.setDateOrdered(this.getDateOrdered());
        order.setDateAcct(this.getDateAcct());
        order.setDatePromised(this.getOrderHeaderDatePromised(this.p_DateAcct));
        order.setDocumentNo("");
        order.setC_DocTypeTarget_ID(this.m_ContractContent.getJP_BaseDocDocType_ID());
        order.setC_DocType_ID(this.m_ContractContent.getJP_BaseDocDocType_ID());
        order.set_ValueOfColumn("JP_Contract_ID", this.m_ContractContent.getParent().getJP_Contract_ID());
        order.set_ValueOfColumn("JP_ContractContent_ID", this.m_ContractContent.getJP_ContractContent_ID());
        if (this.m_ContractContent.getParent().getJP_ContractType().equals("PDC")) {
            order.set_ValueOfColumn("JP_ContractProcPeriod_ID", JP_ContractProcPeriod_ID);
        }
        try {
            order.saveEx(this.get_TrxName());
        }
        catch (AdempiereException e) {
            this.createContractLogDetail("Z1", null, null, e.getMessage());
            throw e;
        }
        isCreateDocLine = false;
        int i2 = 0;
        while (i2 < m_lines.length) {
            if (this.isCreateDocLine(m_lines[i2], JP_ContractProcPeriod_ID, true)) {
                MOrderLine oline = new MOrderLine(this.getCtx(), 0, this.get_TrxName());
                PO.copyValues((PO)m_lines[i2], (PO)oline);
                oline.setC_Order_ID(order.getC_Order_ID());
                oline.setAD_Org_ID(order.getAD_Org_ID());
                oline.setAD_OrgTrx_ID(order.getAD_OrgTrx_ID());
                oline.setProcessed(false);
                if (m_lines[i2].getC_BPartner_ID() == 0) {
                    oline.setC_BPartner_ID(order.getC_BPartner_ID());
                }
                if (m_lines[i2].getC_BPartner_Location_ID() == 0) {
                    oline.setC_BPartner_Location_ID(order.getC_BPartner_Location_ID());
                }
                oline.setM_Warehouse_ID(order.getM_Warehouse_ID());
                oline.setC_Currency_ID(order.getC_Currency_ID());
                if (m_lines[i2].getM_Product_ID() > 0) {
                    oline.setC_UOM_ID(m_lines[i2].getM_Product().getC_UOM_ID());
                    oline.setQtyEntered(m_lines[i2].getQtyOrdered());
                } else {
                    oline.setQtyEntered(m_lines[i2].getQtyEntered());
                }
                oline.setQtyOrdered(m_lines[i2].getQtyOrdered());
                oline.setQtyReserved(Env.ZERO);
                oline.setQtyDelivered(Env.ZERO);
                oline.setQtyInvoiced(Env.ZERO);
                oline.set_ValueNoCheck("JP_ContractLine_ID", (Object)m_lines[i2].getJP_ContractLine_ID());
                if (this.m_ContractContent.getParent().getJP_ContractType().equals("PDC")) {
                    oline.set_ValueOfColumn("JP_ContractProcPeriod_ID", (Object)JP_ContractProcPeriod_ID);
                }
                oline.setDateOrdered(order.getDateOrdered());
                oline.setDatePromised(this.getOrderLineDatePromised(m_lines[i2]));
                try {
                    oline.saveEx(this.get_TrxName());
                }
                catch (AdempiereException e) {
                    this.createContractLogDetail("Z1", null, (PO)order, e.getMessage());
                    throw e;
                }
                isCreateDocLine = true;
            }
            ++i2;
        }
        if (!isCreateDocLine) {
            order.deleteEx(true, this.get_TrxName());
            this.createContractLogDetail("B2", null, null, null);
            return "";
        }
        String docAction = this.getDocAction();
        this.updateContractProcStatus();
        if (!Util.isEmpty((String)docAction)) {
            if (!order.processIt(docAction)) {
                this.createContractLogDetail("Z2", null, (PO)order, order.getProcessMsg());
                throw new AdempiereException(order.getProcessMsg());
            }
            if (!docAction.equals("CO")) {
                order.setDocAction("CO");
                try {
                    order.saveEx(this.get_TrxName());
                }
                catch (AdempiereException e) {
                    this.createContractLogDetail("Z1", null, (PO)order, e.getMessage());
                    throw e;
                }
            }
        } else {
            order.setDocAction("CO");
            try {
                order.saveEx(this.get_TrxName());
            }
            catch (AdempiereException e) {
                this.createContractLogDetail("Z1", null, (PO)order, e.getMessage());
                throw e;
            }
        }
        this.createContractLogDetail("A1", null, (PO)order, null);
        return "";
    }

    private boolean isCreateDocLine(MContractLine contractLine, int JP_ContractProcPeriod_ID, boolean isCreateLog) {
        String logMsg = AbstractContractProcess.getSkipReason_CreateBaseOrderLine(this.getCtx(), this.m_ContractContent, contractLine, JP_ContractProcPeriod_ID, true, this.get_TrxName());
        if (logMsg == null) {
            return true;
        }
        if (isCreateLog) {
            if (logMsg.equals("B1")) {
                MOrderLine[] oLines = contractLine.getOrderLineByContractPeriod(this.getCtx(), JP_ContractProcPeriod_ID, this.get_TrxName());
                if (oLines != null && oLines.length > 0) {
                    this.createContractLogDetail(logMsg, contractLine, (PO)oLines[0], null);
                }
            } else {
                this.createContractLogDetail(logMsg, contractLine, null, null);
            }
        }
        return false;
    }
}

