/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.logging.Level;
import jpiere.base.plugin.org.adempiere.model.MBankData;
import jpiere.base.plugin.org.adempiere.model.MBankDataLine;
import jpiere.base.plugin.org.adempiere.model.MBankDataSchema;
import org.compiere.model.MOrder;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class DefaultBankDataMatchOrder
extends SvrProcess {
    private int p_JP_BankData_ID = 0;
    private MBankData m_BankData = null;
    private MBankDataSchema BDSchema = null;
    private int p_AD_Client_ID = 0;
    private Timestamp dateOrdered_From = null;
    private Timestamp dateOrdered_To = null;

    protected void prepare() {
        this.p_AD_Client_ID = this.getAD_Client_ID();
        this.p_JP_BankData_ID = this.getRecord_ID();
        this.m_BankData = new MBankData(this.getCtx(), this.p_JP_BankData_ID, this.get_TrxName());
        this.BDSchema = new MBankDataSchema(this.getCtx(), this.m_BankData.getJP_BankDataSchema_ID(), this.get_TrxName());
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("DateOrdered")) {
                    this.dateOrdered_From = para[i].getParameterAsTimestamp();
                    this.dateOrdered_To = para[i].getParameter_ToAsTimestamp();
                } else {
                    this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                }
            }
            ++i;
        }
    }

    protected String doIt() throws Exception {
        if (this.dateOrdered_From == null || this.dateOrdered_To == null) {
            throw new Exception("FillMandatory");
        }
        BigDecimal acceptableDiffAmt = this.BDSchema.getJP_AcceptableDiffAmt();
        MBankDataLine[] lines = this.m_BankData.getLines();
        String sql = "SELECT C_Order_ID FROM C_Order WHERE AD_Client_ID = ? AND IsSOTrx = 'Y' AND  C_BPartner_ID = ? AND DocStatus ='CO'  AND DateOrdered >= ? AND DateOrdered <= ?  ORDER BY DateOrdered ASC";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        int i = 0;
        while (i < lines.length) {
            block10: {
                try {
                    try {
                        pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
                        pstmt.setInt(1, this.p_AD_Client_ID);
                        pstmt.setInt(2, lines[i].getC_BPartner_ID());
                        pstmt.setTimestamp(3, this.dateOrdered_From);
                        pstmt.setTimestamp(4, this.dateOrdered_To);
                        rs = pstmt.executeQuery();
                        while (rs.next()) {
                            if (!lines[i].isMatchedJP()) {
                                int C_Order_ID = rs.getInt(1);
                                MOrder order = new MOrder(this.getCtx(), C_Order_ID, this.get_TrxName());
                                if (order.getC_Payment_ID() > 0) continue;
                                BigDecimal openAmt = order.getGrandTotal();
                                BigDecimal diffAmt = lines[i].getTrxAmt().subtract(openAmt);
                                if (diffAmt.abs().compareTo(acceptableDiffAmt.abs()) > 0) continue;
                                lines[i].setC_Order_ID(C_Order_ID);
                                if (diffAmt.compareTo(Env.ZERO) != 0) {
                                    lines[i].setTrxAmt(openAmt);
                                    lines[i].setChargeAmt(diffAmt);
                                    lines[i].setC_Charge_ID(this.BDSchema.getC_Charge_ID());
                                    lines[i].setC_Tax_ID(this.BDSchema.getC_Tax_ID());
                                }
                                lines[i].setIsMatchedJP(true);
                                lines[i].saveEx(this.get_TrxName());
                            }
                            break;
                        }
                    }
                    catch (Exception e) {
                        this.log.log(Level.SEVERE, sql, (Throwable)e);
                        DB.close(rs, (Statement)pstmt);
                        rs = null;
                        pstmt = null;
                        break block10;
                    }
                }
                catch (Throwable throwable) {
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    throw throwable;
                }
                DB.close((ResultSet)rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
            }
            ++i;
        }
        return null;
    }
}

