/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Properties;
import java.util.logging.Level;
import jpiere.base.plugin.org.adempiere.model.MBill;
import jpiere.base.plugin.org.adempiere.model.MBillLine;
import org.compiere.model.MInvoice;
import org.compiere.model.MPayment;
import org.compiere.model.MPaymentAllocate;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class CreatePaymentAllocateFromBill
extends SvrProcess {
    MPayment payment = null;
    int C_Payment_ID = 0;
    MBill bill = null;
    int JP_Bill_ID = 0;

    protected void prepare() {
        this.C_Payment_ID = this.getRecord_ID();
        this.payment = new MPayment(this.getCtx(), this.C_Payment_ID, this.get_TrxName());
        this.JP_Bill_ID = this.payment.get_ValueAsInt("JP_Bill_ID");
        this.bill = new MBill(this.getCtx(), this.JP_Bill_ID, this.get_TrxName());
    }

    protected String doIt() throws Exception {
        if (this.payment.getC_Currency_ID() != this.bill.getC_Currency_ID()) {
            return Msg.getMsg((Properties)this.getCtx(), (String)"JP_DifferentCurrency");
        }
        this.payment.setPayAmt(this.bill.getJPBillAmt());
        this.payment.saveEx(this.get_TrxName());
        MPaymentAllocate[] pAllocs = MPaymentAllocate.get((MPayment)this.payment);
        MBillLine[] billLines = this.bill.getLines();
        int counter = 0;
        int i = 0;
        while (i < billLines.length) {
            MInvoice inv = MInvoice.get((Properties)this.getCtx(), (int)billLines[i].getC_Invoice_ID());
            if (!inv.isPaid()) {
                boolean isContaine = false;
                int j = 0;
                while (j < pAllocs.length) {
                    if (inv.getC_Invoice_ID() == pAllocs[j].getC_Invoice_ID()) {
                        isContaine = true;
                        break;
                    }
                    ++j;
                }
                if (!isContaine) {
                    MPaymentAllocate pAllocate = new MPaymentAllocate(this.getCtx(), 0, this.get_TrxName());
                    pAllocate.setC_Payment_ID(this.C_Payment_ID);
                    pAllocate.setAD_Org_ID(this.payment.getAD_Org_ID());
                    pAllocate.setC_Invoice_ID(inv.getC_Invoice_ID());
                    int C_InvoicePaySchedule_ID = 0;
                    Timestamp ts = this.payment.getDateTrx();
                    String sql = "SELECT C_BPartner_ID,C_Currency_ID, invoiceOpen(C_Invoice_ID, ?), invoiceDiscount(C_Invoice_ID,?,?), IsSOTrx FROM C_Invoice WHERE C_Invoice_ID=?";
                    CPreparedStatement pstmt = null;
                    ResultSet rs = null;
                    try {
                        try {
                            pstmt = DB.prepareStatement((String)sql, null);
                            pstmt.setInt(1, C_InvoicePaySchedule_ID);
                            pstmt.setTimestamp(2, ts);
                            pstmt.setInt(3, C_InvoicePaySchedule_ID);
                            pstmt.setInt(4, inv.getC_Invoice_ID());
                            rs = pstmt.executeQuery();
                            if (rs.next()) {
                                BigDecimal DiscountAmt;
                                BigDecimal InvoiceOpen = rs.getBigDecimal(3);
                                if (InvoiceOpen == null) {
                                    InvoiceOpen = Env.ZERO;
                                }
                                if ((DiscountAmt = rs.getBigDecimal(4)) == null) {
                                    DiscountAmt = Env.ZERO;
                                }
                                pAllocate.setInvoiceAmt(InvoiceOpen);
                                pAllocate.setAmount(InvoiceOpen);
                                pAllocate.setDiscountAmt(Env.ZERO);
                            }
                        }
                        catch (SQLException e) {
                            this.log.log(Level.SEVERE, sql, (Throwable)e);
                            String string = e.getLocalizedMessage();
                            DB.close(rs, (Statement)pstmt);
                            rs = null;
                            pstmt = null;
                            return string;
                        }
                    }
                    catch (Throwable throwable) {
                        DB.close(rs, (Statement)pstmt);
                        rs = null;
                        pstmt = null;
                        throw throwable;
                    }
                    DB.close((ResultSet)rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    pAllocate.saveEx(this.get_TrxName());
                    ++counter;
                }
            }
            ++i;
        }
        return String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Created")) + " : " + counter;
    }
}

