/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import jpiere.base.plugin.org.adempiere.model.MBill;
import jpiere.base.plugin.org.adempiere.model.MBillLine;
import org.adempiere.util.Callback;
import org.adempiere.util.IProcessUI;
import org.compiere.model.MBankAccount;
import org.compiere.model.MInvoice;
import org.compiere.model.MPaySelection;
import org.compiere.model.MPaySelectionLine;
import org.compiere.model.Query;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class CreatePaySelectionFromBill
extends SvrProcess {
    private int p_C_BPartner_ID = 0;
    private int p_C_BP_Group_ID = 0;
    private Timestamp p_JP_PromisedPayDate_From = null;
    private Timestamp p_JP_PromisedPayDate_To = null;
    private boolean p_IsSOTrx = false;
    private String p_TargetPaymentRule = null;
    private int p_C_BankAccount_ID = 0;
    private Timestamp p_PayDate = null;
    private int p_JP_Bill_ID = 0;
    private boolean isCalledFromDocumentWindow = false;
    private boolean isCalledFromProcessWindow = false;
    private boolean isCalledFromInfoWindow = false;
    ArrayList<MBill> p_selectedBillList = new ArrayList();
    ArrayList<MBill> p_searchedBillList = new ArrayList();
    private MBankAccount mBankAccount = null;
    private IProcessUI processUI = null;
    private boolean isOpenDialog = false;
    private boolean isAskAnswer = true;
    private boolean isCreatePaySelection = false;
    private String returnMsg = "";
    private int lines = 0;

    protected void prepare() {
        String whereClause = "EXISTS (SELECT T_Selection_ID FROM T_Selection WHERE T_Selection.AD_PInstance_ID=? AND T_Selection.T_Selection_ID = JP_Bill.JP_Bill_ID)";
        List selectedBills = new Query(this.getCtx(), "JP_Bill", whereClause, this.get_TrxName()).setClient_ID().setParameters(new Object[]{this.getAD_PInstance_ID()}).list();
        this.p_JP_Bill_ID = this.getRecord_ID();
        if (this.p_JP_Bill_ID != 0) {
            this.isCalledFromDocumentWindow = true;
        }
        if (selectedBills.size() != 0) {
            this.isCalledFromInfoWindow = true;
            this.p_selectedBillList = (ArrayList)selectedBills;
        }
        if (!this.isCalledFromInfoWindow && !this.isCalledFromDocumentWindow) {
            this.isCalledFromProcessWindow = true;
        }
    }

    protected String doIt() throws Exception {
        this.processUI = Env.getProcessUI((Properties)this.getCtx());
        if (this.isCalledFromDocumentWindow) {
            ProcessInfoParameter[] para = this.getParameter();
            int i = 0;
            while (i < para.length) {
                String name = para[i].getParameterName();
                if (para[i].getParameter() != null) {
                    if (name.equals("TargetPaymentRule")) {
                        this.p_TargetPaymentRule = para[i].getParameterAsString();
                    } else if (name.equals("C_BankAccount_ID")) {
                        this.p_C_BankAccount_ID = para[i].getParameterAsInt();
                    } else if (name.equals("PayDate")) {
                        this.p_PayDate = (Timestamp)para[i].getParameter();
                    } else {
                        this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                    }
                }
                ++i;
            }
            final MBill mBill = new MBill(this.getCtx(), this.p_JP_Bill_ID, this.get_TrxName());
            this.mBankAccount = new MBankAccount(this.getCtx(), this.p_C_BankAccount_ID, this.get_TrxName());
            if (this.mBankAccount.getC_Currency_ID() != mBill.getC_Currency_ID()) {
                throw new Exception(Msg.getMsg((Properties)this.getCtx(), (String)"JP_DifferentCurrency"));
            }
            final MPaySelection psel = new MPaySelection(this.getCtx(), 0, this.get_TrxName());
            psel.setAD_Org_ID(this.mBankAccount.getAD_Org_ID());
            psel.setC_BankAccount_ID(this.p_C_BankAccount_ID);
            psel.setPayDate(this.p_PayDate);
            LocalDateTime dateTime = LocalDateTime.now();
            psel.setName(dateTime.truncatedTo(ChronoUnit.SECONDS).toString().replaceAll("T", " "));
            psel.set_ValueNoCheck("IsReceiptJP", (Object)mBill.isSOTrx());
            psel.saveEx(this.get_TrxName());
            if (this.processUI != null && mBill.getC_PaySelection_ID() != 0) {
                this.isOpenDialog = true;
                this.processUI.ask(Msg.getMsg((Properties)this.getCtx(), (String)"JP_CreatePSfromBillAgain"), (Callback)new Callback<Boolean>(){

                    public void onCallback(Boolean result) {
                        if (result.booleanValue()) {
                            CreatePaySelectionFromBill.this.returnMsg = CreatePaySelectionFromBill.this.createPaySelectionLine(psel, mBill);
                            CreatePaySelectionFromBill.this.isCreatePaySelection = true;
                        } else {
                            CreatePaySelectionFromBill.this.isAskAnswer = false;
                        }
                    }
                });
            } else {
                this.returnMsg = this.createPaySelectionLine(psel, mBill);
                this.isCreatePaySelection = true;
            }
            while (this.isOpenDialog && this.isAskAnswer && !this.isCreatePaySelection) {
                Thread.sleep(2000L);
            }
            if (this.isCreatePaySelection) {
                this.addBufferLog(0, null, null, String.valueOf(Msg.getElement((Properties)this.getCtx(), (String)"C_PaySelection_ID", (boolean)mBill.isSOTrx())) + " : " + psel.getName(), psel.get_Table_ID(), psel.getC_PaySelection_ID());
            }
            if (mBill.getC_PaySelection_ID() == 0) {
                mBill.setC_PaySelection_ID(psel.getC_PaySelection_ID());
                mBill.saveEx(this.get_TrxName());
            }
            return this.returnMsg;
        }
        if (this.isCalledFromInfoWindow) {
            ProcessInfoParameter[] para = this.getParameter();
            int i = 0;
            while (i < para.length) {
                String name = para[i].getParameterName();
                if (para[i].getParameter() != null) {
                    if (name.equals("TargetPaymentRule")) {
                        this.p_TargetPaymentRule = (String)para[i].getParameter();
                    } else if (name.equals("IsSOTrx")) {
                        this.p_IsSOTrx = "Y".equals(para[i].getParameter());
                    } else if (name.equals("C_BankAccount_ID")) {
                        this.p_C_BankAccount_ID = para[i].getParameterAsInt();
                    } else if (name.equals("PayDate")) {
                        this.p_PayDate = (Timestamp)para[i].getParameter();
                    } else {
                        this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                    }
                }
                ++i;
            }
            if (this.p_selectedBillList != null && this.p_selectedBillList.size() > 0) {
                this.mBankAccount = new MBankAccount(this.getCtx(), this.p_C_BankAccount_ID, this.get_TrxName());
                if (this.mBankAccount.getC_Currency_ID() != this.p_selectedBillList.get(0).getC_Currency_ID()) {
                    throw new Exception(Msg.getMsg((Properties)this.getCtx(), (String)"JP_DifferentCurrency"));
                }
                MPaySelection psel = new MPaySelection(this.getCtx(), 0, this.get_TrxName());
                psel.setAD_Org_ID(this.mBankAccount.getAD_Org_ID());
                psel.setC_BankAccount_ID(this.p_C_BankAccount_ID);
                psel.setPayDate(this.p_PayDate);
                LocalDateTime dateTime = LocalDateTime.now();
                psel.setName(dateTime.truncatedTo(ChronoUnit.SECONDS).toString().replaceAll("T", " "));
                psel.set_ValueNoCheck("IsReceiptJP", (Object)this.p_IsSOTrx);
                psel.saveEx(this.get_TrxName());
                int i2 = 0;
                while (i2 < this.p_selectedBillList.size()) {
                    MBill mBill = new MBill(this.getCtx(), this.p_selectedBillList.get(i2).getJP_Bill_ID(), this.get_TrxName());
                    if (this.mBankAccount.getC_Currency_ID() == mBill.getC_Currency_ID()) {
                        this.createPaySelectionLine(psel, mBill);
                        if (mBill.getC_PaySelection_ID() == 0) {
                            mBill.setC_PaySelection_ID(psel.getC_PaySelection_ID());
                            mBill.saveEx(this.get_TrxName());
                        }
                    }
                    ++i2;
                }
                this.addBufferLog(0, null, null, String.valueOf(Msg.getElement((Properties)this.getCtx(), (String)"C_PaySelection_ID", (boolean)this.p_IsSOTrx)) + " : " + psel.getName(), psel.get_Table_ID(), psel.getC_PaySelection_ID());
                return this.returnMsg;
            }
        } else if (this.isCalledFromProcessWindow) {
            ProcessInfoParameter[] para = this.getParameter();
            int i = 0;
            while (i < para.length) {
                String name = para[i].getParameterName();
                if (para[i].getParameter() != null) {
                    if (name.equals("C_BPartner_ID")) {
                        this.p_C_BPartner_ID = para[i].getParameterAsInt();
                    } else if (name.equals("C_BP_Group_ID")) {
                        this.p_C_BP_Group_ID = para[i].getParameterAsInt();
                    } else if (name.equals("JP_PromisedPayDate")) {
                        this.p_JP_PromisedPayDate_From = (Timestamp)para[i].getParameter();
                        this.p_JP_PromisedPayDate_To = (Timestamp)para[i].getParameter_To();
                    } else if (name.equals("TargetPaymentRule")) {
                        this.p_TargetPaymentRule = (String)para[i].getParameter();
                    } else if (name.equals("IsSOTrx")) {
                        this.p_IsSOTrx = "Y".equals(para[i].getParameter());
                    } else if (name.equals("C_BankAccount_ID")) {
                        this.p_C_BankAccount_ID = para[i].getParameterAsInt();
                    } else if (name.equals("PayDate")) {
                        this.p_PayDate = (Timestamp)para[i].getParameter();
                    } else {
                        this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                    }
                }
                ++i;
            }
            this.mBankAccount = new MBankAccount(this.getCtx(), this.p_C_BankAccount_ID, this.get_TrxName());
            StringBuilder sql = new StringBuilder("SELECT * FROM JP_Bill WHERE DocStatus IN ('CO','CL') ");
            if (this.p_C_BPartner_ID != 0) {
                sql.append("AND C_BPartner_ID = ").append(this.p_C_BPartner_ID);
            }
            if (this.p_C_BP_Group_ID != 0) {
                sql.append(" AND C_BP_Group_ID = ").append(this.p_C_BP_Group_ID);
            }
            if (this.p_JP_PromisedPayDate_From != null) {
                sql.append(" AND JP_PromisedPayDate >= '").append(this.p_JP_PromisedPayDate_From).append("'");
            }
            if (this.p_JP_PromisedPayDate_To != null) {
                sql.append(" AND JP_PromisedPayDate <= '").append(this.p_JP_PromisedPayDate_To).append("'");
            }
            if (this.p_IsSOTrx) {
                sql.append(" AND IsSOTrx='Y'");
            } else {
                sql.append(" AND IsSOTrx='N'");
            }
            sql.append(" AND C_Currency_ID = " + this.mBankAccount.getC_Currency_ID());
            sql.append(" AND C_PaySelection_ID is null ");
            sql.append(" ORDER BY C_BPartner_ID ");
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql.toString(), (String)this.get_TrxName());
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        this.p_searchedBillList.add(new MBill(this.getCtx(), rs, this.get_TrxName()));
                    }
                }
                catch (Exception e) {
                    throw new Exception(Msg.getMsg((Properties)this.getCtx(), (String)"DBExecuteError"));
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
            if (this.p_searchedBillList != null && this.p_searchedBillList.size() > 0) {
                MPaySelection psel = new MPaySelection(this.getCtx(), 0, this.get_TrxName());
                psel.setAD_Org_ID(this.mBankAccount.getAD_Org_ID());
                psel.setC_BankAccount_ID(this.p_C_BankAccount_ID);
                psel.setPayDate(this.p_PayDate);
                LocalDateTime dateTime = LocalDateTime.now();
                psel.setName(dateTime.truncatedTo(ChronoUnit.SECONDS).toString().replaceAll("T", " "));
                psel.set_ValueNoCheck("IsReceiptJP", (Object)this.p_IsSOTrx);
                psel.saveEx(this.get_TrxName());
                int i3 = 0;
                while (i3 < this.p_searchedBillList.size()) {
                    this.createPaySelectionLine(psel, this.p_searchedBillList.get(i3));
                    MBill mBill = new MBill(this.getCtx(), this.p_searchedBillList.get(i3).getJP_Bill_ID(), this.get_TrxName());
                    if (mBill.getC_PaySelection_ID() == 0) {
                        mBill.setC_PaySelection_ID(psel.getC_PaySelection_ID());
                        mBill.saveEx(this.get_TrxName());
                    }
                    ++i3;
                }
                this.addBufferLog(0, null, null, String.valueOf(Msg.getElement((Properties)this.getCtx(), (String)"C_PaySelection_ID", (boolean)this.p_IsSOTrx)) + " : " + psel.getName(), psel.get_Table_ID(), psel.getC_PaySelection_ID());
                return this.returnMsg;
            }
        }
        return "";
    }

    private String createPaySelectionLine(MPaySelection paySelection, MBill bill) {
        MBillLine[] billLines = bill.getLines();
        int i = 0;
        while (i < billLines.length) {
            MInvoice invoice = new MInvoice(this.getCtx(), billLines[i].getC_Invoice_ID(), this.get_TrxName());
            if (!invoice.isPaid() && (invoice.getDocStatus().equals("CO") || invoice.getDocStatus().equals("CL")) && this.mBankAccount.getC_Currency_ID() == invoice.getC_Currency_ID()) {
                ++this.lines;
                BigDecimal openAmt = invoice.getOpenAmt();
                MPaySelectionLine pselLine = new MPaySelectionLine(paySelection, this.lines * 10, bill.getPaymentRule());
                pselLine.setInvoice(invoice.getC_Invoice_ID(), invoice.isSOTrx(), openAmt, openAmt, Env.ZERO, Env.ZERO);
                pselLine.saveEx(this.get_TrxName());
            }
            ++i;
        }
        return "";
    }
}

