/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import jpiere.base.plugin.org.adempiere.model.MContractContent;
import jpiere.base.plugin.org.adempiere.model.MContractLog;
import jpiere.base.plugin.org.adempiere.model.MContractLogDetail;
import jpiere.base.plugin.org.adempiere.model.MRecognition;
import jpiere.base.plugin.org.adempiere.model.MRecognitionLine;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.util.IProcessUI;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class CreateInvoiceFromRecogLump
extends SvrProcess {
    private Timestamp p_DateInvoiced = null;
    private Timestamp p_DateAcct = null;
    private String p_DocAction = null;
    private int p_AD_Org_ID = 0;
    private int p_JP_ContractCategory_ID = 0;
    private boolean p_IsSOTrx = true;
    private boolean p_IsRecordCommitJP = false;
    private String p_JP_ContractProcessTraceLevel = null;
    private MContractLog m_ContractLog = null;
    private IProcessUI processUI = null;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("DateInvoiced")) {
                    this.p_DateInvoiced = para[i].getParameterAsTimestamp();
                } else if (name.equals("DateAcct")) {
                    this.p_DateAcct = para[i].getParameterAsTimestamp();
                } else if (name.equals("DocAction")) {
                    this.p_DocAction = para[i].getParameterAsString();
                } else if (name.equals("AD_Org_ID")) {
                    this.p_AD_Org_ID = para[i].getParameterAsInt();
                } else if (name.equals("JP_ContractCategory_ID")) {
                    this.p_JP_ContractCategory_ID = para[i].getParameterAsInt();
                } else if (name.equals("IsSOTrx")) {
                    this.p_IsSOTrx = para[i].getParameterAsBoolean();
                } else if (name.equals("IsRecordCommitJP")) {
                    this.p_IsRecordCommitJP = para[i].getParameterAsBoolean();
                } else if (name.equals("JP_ContractProcessTraceLevel")) {
                    this.p_JP_ContractProcessTraceLevel = para[i].getParameterAsString();
                } else {
                    this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                }
            }
            ++i;
        }
        this.m_ContractLog = new MContractLog(this.getCtx(), 0, this.get_TrxName());
        this.m_ContractLog.setAD_PInstance_ID(this.getAD_PInstance_ID());
        this.m_ContractLog.setJP_ContractProcessTraceLevel(this.p_JP_ContractProcessTraceLevel);
        this.m_ContractLog.saveEx(this.get_TrxName());
        int JP_ContractLog_ID = this.m_ContractLog.getJP_ContractLog_ID();
        this.addBufferLog(0, null, null, String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"JP_DetailLog")) + " -> " + Msg.getElement((Properties)this.getCtx(), (String)"JP_ContractLog_ID"), MContractLog.Table_ID, JP_ContractLog_ID);
        this.processUI = Env.getProcessUI((Properties)this.getCtx());
    }

    protected String doIt() throws Exception {
        StringBuilder returnMsg = new StringBuilder("");
        String processMsg = null;
        try {
            processMsg = this.createInvoice();
        }
        catch (Exception e) {
            if (!this.p_IsRecordCommitJP) {
                throw e;
            }
        }
        returnMsg.append(Msg.getMsg((Properties)this.getCtx(), (String)"JP_CreateDocNum")).append(":").append(this.m_ContractLog.createDocNum).append(" / ");
        returnMsg.append(Msg.getMsg((Properties)this.getCtx(), (String)"JP_ToBeConfirmed")).append(":").append(this.m_ContractLog.confirmNum).append(" / ");
        returnMsg.append(Msg.getMsg((Properties)this.getCtx(), (String)"JP_NumberOfWarnings")).append(":").append(this.m_ContractLog.warnNum).append(" / ");
        returnMsg.append(Msg.getMsg((Properties)this.getCtx(), (String)"JP_NumberOfErrors")).append(":").append(this.m_ContractLog.errorNum).append("  ");
        return String.valueOf(processMsg) + " ( " + returnMsg.toString() + " ) ";
    }

    private String createInvoice() throws Exception {
        StringBuilder getContractContentSQL = new StringBuilder("");
        getContractContentSQL.append("SELECT DISTINCT o.* FROM C_Order o  INNER JOIN C_OrderLine ol ON (o.C_Order_ID = ol.C_Order_ID) INNER JOIN JP_ContractContent cc ON (o.JP_ContractContent_ID = cc.JP_ContractContent_ID) INNER JOIN JP_Contract_Acct ca ON (cc.JP_Contract_Acct_ID = ca.JP_Contract_Acct_ID) INNER JOIN JP_Contract c ON (c.JP_Contract_ID = cc.JP_Contract_ID) WHERE o.AD_Client_ID = ? AND o.DocStatus in('CO','CL') AND ol.QtyDelivered = ol.QtyOrdered  AND ol.QtyDelivered = ol.JP_QtyRecognized  AND ol.QtyDelivered <> ol.QtyInvoiced  AND ca.JP_RecogToInvoicePolicy = 'LP' ");
        if (this.p_IsSOTrx) {
            getContractContentSQL.append(" AND o.IsSOTrx='Y' ");
        } else {
            getContractContentSQL.append(" AND o.IsSOTrx='N' ");
        }
        if (this.p_AD_Org_ID > 0) {
            getContractContentSQL.append(" AND o.AD_Org_ID = ? ");
        }
        if (this.p_JP_ContractCategory_ID > 0) {
            getContractContentSQL.append(" AND c.JP_ContractCategory_ID = ?");
        }
        ArrayList<MOrder> orderList = new ArrayList<MOrder>();
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                pstmt = DB.prepareStatement((String)getContractContentSQL.toString(), null);
                int i = 1;
                pstmt.setInt(i++, this.getAD_Client_ID());
                if (this.p_AD_Org_ID > 0) {
                    pstmt.setInt(i++, this.p_AD_Org_ID);
                }
                if (this.p_JP_ContractCategory_ID > 0) {
                    pstmt.setInt(i++, this.p_JP_ContractCategory_ID);
                }
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    orderList.add(new MOrder(this.getCtx(), rs, this.get_TrxName()));
                }
            }
            catch (Exception e) {
                throw new Exception(e);
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close((ResultSet)rs, (Statement)pstmt);
        rs = null;
        pstmt = null;
        for (MOrder order : orderList) {
            boolean isCreateInvoice = true;
            MOrderLine[] oLines = order.getLines();
            Object obj_QtyRecognized = null;
            BigDecimal JP_QtyRecognized = Env.ZERO;
            int i = 0;
            while (i < oLines.length) {
                obj_QtyRecognized = oLines[i].get_Value("JP_QtyRecognized");
                if (obj_QtyRecognized == null) {
                    isCreateInvoice = false;
                    String msg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"JP_Null")) + " : " + Msg.getMsg((Properties)this.getCtx(), (String)"JP_QtyRecognized");
                    this.createContractLogDetail("ZZ", (PO)oLines[i], msg, "ERR");
                    break;
                }
                JP_QtyRecognized = (BigDecimal)obj_QtyRecognized;
                if (oLines[i].getQtyOrdered().compareTo(oLines[i].getQtyDelivered()) != 0 || oLines[i].getQtyDelivered().compareTo(JP_QtyRecognized) != 0 || oLines[i].getQtyInvoiced().compareTo(Env.ZERO) != 0) {
                    if (oLines[i].getQtyInvoiced().compareTo(Env.ZERO) != 0) {
                        this.createContractLogDetail("C1", (PO)oLines[i], Msg.getMsg((Properties)this.getCtx(), (String)"JP_RecogToInvoicePolicy_Lump_Invoiced"), "WAR");
                    } else if (oLines[i].getQtyOrdered().compareTo(oLines[i].getQtyDelivered()) != 0) {
                        this.createContractLogDetail("C2", (PO)oLines[i], "", "FIN");
                    } else if (oLines[i].getQtyDelivered().compareTo(JP_QtyRecognized) != 0) {
                        this.createContractLogDetail("C3", (PO)oLines[i], "", "FIN");
                    } else {
                        this.createContractLogDetail("ZZ", (PO)oLines[i], "", "ERR");
                    }
                    isCreateInvoice = false;
                    break;
                }
                obj_QtyRecognized = null;
                JP_QtyRecognized = Env.ZERO;
                ++i;
            }
            if (!isCreateInvoice) continue;
            MRecognition[] recogs = this.getRecognitionByOrder(order.getC_Order_ID());
            int i2 = 0;
            while (i2 < recogs.length) {
                if (recogs[i2].getC_Invoice_ID() > 0) {
                    isCreateInvoice = false;
                    this.createContractLogDetail("C1", recogs[i2], Msg.getMsg((Properties)this.getCtx(), (String)"JP_RecogToInvoicePolicy_Lump_Invoiced"), "WAR");
                    break;
                }
                MRecognitionLine[] rLines = recogs[i2].getLines();
                int j = 0;
                while (j < rLines.length) {
                    if (rLines[j].getC_InvoiceLine_ID() > 0) {
                        isCreateInvoice = false;
                        this.createContractLogDetail("C1", rLines[j], Msg.getMsg((Properties)this.getCtx(), (String)"JP_RecogToInvoicePolicy_Lump_Invoiced"), "WAR");
                        break;
                    }
                    ++j;
                }
                if (!isCreateInvoice) break;
                ++i2;
            }
            if (!isCreateInvoice) continue;
            int linecounter = 1;
            MInvoice invoice = null;
            boolean isCreateHeader = false;
            int i3 = 0;
            while (i3 < recogs.length) {
                if (!isCreateHeader) {
                    invoice = new MInvoice(order, order.getC_DocTypeTarget().getC_DocTypeInvoice_ID(), this.p_DateInvoiced);
                    invoice.setDateAcct(this.p_DateAcct);
                    invoice.setDocumentNo(null);
                    invoice.setTotalLines(Env.ZERO);
                    invoice.setGrandTotal(Env.ZERO);
                    invoice.setDocStatus("DR");
                    invoice.setDocAction("CO");
                    try {
                        invoice.saveEx(this.get_TrxName());
                    }
                    catch (AdempiereException e) {
                        this.createContractLogDetail("Z1", null, e.getMessage(), "ERR");
                        throw e;
                    }
                    isCreateHeader = true;
                    this.createContractLogDetail("A1", (PO)invoice, null, "FIN");
                    ++this.m_ContractLog.createDocNum;
                    if (this.processUI != null) {
                        this.processUI.statusUpdate(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"JP_CreateDocNum")) + " : " + this.m_ContractLog.createDocNum);
                    }
                }
                recogs[i3].setC_Invoice_ID(invoice.getC_Invoice_ID());
                recogs[i3].setDateInvoiced(this.p_DateInvoiced);
                try {
                    recogs[i3].saveEx(this.get_TrxName());
                }
                catch (AdempiereException e) {
                    this.createContractLogDetail("Z1", recogs[i3], e.getMessage(), "ERR");
                    throw e;
                }
                MRecognitionLine[] rLines = recogs[i3].getLines();
                int j = 0;
                while (j < rLines.length) {
                    MInvoiceLine iLine = new MInvoiceLine(this.getCtx(), 0, this.get_TrxName());
                    PO.copyValues((PO)rLines[j], (PO)iLine);
                    iLine.setC_Invoice_ID(invoice.getC_Invoice_ID());
                    iLine.setC_InvoiceLine_ID(0);
                    iLine.setAD_Org_ID(invoice.getAD_Org_ID());
                    iLine.setLine(linecounter * 10);
                    ++linecounter;
                    iLine.setM_InOutLine_ID(rLines[j].getM_InOutLine_ID());
                    iLine.set_ValueNoCheck("JP_RecognitionLine_ID", (Object)rLines[j].getJP_RecognitionLine_ID());
                    try {
                        iLine.saveEx(this.get_TrxName());
                    }
                    catch (AdempiereException e) {
                        this.createContractLogDetail("Z1", null, e.getMessage(), "ERR");
                        throw e;
                    }
                    rLines[j].setC_InvoiceLine_ID(iLine.getC_InvoiceLine_ID());
                    try {
                        rLines[j].saveEx(this.get_TrxName());
                    }
                    catch (AdempiereException e) {
                        this.createContractLogDetail("Z1", rLines[j], e.getMessage(), "ERR");
                        throw e;
                    }
                    ++j;
                }
                ++i3;
            }
            if (invoice != null && this.p_DocAction != null) {
                if (!invoice.processIt(this.p_DocAction)) {
                    this.createContractLogDetail("Z2", (PO)invoice, invoice.getProcessMsg(), "ERR");
                    throw new AdempiereException(invoice.getProcessMsg());
                }
                if (!invoice.getDocStatus().equals("CO")) {
                    try {
                        invoice.saveEx(this.get_TrxName());
                    }
                    catch (AdempiereException e) {
                        this.createContractLogDetail("Z1", (PO)invoice, e.getMessage(), "ERR");
                        throw e;
                    }
                }
            }
            this.addBufferLog(0, null, null, invoice.getDocumentNo(), 318, invoice.getC_Invoice_ID());
            if (!this.p_IsRecordCommitJP) continue;
            this.commitEx();
        }
        return "@Success@";
    }

    private MRecognition[] getRecognitionByOrder(int C_Order_ID) {
        StringBuilder whereClauseFinal = new StringBuilder("C_Order_ID=? AND M_RMA_ID is null AND DocStatus in ('CO','CL')");
        String orderClause = "JP_Recognition_ID";
        List list = new Query(this.getCtx(), "JP_Recognition", whereClauseFinal.toString(), this.get_TrxName()).setParameters(new Object[]{C_Order_ID}).setOrderBy(orderClause).list();
        return list.toArray(new MRecognition[list.size()]);
    }

    private void createContractLogDetail(String ContractLogMsg, PO po, String descriptionMsg, String JP_ContractProcessTraceLevel) {
        if (!JP_ContractProcessTraceLevel.equals("FIN")) {
            if (JP_ContractProcessTraceLevel.equals("TBC")) {
                ++this.m_ContractLog.confirmNum;
            } else if (JP_ContractProcessTraceLevel.equals("WAR")) {
                ++this.m_ContractLog.warnNum;
            } else if (JP_ContractProcessTraceLevel.equals("ERR")) {
                ++this.m_ContractLog.errorNum;
            }
        }
        if (!this.p_JP_ContractProcessTraceLevel.equals("FIN") && (this.p_JP_ContractProcessTraceLevel.equals("TBC") ? JP_ContractProcessTraceLevel.equals("FIN") : (this.p_JP_ContractProcessTraceLevel.equals("WAR") ? JP_ContractProcessTraceLevel.equals("FIN") || JP_ContractProcessTraceLevel.equals("TBC") : (this.p_JP_ContractProcessTraceLevel.equals("ERR") ? JP_ContractProcessTraceLevel.equals("FIN") || JP_ContractProcessTraceLevel.equals("TBC") || JP_ContractProcessTraceLevel.equals("WAR") : this.p_JP_ContractProcessTraceLevel.equals("NON"))))) {
            return;
        }
        MContractLogDetail logDetail = new MContractLogDetail(this.getCtx(), 0, this.m_ContractLog.get_TrxName());
        logDetail.setJP_ContractLog_ID(this.m_ContractLog.getJP_ContractLog_ID());
        logDetail.setJP_ContractLogMsg(ContractLogMsg);
        if (descriptionMsg != null) {
            logDetail.setDescription(descriptionMsg);
        }
        logDetail.setJP_ContractProcessTraceLevel(JP_ContractProcessTraceLevel);
        logDetail.set_ValueNoCheck("AD_Table_ID", po.get_Table_ID());
        logDetail.set_ValueNoCheck("Record_ID", po.get_ID());
        if (po.get_TableName().equals("C_Order")) {
            MOrder order = (MOrder)po;
            logDetail.setC_Order_ID(order.getC_Order_ID());
            MContractContent content = MContractContent.get(this.getCtx(), order.get_ValueAsInt("JP_ContractContent_ID"));
            logDetail.setJP_Contract_ID(content.getJP_Contract_ID());
            logDetail.setJP_ContractContent_ID(content.getJP_ContractContent_ID());
        } else if (po.get_TableName().equals("C_OrderLine")) {
            MOrderLine orderLine = (MOrderLine)po;
            logDetail.setC_Order_ID(orderLine.getC_Order_ID());
            logDetail.setC_OrderLine_ID(orderLine.getC_OrderLine_ID());
            MContractContent content = MContractContent.get(this.getCtx(), orderLine.getParent().get_ValueAsInt("JP_ContractContent_ID"));
            logDetail.setJP_Contract_ID(content.getJP_Contract_ID());
            logDetail.setJP_ContractContent_ID(content.getJP_ContractContent_ID());
            int JP_ContractLine_ID = orderLine.get_ValueAsInt("JP_ContractLine_ID");
            if (JP_ContractLine_ID > 0) {
                logDetail.setJP_ContractLine_ID(JP_ContractLine_ID);
            }
        } else if (po.get_TableName().equals("JP_Recognition")) {
            MRecognition recog = (MRecognition)po;
            logDetail.setC_Order_ID(recog.getC_Order_ID());
            logDetail.setM_InOut_ID(recog.getM_InOut_ID());
            logDetail.setJP_Recognition_ID(recog.getJP_Recognition_ID());
            logDetail.setC_Invoice_ID(recog.getC_Invoice_ID());
            MContractContent content = MContractContent.get(this.getCtx(), recog.getJP_ContractContent_ID());
            logDetail.setJP_Contract_ID(content.getJP_Contract_ID());
            logDetail.setJP_ContractContent_ID(content.getJP_ContractContent_ID());
        } else if (po.get_TableName().equals("JP_RecognitionLine")) {
            MRecognitionLine rLine = (MRecognitionLine)po;
            logDetail.setC_OrderLine_ID(rLine.getC_OrderLine_ID());
            logDetail.setM_InOutLine_ID(rLine.getM_InOutLine_ID());
            logDetail.setJP_Recognition_ID(rLine.getJP_Recognition_ID());
            logDetail.setJP_RecognitionLine_ID(rLine.getJP_RecognitionLine_ID());
            logDetail.setC_InvoiceLine_ID(rLine.getC_InvoiceLine_ID());
            MContractContent content = MContractContent.get(this.getCtx(), rLine.getParent().getJP_ContractContent_ID());
            logDetail.setJP_Contract_ID(content.getJP_Contract_ID());
            logDetail.setJP_ContractContent_ID(content.getJP_ContractContent_ID());
            int JP_ContractLine_ID = rLine.getJP_ContractLine_ID();
            if (JP_ContractLine_ID > 0) {
                logDetail.setJP_ContractLine_ID(JP_ContractLine_ID);
            }
        } else if (po.get_TableName().equals("C_Invoice")) {
            MInvoice invoice = (MInvoice)po;
            logDetail.setC_Order_ID(invoice.getC_Order_ID());
            logDetail.setC_Invoice_ID(invoice.getC_Invoice_ID());
            MContractContent content = MContractContent.get(this.getCtx(), invoice.get_ValueAsInt("JP_ContractContent_ID"));
            logDetail.setJP_Contract_ID(content.getJP_Contract_ID());
            logDetail.setJP_ContractContent_ID(content.getJP_ContractContent_ID());
        }
        logDetail.saveEx(this.get_TrxName());
    }
}

