/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.process;

import java.util.Properties;
import java.util.logging.Level;
import jpiere.base.plugin.org.adempiere.model.MContract;
import jpiere.base.plugin.org.adempiere.model.MContractContent;
import jpiere.base.plugin.org.adempiere.model.MContractContentT;
import jpiere.base.plugin.org.adempiere.model.MContractLine;
import jpiere.base.plugin.org.adempiere.model.MContractLineT;
import jpiere.base.plugin.org.adempiere.model.MContractProcessList;
import jpiere.base.plugin.org.adempiere.model.MContractProcessRef;
import jpiere.base.plugin.org.adempiere.model.MContractT;
import jpiere.base.plugin.org.adempiere.model.MEstimation;
import jpiere.base.plugin.org.adempiere.process.AbstractCreateContractFromTemplate;
import org.adempiere.util.Callback;
import org.adempiere.util.IProcessUI;
import org.compiere.model.PO;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;

public class CreateContractfromEstimationAndTemplate
extends AbstractCreateContractFromTemplate {
    private int p_JP_Estimation_ID = 0;
    private int p_JP_ContractT_ID = 0;
    private MEstimation estimation = null;
    private IProcessUI processUI = null;
    private boolean isCreateSO = false;
    private boolean isOpenDialog = false;
    private boolean isAskAnswer = true;
    private String errorMsg = "";
    private String returnMsg = "";

    @Override
    protected void prepare() {
        this.p_JP_Estimation_ID = this.getRecord_ID();
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("JP_ContractT_ID")) {
                    this.p_JP_ContractT_ID = para[i].getParameterAsInt();
                } else {
                    this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                }
            }
            ++i;
        }
        this.processUI = Env.getProcessUI((Properties)this.getCtx());
        this.estimation = new MEstimation(this.getCtx(), this.p_JP_Estimation_ID, this.get_TrxName());
    }

    @Override
    protected String doIt() throws Exception {
        if (this.estimation.getC_BPartner_ID() == 0) {
            this.errorMsg = String.valueOf(this.errorMsg) + Msg.getMsg((Properties)this.getCtx(), (String)"FillMandatory") + " : " + Msg.getElement((Properties)this.getCtx(), (String)"C_BPartner_ID") + System.lineSeparator();
        }
        if (this.estimation.getC_BPartner_Location_ID() == 0) {
            this.errorMsg = String.valueOf(this.errorMsg) + Msg.getMsg((Properties)this.getCtx(), (String)"FillMandatory") + " : " + Msg.getElement((Properties)this.getCtx(), (String)"C_BPartner_Location_ID") + System.lineSeparator();
        }
        if (!Util.isEmpty((String)this.errorMsg)) {
            throw new Exception(this.errorMsg);
        }
        MContract[] contracts = MContract.getContractByEstimation(this.getCtx(), this.p_JP_Estimation_ID, this.get_TrxName());
        if (this.processUI != null && contracts.length > 0) {
            this.isOpenDialog = true;
            this.processUI.ask("JP_CreateContractFromEstimationAgain", (Callback)new Callback<Boolean>(){

                public void onCallback(Boolean result) {
                    if (result.booleanValue()) {
                        try {
                            try {
                                CreateContractfromEstimationAndTemplate.this.returnMsg = CreateContractfromEstimationAndTemplate.this.createContract();
                            }
                            catch (Exception e) {
                                CreateContractfromEstimationAndTemplate.this.returnMsg = e.getMessage();
                                CreateContractfromEstimationAndTemplate.this.isCreateSO = true;
                            }
                        }
                        finally {
                            CreateContractfromEstimationAndTemplate.this.isCreateSO = true;
                        }
                    } else {
                        CreateContractfromEstimationAndTemplate.this.isAskAnswer = false;
                    }
                }
            });
        } else {
            this.returnMsg = this.createContract();
            this.isCreateSO = true;
        }
        while (this.isOpenDialog && this.isAskAnswer && !this.isCreateSO) {
            Thread.sleep(2000L);
        }
        if (!Util.isEmpty((String)this.returnMsg)) {
            throw new Exception(this.returnMsg);
        }
        if (this.isCreateSO) {
            this.addBufferLog(0, null, null, this.m_Contract.getDocumentNo(), MContract.Table_ID, this.m_Contract.getJP_Contract_ID());
        }
        return "";
    }

    private String createContract() {
        this.m_Contract = new MContract(this.getCtx(), 0, this.get_TrxName());
        MContractT contractTemplate = MContractT.get(this.getCtx(), this.p_JP_ContractT_ID);
        PO.copyValues((PO)contractTemplate, (PO)this.m_Contract);
        PO.copyValues((PO)this.estimation, (PO)this.m_Contract);
        this.m_Contract.setAD_Org_ID(this.estimation.getAD_Org_ID());
        this.m_Contract.setJP_ContractT_ID(contractTemplate.getJP_ContractT_ID());
        this.m_Contract.setC_DocType_ID(contractTemplate.getC_DocType_ID());
        this.m_Contract.setDateDoc(this.estimation.getDateOrdered());
        this.m_Contract.setDateAcct(this.estimation.getDateAcct());
        this.m_Contract.setJP_ContractPeriodDate_From(this.estimation.getDateAcct());
        if (contractTemplate.getC_DocType().isDocNoControlled()) {
            this.m_Contract.setDocumentNo(null);
        }
        this.m_Contract.setJP_Estimation_ID(this.estimation.getJP_Estimation_ID());
        this.m_Contract.setDocStatus("DR");
        this.m_Contract.setDocAction("CO");
        this.m_Contract.setJP_ContractStatus("PR");
        try {
            this.m_Contract.saveEx(this.get_TrxName());
        }
        catch (Exception e) {
            return String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"SaveError")) + Msg.getElement((Properties)this.getCtx(), (String)"JP_Contract_ID") + " >>> " + e.getMessage();
        }
        MContractContentT[] contractContentTemplates = contractTemplate.getContractContentTemplates();
        int i = 0;
        while (i < contractContentTemplates.length) {
            MContractProcessRef contractProcessRef;
            MContractProcessList[] contractProcessLists;
            MContractContent contractContent = new MContractContent(this.getCtx(), 0, this.get_TrxName());
            PO.copyValues((PO)contractContentTemplates[i], (PO)contractContent);
            PO.copyValues((PO)this.estimation, (PO)contractContent);
            contractContent.setAD_Org_ID(this.estimation.getAD_Org_ID());
            contractContent.setAD_OrgTrx_ID(this.estimation.getAD_OrgTrx_ID());
            contractContent.setJP_Contract_ID(this.m_Contract.getJP_Contract_ID());
            contractContent.setJP_ContractContentT_ID(contractContentTemplates[i].getJP_ContractContentT_ID());
            contractContent.setC_DocType_ID(contractContentTemplates[i].getC_DocType_ID());
            if (contractContent.getC_DocType().isDocNoControlled()) {
                contractContent.setDocumentNo(null);
            }
            contractContent.setJP_Contract_Acct_ID(contractContentTemplates[i].getJP_Contract_Acct_ID());
            contractContent.setDateDoc(this.m_Contract.getDateDoc());
            contractContent.setDateAcct(this.m_Contract.getDateAcct());
            contractContent.setDatePromised(this.calculateDate(this.m_Contract.getDateAcct(), contractContentTemplates[i].getDeliveryTime_Promised()));
            contractContent.setDateInvoiced(this.m_Contract.getDateAcct());
            this.setContractContentProcDate(contractContent, contractContentTemplates[i]);
            int JP_ContractProcessRef_ID = contractContentTemplates[i].getJP_ContractProcessRef_ID();
            if (JP_ContractProcessRef_ID > 0 && (contractProcessLists = (contractProcessRef = MContractProcessRef.get(this.getCtx(), JP_ContractProcessRef_ID)).getContractProcessList(this.getCtx(), true, this.get_TrxName())).length == 1) {
                contractContent.setJP_ContractProcess_ID(contractProcessLists[0].getJP_ContractProcess_ID());
            }
            if (contractContentTemplates[i].getC_BPartner_ID() == 0) {
                contractContent.setC_BPartner_ID(this.m_Contract.getC_BPartner_ID());
                contractContent.setC_BPartner_Location_ID(this.m_Contract.getC_BPartner_Location_ID());
                contractContent.setAD_User_ID(this.m_Contract.getAD_User_ID());
            }
            contractContent.setTotalLines(Env.ZERO);
            contractContent.setDocStatus("DR");
            contractContent.setDocAction("CO");
            contractContent.setJP_ContractProcStatus("UN");
            contractContent.setC_Currency_ID(contractContent.getM_PriceList().getC_Currency_ID());
            try {
                this.setWarehouseOfContractContent(contractContentTemplates[i], contractContent);
            }
            catch (Exception e) {
                return e.getMessage();
            }
            try {
                contractContent.saveEx(this.get_TrxName());
            }
            catch (Exception e) {
                return String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"SaveError")) + Msg.getElement((Properties)this.getCtx(), (String)"CopyFrom") + " : " + Msg.getElement((Properties)this.getCtx(), (String)"JP_ContractContentT_ID") + "_" + contractContentTemplates[i].getValue() + " >>> " + e.getMessage();
            }
            try {
                this.createContractLine(contractContent, contractContentTemplates[i]);
            }
            catch (Exception e) {
                return String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + Msg.getElement((Properties)this.getCtx(), (String)"CopyFrom") + " : " + Msg.getElement((Properties)this.getCtx(), (String)"JP_ContractContentT_ID") + "_" + contractContentTemplates[i].getValue() + " >>> " + e.getMessage();
            }
            ++i;
        }
        this.estimation.setJP_Contract_ID(this.m_Contract.getJP_Contract_ID());
        try {
            this.estimation.saveEx(this.get_TrxName());
        }
        catch (Exception e) {
            return String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"SaveError")) + Msg.getElement((Properties)this.getCtx(), (String)"JP_Estimation_ID") + " >>> " + e.getMessage();
        }
        return "";
    }

    protected void createContractLine(MContractContent contractContent, MContractContentT template) throws Exception {
        MContractLineT[] m_ContractLineTemplates = template.getContractLineTemplates();
        int i = 0;
        while (i < m_ContractLineTemplates.length) {
            MContractProcessRef contractProcessRef;
            MContractProcessList[] contractProcessLists;
            int JP_ContractProcRef_Inv_ID;
            MContractProcessRef contractProcessRef2;
            MContractProcessList[] contractProcessLists2;
            int JP_ContractProcRef_InOut_ID;
            int JP_ContractCalRef_Inv_ID;
            int JP_ContractCalRef_InOut_ID;
            MContractLine contrctLine = new MContractLine(this.getCtx(), 0, this.get_TrxName());
            PO.copyValues((PO)m_ContractLineTemplates[i], (PO)contrctLine);
            contrctLine.setAD_Org_ID(contractContent.getAD_Org_ID());
            contrctLine.setAD_OrgTrx_ID(contractContent.getAD_OrgTrx_ID());
            contrctLine.setDateOrdered(contractContent.getDateOrdered());
            contrctLine.setDatePromised(this.calculateDate(contractContent.getDateAcct(), m_ContractLineTemplates[i].getDeliveryTime_Promised()));
            contrctLine.setJP_ContractContent_ID(contractContent.getJP_ContractContent_ID());
            contrctLine.setJP_ContractLineT_ID(m_ContractLineTemplates[i].getJP_ContractLineT_ID());
            if (contrctLine.getJP_BaseDocLinePolicy() != null) {
                this.setBaseDocLineProcPeriod(contrctLine, m_ContractLineTemplates[i]);
            }
            if ((JP_ContractCalRef_InOut_ID = m_ContractLineTemplates[i].getJP_ContractCalRef_InOut_ID()) > 0 && !Util.isEmpty((String)contractContent.getJP_CreateDerivativeDocPolicy())) {
                this.setDerivativeInOutLineProcPeriod(contrctLine, m_ContractLineTemplates[i]);
            }
            if ((JP_ContractCalRef_Inv_ID = m_ContractLineTemplates[i].getJP_ContractCalRef_Inv_ID()) > 0 && !Util.isEmpty((String)contractContent.getJP_CreateDerivativeDocPolicy())) {
                this.setDerivativeInvoiceLineProcPeriod(contrctLine, m_ContractLineTemplates[i]);
            }
            if ((JP_ContractProcRef_InOut_ID = m_ContractLineTemplates[i].getJP_ContractProcRef_InOut_ID()) > 0 && (contractProcessLists2 = (contractProcessRef2 = MContractProcessRef.get(this.getCtx(), JP_ContractProcRef_InOut_ID)).getContractProcessList(this.getCtx(), true, this.get_TrxName())).length == 1) {
                contrctLine.setJP_ContractProcess_InOut_ID(contractProcessLists2[0].getJP_ContractProcess_ID());
            }
            if ((JP_ContractProcRef_Inv_ID = m_ContractLineTemplates[i].getJP_ContractProcRef_Inv_ID()) > 0 && (contractProcessLists = (contractProcessRef = MContractProcessRef.get(this.getCtx(), JP_ContractProcRef_Inv_ID)).getContractProcessList(this.getCtx(), true, this.get_TrxName())).length == 1) {
                contrctLine.setJP_ContractProcess_Inv_ID(contractProcessLists[0].getJP_ContractProcess_ID());
            }
            try {
                contrctLine.saveEx(this.get_TrxName());
            }
            catch (Exception e) {
                throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"SaveError")) + Msg.getElement((Properties)this.getCtx(), (String)"CopyFrom") + " : " + Msg.getElement((Properties)this.getCtx(), (String)"JP_ContractLineT_ID") + "_" + m_ContractLineTemplates[i].getLine() + " >>> " + e.getMessage());
            }
            ++i;
        }
    }
}

