/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.process;

import java.time.Duration;
import java.time.LocalDateTime;
import java.util.Properties;
import java.util.logging.Level;
import jpiere.base.plugin.org.adempiere.model.MContract;
import jpiere.base.plugin.org.adempiere.model.MContractContent;
import jpiere.base.plugin.org.adempiere.model.MContractContentT;
import jpiere.base.plugin.org.adempiere.model.MContractLine;
import jpiere.base.plugin.org.adempiere.model.MContractLineT;
import jpiere.base.plugin.org.adempiere.model.MEstimation;
import jpiere.base.plugin.org.adempiere.process.AbstractCreateContractByCopy;
import org.adempiere.util.Callback;
import org.adempiere.util.IProcessUI;
import org.compiere.model.PO;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;

public class CreateContractfromEstimationAndContract
extends AbstractCreateContractByCopy {
    private int p_JP_Estimation_ID = 0;
    private int from_JP_Contract_ID = 0;
    private int from_JP_ContractContent_ID = 0;
    private MEstimation estimation = null;
    private IProcessUI processUI = null;
    private boolean isCreateSO = false;
    private boolean isOpenDialog = false;
    private boolean isAskAnswer = true;
    private String errorMsg = "";
    private String returnMsg = "";

    @Override
    protected void prepare() {
        this.p_JP_Estimation_ID = this.getRecord_ID();
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("JP_CopyFrom_Contract_ID")) {
                    this.from_JP_Contract_ID = para[i].getParameterAsInt();
                } else if (name.equals("JP_CopyFrom_ContractContent_ID")) {
                    this.from_JP_ContractContent_ID = para[i].getParameterAsInt();
                } else {
                    this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                }
            }
            ++i;
        }
        this.processUI = Env.getProcessUI((Properties)this.getCtx());
        this.estimation = new MEstimation(this.getCtx(), this.p_JP_Estimation_ID, this.get_TrxName());
    }

    @Override
    protected String doIt() throws Exception {
        if (this.estimation.getC_BPartner_ID() == 0) {
            this.errorMsg = String.valueOf(this.errorMsg) + Msg.getMsg((Properties)this.getCtx(), (String)"FillMandatory") + " : " + Msg.getElement((Properties)this.getCtx(), (String)"C_BPartner_ID") + System.lineSeparator();
        }
        if (this.estimation.getC_BPartner_Location_ID() == 0) {
            this.errorMsg = String.valueOf(this.errorMsg) + Msg.getMsg((Properties)this.getCtx(), (String)"FillMandatory") + " : " + Msg.getElement((Properties)this.getCtx(), (String)"C_BPartner_Location_ID") + System.lineSeparator();
        }
        if (!Util.isEmpty((String)this.errorMsg)) {
            throw new Exception(this.errorMsg);
        }
        MContract[] contracts = MContract.getContractByEstimation(this.getCtx(), this.p_JP_Estimation_ID, this.get_TrxName());
        if (this.processUI != null && contracts.length > 0) {
            this.isOpenDialog = true;
            this.processUI.ask("JP_CreateContractFromEstimationAgain", (Callback)new Callback<Boolean>(){

                public void onCallback(Boolean result) {
                    if (result.booleanValue()) {
                        try {
                            try {
                                CreateContractfromEstimationAndContract.this.returnMsg = CreateContractfromEstimationAndContract.this.createContract();
                            }
                            catch (Exception e) {
                                CreateContractfromEstimationAndContract.this.returnMsg = e.getMessage();
                                CreateContractfromEstimationAndContract.this.isCreateSO = true;
                            }
                        }
                        finally {
                            CreateContractfromEstimationAndContract.this.isCreateSO = true;
                        }
                    } else {
                        CreateContractfromEstimationAndContract.this.isAskAnswer = false;
                    }
                }
            });
        } else {
            this.returnMsg = this.createContract();
            this.isCreateSO = true;
        }
        while (this.isOpenDialog && this.isAskAnswer && !this.isCreateSO) {
            Thread.sleep(2000L);
        }
        if (!Util.isEmpty((String)this.returnMsg)) {
            throw new Exception(this.returnMsg);
        }
        if (this.isCreateSO) {
            this.addBufferLog(0, null, null, this.m_Contract.getDocumentNo(), MContract.Table_ID, this.m_Contract.getJP_Contract_ID());
        }
        return "";
    }

    private String createContract() throws Exception {
        MContract to_Contract = new MContract(this.getCtx(), 0, this.get_TrxName());
        MContract from_Contract = MContract.get(this.getCtx(), this.from_JP_Contract_ID);
        PO.copyValues((PO)from_Contract, (PO)to_Contract);
        PO.copyValues((PO)this.estimation, (PO)to_Contract);
        to_Contract.setJP_Contract_Link_ID(from_Contract.getJP_Contract_ID());
        to_Contract.setAD_Org_ID(this.estimation.getAD_Org_ID());
        to_Contract.setJP_ContractT_ID(from_Contract.getJP_ContractT_ID());
        to_Contract.setC_DocType_ID(from_Contract.getC_DocType_ID());
        to_Contract.setDateDoc(this.estimation.getDateOrdered());
        to_Contract.setDateAcct(this.estimation.getDateAcct());
        to_Contract.setJP_ContractPeriodDate_From(this.estimation.getDateAcct());
        if (from_Contract.getJP_ContractPeriodDate_To() != null) {
            LocalDateTime from_Date = from_Contract.getJP_ContractPeriodDate_From().toLocalDateTime();
            LocalDateTime to_Date = from_Contract.getJP_ContractPeriodDate_To().toLocalDateTime();
            Duration duration = Duration.between(from_Date, to_Date);
            to_Contract.setJP_ContractPeriodDate_To(this.calculateDate(to_Contract.getJP_ContractPeriodDate_From(), (int)duration.toDays()));
        } else {
            to_Contract.setJP_ContractPeriodDate_To(null);
        }
        if (from_Contract.getC_DocType().isDocNoControlled()) {
            to_Contract.setDocumentNo(null);
        }
        to_Contract.setJP_Estimation_ID(this.estimation.getJP_Estimation_ID());
        to_Contract.setDocStatus("DR");
        to_Contract.setDocAction("CO");
        to_Contract.setJP_ContractStatus("PR");
        try {
            to_Contract.saveEx(this.get_TrxName());
        }
        catch (Exception e) {
            return String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"SaveError")) + Msg.getElement((Properties)this.getCtx(), (String)"JP_Contract_ID") + " >>> " + e.getMessage();
        }
        MContractContent[] from_ContractContents = from_Contract.getContractContents();
        int i = 0;
        while (i < from_ContractContents.length) {
            if (this.from_JP_ContractContent_ID == 0 || this.from_JP_ContractContent_ID == from_ContractContents[i].getJP_ContractContent_ID()) {
                MContractContent to_ContractContent = new MContractContent(this.getCtx(), 0, this.get_TrxName());
                PO.copyValues((PO)from_ContractContents[i], (PO)to_ContractContent);
                to_ContractContent.setAD_Org_ID(to_Contract.getAD_Org_ID());
                to_ContractContent.setAD_OrgTrx_ID(to_Contract.getAD_OrgTrx_ID());
                to_ContractContent.setJP_Contract_ID(to_Contract.get_ID());
                to_ContractContent.setJP_ContractContentT_ID(from_ContractContents[i].getJP_ContractContentT_ID());
                to_ContractContent.setJP_Contract_Acct_ID(from_ContractContents[i].getJP_Contract_Acct_ID());
                if (to_ContractContent.getC_DocType().isDocNoControlled()) {
                    to_ContractContent.setDocumentNo(null);
                }
                to_ContractContent.setDateDoc(to_Contract.getDateDoc());
                to_ContractContent.setDateAcct(to_Contract.getDateAcct());
                to_ContractContent.setDatePromised(this.calculateDate(to_Contract.getDateAcct(), from_ContractContents[i].getJP_ContractContentT().getDeliveryTime_Promised()));
                to_ContractContent.setDateInvoiced(from_ContractContents[i].getDateInvoiced());
                this.setContractContentProcDate(to_ContractContent, MContractContentT.get(this.getCtx(), from_ContractContents[i].getJP_ContractContentT_ID()));
                to_ContractContent.setTotalLines(Env.ZERO);
                to_ContractContent.setDocStatus("DR");
                to_ContractContent.setDocAction("CO");
                to_ContractContent.setIsScheduleCreatedJP(false);
                to_ContractContent.setJP_ContractProcStatus("UN");
                this.setDocumentNoOfContractContent(from_ContractContents[i], to_ContractContent);
                this.setBPartnerOfContractContent(from_ContractContents[i], to_ContractContent);
                try {
                    this.setWarehouseOfContractContent(from_ContractContents[i], to_ContractContent);
                }
                catch (Exception e) {
                    return e.getMessage();
                }
                to_ContractContent.setC_Currency_ID(to_ContractContent.getM_PriceList().getC_Currency_ID());
                try {
                    to_ContractContent.saveEx(this.get_TrxName());
                }
                catch (Exception e) {
                    return String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"SaveError")) + Msg.getElement((Properties)this.getCtx(), (String)"CopyFrom") + " : " + Msg.getElement((Properties)this.getCtx(), (String)"JP_ContractContent_ID") + "_" + from_ContractContents[i].getDocumentNo() + " >>> " + e.getMessage();
                }
                try {
                    this.createContractLine(to_ContractContent, from_ContractContents[i], true);
                }
                catch (Exception e) {
                    return String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + Msg.getElement((Properties)this.getCtx(), (String)"CopyFrom") + " : " + Msg.getElement((Properties)this.getCtx(), (String)"JP_ContractContent_ID") + "_" + from_ContractContents[i].getDocumentNo() + " >>> " + e.getMessage();
                }
            }
            ++i;
        }
        this.m_Contract = to_Contract;
        this.estimation.setJP_Contract_ID(this.m_Contract.getJP_Contract_ID());
        try {
            this.estimation.saveEx(this.get_TrxName());
        }
        catch (Exception e) {
            return String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"SaveError")) + Msg.getElement((Properties)this.getCtx(), (String)"JP_Estimation_ID") + " >>> " + e.getMessage();
        }
        return "";
    }

    protected void createContractLine(MContractContent to_ContractContent, MContractContent from_ContractContent, boolean isReSetPeriod) throws Exception {
        MContractLine[] from_ContractLines = from_ContractContent.getLines();
        int i = 0;
        while (i < from_ContractLines.length) {
            MContractLine to_ContractLine = new MContractLine(this.getCtx(), 0, this.get_TrxName());
            PO.copyValues((PO)from_ContractLines[i], (PO)to_ContractLine);
            to_ContractLine.setAD_Org_ID(to_ContractContent.getAD_Org_ID());
            to_ContractLine.setAD_OrgTrx_ID(to_ContractContent.getAD_OrgTrx_ID());
            to_ContractLine.setDateOrdered(to_ContractContent.getDateOrdered());
            to_ContractLine.setDatePromised(this.calculateDate(to_ContractContent.getDateAcct(), from_ContractLines[i].getJP_ContractLineT().getDeliveryTime_Promised()));
            to_ContractLine.setJP_ContractContent_ID(to_ContractContent.getJP_ContractContent_ID());
            to_ContractLine.setJP_ContractLineT_ID(from_ContractLines[i].getJP_ContractLineT_ID());
            if (isReSetPeriod) {
                this.setBaseDocLineProcPeriod(to_ContractLine, MContractLineT.get(this.getCtx(), to_ContractLine.getJP_ContractLineT_ID()));
                this.setDerivativeInOutLineProcPeriod(to_ContractLine, MContractLineT.get(this.getCtx(), to_ContractLine.getJP_ContractLineT_ID()));
                this.setDerivativeInvoiceLineProcPeriod(to_ContractLine, MContractLineT.get(this.getCtx(), to_ContractLine.getJP_ContractLineT_ID()));
            }
            try {
                to_ContractLine.saveEx(this.get_TrxName());
            }
            catch (Exception e) {
                throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"SaveError")) + Msg.getElement((Properties)this.getCtx(), (String)"CopyFrom") + " : " + Msg.getElement((Properties)this.getCtx(), (String)"JP_ContractLine_ID") + "_" + from_ContractLines[i].getLine() + " >>> " + e.getMessage());
            }
            ++i;
        }
    }
}

