/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.process;

import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.util.Locale;
import java.util.Properties;
import java.util.logging.Level;
import jpiere.base.plugin.org.adempiere.model.MContractProcPeriod;
import jpiere.base.plugin.org.adempiere.model.MContractProcPeriodG;
import org.adempiere.util.IProcessUI;
import org.compiere.model.MClient;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.Env;
import org.compiere.util.Language;
import org.compiere.util.Msg;

public class CreateContractProcessPeriod
extends SvrProcess {
    private int p_ContractProcPeriodG_ID = 0;
    private Timestamp p_DateContract_From;
    private Timestamp p_DateContract_To;
    private int p_Year = 0;
    private int p_Month = 0;
    private int p_Day = 0;
    private String p_DateFormat;
    private String p_DateDocList = "E";
    private int p_MonthOffset = 0;
    private int p_DayOffset = 0;
    private boolean isDueFixed = true;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("DateContract")) {
                    this.p_DateContract_From = para[i].getParameterAsTimestamp();
                    this.p_DateContract_To = para[i].getParameter_ToAsTimestamp();
                } else if (name.equals("JP_Year")) {
                    this.p_Year = para[i].getParameterAsInt();
                } else if (name.equals("JP_Month")) {
                    this.p_Month = para[i].getParameterAsInt();
                } else if (name.equals("JP_Day")) {
                    this.p_Day = para[i].getParameterAsInt();
                } else if (name.equals("DateFormat")) {
                    this.p_DateFormat = (String)para[i].getParameter();
                } else if (name.equals("DateAcct")) {
                    this.p_DateDocList = (String)para[i].getParameter();
                } else if (name.equals("JP_MonthOffset")) {
                    this.p_MonthOffset = para[i].getParameterAsInt();
                } else if (name.equals("JP_DayOffset")) {
                    this.p_DayOffset = para[i].getParameterAsInt();
                } else if (name.equals("IsDueFixed")) {
                    this.isDueFixed = para[i].getParameterAsBoolean();
                } else {
                    this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                }
            }
            ++i;
        }
        this.p_ContractProcPeriodG_ID = this.getRecord_ID();
    }

    protected String doIt() throws Exception {
        LocalDateTime dateContract_To;
        if (this.isDueFixed && (this.p_DayOffset > 31 || this.p_DayOffset < 0)) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Invalid")) + Msg.getElement((Properties)this.getCtx(), (String)"JP_DayOffset"));
        }
        MContractProcPeriodG contractCalender = MContractProcPeriodG.get(this.getCtx(), this.p_ContractProcPeriodG_ID);
        if (this.p_Year == 0 && this.p_Month == 0 && this.p_Day == 0) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"FillMandatory")) + Msg.getElement((Properties)this.getCtx(), (String)"JP_ContractProcPeriod_ID"));
        }
        if (this.p_Year < 0 || this.p_Month < 0 || this.p_Day < 0) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Invalid")) + Msg.getElement((Properties)this.getCtx(), (String)"JP_DayOffset"));
        }
        MClient client = MClient.get((Properties)this.getCtx());
        Locale locale = client.getLocale();
        if (locale == null && Language.getLoginLanguage() != null) {
            locale = Language.getLoginLanguage().getLocale();
        }
        if (locale == null) {
            locale = Env.getLanguage((Properties)this.getCtx()).getLocale();
        }
        if (this.p_DateFormat == null || this.p_DateFormat.equals("")) {
            this.p_DateFormat = "MMM-yy";
        }
        SimpleDateFormat formatter = new SimpleDateFormat(this.p_DateFormat, locale);
        LocalDateTime dateContract_From = this.p_DateContract_From.toLocalDateTime();
        if (dateContract_From.compareTo(dateContract_To = this.p_DateContract_To.toLocalDateTime()) >= 0) {
            return String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Invalid")) + Msg.getElement((Properties)this.getCtx(), (String)"DateContract");
        }
        LocalDateTime startDate = this.p_DateContract_From.toLocalDateTime();
        LocalDateTime endDate = startDate.plusYears(this.p_Year).plusMonths(this.p_Month).plusDays(this.p_Day).minusDays(1L);
        LocalDateTime docDate = null;
        boolean isBreak = false;
        IProcessUI processMonitor = Env.getProcessUI((Properties)this.getCtx());
        do {
            if (endDate.compareTo(dateContract_To) > 0) {
                endDate = dateContract_To;
                isBreak = true;
            }
            String name = formatter.format(Timestamp.valueOf(startDate));
            MContractProcPeriod procPeriod = new MContractProcPeriod(this.getCtx(), 0, this.get_TrxName());
            procPeriod.setStartDate(Timestamp.valueOf(startDate));
            procPeriod.setEndDate(Timestamp.valueOf(endDate));
            procPeriod.setName(name);
            if (this.p_DateDocList.equals("E")) {
                procPeriod.setDateAcct(Timestamp.valueOf(endDate));
                if (this.isDueFixed) {
                    if (this.p_DayOffset == 31) {
                        docDate = endDate.plusMonths(this.p_MonthOffset + 1).withDayOfMonth(1).minusDays(1L);
                    } else if (this.p_DayOffset == 0) {
                        docDate = endDate.plusMonths(this.p_MonthOffset);
                    } else {
                        try {
                            docDate = endDate.plusMonths(this.p_MonthOffset).withDayOfMonth(this.p_DayOffset);
                        }
                        catch (Exception e) {
                            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Invalid")) + Msg.getElement((Properties)this.getCtx(), (String)"JP_DayOffset"));
                        }
                    }
                } else {
                    docDate = endDate.plusMonths(this.p_MonthOffset).plusDays(this.p_DayOffset);
                }
            } else if (this.p_DateDocList.equals("S")) {
                procPeriod.setDateAcct(Timestamp.valueOf(startDate));
                if (this.isDueFixed) {
                    if (this.p_DayOffset == 31) {
                        docDate = startDate.plusMonths(this.p_MonthOffset + 1).withDayOfMonth(1).minusDays(1L);
                    } else if (this.p_DayOffset == 0) {
                        docDate = startDate.plusMonths(this.p_MonthOffset);
                    } else {
                        try {
                            docDate = startDate.plusMonths(this.p_MonthOffset).withDayOfMonth(this.p_DayOffset);
                        }
                        catch (Exception e) {
                            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Invalid")) + Msg.getElement((Properties)this.getCtx(), (String)"JP_DayOffset"));
                        }
                    }
                } else {
                    docDate = startDate.plusMonths(this.p_MonthOffset).plusDays(this.p_DayOffset);
                }
            }
            procPeriod.setDateDoc(Timestamp.valueOf(docDate));
            procPeriod.setJP_ContractProcPeriodG_ID(this.p_ContractProcPeriodG_ID);
            procPeriod.setJP_ContractCalender_ID(contractCalender.getJP_ContractCalender_ID());
            procPeriod.saveEx(this.get_TrxName());
            if (processMonitor != null) {
                processMonitor.statusUpdate(procPeriod.toString());
            }
            startDate = endDate.plusDays(1L);
            endDate = startDate.plusYears(this.p_Year).plusMonths(this.p_Month).plusDays(this.p_Day).minusDays(1L);
        } while (!isBreak && startDate.compareTo(dateContract_To) < 0);
        return Msg.getMsg((Properties)this.getCtx(), (String)"OK");
    }
}

