/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.process;

import java.util.ArrayList;
import java.util.List;
import jpiere.base.plugin.org.adempiere.model.MBillSchema;
import jpiere.base.plugin.org.adempiere.process.I_CreateBill;
import jpiere.base.plugin.org.adempiere.process.I_CreateBillFactory;
import org.adempiere.base.Service;
import org.compiere.model.MBPartner;
import org.compiere.model.MInvoice;
import org.compiere.model.MPaymentTerm;
import org.compiere.model.Query;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;

public class CreateBillCallProcess
extends SvrProcess {
    boolean isCalledFromInfoWindow = false;
    ArrayList<MInvoice> p_selectedInvoices = null;
    int p_JP_BillSchema_ID = 0;
    int p_C_PaymentTerm_ID = 0;
    boolean p_IsSOTrx = false;

    protected void prepare() {
        String whereClause = "EXISTS (SELECT T_Selection_ID FROM T_Selection WHERE T_Selection.AD_PInstance_ID=? AND T_Selection.T_Selection_ID = C_Invoice.C_Invoice_ID)";
        List selectedInvoices = new Query(this.getCtx(), "C_Invoice", whereClause, this.get_TrxName()).setClient_ID().setParameters(new Object[]{this.getAD_PInstance_ID()}).list();
        if (selectedInvoices.size() != 0) {
            this.isCalledFromInfoWindow = true;
            this.p_selectedInvoices = (ArrayList)selectedInvoices;
        }
    }

    protected String doIt() throws Exception {
        if (this.isCalledFromInfoWindow) {
            int C_BPartner_ID = this.p_selectedInvoices.get(0).getC_BPartner_ID();
            MBPartner bPartner = new MBPartner(this.getCtx(), C_BPartner_ID, this.get_TrxName());
            ProcessInfoParameter[] para = this.getParameter();
            int i = 0;
            while (i < para.length) {
                String name = para[i].getParameterName();
                if (para[i].getParameter() != null && name.equals("IsSOTrx")) {
                    this.p_IsSOTrx = para[i].getParameterAsString().equals("Y");
                }
                ++i;
            }
            this.p_JP_BillSchema_ID = this.p_IsSOTrx ? bPartner.get_ValueAsInt("JP_BillSchema_ID") : bPartner.get_ValueAsInt("JP_BillSchemaPO_ID");
            this.p_C_PaymentTerm_ID = this.p_selectedInvoices.get(0).getC_PaymentTerm_ID();
        } else {
            ProcessInfoParameter[] para = this.getParameter();
            int i = 0;
            while (i < para.length) {
                String name = para[i].getParameterName();
                if (para[i].getParameter() != null) {
                    if (name.equals("IsSOTrx")) {
                        this.p_IsSOTrx = para[i].getParameterAsString().equals("Y");
                    } else if (name.equals("JP_BillSchema_ID")) {
                        this.p_JP_BillSchema_ID = para[i].getParameterAsInt();
                    } else if (name.equals("C_PaymentTerm_ID")) {
                        this.p_C_PaymentTerm_ID = para[i].getParameterAsInt();
                    }
                }
                ++i;
            }
        }
        MBillSchema billSchema = new MBillSchema(this.getCtx(), this.p_JP_BillSchema_ID, this.get_TrxName());
        MPaymentTerm paymentTerm = new MPaymentTerm(this.getCtx(), this.p_C_PaymentTerm_ID, this.get_TrxName());
        String createBillMessage = null;
        List factories = Service.locator().list(I_CreateBillFactory.class).getServices();
        if (factories != null) {
            for (I_CreateBillFactory factory : factories) {
                I_CreateBill createBill = factory.getCreateBill(billSchema.getClassname());
                if (createBill == null) continue;
                createBillMessage = createBill.createBills(this.getCtx(), this.getAD_PInstance_ID(), this, this.getParameter(), billSchema, paymentTerm, this.p_IsSOTrx, this.isCalledFromInfoWindow, this.get_TrxName());
                break;
            }
        }
        return createBillMessage;
    }
}

