/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.process;

import java.math.BigDecimal;
import java.util.logging.Level;
import org.compiere.model.MMovement;
import org.compiere.model.MMovementLine;
import org.compiere.model.PO;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.Env;

public class CopyFromMovement
extends SvrProcess {
    private int p_M_Movement_ID = 0;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("M_Movement_ID")) {
                    this.p_M_Movement_ID = ((BigDecimal)para[i].getParameter()).intValue();
                } else {
                    this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                }
            }
            ++i;
        }
    }

    protected String doIt() throws Exception {
        int To_M_Movement_ID = this.getRecord_ID();
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("From M_Movement_ID=" + this.p_M_Movement_ID + " to " + To_M_Movement_ID);
        }
        if (To_M_Movement_ID == 0) {
            throw new IllegalArgumentException("Target M_Movement_ID == 0");
        }
        if (this.p_M_Movement_ID == 0) {
            throw new IllegalArgumentException("Source M_Movement_ID == 0");
        }
        MMovement from = new MMovement(this.getCtx(), this.p_M_Movement_ID, this.get_TrxName());
        MMovement to = new MMovement(this.getCtx(), To_M_Movement_ID, this.get_TrxName());
        int no = 0;
        MMovementLine[] mMovementLineArray = from.getLines(false);
        int n = mMovementLineArray.length;
        int n2 = 0;
        while (n2 < n) {
            MMovementLine fromLine = mMovementLineArray[n2];
            if (fromLine.isActive()) {
                MMovementLine toLine = new MMovementLine(to);
                PO.copyValues((PO)fromLine, (PO)toLine);
                toLine.setM_Movement_ID(to.getM_Movement_ID());
                toLine.setProcessed(false);
                toLine.setTargetQty(Env.ZERO);
                toLine.setScrappedQty(Env.ZERO);
                toLine.setConfirmedQty(Env.ZERO);
                toLine.setReversalLine_ID(0);
                toLine.setDD_OrderLine_ID(0);
                toLine.saveEx();
                ++no;
            }
            ++n2;
        }
        return "@Copied@=" + no;
    }
}

