/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.process;

import java.math.BigDecimal;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MMovement;
import org.compiere.model.MMovementLine;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.Msg;

public class BulkUpdateMovementLineLocator
extends SvrProcess {
    private int p_M_Movement_ID = 0;
    private int p_M_Locator_From_ID = 0;
    private int p_M_Locator_To_ID = 0;

    protected void prepare() {
        this.p_M_Movement_ID = this.getRecord_ID();
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("M_Locator_ID")) {
                    this.p_M_Locator_From_ID = ((BigDecimal)para[i].getParameter()).intValue();
                } else if (name.equals("M_LocatorTo_ID")) {
                    this.p_M_Locator_To_ID = ((BigDecimal)para[i].getParameter()).intValue();
                } else {
                    this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                }
            }
            ++i;
        }
    }

    protected String doIt() throws Exception {
        if (this.p_M_Locator_From_ID == 0 && this.p_M_Locator_To_ID == 0) {
            throw new Exception(Msg.getMsg((Properties)this.getCtx(), (String)"JP_Mandatory_LocatorFromTo"));
        }
        MMovement movement = new MMovement(this.getCtx(), this.p_M_Movement_ID, this.get_TrxName());
        int no = 0;
        String msg = Msg.getMsg((Properties)this.getCtx(), (String)"JP_CheckASI");
        MMovementLine[] mMovementLineArray = movement.getLines(false);
        int n = mMovementLineArray.length;
        int n2 = 0;
        while (n2 < n) {
            MMovementLine mLine = mMovementLineArray[n2];
            if (this.p_M_Locator_From_ID > 0) {
                mLine.setM_Locator_ID(this.p_M_Locator_From_ID);
            }
            if (this.p_M_Locator_To_ID > 0) {
                mLine.setM_LocatorTo_ID(this.p_M_Locator_To_ID);
            }
            if (mLine.getM_AttributeSetInstance_ID() != mLine.getM_AttributeSetInstanceTo_ID()) {
                this.addBufferLog(0, null, null, String.valueOf(msg) + " " + mLine.getParent().getDocumentNo() + "_" + mLine.getLine(), mLine.get_Table_ID(), mLine.get_ID());
            }
            ++no;
            mLine.saveEx();
            ++n2;
        }
        return "@Copied@=" + no;
    }
}

