/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.process;

import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MInvoice;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.Msg;

public class BulkUpdateInvoiceDocStatusInfoWindow
extends SvrProcess {
    String p_DocAction = "CO";

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("DocAction")) {
                    this.p_DocAction = para[i].getParameterAsString();
                } else {
                    this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                }
            }
            ++i;
        }
    }

    protected String doIt() throws Exception {
        String whereClause = "EXISTS (SELECT T_Selection_ID FROM T_Selection WHERE T_Selection.AD_PInstance_ID=? AND T_Selection.T_Selection_ID = C_Invoice.C_Invoice_ID)";
        List genericPOs = new Query(this.getCtx(), "C_Invoice", whereClause, this.get_TrxName()).setClient_ID().setParameters(new Object[]{this.getAD_PInstance_ID()}).list();
        int successNo = 0;
        int failureNo = 0;
        String success = Msg.getMsg((Properties)this.getCtx(), (String)"JP_Success");
        String failure = Msg.getMsg((Properties)this.getCtx(), (String)"JP_Failure");
        for (PO po : genericPOs) {
            MInvoice inv = new MInvoice(this.getCtx(), po.get_ID(), this.get_TrxName());
            try {
                if (inv.isProcessed()) continue;
                if (inv.processIt(this.p_DocAction)) {
                    ++successNo;
                    inv.saveEx(this.get_TrxName());
                    this.addBufferLog(0, null, null, String.valueOf(success) + ":" + inv.getDocumentNo(), 318, inv.getC_Invoice_ID());
                    continue;
                }
                ++failureNo;
                inv.saveEx(this.get_TrxName());
                this.addBufferLog(0, null, null, String.valueOf(failure) + ":" + inv.getDocumentNo(), 318, inv.getC_Invoice_ID());
            }
            catch (Exception e) {
                ++failureNo;
                this.addBufferLog(0, null, null, String.valueOf(failure) + ":" + inv.getDocumentNo(), 318, inv.getC_Invoice_ID());
            }
        }
        return String.valueOf(success) + " : " + successNo + "  /  " + failure + " " + failureNo;
    }
}

