/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MCalendar;
import org.compiere.model.MConversionType;
import org.compiere.model.MDocType;
import org.compiere.model.MJournal;
import org.compiere.model.MJournalLine;
import org.compiere.model.MPeriod;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;

public class AdjustAccountingBookQtyFromLogistics
extends SvrProcess {
    private int p_AD_Client_ID = 0;
    private Timestamp p_DateValue = null;
    private int p_C_AcctSchema_ID = 0;
    private int p_AD_Org_ID = 0;
    private int p_M_Product_ID = 0;
    private int p_C_DocType_ID = 0;
    private String p_DocAction = "CO";
    private HashMap<Integer, MJournal> orgJournalMap = new HashMap();
    private MDocType docType = null;
    private MAcctSchema acctSchema = null;
    private MPeriod period = null;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("DateValue")) {
                    this.p_DateValue = para[i].getParameterAsTimestamp();
                } else if (name.equals("C_AcctSchema_ID")) {
                    this.p_C_AcctSchema_ID = para[i].getParameterAsInt();
                } else if (name.equals("AD_Org_ID")) {
                    this.p_AD_Org_ID = para[i].getParameterAsInt();
                } else if (name.equals("M_Product_ID")) {
                    this.p_M_Product_ID = para[i].getParameterAsInt();
                } else if (name.equals("C_DocType_ID")) {
                    this.p_C_DocType_ID = para[i].getParameterAsInt();
                } else if (name.equals("DocAction")) {
                    this.p_DocAction = para[i].getParameterAsString();
                } else {
                    this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                }
            }
            ++i;
        }
        this.p_AD_Client_ID = this.getAD_Client_ID();
    }

    protected String doIt() throws Exception {
        this.doCheckFromJP_StockOrgToJP_InvOrgBalance();
        this.doCheckFromJP_InvOrgBalanceToJP_StockOrg();
        if (this.orgJournalMap.size() > 0) {
            for (Integer key : this.orgJournalMap.keySet()) {
                MJournal Journal = this.orgJournalMap.get(key);
                this.addBufferLog(0, null, null, Journal.getDocumentNo(), 224, Journal.getGL_Journal_ID());
                if (Util.isEmpty((String)this.p_DocAction)) continue;
                Journal.processIt(this.p_DocAction);
                Journal.saveEx(this.get_TrxName());
            }
        } else {
            return Msg.getMsg((Properties)this.getCtx(), (String)"JP_NoDiff");
        }
        return Msg.getMsg((Properties)this.getCtx(), (String)"Success");
    }

    private void doCheckFromJP_StockOrgToJP_InvOrgBalance() throws Exception {
        StringBuilder sql = new StringBuilder("SELECT AD_Org_ID, M_Product_ID, QtyBook ").append("FROM JP_StockOrg ").append("WHERE dateValue=? ");
        if (this.p_M_Product_ID != 0) {
            sql.append(" AND M_Product_ID = ?");
        }
        if (this.p_AD_Org_ID != 0) {
            sql.append(" AND AD_Org_ID = ?");
        }
        sql.append(" AND AD_Client_ID=? ");
        sql.append(" ORDER BY AD_Org_ID, M_Product_ID ");
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement((String)sql.toString(), null);
            int i = 1;
            pstmt.setTimestamp(i, this.p_DateValue);
            ++i;
            if (this.p_M_Product_ID != 0) {
                pstmt.setInt(i, this.p_M_Product_ID);
                ++i;
            }
            if (this.p_AD_Org_ID != 0) {
                pstmt.setInt(i, this.p_AD_Org_ID);
                ++i;
            }
            pstmt.setInt(i, this.p_AD_Client_ID);
            rs = pstmt.executeQuery();
            int counter = 0;
            while (rs.next()) {
                ++counter;
                int AD_Org_ID = rs.getInt(1);
                int M_Product_ID = rs.getInt(2);
                BigDecimal logisticsBookQty = rs.getBigDecimal(3);
                StringBuilder sql2 = new StringBuilder("SELECT Account_ID ,QtyBook ").append("FROM JP_InvOrgBalance ").append("WHERE C_AcctSchema_ID=? AND dateValue=? AND AD_Org_ID=? AND M_Product_ID=? ");
                CPreparedStatement pstmt2 = null;
                ResultSet rs2 = null;
                try {
                    MJournalLine line;
                    MJournal journal;
                    pstmt2 = DB.prepareStatement((String)sql2.toString(), null);
                    pstmt2.setInt(1, this.p_C_AcctSchema_ID);
                    pstmt2.setTimestamp(2, this.p_DateValue);
                    pstmt2.setInt(3, AD_Org_ID);
                    pstmt2.setInt(4, M_Product_ID);
                    rs2 = pstmt2.executeQuery();
                    if (rs2.next()) {
                        int account_ID = rs2.getInt(1);
                        BigDecimal accountBookQty = rs2.getBigDecimal(2);
                        if (logisticsBookQty.compareTo(accountBookQty) != 0) {
                            journal = this.orgJournalMap.get(AD_Org_ID);
                            if (journal == null) {
                                journal = this.createJournal(AD_Org_ID);
                            }
                            line = new MJournalLine(journal);
                            line.setM_Product_ID(M_Product_ID);
                            line.setAccount_ID(account_ID);
                            BigDecimal diffQty = logisticsBookQty.subtract(accountBookQty);
                            line.setQty(diffQty);
                            line.saveEx(this.get_TrxName());
                        }
                    } else {
                        int account_ID;
                        BigDecimal accountBookQty = Env.ZERO;
                        if (logisticsBookQty.compareTo(accountBookQty) != 0 && (account_ID = this.getP_Asset_Acct(M_Product_ID, this.p_C_AcctSchema_ID)) > 0) {
                            journal = this.orgJournalMap.get(AD_Org_ID);
                            if (journal == null) {
                                journal = this.createJournal(AD_Org_ID);
                            }
                            line = new MJournalLine(journal);
                            line.setM_Product_ID(M_Product_ID);
                            line.setAccount_ID(account_ID);
                            line.setQty(logisticsBookQty);
                            line.saveEx(this.get_TrxName());
                        }
                    }
                }
                catch (Throwable throwable) {
                    DB.close(rs2, pstmt2);
                    rs2 = null;
                    pstmt2 = null;
                    throw throwable;
                }
                DB.close((ResultSet)rs2, (Statement)pstmt2);
                rs2 = null;
                pstmt2 = null;
            }
            if (counter == 0) {
                throw new Exception(Msg.getMsg((Properties)this.getCtx(), (String)"not.found"));
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close((ResultSet)rs, (Statement)pstmt);
        rs = null;
        pstmt = null;
    }

    private void doCheckFromJP_InvOrgBalanceToJP_StockOrg() throws Exception {
        StringBuilder sql = new StringBuilder("SELECT AD_Org_ID, M_Product_ID, QtyBook, Account_ID ").append("FROM JP_InvOrgBalance ").append("WHERE C_AcctSchema_ID=? AND dateValue=? ");
        if (this.p_AD_Org_ID != 0) {
            sql.append(" AND AD_Org_ID = ?");
        }
        if (this.p_M_Product_ID != 0) {
            sql.append(" AND M_Product_ID = ?");
        }
        sql.append(" ORDER BY AD_Org_ID, M_Product_ID ");
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement((String)sql.toString(), null);
            int i = 1;
            pstmt.setInt(i, this.p_C_AcctSchema_ID);
            pstmt.setTimestamp(++i, this.p_DateValue);
            ++i;
            if (this.p_AD_Org_ID != 0) {
                pstmt.setInt(i, this.p_AD_Org_ID);
                ++i;
            }
            if (this.p_M_Product_ID != 0) {
                pstmt.setInt(i, this.p_M_Product_ID);
            }
            rs = pstmt.executeQuery();
            int counter = 0;
            while (rs.next()) {
                ++counter;
                int AD_Org_ID = rs.getInt(1);
                int M_Product_ID = rs.getInt(2);
                BigDecimal accountBookQty = rs.getBigDecimal(3);
                int account_ID = rs.getInt(4);
                StringBuilder sql2 = new StringBuilder("SELECT QtyBook ").append("FROM JP_StockOrg ").append("WHERE dateValue=? AND M_Product_ID=? AND AD_Org_ID=? ");
                CPreparedStatement pstmt2 = null;
                ResultSet rs2 = null;
                try {
                    BigDecimal logisticsBookQty;
                    pstmt2 = DB.prepareStatement((String)sql2.toString(), null);
                    pstmt2.setTimestamp(1, this.p_DateValue);
                    pstmt2.setInt(2, M_Product_ID);
                    pstmt2.setInt(3, AD_Org_ID);
                    rs2 = pstmt2.executeQuery();
                    if (!rs2.next() && (logisticsBookQty = Env.ZERO).compareTo(accountBookQty) != 0 && account_ID > 0) {
                        MJournal journal = this.orgJournalMap.get(AD_Org_ID);
                        if (journal == null) {
                            journal = this.createJournal(AD_Org_ID);
                        }
                        MJournalLine line = new MJournalLine(journal);
                        line.setM_Product_ID(M_Product_ID);
                        line.setAccount_ID(account_ID);
                        line.setQty(accountBookQty.negate());
                        line.saveEx(this.get_TrxName());
                    }
                }
                catch (Throwable throwable) {
                    DB.close(rs2, pstmt2);
                    rs2 = null;
                    pstmt2 = null;
                    throw throwable;
                }
                DB.close((ResultSet)rs2, (Statement)pstmt2);
                rs2 = null;
                pstmt2 = null;
            }
            if (counter == 0) {
                throw new Exception(Msg.getMsg((Properties)this.getCtx(), (String)"not.found"));
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close((ResultSet)rs, (Statement)pstmt);
        rs = null;
        pstmt = null;
    }

    private MJournal createJournal(int AD_Org_ID) {
        MJournal glj = new MJournal(this.getCtx(), 0, this.get_TrxName());
        glj.setAD_Org_ID(AD_Org_ID);
        glj.setC_DocType_ID(this.p_C_DocType_ID);
        if (this.docType == null) {
            this.docType = new MDocType(this.getCtx(), this.p_C_DocType_ID, this.get_TrxName());
        }
        glj.setGL_Category_ID(this.docType.getGL_Category_ID());
        glj.setC_ConversionType_ID(MConversionType.getDefault((int)this.p_AD_Client_ID));
        glj.setC_AcctSchema_ID(this.p_C_AcctSchema_ID);
        if (this.acctSchema == null) {
            this.acctSchema = new MAcctSchema(this.getCtx(), this.p_C_AcctSchema_ID, this.get_TrxName());
        }
        glj.setC_Currency_ID(this.acctSchema.getC_Currency_ID());
        glj.setPostingType("A");
        glj.setDateDoc(this.p_DateValue);
        glj.setDateAcct(this.p_DateValue);
        if (this.period == null) {
            MCalendar baseCalendar = MCalendar.getDefault((Properties)this.getCtx(), (int)this.p_AD_Client_ID);
            this.period = MPeriod.findByCalendar((Properties)this.getCtx(), (Timestamp)glj.getDateAcct(), (int)baseCalendar.getC_Calendar_ID(), (String)this.get_TrxName());
        }
        glj.setC_Period_ID(this.period.getC_Period_ID());
        glj.setDescription(this.getProcessInfo().getTitle());
        glj.saveEx(this.get_TrxName());
        this.orgJournalMap.put(AD_Org_ID, glj);
        return glj;
    }

    /*
     * Loose catch block
     */
    private int getP_Asset_Acct(int M_Product_ID, int p_C_AcctSchema_ID) {
        block5: {
            ResultSet rs;
            CPreparedStatement pstmt;
            block4: {
                int n;
                StringBuilder sql = new StringBuilder("SELECT vc.Account_ID FROM M_Product p ").append(" INNER JOIN adempiere.M_Product_Acct pa ON (p.M_Product_ID=pa.M_Product_ID) ").append(" INNER JOIN adempiere.C_ValidCombination vc ON (pa.P_Asset_Acct = vc.C_ValidCombination_ID )").append(" WHERE p.M_Product_ID=? AND pa.C_AcctSchema_ID=?");
                pstmt = null;
                rs = null;
                try {
                    int account_ID;
                    pstmt = DB.prepareStatement((String)sql.toString(), null);
                    pstmt.setInt(1, M_Product_ID);
                    pstmt.setInt(2, p_C_AcctSchema_ID);
                    rs = pstmt.executeQuery();
                    if (!rs.next()) break block4;
                    n = account_ID = rs.getInt(1);
                }
                catch (Exception exception) {
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block5;
                    catch (Throwable throwable) {
                        DB.close(rs, (Statement)pstmt);
                        rs = null;
                        pstmt = null;
                        throw throwable;
                    }
                }
                DB.close((ResultSet)rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                return n;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        return 0;
    }
}

