/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.process;

import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.Properties;
import java.util.logging.Level;
import jpiere.base.plugin.org.adempiere.model.MContract;
import jpiere.base.plugin.org.adempiere.model.MContractCalender;
import jpiere.base.plugin.org.adempiere.model.MContractCalenderList;
import jpiere.base.plugin.org.adempiere.model.MContractCalenderRef;
import jpiere.base.plugin.org.adempiere.model.MContractContent;
import jpiere.base.plugin.org.adempiere.model.MContractContentT;
import jpiere.base.plugin.org.adempiere.model.MContractLine;
import jpiere.base.plugin.org.adempiere.model.MContractLineT;
import jpiere.base.plugin.org.adempiere.model.MContractProcPeriod;
import jpiere.base.plugin.org.adempiere.model.MContractT;
import org.compiere.model.MOrgInfo;
import org.compiere.model.MWarehouse;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;

public abstract class AbstractCreateContractFromTemplate
extends SvrProcess {
    protected MContract m_Contract = null;
    protected MContractContent m_ContractContent = null;
    protected MContractT m_ContractTemplate = null;
    protected MContractContentT[] m_ContractContentTemplates = null;
    protected String p_JP_ContractTabLevel = null;
    protected static final String JP_ContractTabLevel_Document = "CD";
    protected static final String JP_ContractTabLevel_Content = "CC";
    int Record_ID = 0;

    protected void prepare() {
        this.Record_ID = this.getRecord_ID();
        if (this.Record_ID > 0) {
            ProcessInfoParameter[] para = this.getParameter();
            int i = 0;
            while (i < para.length) {
                String name = para[i].getParameterName();
                if (para[i].getParameter() != null) {
                    if (name.equals("JP_ContractTabLevel")) {
                        this.p_JP_ContractTabLevel = para[i].getParameterAsString();
                    } else {
                        this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                    }
                }
                ++i;
            }
            if (this.p_JP_ContractTabLevel.equals(JP_ContractTabLevel_Document)) {
                this.m_Contract = new MContract(this.getCtx(), this.Record_ID, this.get_TrxName());
                this.m_ContractTemplate = new MContractT(this.getCtx(), this.m_Contract.getJP_ContractT_ID(), this.get_TrxName());
                this.m_ContractContentTemplates = this.m_ContractTemplate.getContractContentTemplates();
            } else if (this.p_JP_ContractTabLevel.equals(JP_ContractTabLevel_Content)) {
                this.m_ContractContent = new MContractContent(this.getCtx(), this.Record_ID, this.get_TrxName());
                this.m_Contract = this.m_ContractContent.getParent();
            }
        } else {
            this.log.log(Level.SEVERE, "Record_ID <= 0 ");
        }
    }

    protected String doIt() throws Exception {
        if (this.m_Contract.getJP_ContractType().equals("GLC")) {
            throw new Exception("JP_GeneralContractContent");
        }
        return Msg.getMsg((Properties)this.getCtx(), (String)"Success");
    }

    protected Timestamp calculateDate(Timestamp baseDate, int addNum) {
        LocalDateTime datePromisedLocal = baseDate.toLocalDateTime();
        datePromisedLocal = datePromisedLocal.plusDays(addNum);
        return Timestamp.valueOf(datePromisedLocal);
    }

    protected void setContractContentProcDate(MContractContent contractContent, MContractContentT contentTemplate) {
        MContractProcPeriod period;
        MContractCalender calender;
        MContractCalenderRef contractCalenderRef;
        MContractCalenderList[] contractCalenderLists;
        int JP_ContractCalenderRef_ID = contentTemplate.getJP_ContractCalenderRef_ID();
        if (JP_ContractCalenderRef_ID > 0 && (contractCalenderLists = (contractCalenderRef = MContractCalenderRef.get(this.getCtx(), JP_ContractCalenderRef_ID)).getContractCalenderList(this.getCtx(), true, this.get_TrxName())).length == 1) {
            contractContent.setJP_ContractCalender_ID(contractCalenderLists[0].getJP_ContractCalender_ID());
        }
        if (contentTemplate.getJP_ContractProcPOffset() == 0) {
            contractContent.setJP_ContractProcDate_From(contractContent.getParent().getJP_ContractPeriodDate_From());
        } else if (contractContent.getJP_ContractCalender_ID() > 0) {
            calender = MContractCalender.get(this.getCtx(), contractContent.getJP_ContractCalender_ID());
            period = calender.getContractProcessPeriod(this.getCtx(), contractContent.getParent().getJP_ContractPeriodDate_From(), null, contentTemplate.getJP_ContractProcPOffset());
            contractContent.setJP_ContractProcDate_From(period.getStartDate());
        } else if (contractContent.getJP_ContractProcDate_From() == null) {
            contractContent.setJP_ContractProcDate_From(contractContent.getParent().getJP_ContractPeriodDate_From());
        }
        if (contractContent.getJP_ContractCalender_ID() > 0) {
            calender = MContractCalender.get(this.getCtx(), contractContent.getJP_ContractCalender_ID());
            period = calender.getContractProcessPeriod(this.getCtx(), contractContent.getJP_ContractProcDate_From(), null, contentTemplate.getJP_ContractProcPeriodNum());
            if (contractContent.getParent().getJP_ContractPeriodDate_To() == null) {
                if (contentTemplate.getJP_ContractProcPeriodNum() == 0) {
                    if (contentTemplate.getJP_ContractProcessMethod().equals("IC")) {
                        contractContent.setJP_ContractProcDate_To(period.getEndDate());
                    } else {
                        contractContent.setJP_ContractProcDate_To(null);
                    }
                } else {
                    contractContent.setJP_ContractProcDate_To(period.getEndDate());
                }
            } else if (contentTemplate.getJP_ContractProcPeriodNum() == 0) {
                contractContent.setJP_ContractProcDate_To(contractContent.getParent().getJP_ContractPeriodDate_To());
            } else if (contractContent.getParent().getJP_ContractPeriodDate_To().compareTo(period.getEndDate()) >= 0) {
                contractContent.setJP_ContractProcDate_To(period.getEndDate());
            } else {
                contractContent.setJP_ContractProcDate_To(contractContent.getParent().getJP_ContractPeriodDate_To());
            }
        } else if (contractContent.getParent().getJP_ContractPeriodDate_To() != null) {
            contractContent.setJP_ContractProcDate_To(contractContent.getParent().getJP_ContractPeriodDate_To());
        } else if (contentTemplate.getJP_ContractProcessMethod().equals("IC")) {
            contractContent.setJP_ContractProcDate_To(contractContent.getJP_ContractProcDate_From());
        } else {
            contractContent.setJP_ContractProcDate_To(null);
        }
    }

    protected void setBaseDocLineProcPeriod(MContractLine contractLine, MContractLineT lineTemplate) {
        MContractProcPeriod period;
        MContractCalender calender;
        int processPeriodOffset;
        if (Util.isEmpty((String)contractLine.getJP_BaseDocLinePolicy())) {
            contractLine.setJP_ProcPeriod_Lump_ID(0);
            contractLine.setJP_ProcPeriod_Start_ID(0);
            contractLine.setJP_ProcPeriod_End_ID(0);
            return;
        }
        if (contractLine.getJP_BaseDocLinePolicy().equals("LP")) {
            processPeriodOffset = lineTemplate.getJP_ProcPeriodOffs_Lump();
            processPeriodOffset = processPeriodOffset > 0 ? ++processPeriodOffset : --processPeriodOffset;
            calender = MContractCalender.get(this.getCtx(), contractLine.getParent().getJP_ContractCalender_ID());
            period = calender.getContractProcessPeriod(this.getCtx(), contractLine.getParent().getJP_ContractProcDate_From(), null, processPeriodOffset);
            if (period != null) {
                contractLine.setJP_ProcPeriod_Lump_ID(period.getJP_ContractProcPeriod_ID());
            }
        }
        if (contractLine.getJP_BaseDocLinePolicy().equals("PS") || contractLine.getJP_BaseDocLinePolicy().equals("PB")) {
            processPeriodOffset = lineTemplate.getJP_ProcPeriodOffs_Start();
            processPeriodOffset = processPeriodOffset > 0 ? ++processPeriodOffset : --processPeriodOffset;
            calender = MContractCalender.get(this.getCtx(), contractLine.getParent().getJP_ContractCalender_ID());
            period = calender.getContractProcessPeriod(this.getCtx(), contractLine.getParent().getJP_ContractProcDate_From(), null, processPeriodOffset);
            if (period != null) {
                contractLine.setJP_ProcPeriod_Start_ID(period.getJP_ContractProcPeriod_ID());
            }
        }
        if (contractLine.getJP_BaseDocLinePolicy().equals("PE") || contractLine.getJP_BaseDocLinePolicy().equals("PB")) {
            processPeriodOffset = lineTemplate.getJP_ProcPeriodOffs_End();
            processPeriodOffset = processPeriodOffset > 0 ? ++processPeriodOffset : --processPeriodOffset;
            calender = MContractCalender.get(this.getCtx(), contractLine.getParent().getJP_ContractCalender_ID());
            period = calender.getContractProcessPeriod(this.getCtx(), contractLine.getParent().getJP_ContractProcDate_From(), null, processPeriodOffset);
            if (period != null) {
                contractLine.setJP_ProcPeriod_End_ID(period.getJP_ContractProcPeriod_ID());
            }
        }
    }

    protected void setDerivativeInOutLineProcPeriod(MContractLine contractLine, MContractLineT lineTemplate) {
        if (!contractLine.getParent().getJP_CreateDerivativeDocPolicy().equals("IO") && !contractLine.getParent().getJP_CreateDerivativeDocPolicy().equals("BT")) {
            contractLine.setJP_ContractCalender_InOut_ID(0);
            contractLine.setJP_ProcPeriod_Lump_InOut_ID(0);
            contractLine.setJP_ProcPeriod_Start_InOut_ID(0);
            contractLine.setJP_ProcPeriod_End_InOut_ID(0);
            return;
        }
        if (contractLine.getJP_ContractCalender_InOut_ID() == 0) {
            int JP_ContractCalRef_InOut_ID = lineTemplate.getJP_ContractCalRef_InOut_ID();
            MContractCalenderRef contractCalenderRef = MContractCalenderRef.get(this.getCtx(), JP_ContractCalRef_InOut_ID);
            MContractCalenderList[] contractCalenderLists = contractCalenderRef.getContractCalenderList(this.getCtx(), true, this.get_TrxName());
            if (contractCalenderLists.length == 1) {
                contractLine.setJP_ContractCalender_InOut_ID(contractCalenderLists[0].getJP_ContractCalender_ID());
            }
        }
        if (contractLine.getJP_ContractCalender_InOut_ID() != 0) {
            MContractProcPeriod period;
            MContractCalender calender;
            int processPeriodOffset;
            if (contractLine.getJP_DerivativeDocPolicy_InOut().equals("LP")) {
                processPeriodOffset = lineTemplate.getJP_ProcPeriodOffs_Lump_InOut();
                processPeriodOffset = processPeriodOffset > 0 ? ++processPeriodOffset : --processPeriodOffset;
                calender = MContractCalender.get(this.getCtx(), contractLine.getJP_ContractCalender_InOut_ID());
                period = calender.getContractProcessPeriod(this.getCtx(), contractLine.getParent().getJP_ContractProcDate_From(), null, processPeriodOffset);
                if (period != null) {
                    contractLine.setJP_ProcPeriod_Lump_InOut_ID(period.getJP_ContractProcPeriod_ID());
                }
            }
            if (contractLine.getJP_DerivativeDocPolicy_InOut().equals("PS") || contractLine.getJP_DerivativeDocPolicy_InOut().equals("PB")) {
                processPeriodOffset = lineTemplate.getJP_ProcPeriodOffs_Start_InOut();
                processPeriodOffset = processPeriodOffset > 0 ? ++processPeriodOffset : --processPeriodOffset;
                calender = MContractCalender.get(this.getCtx(), contractLine.getJP_ContractCalender_InOut_ID());
                period = calender.getContractProcessPeriod(this.getCtx(), contractLine.getParent().getJP_ContractProcDate_From(), null, processPeriodOffset);
                if (period != null) {
                    contractLine.setJP_ProcPeriod_Start_InOut_ID(period.getJP_ContractProcPeriod_ID());
                }
            }
            if (contractLine.getJP_DerivativeDocPolicy_InOut().equals("PE") || contractLine.getJP_DerivativeDocPolicy_InOut().equals("PB")) {
                processPeriodOffset = lineTemplate.getJP_ProcPeriodOffs_End_InOut();
                processPeriodOffset = processPeriodOffset > 0 ? ++processPeriodOffset : --processPeriodOffset;
                calender = MContractCalender.get(this.getCtx(), contractLine.getJP_ContractCalender_InOut_ID());
                period = calender.getContractProcessPeriod(this.getCtx(), contractLine.getParent().getJP_ContractProcDate_From(), null, processPeriodOffset);
                if (period != null) {
                    contractLine.setJP_ProcPeriod_End_InOut_ID(period.getJP_ContractProcPeriod_ID());
                }
            }
        }
    }

    protected void setDerivativeInvoiceLineProcPeriod(MContractLine contractLine, MContractLineT lineTemplate) {
        if (!contractLine.getParent().getJP_CreateDerivativeDocPolicy().equals("IV") && !contractLine.getParent().getJP_CreateDerivativeDocPolicy().equals("BT")) {
            contractLine.setJP_ContractCalender_Inv_ID(0);
            contractLine.setJP_ProcPeriod_Lump_Inv_ID(0);
            contractLine.setJP_ProcPeriod_Start_Inv_ID(0);
            contractLine.setJP_ProcPeriod_End_Inv_ID(0);
            return;
        }
        if (contractLine.getJP_ContractCalender_Inv_ID() == 0) {
            int JP_ContractCalRef_Inv_ID = lineTemplate.getJP_ContractCalRef_Inv_ID();
            MContractCalenderRef contractCalenderRef = MContractCalenderRef.get(this.getCtx(), JP_ContractCalRef_Inv_ID);
            MContractCalenderList[] contractCalenderLists = contractCalenderRef.getContractCalenderList(this.getCtx(), true, this.get_TrxName());
            if (contractCalenderLists.length == 1) {
                contractLine.setJP_ContractCalender_Inv_ID(contractCalenderLists[0].getJP_ContractCalender_ID());
            }
        }
        if (contractLine.getJP_ContractCalender_Inv_ID() != 0) {
            MContractProcPeriod period;
            MContractCalender calender;
            int processPeriodOffset;
            if (contractLine.getJP_DerivativeDocPolicy_Inv().equals("LP")) {
                processPeriodOffset = lineTemplate.getJP_ProcPeriodOffs_Lump_Inv();
                processPeriodOffset = processPeriodOffset > 0 ? ++processPeriodOffset : --processPeriodOffset;
                calender = MContractCalender.get(this.getCtx(), contractLine.getJP_ContractCalender_Inv_ID());
                period = calender.getContractProcessPeriod(this.getCtx(), contractLine.getParent().getJP_ContractProcDate_From(), null, processPeriodOffset);
                if (period != null) {
                    contractLine.setJP_ProcPeriod_Lump_Inv_ID(period.getJP_ContractProcPeriod_ID());
                }
            }
            if (contractLine.getJP_DerivativeDocPolicy_Inv().equals("PS") || contractLine.getJP_DerivativeDocPolicy_Inv().equals("PB")) {
                processPeriodOffset = lineTemplate.getJP_ProcPeriodOffs_Start_Inv();
                processPeriodOffset = processPeriodOffset > 0 ? ++processPeriodOffset : --processPeriodOffset;
                calender = MContractCalender.get(this.getCtx(), contractLine.getJP_ContractCalender_Inv_ID());
                period = calender.getContractProcessPeriod(this.getCtx(), contractLine.getParent().getJP_ContractProcDate_From(), null, processPeriodOffset);
                if (period != null) {
                    contractLine.setJP_ProcPeriod_Start_Inv_ID(period.getJP_ContractProcPeriod_ID());
                }
            }
            if (contractLine.getJP_DerivativeDocPolicy_Inv().equals("PE") || contractLine.getJP_DerivativeDocPolicy_Inv().equals("PB")) {
                processPeriodOffset = lineTemplate.getJP_ProcPeriodOffs_End_Inv();
                processPeriodOffset = processPeriodOffset > 0 ? ++processPeriodOffset : --processPeriodOffset;
                calender = MContractCalender.get(this.getCtx(), contractLine.getJP_ContractCalender_Inv_ID());
                period = calender.getContractProcessPeriod(this.getCtx(), contractLine.getParent().getJP_ContractProcDate_From(), null, processPeriodOffset);
                if (period != null) {
                    contractLine.setJP_ProcPeriod_End_Inv_ID(period.getJP_ContractProcPeriod_ID());
                }
            }
        }
    }

    protected void setWarehouseOfContractContent(MContractContentT from, MContractContent to) throws Exception {
        if (from.getDocBaseType().equals("API") || from.getDocBaseType().equals("ARI")) {
            return;
        }
        if (from.getM_Warehouse() != null && from.getM_Warehouse().getAD_Org_ID() == to.getAD_Org_ID()) {
            to.setM_Warehouse_ID(from.getM_Warehouse_ID());
        } else if (MOrgInfo.get(null, (int)to.getAD_Org_ID(), (String)this.get_TrxName()).getM_Warehouse_ID() != 0) {
            to.setM_Warehouse_ID(MOrgInfo.get(null, (int)to.getAD_Org_ID(), (String)this.get_TrxName()).getM_Warehouse_ID());
        } else {
            MWarehouse[] warehouses = MWarehouse.getForOrg((Properties)this.getCtx(), (int)from.getAD_Org_ID());
            if (warehouses.length > 0) {
                to.setM_Warehouse_ID(warehouses[0].getM_Warehouse_ID());
            } else {
                throw new Exception(String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"NotFound")) + Msg.getElement((Properties)this.getCtx(), (String)"M_Warehouse_ID") + " : " + Msg.getElement((Properties)this.getCtx(), (String)"JP_ContractContent_ID") + " - " + to.getDocumentNo());
            }
        }
    }
}

