/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.process;

import java.util.Properties;
import java.util.logging.Level;
import jpiere.base.plugin.org.adempiere.model.MContract;
import jpiere.base.plugin.org.adempiere.model.MContractContent;
import jpiere.base.plugin.org.adempiere.process.AbstractCreateContractFromTemplate;
import org.compiere.model.MBPartnerLocation;
import org.compiere.model.MDocType;
import org.compiere.model.MOrgInfo;
import org.compiere.model.MWarehouse;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public abstract class AbstractCreateContractByCopy
extends AbstractCreateContractFromTemplate {
    protected MContract to_Contract = null;
    protected MContractContent to_ContractContent = null;
    protected int from_JP_Contract_ID = 0;
    protected int from_JP_ContractContent_ID = 0;
    protected MContract from_Contract = null;
    protected MContractContent from_ContractContent = null;
    protected String p_JP_ContractTabLevel = null;
    protected static final String JP_ContractTabLevel_Document = "CD";
    protected static final String JP_ContractTabLevel_Content = "CC";
    int Record_ID = 0;

    @Override
    protected void prepare() {
        this.Record_ID = this.getRecord_ID();
        if (this.Record_ID > 0) {
            ProcessInfoParameter[] para = this.getParameter();
            int i = 0;
            while (i < para.length) {
                String name = para[i].getParameterName();
                if (para[i].getParameter() != null) {
                    if (name.equals("JP_ContractTabLevel")) {
                        this.p_JP_ContractTabLevel = para[i].getParameterAsString();
                    } else if (name.equals("JP_CopyFrom_Contract_ID")) {
                        this.from_JP_Contract_ID = para[i].getParameterAsInt();
                    } else if (name.equals("JP_CopyFrom_ContractContent_ID")) {
                        this.from_JP_ContractContent_ID = para[i].getParameterAsInt();
                    } else {
                        this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                    }
                }
                ++i;
            }
            if (this.p_JP_ContractTabLevel.equals(JP_ContractTabLevel_Document)) {
                this.to_Contract = new MContract(this.getCtx(), this.Record_ID, this.get_TrxName());
                this.from_Contract = new MContract(this.getCtx(), this.from_JP_Contract_ID, this.get_TrxName());
                if (this.from_JP_ContractContent_ID != 0) {
                    this.from_ContractContent = new MContractContent(this.getCtx(), this.from_JP_ContractContent_ID, this.get_TrxName());
                }
            } else if (this.p_JP_ContractTabLevel.equals(JP_ContractTabLevel_Content)) {
                this.to_ContractContent = new MContractContent(this.getCtx(), this.Record_ID, this.get_TrxName());
                this.to_Contract = this.to_ContractContent.getParent();
                this.from_ContractContent = new MContractContent(this.getCtx(), this.from_JP_ContractContent_ID, this.get_TrxName());
                this.from_Contract = new MContract(this.getCtx(), this.from_JP_Contract_ID, this.get_TrxName());
            }
        } else {
            this.log.log(Level.SEVERE, "Record_ID <= 0 ");
        }
    }

    @Override
    protected String doIt() throws Exception {
        if (this.to_Contract.getJP_ContractType().equals("GLC")) {
            throw new Exception("JP_GeneralContractContent");
        }
        if (this.from_JP_ContractContent_ID > 0 && this.from_Contract.getJP_Contract_ID() != this.from_ContractContent.getJP_Contract_ID()) {
            String msg0 = Msg.getElement((Properties)Env.getCtx(), (String)"JP_Contract_ID");
            String msg1 = Msg.getElement((Properties)Env.getCtx(), (String)"JP_ContractContent_ID");
            throw new Exception(Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Different", (Object[])new Object[]{msg0, msg1}));
        }
        if (this.to_Contract.getJP_ContractT_ID() != this.from_Contract.getJP_ContractT_ID()) {
            throw new Exception(Msg.getMsg((Properties)this.getCtx(), (String)"JP_DifferentContractTemplate"));
        }
        if (this.p_JP_ContractTabLevel.equals(JP_ContractTabLevel_Content)) {
            if (this.from_JP_ContractContent_ID == 0) {
                String msg0 = Msg.getElement((Properties)Env.getCtx(), (String)"JP_ContractContent_ID");
                throw new Exception(Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Mandatory", (Object[])new Object[]{msg0}));
            }
            if (this.to_ContractContent.getJP_ContractContentT_ID() != this.from_ContractContent.getJP_ContractContentT_ID()) {
                throw new Exception(Msg.getMsg((Properties)this.getCtx(), (String)"JP_DifferentContractTemplate"));
            }
        }
        return Msg.getMsg((Properties)this.getCtx(), (String)"Success");
    }

    protected void setDocumentNoOfContractContent(MContractContent from, MContractContent to) {
        MDocType docType = MDocType.get((Properties)this.getCtx(), (int)from.getC_DocType_ID());
        to.setC_DocType_ID(docType.getC_DocType_ID());
        if (docType.isDocNoControlled()) {
            to.setDocumentNo(null);
        }
    }

    protected void setBPartnerOfContractContent(MContractContent from, MContractContent to) {
        if (to.getParent().getC_BPartner_ID() == from.getC_BPartner_ID()) {
            to.setC_BPartner_ID(from.getC_BPartner_ID());
            to.setC_BPartner_Location_ID(from.getC_BPartner_Location_ID());
            to.setAD_User_ID(from.getAD_User_ID());
            to.setDropShip_BPartner_ID(from.getDropShip_BPartner_ID());
            to.setDropShip_Location_ID(from.getDropShip_Location_ID());
            to.setDropShip_User_ID(from.getDropShip_User_ID());
            to.setIsDropShip(from.isDropShip());
            to.setBill_BPartner_ID(from.getBill_BPartner_ID());
            to.setBill_Location_ID(from.getBill_Location_ID());
            to.setBill_User_ID(from.getBill_User_ID());
        } else if (from.getC_BPartner_ID() == from.getJP_ContractContentT().getC_BPartner_ID()) {
            to.setC_BPartner_ID(from.getC_BPartner_ID());
            to.setC_BPartner_Location_ID(from.getC_BPartner_Location_ID());
            to.setAD_User_ID(from.getAD_User_ID());
            to.setDropShip_BPartner_ID(from.getDropShip_BPartner_ID());
            to.setDropShip_Location_ID(from.getDropShip_Location_ID());
            to.setDropShip_User_ID(from.getDropShip_User_ID());
            to.setIsDropShip(from.isDropShip());
            to.setBill_BPartner_ID(from.getBill_BPartner_ID());
            to.setBill_Location_ID(from.getBill_Location_ID());
            to.setBill_User_ID(from.getBill_User_ID());
        } else {
            to.setC_BPartner_ID(to.getParent().getC_BPartner_ID());
            if (to.getParent().getC_BPartner_Location_ID() != 0) {
                to.setC_BPartner_Location_ID(to.getParent().getC_BPartner_Location_ID());
            } else {
                MBPartnerLocation[] bpLocations = MBPartnerLocation.getForBPartner((Properties)this.getCtx(), (int)to.getParent().getC_BPartner_ID(), (String)this.get_TrxName());
                if (bpLocations.length > 1) {
                    to.setC_BPartner_Location_ID(bpLocations[0].getC_BPartner_Location_ID());
                }
            }
            if (to.getParent().getAD_User_ID() != 0) {
                to.setAD_User_ID(to.getParent().getAD_User_ID());
            } else {
                to.setAD_User_ID(0);
            }
            to.setDropShip_BPartner_ID(0);
            to.setDropShip_Location_ID(0);
            to.setDropShip_User_ID(0);
            to.setIsDropShip(false);
            to.setBill_BPartner_ID(0);
            to.setBill_Location_ID(0);
            to.setBill_User_ID(0);
        }
    }

    protected void setWarehouseOfContractContent(MContractContent from, MContractContent to) throws Exception {
        if (from.getDocBaseType().equals("API") || from.getDocBaseType().equals("ARI")) {
            return;
        }
        if (from.getM_Warehouse() != null && from.getM_Warehouse().getAD_Org_ID() == to.getAD_Org_ID()) {
            to.setM_Warehouse_ID(from.getM_Warehouse_ID());
        } else if (MOrgInfo.get(null, (int)to.getAD_Org_ID(), (String)this.get_TrxName()).getM_Warehouse_ID() != 0) {
            to.setM_Warehouse_ID(MOrgInfo.get(null, (int)to.getAD_Org_ID(), (String)this.get_TrxName()).getM_Warehouse_ID());
        } else {
            MWarehouse[] warehouses = MWarehouse.getForOrg((Properties)this.getCtx(), (int)from.getAD_Org_ID());
            if (warehouses.length > 0) {
                to.setM_Warehouse_ID(warehouses[0].getM_Warehouse_ID());
            } else {
                throw new Exception(String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"NotFound")) + Msg.getElement((Properties)this.getCtx(), (String)"M_Warehouse_ID") + " : " + Msg.getElement((Properties)this.getCtx(), (String)"CopyFrom") + " : " + Msg.getElement((Properties)this.getCtx(), (String)"JP_ContractContent_ID") + "_" + from.getDocumentNo());
            }
        }
    }
}

