/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.model;

import java.io.File;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import jpiere.base.plugin.org.adempiere.model.MContractAcct;
import jpiere.base.plugin.org.adempiere.model.MContractContent;
import jpiere.base.plugin.org.adempiere.model.MRecognitionLine;
import jpiere.base.plugin.org.adempiere.model.MRecognitionTax;
import jpiere.base.plugin.org.adempiere.model.X_JP_Recognition;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.exceptions.BPartnerNoAddressException;
import org.adempiere.exceptions.PeriodClosedException;
import org.compiere.model.I_C_BPartner;
import org.compiere.model.MBPartner;
import org.compiere.model.MBPartnerLocation;
import org.compiere.model.MCurrency;
import org.compiere.model.MDocType;
import org.compiere.model.MInOut;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MPeriod;
import org.compiere.model.MPriceList;
import org.compiere.model.MPriceListVersion;
import org.compiere.model.MRMA;
import org.compiere.model.MRMALine;
import org.compiere.model.MRefList;
import org.compiere.model.MSysConfig;
import org.compiere.model.MTax;
import org.compiere.model.MTaxProvider;
import org.compiere.model.MUser;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.print.MPrintFormat;
import org.compiere.print.ReportEngine;
import org.compiere.process.DocAction;
import org.compiere.process.DocOptions;
import org.compiere.process.DocumentEngine;
import org.compiere.process.ProcessInfo;
import org.compiere.process.ServerProcessCtl;
import org.compiere.util.CCache;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class MRecognition
extends X_JP_Recognition
implements DocAction,
DocOptions {
    private static final long serialVersionUID = -9210893813732918522L;
    private static CCache<Integer, MRecognition> s_cache = new CCache("JP_Recognition", 20, 2);
    private MRecognitionLine[] m_lines;
    private MRecognitionTax[] m_taxes;
    private static CLogger s_log = CLogger.getCLogger(MRecognition.class);
    private boolean m_reversal = false;
    private String m_processMsg = null;
    private boolean m_justPrepared = false;
    ArrayList<PO> docsPostProcess = new ArrayList();

    public static MRecognition[] getOfBPartner(Properties ctx, int C_BPartner_ID, String trxName) {
        List list = new Query(ctx, "JP_Recognition", "C_BPartner_ID=?", trxName).setParameters(new Object[]{C_BPartner_ID}).list();
        return list.toArray(new MRecognition[list.size()]);
    }

    public static MRecognition copyFrom(MRecognition from, Timestamp dateDoc, Timestamp dateAcct, int C_DocTypeTarget_ID, boolean isSOTrx, boolean counter, String trxName, boolean setOrder) {
        return MRecognition.copyFrom(from, dateDoc, dateAcct, C_DocTypeTarget_ID, isSOTrx, counter, trxName, setOrder, null);
    }

    public static MRecognition copyFrom(MRecognition from, Timestamp dateDoc, Timestamp dateAcct, int C_DocTypeTarget_ID, boolean isSOTrx, boolean counter, String trxName, boolean setOrder, String documentNo) {
        MRecognition to = new MRecognition(from.getCtx(), 0, trxName);
        PO.copyValues((PO)from, (PO)to, (int)from.getAD_Client_ID(), (int)from.getAD_Org_ID());
        to.set_ValueNoCheck("JP_Recognition_ID", I_ZERO);
        to.set_ValueNoCheck("DocumentNo", documentNo);
        to.setJP_Contract_ID(from.getJP_Contract_ID());
        to.setJP_ContractContent_ID(from.getJP_ContractContent_ID());
        to.setJP_ContractProcPeriod_ID(from.getJP_ContractProcPeriod_ID());
        to.setC_Order_ID(from.getC_Order_ID());
        to.setM_InOut_ID(from.getM_InOut_ID());
        to.setDocStatus("DR");
        to.setDocAction("CO");
        to.setC_DocType_ID(0);
        to.setC_DocTypeTarget_ID(C_DocTypeTarget_ID);
        to.setIsSOTrx(isSOTrx);
        to.setDateInvoiced(dateDoc);
        to.setDateAcct(dateAcct);
        to.setDatePrinted(null);
        to.setIsPrinted(false);
        to.setIsApproved(false);
        to.setGrandTotal(Env.ZERO);
        to.setTotalLines(Env.ZERO);
        to.setPosted(false);
        to.setProcessed(false);
        to.setProcessing(false);
        to.saveEx(trxName);
        if (to.copyLinesFrom(from, counter, setOrder) == 0) {
            throw new IllegalStateException("Could not create Recognition Lines");
        }
        return to;
    }

    public static MRecognition copyFrom(MRecognition from, Timestamp dateDoc, int C_DocTypeTarget_ID, boolean isSOTrx, boolean counter, String trxName, boolean setOrder) {
        MRecognition to = MRecognition.copyFrom(from, dateDoc, dateDoc, C_DocTypeTarget_ID, isSOTrx, counter, trxName, setOrder);
        return to;
    }

    public static String getPDFFileName(String documentDir, int JP_Recognition_ID) {
        StringBuilder sb = new StringBuilder(documentDir);
        if (sb.length() == 0) {
            sb.append(".");
        }
        if (!sb.toString().endsWith(File.separator)) {
            sb.append(File.separator);
        }
        sb.append("JP_Recognition_ID_").append(JP_Recognition_ID).append(".pdf");
        return sb.toString();
    }

    public static MRecognition get(Properties ctx, int JP_Recognition_ID) {
        Integer key = JP_Recognition_ID;
        MRecognition retValue = (MRecognition)s_cache.get((Object)key);
        if (retValue != null) {
            return retValue;
        }
        retValue = new MRecognition(ctx, JP_Recognition_ID, null);
        if (retValue.get_ID() != 0) {
            s_cache.put((Object)key, (Object)retValue);
        }
        return retValue;
    }

    public MRecognition(Properties ctx, int JP_Recognition_ID, String trxName) {
        super(ctx, JP_Recognition_ID, trxName);
        if (JP_Recognition_ID == 0) {
            this.setDocStatus("DR");
            this.setDocAction("CO");
            this.setDateInvoiced(new Timestamp(System.currentTimeMillis()));
            this.setDateAcct(new Timestamp(System.currentTimeMillis()));
            this.setTotalLines(Env.ZERO);
            this.setGrandTotal(Env.ZERO);
            this.setIsSOTrx(true);
            this.setIsTaxIncluded(false);
            this.setIsApproved(false);
            this.setSendEMail(false);
            this.setIsPrinted(false);
            this.setIsSelfService(false);
            this.setPosted(false);
            super.setProcessed(false);
            this.setProcessing(false);
        }
    }

    public MRecognition(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MRecognition(MOrder order, int C_DocTypeTarget_ID, Timestamp DateAcct) {
        this(order.getCtx(), 0, order.get_TrxName());
        MDocType odt;
        this.setClientOrg((PO)order);
        this.setOrder(order);
        if (C_DocTypeTarget_ID <= 0 && (odt = MDocType.get((Properties)order.getCtx(), (int)order.getC_DocType_ID())) != null && (C_DocTypeTarget_ID = odt.get_ValueAsInt("JP_DocTypeRecognition_ID")) <= 0) {
            throw new AdempiereException("@NotFound@ @C_DocTypeInvoice_ID@ - @C_DocType_ID@:" + odt.get_Translation("Name"));
        }
        this.setC_DocTypeTarget_ID(C_DocTypeTarget_ID);
        this.setC_DocType_ID(C_DocTypeTarget_ID);
        this.setDateInvoiced(DateAcct);
        this.setDateAcct(DateAcct);
        this.setSalesRep_ID(order.getSalesRep_ID());
        this.setC_BPartner_ID(order.getC_BPartner_ID());
        this.setC_BPartner_Location_ID(order.getC_BPartner_Location_ID());
        this.setAD_User_ID(order.getAD_User_ID());
        if (order.getBill_BPartner_ID() > 0) {
            this.setBill_BPartner_ID(order.getBill_BPartner_ID());
            this.setBill_Location_ID(order.getBill_Location_ID());
            this.setBill_User_ID(order.getBill_User_ID());
        } else {
            this.setBill_BPartner_ID(order.getC_BPartner_ID());
            this.setBill_Location_ID(order.getC_BPartner_Location_ID());
            this.setBill_User_ID(order.getAD_User_ID());
        }
        this.setJP_Contract_ID(order.get_ValueAsInt("JP_Contract_ID"));
        this.setJP_ContractContent_ID(order.get_ValueAsInt("JP_ContractContent_ID"));
        this.setJP_ContractProcPeriod_ID(order.get_ValueAsInt("JP_ContractProcPeriod_ID"));
    }

    public void setClientOrg(int AD_Client_ID, int AD_Org_ID) {
        super.setClientOrg(AD_Client_ID, AD_Org_ID);
    }

    public void setBPartner(MBPartner bp) {
        MUser[] contacts;
        MBPartnerLocation[] locs;
        if (bp == null) {
            return;
        }
        this.setC_BPartner_ID(bp.getC_BPartner_ID());
        int ii = 0;
        ii = this.isSOTrx() ? bp.getM_PriceList_ID() : bp.getPO_PriceList_ID();
        if (ii != 0) {
            this.setM_PriceList_ID(ii);
        }
        if ((locs = bp.getLocations(false)) != null) {
            int i = 0;
            while (i < locs.length) {
                if (locs[i].isBillTo() && this.isSOTrx() || locs[i].isPayFrom() && !this.isSOTrx()) {
                    this.setC_BPartner_Location_ID(locs[i].getC_BPartner_Location_ID());
                }
                ++i;
            }
            if (this.getC_BPartner_Location_ID() == 0 && locs.length > 0) {
                this.setC_BPartner_Location_ID(locs[0].getC_BPartner_Location_ID());
            }
        }
        if (this.getC_BPartner_Location_ID() == 0) {
            this.log.log(Level.SEVERE, new BPartnerNoAddressException((I_C_BPartner)bp).getLocalizedMessage());
        }
        if ((contacts = bp.getContacts(false)) != null && contacts.length > 0) {
            this.setAD_User_ID(contacts[0].getAD_User_ID());
        }
    }

    public void setOrder(MOrder order) {
        if (order == null) {
            return;
        }
        this.setC_Order_ID(order.getC_Order_ID());
        this.setIsSOTrx(order.isSOTrx());
        this.setIsDiscountPrinted(order.isDiscountPrinted());
        this.setIsSelfService(order.isSelfService());
        this.setSendEMail(order.isSendEMail());
        this.setM_PriceList_ID(order.getM_PriceList_ID());
        this.setIsTaxIncluded(order.isTaxIncluded());
        this.setC_Currency_ID(order.getC_Currency_ID());
        this.setC_ConversionType_ID(order.getC_ConversionType_ID());
        this.setPOReference(order.getPOReference());
        this.setDescription(order.getDescription());
        this.setDateOrdered(order.getDateOrdered());
        this.setBill_BPartner_ID(order.getBill_BPartner_ID());
        this.setBill_Location_ID(order.getBill_Location_ID());
        this.setBill_User_ID(order.getBill_User_ID());
        this.setAD_OrgTrx_ID(order.getAD_OrgTrx_ID());
        this.setC_Project_ID(order.getC_Project_ID());
        this.setC_Campaign_ID(order.getC_Campaign_ID());
        this.setC_Activity_ID(order.getC_Activity_ID());
        this.setUser1_ID(order.getUser1_ID());
        this.setUser2_ID(order.getUser2_ID());
    }

    public void setShipment(MInOut ship) {
        MDocType dt;
        if (ship == null) {
            return;
        }
        this.setIsSOTrx(ship.isSOTrx());
        MBPartner bp = new MBPartner(this.getCtx(), ship.getC_BPartner_ID(), null);
        this.setBPartner(bp);
        this.setAD_User_ID(ship.getAD_User_ID());
        this.setSendEMail(ship.isSendEMail());
        this.setPOReference(ship.getPOReference());
        this.setDescription(ship.getDescription());
        this.setDateOrdered(ship.getDateOrdered());
        this.setAD_OrgTrx_ID(ship.getAD_OrgTrx_ID());
        this.setC_Project_ID(ship.getC_Project_ID());
        this.setC_Campaign_ID(ship.getC_Campaign_ID());
        this.setC_Activity_ID(ship.getC_Activity_ID());
        this.setUser1_ID(ship.getUser1_ID());
        this.setUser2_ID(ship.getUser2_ID());
        if (ship.getC_Order_ID() != 0) {
            this.setC_Order_ID(ship.getC_Order_ID());
            MOrder order = new MOrder(this.getCtx(), ship.getC_Order_ID(), this.get_TrxName());
            this.setIsDiscountPrinted(order.isDiscountPrinted());
            this.setM_PriceList_ID(order.getM_PriceList_ID());
            this.setIsTaxIncluded(order.isTaxIncluded());
            this.setC_Currency_ID(order.getC_Currency_ID());
            this.setC_ConversionType_ID(order.getC_ConversionType_ID());
            dt = MDocType.get((Properties)this.getCtx(), (int)order.getC_DocType_ID());
            if (dt.getC_DocTypeInvoice_ID() != 0) {
                this.setC_DocTypeTarget_ID(dt.getC_DocTypeInvoice_ID());
            }
            this.setC_BPartner_ID(order.getBill_BPartner_ID());
            this.setC_BPartner_Location_ID(order.getBill_Location_ID());
            this.setAD_User_ID(order.getBill_User_ID());
        }
        if (ship.getM_RMA_ID() != 0) {
            this.setM_RMA_ID(ship.getM_RMA_ID());
            MRMA rma = new MRMA(this.getCtx(), ship.getM_RMA_ID(), this.get_TrxName());
            dt = MDocType.get((Properties)this.getCtx(), (int)rma.getC_DocType_ID());
            if (dt.getC_DocTypeInvoice_ID() != 0) {
                this.setC_DocTypeTarget_ID(dt.getC_DocTypeInvoice_ID());
            }
            this.setIsSOTrx(rma.isSOTrx());
            MOrder rmaOrder = rma.getOriginalOrder();
            if (rmaOrder != null) {
                this.setM_PriceList_ID(rmaOrder.getM_PriceList_ID());
                this.setIsTaxIncluded(rmaOrder.isTaxIncluded());
                this.setC_Currency_ID(rmaOrder.getC_Currency_ID());
                this.setC_ConversionType_ID(rmaOrder.getC_ConversionType_ID());
                this.setC_BPartner_Location_ID(rmaOrder.getBill_Location_ID());
            }
        }
    }

    public BigDecimal getGrandTotal(boolean creditMemoAdjusted) {
        if (!creditMemoAdjusted) {
            return super.getGrandTotal();
        }
        BigDecimal amt = this.getGrandTotal();
        if (this.isCreditMemo()) {
            return amt.negate();
        }
        return amt;
    }

    public BigDecimal getTotalLines(boolean creditMemoAdjusted) {
        if (!creditMemoAdjusted) {
            return super.getTotalLines();
        }
        BigDecimal amt = this.getTotalLines();
        if (this.isCreditMemo()) {
            return amt.negate();
        }
        return amt;
    }

    private MRecognitionLine[] getLines(String whereClause) {
        String whereClauseFinal = "JP_Recognition_ID=? ";
        if (whereClause != null) {
            whereClauseFinal = String.valueOf(whereClauseFinal) + whereClause;
        }
        List list = new Query(this.getCtx(), "JP_RecognitionLine", whereClauseFinal, this.get_TrxName()).setParameters(new Object[]{this.getJP_Recognition_ID()}).setOrderBy("Line").list();
        return list.toArray(new MRecognitionLine[list.size()]);
    }

    public MRecognitionLine[] getLines(boolean requery) {
        if (this.m_lines == null || this.m_lines.length == 0 || requery) {
            this.m_lines = this.getLines(null);
        }
        MRecognition.set_TrxName((PO[])this.m_lines, (String)this.get_TrxName());
        return this.m_lines;
    }

    public MRecognitionLine[] getLines() {
        return this.getLines(false);
    }

    public void renumberLines(int step) {
        int number = step;
        MRecognitionLine[] lines = this.getLines(false);
        int i = 0;
        while (i < lines.length) {
            MRecognitionLine line = lines[i];
            line.setLine(number);
            line.saveEx();
            number += step;
            ++i;
        }
        this.m_lines = null;
    }

    public int copyLinesFrom(MRecognition otherRecognition, boolean counter, boolean setOrder) {
        if (this.isProcessed() || this.isPosted() || otherRecognition == null) {
            return 0;
        }
        MRecognitionLine[] fromLines = otherRecognition.getLines(false);
        int count = 0;
        int i = 0;
        while (i < fromLines.length) {
            MRecognitionLine line = new MRecognitionLine(this.getCtx(), 0, this.get_TrxName());
            MRecognitionLine fromLine = fromLines[i];
            if (counter) {
                PO.copyValues((PO)fromLine, (PO)line, (int)this.getAD_Client_ID(), (int)this.getAD_Org_ID());
            } else {
                PO.copyValues((PO)fromLine, (PO)line, (int)fromLine.getAD_Client_ID(), (int)fromLine.getAD_Org_ID());
            }
            line.setJP_Recognition_ID(this.getJP_Recognition_ID());
            line.setRecognition(this);
            line.set_ValueNoCheck("JP_RecognitionLine_ID", I_ZERO);
            line.setC_OrderLine_ID(fromLine.getC_OrderLine_ID());
            line.setM_RMALine_ID(fromLine.getM_RMALine_ID());
            line.setM_InOutLine_ID(fromLine.getM_InOutLine_ID());
            line.setJP_ContractLine_ID(fromLine.getJP_ContractLine_ID());
            line.setJP_ContractProcPeriod_ID(fromLine.getJP_ContractProcPeriod_ID());
            line.setQtyEntered(fromLine.getQtyEntered());
            line.setQtyInvoiced(fromLine.getQtyInvoiced());
            line.setJP_QtyRecognized(fromLine.getJP_QtyRecognized());
            line.setJP_TargetQtyRecognized(fromLine.getJP_TargetQtyRecognized());
            line.setM_AttributeSetInstance_ID(0);
            line.setS_ResourceAssignment_ID(0);
            if (this.getC_BPartner_ID() != otherRecognition.getC_BPartner_ID()) {
                line.setTax();
            }
            line.setProcessed(false);
            if (line.save(this.get_TrxName())) {
                ++count;
            }
            ++i;
        }
        if (fromLines.length != count) {
            this.log.log(Level.SEVERE, "Line difference - From=" + fromLines.length + " <> Saved=" + count);
        }
        return count;
    }

    private void setReversal(boolean reversal) {
        this.m_reversal = reversal;
    }

    public boolean isReversal() {
        return this.m_reversal;
    }

    public MRecognitionTax[] getTaxes(boolean requery) {
        if (this.m_taxes != null && !requery) {
            return this.m_taxes;
        }
        String whereClause = "JP_Recognition_ID=?";
        List list = new Query(this.getCtx(), "JP_RecognitionTax", "JP_Recognition_ID=?", this.get_TrxName()).setParameters(new Object[]{this.get_ID()}).list();
        this.m_taxes = list.toArray(new MRecognitionTax[list.size()]);
        return this.m_taxes;
    }

    public void addDescription(String description) {
        String desc = this.getDescription();
        if (desc == null) {
            this.setDescription(description);
        } else {
            StringBuilder msgd = new StringBuilder(desc).append(" | ").append(description);
            this.setDescription(msgd.toString());
        }
    }

    public boolean isCreditMemo() {
        MDocType dt = MDocType.get((Properties)this.getCtx(), (int)(this.getC_DocType_ID() == 0 ? this.getC_DocTypeTarget_ID() : this.getC_DocType_ID()));
        return "APC".equals(dt.getDocBaseType()) || "ARC".equals(dt.getDocBaseType());
    }

    @Override
    public void setProcessed(boolean processed) {
        super.setProcessed(processed);
        if (this.get_ID() == 0) {
            return;
        }
        StringBuilder set = new StringBuilder("SET Processed='").append(processed ? "Y" : "N").append("' WHERE JP_Recognition_ID=").append(this.getJP_Recognition_ID());
        StringBuilder msgdb = new StringBuilder("UPDATE JP_RecognitionLine ").append((CharSequence)set);
        int noLine = DB.executeUpdate((String)msgdb.toString(), (String)this.get_TrxName());
        msgdb = new StringBuilder("UPDATE JP_RecognitionTax ").append((CharSequence)set);
        int noTax = DB.executeUpdate((String)msgdb.toString(), (String)this.get_TrxName());
        this.m_lines = null;
        this.m_taxes = null;
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine(String.valueOf(processed) + " - Lines=" + noLine + ", Tax=" + noTax);
        }
    }

    protected boolean beforeSave(boolean newRecord) {
        int cnt;
        int ii;
        if (newRecord || this.is_ValueChanged("M_InOut_ID")) {
            MInOut io = new MInOut(this.getCtx(), this.getM_InOut_ID(), this.get_TrxName());
            int JP_ContractContent_ID = io.get_ValueAsInt("JP_ContractContent_ID");
            MContractContent contractContent = MContractContent.get(this.getCtx(), JP_ContractContent_ID);
            if (!contractContent.getJP_Contract_Acct().isPostingRecognitionDocJP()) {
                this.log.saveError("Error", Msg.getMsg((Properties)this.getCtx(), (String)"JP_InOutDocCannotCreateRecog"));
                return false;
            }
            if (io.getC_Order_ID() == 0 && io.getM_RMA_ID() == 0) {
                this.log.saveError("Error", Msg.getMsg((Properties)this.getCtx(), (String)"JP_CouldNotCreateRecog_NoInOutInfo"));
                return false;
            }
            if (io.getM_RMA_ID() > 0) {
                MRMA rma = new MRMA(this.getCtx(), io.getM_RMA_ID(), this.get_TrxName());
                this.setM_RMA_ID(rma.getM_RMA_ID());
            } else if (io.getC_Order_ID() > 0) {
                MOrder order = new MOrder(this.getCtx(), io.getC_Order_ID(), this.get_TrxName());
                this.setC_Order_ID(order.getC_Order_ID());
                this.setDateOrdered(order.getDateOrdered());
            }
        }
        if (newRecord || this.is_ValueChanged("C_DocTypeTarget_ID")) {
            String msg;
            if (this.getM_RMA_ID() > 0) {
                if (this.isSOTrx()) {
                    if (!this.getC_DocTypeTarget().getDocBaseType().equals("JPS")) {
                        msg = Msg.getMsg((Properties)this.getCtx(), (String)"JP_Inconsistency", (Object[])new Object[]{Msg.getElement((Properties)Env.getCtx(), (String)"C_DocType_ID"), Msg.getElement((Properties)Env.getCtx(), (String)"M_RMA_ID", (boolean)this.isSOTrx())});
                        this.log.saveError("Error", msg);
                        return false;
                    }
                } else if (!this.getC_DocTypeTarget().getDocBaseType().equals("JPY")) {
                    msg = Msg.getMsg((Properties)this.getCtx(), (String)"JP_Inconsistency", (Object[])new Object[]{Msg.getElement((Properties)Env.getCtx(), (String)"C_DocType_ID"), Msg.getElement((Properties)Env.getCtx(), (String)"M_RMA_ID", (boolean)this.isSOTrx())});
                    this.log.saveError("Error", msg);
                    return false;
                }
            } else if (this.getC_Order_ID() > 0) {
                if (this.isSOTrx()) {
                    if (!this.getC_DocTypeTarget().getDocBaseType().equals("JPR")) {
                        msg = Msg.getMsg((Properties)this.getCtx(), (String)"JP_Inconsistency", (Object[])new Object[]{Msg.getElement((Properties)Env.getCtx(), (String)"C_DocType_ID"), Msg.getElement((Properties)Env.getCtx(), (String)"C_Order_ID", (boolean)this.isSOTrx())});
                        this.log.saveError("Error", msg);
                        return false;
                    }
                } else if (!this.getC_DocTypeTarget().getDocBaseType().equals("JPX")) {
                    msg = Msg.getMsg((Properties)this.getCtx(), (String)"JP_Inconsistency", (Object[])new Object[]{Msg.getElement((Properties)Env.getCtx(), (String)"C_DocType_ID"), Msg.getElement((Properties)Env.getCtx(), (String)"C_Order_ID", (boolean)this.isSOTrx())});
                    this.log.saveError("Error", msg);
                    return false;
                }
            }
        }
        this.log.fine("");
        if (this.getC_BPartner_ID() == 0) {
            this.setBPartner(MBPartner.getTemplate((Properties)this.getCtx(), (int)this.getAD_Client_ID()));
        }
        if (this.getC_BPartner_Location_ID() == 0) {
            this.setBPartner(new MBPartner(this.getCtx(), this.getC_BPartner_ID(), null));
        }
        if (this.getM_PriceList_ID() == 0) {
            String sql;
            int ii2 = Env.getContextAsInt((Properties)this.getCtx(), (String)"#M_PriceList_ID");
            if (ii2 != 0) {
                MPriceList pl = new MPriceList(this.getCtx(), ii2, null);
                if (this.isSOTrx() == pl.isSOPriceList()) {
                    this.setM_PriceList_ID(ii2);
                }
            }
            if (this.getM_PriceList_ID() == 0 && (ii2 = DB.getSQLValue(null, (String)(sql = "SELECT M_PriceList_ID FROM M_PriceList WHERE AD_Client_ID=? AND IsSOPriceList=? AND IsActive='Y' ORDER BY IsDefault DESC"), (Object[])new Object[]{this.getAD_Client_ID(), this.isSOTrx()})) != 0) {
                this.setM_PriceList_ID(ii2);
            }
        }
        if (this.getC_Currency_ID() == 0) {
            String sql = "SELECT C_Currency_ID FROM M_PriceList WHERE M_PriceList_ID=?";
            int ii3 = DB.getSQLValue(null, (String)sql, (int)this.getM_PriceList_ID());
            if (ii3 != 0) {
                this.setC_Currency_ID(ii3);
            } else {
                this.setC_Currency_ID(Env.getContextAsInt((Properties)this.getCtx(), (String)"#C_Currency_ID"));
            }
        }
        if (this.getSalesRep_ID() == 0 && (ii = Env.getContextAsInt((Properties)this.getCtx(), (String)"#SalesRep_ID")) != 0) {
            this.setSalesRep_ID(ii);
        }
        if (!newRecord || this.is_ValueChanged("C_DocTypeTarget_ID")) {
            this.setC_DocType_ID(this.getC_DocTypeTarget_ID());
        }
        if (!newRecord && (this.is_ValueChanged("M_PriceList_ID") || this.is_ValueChanged("DateInvoiced")) && (cnt = DB.getSQLValueEx((String)this.get_TrxName(), (String)"SELECT COUNT(*) FROM JP_RecognitionLine WHERE JP_Recognition_ID=? AND M_Product_ID>0", (Object[])new Object[]{this.getJP_Recognition_ID()})) > 0) {
            if (this.is_ValueChanged("M_PriceList_ID")) {
                this.log.saveError("Error", Msg.getMsg((Properties)this.getCtx(), (String)"CannotChangePlIn"));
                return false;
            }
            if (this.is_ValueChanged("DateInvoiced")) {
                MPriceList pList = MPriceList.get((Properties)this.getCtx(), (int)this.getM_PriceList_ID(), null);
                MPriceListVersion plOld = pList.getPriceListVersion((Timestamp)this.get_ValueOld("DateInvoiced"));
                MPriceListVersion plNew = pList.getPriceListVersion((Timestamp)this.get_Value("DateInvoiced"));
                if (plNew == null || !plNew.equals((Object)plOld)) {
                    this.log.saveError("Error", Msg.getMsg((Properties)this.getCtx(), (String)"CannotChangeDateInvoiced"));
                    return false;
                }
            }
        }
        return true;
    }

    protected boolean beforeDelete() {
        if (this.getC_Order_ID() != 0) {
            this.getLines();
        }
        return true;
    }

    protected boolean afterDelete(boolean success) {
        if (!success) {
            return success;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("MRecognition[").append(this.get_ID()).append("-").append(this.getDocumentNo()).append(",GrandTotal=").append(this.getGrandTotal());
        if (this.m_lines != null) {
            sb.append(" (#").append(this.m_lines.length).append(")");
        }
        sb.append("]");
        return sb.toString();
    }

    public String getDocumentInfo() {
        MDocType dt = MDocType.get((Properties)this.getCtx(), (int)this.getC_DocType_ID());
        StringBuilder msgreturn = new StringBuilder().append(dt.getNameTrl()).append(" ").append(this.getDocumentNo());
        return msgreturn.toString();
    }

    protected boolean afterSave(boolean newRecord, boolean success) {
        if (!success || newRecord) {
            return success;
        }
        if (this.is_ValueChanged("AD_Org_ID")) {
            StringBuilder sql = new StringBuilder("UPDATE JP_RecognitionLine ol").append(" SET AD_Org_ID =").append("(SELECT AD_Org_ID").append(" FROM JP_Recognition o WHERE ol.JP_Recognition_ID=o.JP_Recognition_ID) ").append("WHERE JP_Recognition_ID=").append(this.getJP_Recognition_ID());
            int no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("Lines -> #" + no);
            }
        }
        return true;
    }

    @Override
    public void setM_PriceList_ID(int M_PriceList_ID) {
        MPriceList pl = MPriceList.get((Properties)this.getCtx(), (int)M_PriceList_ID, null);
        if (pl != null) {
            this.setC_Currency_ID(pl.getC_Currency_ID());
            super.setM_PriceList_ID(M_PriceList_ID);
        }
    }

    public String getDocStatusName() {
        return MRefList.getListName((Properties)this.getCtx(), (int)131, (String)this.getDocStatus());
    }

    public File createPDF() {
        try {
            StringBuilder msgfile = new StringBuilder().append(this.get_TableName()).append(this.get_ID()).append("_");
            File temp = File.createTempFile(msgfile.toString(), ".pdf");
            return this.createPDF(temp);
        }
        catch (Exception e) {
            this.log.severe("Could not create PDF - " + e.getMessage());
            return null;
        }
    }

    public File createPDF(File file) {
        ReportEngine re = ReportEngine.get((Properties)this.getCtx(), (int)2, (int)this.getJP_Recognition_ID(), (String)this.get_TrxName());
        if (re == null) {
            return null;
        }
        MPrintFormat format = re.getPrintFormat();
        if (format.getJasperProcess_ID() > 0) {
            ProcessInfo pi = new ProcessInfo("", format.getJasperProcess_ID());
            pi.setRecord_ID(this.getJP_Recognition_ID());
            pi.setIsBatch(true);
            ServerProcessCtl.process((ProcessInfo)pi, null);
            return pi.getPDFReport();
        }
        return re.getPDF(file);
    }

    public String getPDFFileName(String documentDir) {
        return MRecognition.getPDFFileName(documentDir, this.getJP_Recognition_ID());
    }

    public String getCurrencyISO() {
        return MCurrency.getISO_Code((Properties)this.getCtx(), (int)this.getC_Currency_ID());
    }

    public int getPrecision() {
        return MCurrency.getStdPrecision((Properties)this.getCtx(), (int)this.getC_Currency_ID());
    }

    public boolean processIt(String processAction) {
        this.m_processMsg = null;
        DocumentEngine engine = new DocumentEngine((DocAction)this, this.getDocStatus());
        return engine.processIt(processAction, this.getDocAction());
    }

    public boolean unlockIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("unlockIt - " + this.toString());
        }
        this.setProcessing(false);
        return true;
    }

    public boolean invalidateIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("invalidateIt - " + this.toString());
        }
        this.setDocAction("PR");
        return true;
    }

    public String prepareIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.toString());
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 1);
        if (this.m_processMsg != null) {
            return "IN";
        }
        MPeriod.testPeriodOpen((Properties)this.getCtx(), (Timestamp)this.getDateAcct(), (int)this.getC_DocTypeTarget_ID(), (int)this.getAD_Org_ID());
        MRecognitionLine[] lines = this.getLines(true);
        if (lines.length == 0) {
            this.m_processMsg = "@NoLines@";
            return "IN";
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 8);
        if (this.m_processMsg != null) {
            return "IN";
        }
        this.m_justPrepared = true;
        if (!"CO".equals(this.getDocAction())) {
            this.setDocAction("CO");
        }
        return "IP";
    }

    public boolean approveIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.toString());
        }
        this.setIsApproved(true);
        return true;
    }

    public boolean rejectIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.toString());
        }
        this.setIsApproved(false);
        return true;
    }

    public String completeIt() {
        MContractAcct acctInfo;
        int JP_Contract_Acct_ID;
        if (!this.m_justPrepared) {
            String status = this.prepareIt();
            this.m_justPrepared = false;
            if (!"IP".equals(status)) {
                return status;
            }
        }
        this.setDefiniteDocumentNo();
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 7);
        if (this.m_processMsg != null) {
            return "IN";
        }
        if (!this.isApproved()) {
            this.approveIt();
        }
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.toString());
        }
        StringBuilder info = new StringBuilder();
        MRecognitionLine[] lines = this.getLines(false);
        boolean isDiffQty = false;
        int i = 0;
        while (i < lines.length) {
            MRecognitionLine line = lines[i];
            if (!isDiffQty && line.getJP_TargetQtyRecognized().compareTo(Env.ZERO) != 0 && line.getJP_QtyRecognized().compareTo(line.getJP_TargetQtyRecognized()) != 0) {
                isDiffQty = true;
            }
            MOrderLine ol = null;
            if (line.getC_OrderLine_ID() != 0 && line.getM_RMALine_ID() == 0) {
                ol = new MOrderLine(this.getCtx(), line.getC_OrderLine_ID(), this.get_TrxName());
                BigDecimal JP_QtyRecognized = (BigDecimal)ol.get_Value("JP_QtyRecognized");
                if (JP_QtyRecognized == null) {
                    JP_QtyRecognized = Env.ZERO;
                }
                if (line.getJP_QtyRecognized() != null) {
                    BigDecimal qtyDelivered = ol.getQtyDelivered();
                    BigDecimal qtyRecognized = JP_QtyRecognized.add(line.getJP_QtyRecognized());
                    if (qtyRecognized.compareTo(qtyDelivered) > 0) {
                        this.m_processMsg = String.valueOf(Msg.getElement((Properties)this.getCtx(), (String)"JP_QtyRecognized")) + " > " + Msg.getElement((Properties)this.getCtx(), (String)"QtyDelivered") + "  " + Msg.getElement((Properties)this.getCtx(), (String)"JP_ToBeConfirmed") + " : " + Msg.getElement((Properties)this.getCtx(), (String)"JP_ContractLine_ID") + " : " + line.getLine();
                        return "IN";
                    }
                    ol.set_ValueNoCheck("JP_QtyRecognized", (Object)qtyRecognized);
                }
                if (!ol.save(this.get_TrxName())) {
                    this.m_processMsg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"JP_CouldNotUpdate")) + " " + Msg.getElement((Properties)this.getCtx(), (String)"C_OrderLine_ID", (boolean)this.isSOTrx());
                    return "IN";
                }
            }
            if (line.getM_RMALine_ID() != 0) {
                MRMALine rmaLine = new MRMALine(this.getCtx(), line.getM_RMALine_ID(), this.get_TrxName());
                BigDecimal JP_QtyRecognized = (BigDecimal)rmaLine.get_Value("JP_QtyRecognized");
                if (JP_QtyRecognized == null) {
                    JP_QtyRecognized = Env.ZERO;
                }
                if (line.getJP_QtyRecognized() != null) {
                    rmaLine.set_ValueNoCheck("JP_QtyRecognized", (Object)JP_QtyRecognized.add(line.getJP_QtyRecognized()));
                }
                if (!rmaLine.save(this.get_TrxName())) {
                    this.m_processMsg = "Could not update RMA Line";
                    return "IN";
                }
            }
            ++i;
        }
        if (isDiffQty) {
            MContractContent content = MContractContent.get(this.getCtx(), this.getJP_ContractContent_ID());
            MContractAcct acct = MContractAcct.get(this.getCtx(), content.getJP_Contract_Acct_ID());
            if (acct != null && acct.isPostingContractAcctJP() && acct.isPostingRecognitionDocJP() && acct.isSplitWhenDifferenceJP()) {
                this.splitRecognition(lines);
            }
        }
        if ((JP_Contract_Acct_ID = this.getJP_ContractContent().getJP_Contract_Acct_ID()) > 0 && (acctInfo = MContractAcct.get(this.getCtx(), JP_Contract_Acct_ID)).isPostingContractAcctJP() && acctInfo.isPostingRecognitionDocJP() && acctInfo.getJP_RecogToInvoicePolicy() != null && acctInfo.getJP_RecogToInvoicePolicy().equals("DD") && !this.createInvoiceFromRecog()) {
            return "IN";
        }
        String valid = ModelValidationEngine.get().fireDocValidate((PO)this, 9);
        if (valid != null) {
            this.m_processMsg = valid;
            return "IN";
        }
        this.m_processMsg = info.toString().trim();
        this.setProcessed(true);
        this.setDocAction("CL");
        return "CO";
    }

    public ArrayList<PO> getDocsPostProcess() {
        return this.docsPostProcess;
    }

    private void setDefiniteDocumentNo() {
        String value;
        if (this.isReversal() && !MSysConfig.getBooleanValue((String)"Invoice_ReverseUseNewNumber", (boolean)true, (int)this.getAD_Client_ID())) {
            return;
        }
        MDocType dt = MDocType.get((Properties)this.getCtx(), (int)this.getC_DocType_ID());
        if (dt.isOverwriteDateOnComplete()) {
            this.setDateInvoiced(new Timestamp(System.currentTimeMillis()));
            if (this.getDateAcct().before(this.getDateInvoiced())) {
                this.setDateAcct(this.getDateInvoiced());
                MPeriod.testPeriodOpen((Properties)this.getCtx(), (Timestamp)this.getDateAcct(), (int)this.getC_DocType_ID(), (int)this.getAD_Org_ID());
            }
        }
        if (dt.isOverwriteSeqOnComplete() && (value = DB.getDocumentNo((int)this.getC_DocType_ID(), (String)this.get_TrxName(), (boolean)true, (PO)this)) != null) {
            this.setDocumentNo(value);
        }
    }

    public boolean voidIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.toString());
        }
        if ("CL".equals(this.getDocStatus()) || "RE".equals(this.getDocStatus()) || "VO".equals(this.getDocStatus())) {
            this.m_processMsg = "Document Closed: " + this.getDocStatus();
            this.setDocAction("--");
            return false;
        }
        if ("DR".equals(this.getDocStatus()) || "IN".equals(this.getDocStatus()) || "IP".equals(this.getDocStatus()) || "AP".equals(this.getDocStatus()) || "NA".equals(this.getDocStatus())) {
            this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 2);
            if (this.m_processMsg != null) {
                return false;
            }
            MRecognitionLine[] lines = this.getLines(false);
            int i = 0;
            while (i < lines.length) {
                MRecognitionLine line = lines[i];
                BigDecimal old = line.getQtyInvoiced();
                if (old.compareTo(Env.ZERO) != 0) {
                    line.setQty(Env.ZERO);
                    line.setTaxAmt(Env.ZERO);
                    line.setLineNetAmt(Env.ZERO);
                    line.setLineTotalAmt(Env.ZERO);
                    StringBuilder msgadd = new StringBuilder(Msg.getMsg((Properties)this.getCtx(), (String)"Voided")).append(" (").append(old).append(")");
                    line.addDescription(msgadd.toString());
                    line.saveEx(this.get_TrxName());
                }
                ++i;
            }
        } else {
            boolean accrual = false;
            try {
                MPeriod.testPeriodOpen((Properties)this.getCtx(), (Timestamp)this.getDateAcct(), (int)this.getC_DocType_ID(), (int)this.getAD_Org_ID());
            }
            catch (PeriodClosedException e) {
                accrual = true;
            }
            if (accrual) {
                return this.reverseAccrualIt();
            }
            return this.reverseCorrectIt();
        }
        this.addDescription(Msg.getMsg((Properties)this.getCtx(), (String)"Voided"));
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 10);
        if (this.m_processMsg != null) {
            return false;
        }
        this.setProcessed(true);
        this.setDocAction("--");
        return true;
    }

    public boolean closeIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.toString());
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 3);
        if (this.m_processMsg != null) {
            return false;
        }
        if (!this.getM_InOut().getDocStatus().equals("CL")) {
            this.m_processMsg = Msg.getMsg((Properties)this.getCtx(), (String)"JP_RecogDocStatusCloseError");
            return false;
        }
        this.setProcessed(true);
        this.setDocAction("--");
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 11);
        return this.m_processMsg == null;
    }

    public boolean reverseCorrectIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.toString());
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 5);
        if (this.m_processMsg != null) {
            return false;
        }
        MRecognition reversal = this.reverse(false);
        if (reversal == null) {
            return false;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 13);
        if (this.m_processMsg != null) {
            return false;
        }
        this.m_processMsg = reversal.getDocumentNo();
        return true;
    }

    private MRecognition reverse(boolean accrual) {
        MContractAcct acct;
        MContractContent content;
        int JP_Contract_Acct_ID;
        Timestamp reversalDate;
        Timestamp timestamp = reversalDate = accrual ? Env.getContextAsDate((Properties)this.getCtx(), (String)"#Date") : this.getDateAcct();
        if (reversalDate == null) {
            reversalDate = new Timestamp(System.currentTimeMillis());
        }
        Timestamp reversalDateRecognitioned = accrual ? reversalDate : this.getDateAcct();
        MPeriod.testPeriodOpen((Properties)this.getCtx(), (Timestamp)reversalDate, (int)this.getC_DocType_ID(), (int)this.getAD_Org_ID());
        MRecognition reversal = null;
        reversal = MSysConfig.getBooleanValue((String)"Invoice_ReverseUseNewNumber", (boolean)true, (int)this.getAD_Client_ID()) ? MRecognition.copyFrom(this, reversalDateRecognitioned, reversalDate, this.getC_DocType_ID(), this.isSOTrx(), false, this.get_TrxName(), true) : MRecognition.copyFrom(this, reversalDateRecognitioned, reversalDate, this.getC_DocType_ID(), this.isSOTrx(), false, this.get_TrxName(), true, String.valueOf(this.getDocumentNo()) + "^");
        if (reversal == null) {
            this.m_processMsg = "Could not create Invoice Reversal";
            return null;
        }
        reversal.setReversal(true);
        MRecognitionLine[] sLines = this.getLines(false);
        MRecognitionLine[] rLines = reversal.getLines(true);
        int i = 0;
        while (i < rLines.length) {
            MRecognitionLine rLine = rLines[i];
            rLine.setReversalLine_ID(sLines[i].getJP_RecognitionLine_ID());
            rLine.setQtyEntered(rLine.getQtyEntered().negate());
            rLine.setQtyInvoiced(rLine.getQtyInvoiced().negate());
            rLine.setJP_QtyRecognized(rLine.getJP_QtyRecognized().negate());
            rLine.setJP_TargetQtyRecognized(rLine.getJP_TargetQtyRecognized().negate());
            rLine.setLineNetAmt(rLine.getLineNetAmt().negate());
            if (rLine.getTaxAmt() != null && rLine.getTaxAmt().compareTo(Env.ZERO) != 0) {
                rLine.setTaxAmt(rLine.getTaxAmt().negate());
            }
            if (rLine.getLineTotalAmt() != null && rLine.getLineTotalAmt().compareTo(Env.ZERO) != 0) {
                rLine.setLineTotalAmt(rLine.getLineTotalAmt().negate());
            }
            if (!rLine.save(this.get_TrxName())) {
                this.m_processMsg = "Could not correct Invoice Reversal Line";
                return null;
            }
            ++i;
        }
        reversal.setC_Order_ID(this.getC_Order_ID());
        StringBuilder msgadd = new StringBuilder("{->").append(this.getDocumentNo()).append(")");
        reversal.addDescription(msgadd.toString());
        reversal.setReversal_ID(this.getJP_Recognition_ID());
        reversal.saveEx(this.get_TrxName());
        reversal.docsPostProcess = this.docsPostProcess;
        this.docsPostProcess = new ArrayList();
        if (!reversal.processIt("CO")) {
            this.m_processMsg = "Reversal ERROR: " + reversal.getProcessMsg();
            return null;
        }
        reversal.closeIt();
        reversal.setProcessing(false);
        reversal.setDocStatus("RE");
        reversal.setDocAction("--");
        reversal.saveEx(this.get_TrxName());
        msgadd = new StringBuilder("(").append(reversal.getDocumentNo()).append("<-)");
        this.addDescription(msgadd.toString());
        this.setProcessed(true);
        this.setReversal_ID(reversal.getJP_Recognition_ID());
        this.setDocStatus("RE");
        this.setDocAction("--");
        int JP_ContractContent_ID = this.getJP_ContractContent_ID();
        if (JP_ContractContent_ID > 0 && (JP_Contract_Acct_ID = (content = MContractContent.get(Env.getCtx(), JP_ContractContent_ID)).getJP_Contract_Acct_ID()) > 0 && (acct = MContractAcct.get(Env.getCtx(), JP_Contract_Acct_ID)).isPostingContractAcctJP() && acct.isPostingRecognitionDocJP() && acct.getJP_RecogToInvoicePolicy() != null && acct.getJP_RecogToInvoicePolicy().equals("DD")) {
            int C_Invoice_ID = this.getC_Invoice_ID();
            MInvoice invoice = new MInvoice(Env.getCtx(), C_Invoice_ID, this.get_TrxName());
            if (invoice.getDocStatus().equals("CO")) {
                if (accrual) {
                    invoice.processIt("RA");
                } else if (!accrual) {
                    invoice.processIt("RC");
                }
            } else if (!invoice.getDocStatus().equals("CO")) {
                invoice.processIt("VO");
            } else if (MPeriod.isOpen((Properties)Env.getCtx(), (Timestamp)invoice.getDateAcct(), (String)invoice.getC_DocType().getDocBaseType(), (int)invoice.getAD_Org_ID())) {
                invoice.processIt("RC");
            } else {
                invoice.processIt("RA");
            }
            invoice.saveEx(this.get_TrxName());
        }
        return reversal;
    }

    public boolean reverseAccrualIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.toString());
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 6);
        if (this.m_processMsg != null) {
            return false;
        }
        MRecognition reversal = this.reverse(true);
        if (reversal == null) {
            return false;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 14);
        if (this.m_processMsg != null) {
            return false;
        }
        this.m_processMsg = reversal.getDocumentNo();
        return true;
    }

    public boolean reActivateIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.toString());
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 4);
        if (this.m_processMsg != null) {
            return false;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 12);
        if (this.m_processMsg != null) {
            return false;
        }
        return false;
    }

    public String getSummary() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getDocumentNo());
        sb.append(": ").append(Msg.translate((Properties)this.getCtx(), (String)"GrandTotal")).append("=").append(this.getGrandTotal()).append(" (#").append(this.getLines(false).length).append(")");
        if (this.getDescription() != null && this.getDescription().length() > 0) {
            sb.append(" - ").append(this.getDescription());
        }
        return sb.toString();
    }

    public String getProcessMsg() {
        return this.m_processMsg;
    }

    public int getDoc_User_ID() {
        return this.getSalesRep_ID();
    }

    public BigDecimal getApprovalAmt() {
        return this.getGrandTotal();
    }

    public void setRMA(MRMA rma) {
        this.setM_RMA_ID(rma.getM_RMA_ID());
        this.setAD_Org_ID(rma.getAD_Org_ID());
        this.setDescription(rma.getDescription());
        this.setC_BPartner_ID(rma.getC_BPartner_ID());
        this.setSalesRep_ID(rma.getSalesRep_ID());
        this.setGrandTotal(rma.getAmt());
        this.setIsSOTrx(rma.isSOTrx());
        this.setTotalLines(rma.getAmt());
    }

    public boolean isComplete() {
        String ds = this.getDocStatus();
        return "CO".equals(ds) || "CL".equals(ds) || "RE".equals(ds);
    }

    public void setProcessMessage(String processMsg) {
        this.m_processMsg = processMsg;
    }

    public MTaxProvider[] getTaxProviders() {
        MRecognitionLine[] lines;
        Hashtable<Integer, MTaxProvider> providers = new Hashtable<Integer, MTaxProvider>();
        MRecognitionLine[] mRecognitionLineArray = lines = this.getLines();
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            MRecognitionLine line = mRecognitionLineArray[n2];
            MTax tax = new MTax(line.getCtx(), line.getC_Tax_ID(), line.get_TrxName());
            MTaxProvider provider = (MTaxProvider)providers.get(tax.getC_TaxProvider_ID());
            if (provider == null) {
                providers.put(tax.getC_TaxProvider_ID(), new MTaxProvider(tax.getCtx(), tax.getC_TaxProvider_ID(), tax.get_TrxName()));
            }
            ++n2;
        }
        MTaxProvider[] retValue = new MTaxProvider[providers.size()];
        providers.values().toArray(retValue);
        return retValue;
    }

    public int getDocTypeID() {
        return this.getC_DocType_ID() > 0 ? this.getC_DocType_ID() : this.getC_DocTypeTarget_ID();
    }

    public static MRecognition[] getRecognitionsByInOut(Properties ctx, int M_InOut_ID, boolean isReversal, int original_InOut_ID, String trxName) {
        ArrayList<MRecognition> list;
        block8: {
            list = new ArrayList<MRecognition>();
            String sql = "SELECT * FROM JP_Recognition WHERE M_InOut_ID=? AND DocStatus NOT IN ('VO','RE','CL')";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)"SELECT * FROM JP_Recognition WHERE M_InOut_ID=? AND DocStatus NOT IN ('VO','RE','CL')", (String)trxName);
                    if (isReversal) {
                        pstmt.setInt(1, original_InOut_ID);
                    } else {
                        pstmt.setInt(1, M_InOut_ID);
                    }
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        list.add(new MRecognition(ctx, rs, trxName));
                    }
                }
                catch (Exception exception) {
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block8;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        MRecognition[] recogs = new MRecognition[list.size()];
        list.toArray(recogs);
        return recogs;
    }

    public int customizeValidActions(String docStatus, Object processing, String orderType, String isSOTrx, int AD_Table_ID, String[] docAction, String[] options, int index) {
        if (docStatus.equals("CO")) {
            index = 0;
            options[index++] = "CL";
            options[index++] = "RA";
            options[index++] = "RC";
            return index;
        }
        if (docStatus.equals("DR")) {
            index = 0;
            options[index++] = "PR";
            options[index++] = "VO";
            options[index++] = "CO";
            return index;
        }
        return index;
    }

    private void splitRecognition(MRecognitionLine[] lines) {
        MRecognition split = new MRecognition(this.getCtx(), 0, this.get_TrxName());
        PO.copyValues((PO)this, (PO)split);
        split.setAD_Org_ID(this.getAD_Org_ID());
        split.setDocumentNo(null);
        split.setJP_Recognition_SplitFrom_ID(this.getJP_Recognition_ID());
        split.setReversal_ID(0);
        split.setJP_Contract_ID(this.getJP_Contract_ID());
        split.setJP_ContractContent_ID(this.getJP_ContractContent_ID());
        split.setJP_ContractProcPeriod_ID(this.getJP_ContractProcPeriod_ID());
        split.setDocStatus("DR");
        split.setDocAction("CO");
        split.setTotalLines(Env.ZERO);
        split.setGrandTotal(Env.ZERO);
        split.saveEx();
        this.setJP_Recognition_SplitTo_ID(split.getJP_Recognition_ID());
        int i = 0;
        while (i < lines.length) {
            BigDecimal differenceQty;
            MRecognitionLine line = lines[i];
            if (line.getJP_TargetQtyRecognized().compareTo(Env.ZERO) != 0 && (differenceQty = line.getJP_TargetQtyRecognized().subtract(line.getJP_QtyRecognized())).compareTo(Env.ZERO) != 0) {
                MRecognitionLine splitLine = new MRecognitionLine(this.getCtx(), 0, this.get_TrxName());
                PO.copyValues((PO)line, (PO)splitLine);
                splitLine.setJP_Recognition_ID(split.getJP_Recognition_ID());
                splitLine.setAD_Org_ID(line.getAD_Org_ID());
                splitLine.setC_OrderLine_ID(line.getC_OrderLine_ID());
                splitLine.setM_RMALine_ID(line.getM_RMALine_ID());
                splitLine.setM_InOutLine_ID(line.getM_InOutLine_ID());
                splitLine.setLine(line.getLine());
                splitLine.setQty(differenceQty);
                splitLine.setJP_RecogLine_SplitFrom_ID(line.getJP_RecognitionLine_ID());
                splitLine.saveEx();
            }
            ++i;
        }
    }

    private boolean createInvoiceFromRecog() {
        MInOut io = new MInOut(this.getCtx(), this.getM_InOut_ID(), this.get_TrxName());
        int io_DocType_ID = io.getC_DocType_ID();
        MDocType io_DocType = MDocType.get((Properties)this.getCtx(), (int)io_DocType_ID);
        if (io_DocType.get_ValueAsBoolean("IsCreateInvoiceJP")) {
            String msg;
            this.m_processMsg = msg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"JP_DocTypeForShipmentOfBaseDocDocType")) + "  " + Msg.getElement((Properties)this.getCtx(), (String)"DocumentNo") + " : " + this.getDocumentNo();
            return false;
        }
        MInvoice invoice = new MInvoice(this.getCtx(), 0, this.get_TrxName());
        MOrder order = new MOrder(this.getCtx(), this.getC_Order_ID(), this.get_TrxName());
        PO.copyValues((PO)this, (PO)invoice);
        invoice.setC_Invoice_ID(0);
        if (this.getBill_BPartner_ID() > 0) {
            invoice.setC_BPartner_ID(this.getBill_BPartner_ID());
            invoice.setC_BPartner_Location_ID(this.getBill_Location_ID());
            invoice.setAD_User_ID(this.getBill_User_ID());
        }
        invoice.setC_DocTypeTarget_ID(order.getC_DocType().getC_DocTypeInvoice_ID());
        invoice.setAD_Org_ID(this.getAD_Org_ID());
        invoice.setDocumentNo(null);
        invoice.setTotalLines(Env.ZERO);
        invoice.setGrandTotal(Env.ZERO);
        invoice.setDocStatus("DR");
        invoice.setDocAction("CO");
        invoice.set_ValueNoCheck("JP_Recognition_ID", (Object)this.getJP_Recognition_ID());
        invoice.saveEx(this.get_TrxName());
        this.setC_Invoice_ID(invoice.getC_Invoice_ID());
        MRecognitionLine[] rLines = this.getLines();
        int i = 0;
        while (i < rLines.length) {
            MInvoiceLine iLine = new MInvoiceLine(this.getCtx(), 0, this.get_TrxName());
            PO.copyValues((PO)rLines[i], (PO)iLine);
            iLine.setC_Invoice_ID(invoice.getC_Invoice_ID());
            iLine.setC_InvoiceLine_ID(0);
            iLine.setAD_Org_ID(this.getAD_Org_ID());
            iLine.set_ValueNoCheck("JP_RecognitionLine_ID", (Object)rLines[i].getJP_RecognitionLine_ID());
            iLine.setM_InOutLine_ID(rLines[i].getM_InOutLine_ID());
            iLine.saveEx(this.get_TrxName());
            rLines[i].setC_InvoiceLine_ID(iLine.getC_InvoiceLine_ID());
            rLines[i].saveEx(this.get_TrxName());
            ++i;
        }
        invoice.processIt("CO");
        if (!invoice.getDocStatus().equals("CO")) {
            invoice.saveEx(this.get_TrxName());
        }
        return true;
    }
}

