/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.model;

import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MDocType;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutConfirm;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.PO;
import org.compiere.process.DocOptions;
import org.compiere.util.DB;
import org.compiere.util.Msg;

public class MInOutConfirmJP
extends MInOutConfirm
implements DocOptions {
    private String m_processMsg = null;

    public MInOutConfirmJP(Properties ctx, int M_InOutConfirm_ID, String trxName) {
        super(ctx, M_InOutConfirm_ID, trxName);
    }

    public MInOutConfirmJP(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MInOutConfirmJP(MInOut ship, String confirmType) {
        super(ship, confirmType);
    }

    public boolean reActivateIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.toString());
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 4);
        if (this.m_processMsg != null) {
            return false;
        }
        if (this.getM_InOut().getDocStatus().equals("CO") || this.getM_InOut().getDocStatus().equals("CL") || this.getM_InOut().getDocStatus().equals("VO") || this.getM_InOut().getDocStatus().equals("RE")) {
            this.setDescription(Msg.getMsg((Properties)this.getCtx(), (String)"JP_CanNotReActivateInOutConfirm"));
            return false;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 12);
        if (this.m_processMsg != null) {
            return false;
        }
        this.setDocAction("CO");
        this.setProcessed(false);
        return true;
    }

    public void setProcessed(boolean processed) {
        super.setProcessed(processed);
        if (this.get_ID() == 0) {
            return;
        }
        String set = "SET Processed='" + (processed ? "Y" : "N") + "' WHERE M_InOutConfirm_ID=" + this.getM_InOutConfirm_ID();
        int noLine = DB.executeUpdateEx((String)("UPDATE M_InOutLineConfirm " + set), (String)this.get_TrxName());
        this.getLines(true);
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("setProcessed - " + processed + " - Lines=" + noLine);
        }
    }

    public int customizeValidActions(String docStatus, Object processing, String orderType, String isSOTrx, int AD_Table_ID, String[] docAction, String[] options, int index) {
        if (docStatus.equals("DR")) {
            index = 0;
            options[index++] = "PR";
            options[index++] = "CO";
            return index;
        }
        if (docStatus.equals("IP")) {
            index = 0;
            options[index++] = "CO";
            return index;
        }
        if (docStatus.equals("CO")) {
            index = 0;
            options[index++] = "CL";
            options[index++] = "RE";
            return index;
        }
        return 0;
    }

    public String completeIt() {
        String docStatus = super.completeIt();
        MInOut io = new MInOut(this.getCtx(), this.getM_InOut_ID(), this.get_TrxName());
        MDocType dt = MDocType.get((Properties)this.getCtx(), (int)io.getC_DocType_ID());
        if (dt.get_ValueAsBoolean("IsInOutCompleteJP") && docStatus.equals("CO")) {
            this.saveEx(this.get_TrxName());
            String cf = this.getConfirmType();
            if (cf.equals("SC")) {
                if (dt.getDocBaseType().equals("MMS")) {
                    io.setShipDate(new Timestamp(Calendar.getInstance().getTimeInMillis()));
                } else if (dt.getDocBaseType().equals("MMR")) {
                    io.setDateReceived(new Timestamp(Calendar.getInstance().getTimeInMillis()));
                }
            } else if (cf.equals("PC") && io.isSOTrx() && dt.getDocBaseType().equals("MMS")) {
                io.setPickDate(new Timestamp(Calendar.getInstance().getTimeInMillis()));
            }
            boolean isOK = io.processIt("CO");
            if (isOK) {
                io.saveEx(this.get_TrxName());
            }
        }
        return docStatus;
    }
}

