/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.model;

import java.sql.ResultSet;
import java.sql.Statement;
import java.time.Duration;
import java.util.Properties;
import java.util.logging.Level;
import jpiere.base.plugin.org.adempiere.model.X_JP_ContractProcPeriod;
import org.compiere.util.CCache;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Msg;

public class MContractProcPeriod
extends X_JP_ContractProcPeriod {
    private static CCache<Integer, MContractProcPeriod> s_cache = new CCache("JP_ContractProcPeriod", 20);

    public MContractProcPeriod(Properties ctx, int JP_ContractProcPeriod_ID, String trxName) {
        super(ctx, JP_ContractProcPeriod_ID, trxName);
    }

    public MContractProcPeriod(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public static MContractProcPeriod get(Properties ctx, int JP_ContractProcPeriod_ID) {
        Integer ii = JP_ContractProcPeriod_ID;
        MContractProcPeriod retValue = (MContractProcPeriod)s_cache.get((Object)ii);
        if (retValue != null) {
            return retValue;
        }
        retValue = new MContractProcPeriod(ctx, JP_ContractProcPeriod_ID, null);
        if (retValue.get_ID() != 0) {
            s_cache.put((Object)JP_ContractProcPeriod_ID, (Object)retValue);
        }
        return retValue;
    }

    protected boolean beforeSave(boolean newRecord) {
        if (newRecord || this.is_ValueChanged("StartDate") || this.is_ValueChanged("EndDate")) {
            boolean isUnique;
            block10: {
                isUnique = true;
                String sql = "SELECT JP_ContractProcPeriod_ID FROM JP_ContractProcPeriod WHERE StartDate <= ? AND EndDate >=? AND JP_ContractCalender_ID=? ";
                CPreparedStatement pstmt = null;
                ResultSet rs = null;
                try {
                    try {
                        pstmt = DB.prepareStatement((String)"SELECT JP_ContractProcPeriod_ID FROM JP_ContractProcPeriod WHERE StartDate <= ? AND EndDate >=? AND JP_ContractCalender_ID=? ", (String)this.get_TrxName());
                        pstmt.setTimestamp(1, this.getEndDate());
                        pstmt.setTimestamp(2, this.getStartDate());
                        pstmt.setInt(3, this.getJP_ContractCalender_ID());
                        rs = pstmt.executeQuery();
                        while (rs.next()) {
                            int JP_ContractProcPeriod_ID = rs.getInt(1);
                            if (this.getJP_ContractProcPeriod_ID() == JP_ContractProcPeriod_ID) {
                                isUnique = true;
                                continue;
                            }
                            isUnique = false;
                            break;
                        }
                    }
                    catch (Exception e) {
                        this.log.log(Level.SEVERE, "SELECT JP_ContractProcPeriod_ID FROM JP_ContractProcPeriod WHERE StartDate <= ? AND EndDate >=? AND JP_ContractCalender_ID=? ", (Throwable)e);
                        DB.close(rs, (Statement)pstmt);
                        rs = null;
                        pstmt = null;
                        break block10;
                    }
                }
                catch (Throwable throwable) {
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    throw throwable;
                }
                DB.close((ResultSet)rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
            }
            if (!isUnique) {
                this.log.saveError("Error", Msg.getMsg((Properties)this.getCtx(), (String)"JP_OverlapPeriod"));
                return false;
            }
        }
        if ((newRecord || this.is_ValueChanged("DateAcct") || this.is_ValueChanged("StartDate") || this.is_ValueChanged("EndDate")) && (this.getStartDate().compareTo(this.getDateAcct()) > 0 || this.getEndDate().compareTo(this.getDateAcct()) < 0)) {
            this.log.saveError("Error", String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"JP_OutsidePperiod")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"DateAcct"));
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        return this.getName();
    }

    public boolean isContainedBaseDocContractProcPeriod(int BaseDoc_ContractProcPeriod_ID) {
        return this.isContainedBaseDocContractProcPeriod(MContractProcPeriod.get(this.getCtx(), BaseDoc_ContractProcPeriod_ID));
    }

    public boolean isContainedBaseDocContractProcPeriod(MContractProcPeriod BaseDoc_ContractProcPeriod) {
        return this.getStartDate().compareTo(BaseDoc_ContractProcPeriod.getStartDate()) >= 0 && this.getEndDate().compareTo(BaseDoc_ContractProcPeriod.getEndDate()) <= 0;
    }

    public long getContractProcPeriodDays() {
        return Duration.between(this.getStartDate().toLocalDateTime(), this.getEndDate().toLocalDateTime()).toDays() + 1L;
    }
}

