/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.model;

import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import jpiere.base.plugin.org.adempiere.model.MContractCalender;
import jpiere.base.plugin.org.adempiere.model.MContractContent;
import jpiere.base.plugin.org.adempiere.model.MContractProcPeriod;
import jpiere.base.plugin.org.adempiere.model.MRecognitionLine;
import jpiere.base.plugin.org.adempiere.model.X_JP_ContractLine;
import org.adempiere.base.IProductPricing;
import org.adempiere.exceptions.ProductNotOnPriceListException;
import org.compiere.model.MInOutLine;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MOrderLine;
import org.compiere.model.MProductPricing;
import org.compiere.model.MRole;
import org.compiere.util.CCache;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;

public class MContractLine
extends X_JP_ContractLine {
    protected MContractContent m_parent = null;
    protected Integer m_precision = null;
    protected int m_M_PriceList_ID = 0;
    protected boolean m_IsSOTrx = true;
    protected MProductPricing m_productPrice = null;
    protected Timestamp m_DateDoc = null;
    private static CCache<Integer, MContractLine> s_cache = new CCache("JP_ContractLine", 20);

    public MContractLine(Properties ctx, int JP_ContractLine_ID, String trxName) {
        super(ctx, JP_ContractLine_ID, trxName);
    }

    public MContractLine(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public static MContractLine get(Properties ctx, int JP_ContractLine_ID) {
        Integer ii = JP_ContractLine_ID;
        MContractLine retValue = (MContractLine)s_cache.get((Object)ii);
        if (retValue != null) {
            return retValue;
        }
        retValue = new MContractLine(ctx, JP_ContractLine_ID, null);
        if (retValue.get_ID() != 0) {
            s_cache.put((Object)JP_ContractLine_ID, (Object)retValue);
        }
        return retValue;
    }

    public MContractContent getParent() {
        if (this.m_parent == null) {
            this.m_parent = new MContractContent(this.getCtx(), this.getJP_ContractContent_ID(), this.get_TrxName());
        }
        return this.m_parent;
    }

    protected boolean beforeSave(boolean newRecord) {
        if (this.getParent().getParent().getJP_ContractType().equals("PDC") && (newRecord || this.is_ValueChanged("M_Product_ID") || this.is_ValueChanged("C_Charge_ID") || this.is_ValueChanged("IsCreateDocLineJP") || this.is_ValueChanged("QtyEntered") || this.is_ValueChanged("C_UOM_ID") || this.is_ValueChanged("QtyOrdered") || this.is_ValueChanged("MovementQty") || this.is_ValueChanged("QtyInvoiced") || this.is_ValueChanged("JP_BaseDocLinePolicy") || this.is_ValueChanged("JP_ProcPeriod_Lump_Date") || this.is_ValueChanged("JP_ProcPeriod_Lump_ID") || this.is_ValueChanged("JP_ProcPeriod_Start_Date") || this.is_ValueChanged("JP_ProcPeriod_Start_ID") || this.is_ValueChanged("JP_ProcPeriod_End_Date") || this.is_ValueChanged("JP_ProcPeriod_End_ID") || this.is_ValueChanged("JP_DerivativeDocPolicy_InOut") || this.is_ValueChanged("JP_DerivativeDocPolicy_Inv") || this.is_ValueChanged("JP_ContractCalender_InOut_ID") || this.is_ValueChanged("JP_ContractCalender_Inv_ID") || this.is_ValueChanged("JP_ProcPeriod_Lump_InOut_Date") || this.is_ValueChanged("JP_ProcPeriod_Lump_InOut_ID") || this.is_ValueChanged("JP_ProcPeriod_Start_InOut_Date") || this.is_ValueChanged("JP_ProcPeriod_Start_InOut_ID") || this.is_ValueChanged("JP_ProcPeriod_End_InOut_Date") || this.is_ValueChanged("JP_ProcPeriod_End_InOut_ID") || this.is_ValueChanged("JP_ProcPeriod_Lump_Inv_Date") || this.is_ValueChanged("JP_ProcPeriod_Lump_Inv_ID") || this.is_ValueChanged("JP_ProcPeriod_Start_Inv_Date") || this.is_ValueChanged("JP_ProcPeriod_Start_Inv_ID") || this.is_ValueChanged("JP_ProcPeriod_End_Inv_Date") || this.is_ValueChanged("JP_ProcPeriod_End_Inv_ID") || this.is_ValueChanged("JP_ContractProcess_InOut_ID") || this.is_ValueChanged("JP_ContractProcess_Inv_ID"))) {
            if (!this.getParent().getJP_ContractProcStatus().equals("UN")) {
                StringBuilder msg = new StringBuilder(Msg.getMsg((Properties)this.getCtx(), (String)"JP_ContractLineUpdate_PeriodContract"));
                if (this.is_ValueChanged("M_Product_ID")) {
                    msg = msg.append(" ").append(Msg.getElement((Properties)this.getCtx(), (String)"M_Product_ID"));
                } else if (this.is_ValueChanged("C_Charge_ID")) {
                    msg = msg.append(" ").append(Msg.getElement((Properties)this.getCtx(), (String)"C_Charge_ID"));
                } else if (this.is_ValueChanged("IsCreateDocLineJP")) {
                    msg = msg.append(" ").append(Msg.getElement((Properties)this.getCtx(), (String)"IsCreateDocLineJP"));
                } else if (this.is_ValueChanged("QtyEntered")) {
                    msg = msg.append(" ").append(Msg.getElement((Properties)this.getCtx(), (String)"QtyEntered"));
                } else if (this.is_ValueChanged("C_UOM_ID")) {
                    msg = msg.append(" ").append(Msg.getElement((Properties)this.getCtx(), (String)"C_UOM_ID"));
                } else if (this.is_ValueChanged("QtyOrdered")) {
                    msg = msg.append(" ").append(Msg.getElement((Properties)this.getCtx(), (String)"QtyOrdered"));
                } else if (this.is_ValueChanged("MovementQty")) {
                    msg = msg.append(" ").append(Msg.getElement((Properties)this.getCtx(), (String)"MovementQty"));
                } else if (this.is_ValueChanged("QtyInvoiced")) {
                    msg = msg.append(" ").append(Msg.getElement((Properties)this.getCtx(), (String)"QtyInvoiced"));
                } else if (this.is_ValueChanged("JP_BaseDocLinePolicy")) {
                    msg = msg.append(" ").append(Msg.getElement((Properties)this.getCtx(), (String)"JP_BaseDocLinePolicy"));
                } else if (this.is_ValueChanged("JP_ProcPeriod_Lump_Date")) {
                    msg = msg.append(" ").append(Msg.getElement((Properties)this.getCtx(), (String)"JP_ProcPeriod_Lump_Date"));
                } else if (this.is_ValueChanged("JP_ProcPeriod_Lump_ID")) {
                    msg = msg.append(" ").append(Msg.getElement((Properties)this.getCtx(), (String)"JP_ProcPeriod_Lump_ID"));
                } else if (this.is_ValueChanged("JP_ProcPeriod_Start_Date")) {
                    msg = msg.append(" ").append(Msg.getElement((Properties)this.getCtx(), (String)"JP_ProcPeriod_Start_Date"));
                } else if (this.is_ValueChanged("JP_ProcPeriod_Start_ID")) {
                    msg = msg.append(" ").append(Msg.getElement((Properties)this.getCtx(), (String)"JP_ProcPeriod_Start_ID"));
                } else if (this.is_ValueChanged("JP_ProcPeriod_End_Date")) {
                    msg = msg.append(" ").append(Msg.getElement((Properties)this.getCtx(), (String)"JP_ProcPeriod_End_Date"));
                } else if (this.is_ValueChanged("JP_ProcPeriod_End_ID")) {
                    msg = msg.append(" ").append(Msg.getElement((Properties)this.getCtx(), (String)"JP_ProcPeriod_End_ID"));
                } else if (this.is_ValueChanged("JP_DerivativeDocPolicy_InOut")) {
                    msg = msg.append(" ").append(Msg.getElement((Properties)this.getCtx(), (String)"JP_DerivativeDocPolicy_InOut"));
                } else if (this.is_ValueChanged("JP_DerivativeDocPolicy_Inv")) {
                    msg = msg.append(" ").append(Msg.getElement((Properties)this.getCtx(), (String)"JP_DerivativeDocPolicy_Inv"));
                } else if (this.is_ValueChanged("JP_ContractCalender_InOut_ID")) {
                    msg = msg.append(" ").append(Msg.getElement((Properties)this.getCtx(), (String)"JP_ContractCalender_InOut_ID"));
                } else if (this.is_ValueChanged("JP_ContractCalender_Inv_ID")) {
                    msg = msg.append(" ").append(Msg.getElement((Properties)this.getCtx(), (String)"JP_ContractCalender_Inv_ID"));
                } else if (this.is_ValueChanged("JP_ProcPeriod_Lump_InOut_Date")) {
                    msg = msg.append(" ").append(Msg.getElement((Properties)this.getCtx(), (String)"JP_ProcPeriod_Lump_InOut_Date"));
                } else if (this.is_ValueChanged("JP_ProcPeriod_Lump_InOut_ID")) {
                    msg = msg.append(" ").append(Msg.getElement((Properties)this.getCtx(), (String)"JP_ProcPeriod_Lump_InOut_ID"));
                } else if (this.is_ValueChanged("JP_ProcPeriod_Start_InOut_Date")) {
                    msg = msg.append(" ").append(Msg.getElement((Properties)this.getCtx(), (String)"JP_ProcPeriod_Start_InOut_Date"));
                } else if (this.is_ValueChanged("JP_ProcPeriod_Start_InOut_ID")) {
                    msg = msg.append(" ").append(Msg.getElement((Properties)this.getCtx(), (String)"JP_ProcPeriod_Start_InOut_ID"));
                } else if (this.is_ValueChanged("JP_ProcPeriod_End_InOut_Date")) {
                    msg = msg.append(" ").append(Msg.getElement((Properties)this.getCtx(), (String)"JP_ProcPeriod_End_InOut_Date"));
                } else if (this.is_ValueChanged("JP_ProcPeriod_End_InOut_ID")) {
                    msg = msg.append(" ").append(Msg.getElement((Properties)this.getCtx(), (String)"JP_ProcPeriod_End_InOut_ID"));
                } else if (this.is_ValueChanged("JP_ProcPeriod_Lump_Inv_Date")) {
                    msg = msg.append(" ").append(Msg.getElement((Properties)this.getCtx(), (String)"JP_ProcPeriod_Lump_Inv_Date"));
                } else if (this.is_ValueChanged("JP_ProcPeriod_Lump_Inv_ID")) {
                    msg = msg.append(" ").append(Msg.getElement((Properties)this.getCtx(), (String)"JP_ProcPeriod_Lump_Inv_ID"));
                } else if (this.is_ValueChanged("JP_ProcPeriod_Start_Inv_Date")) {
                    msg = msg.append(" ").append(Msg.getElement((Properties)this.getCtx(), (String)"JP_ProcPeriod_Start_Inv_Date"));
                } else if (this.is_ValueChanged("JP_ProcPeriod_Start_Inv_ID")) {
                    msg = msg.append(" ").append(Msg.getElement((Properties)this.getCtx(), (String)"JP_ProcPeriod_Start_Inv_ID"));
                } else if (this.is_ValueChanged("JP_ProcPeriod_End_Inv_Date")) {
                    msg = msg.append(" ").append(Msg.getElement((Properties)this.getCtx(), (String)"JP_ProcPeriod_End_Inv_Date"));
                } else if (this.is_ValueChanged("JP_ProcPeriod_End_Inv_ID")) {
                    msg = msg.append(" ").append(Msg.getElement((Properties)this.getCtx(), (String)"JP_ProcPeriod_End_Inv_ID"));
                } else if (this.is_ValueChanged("JP_ContractProcess_InOut_ID")) {
                    msg = msg.append(" ").append(Msg.getElement((Properties)this.getCtx(), (String)"JP_ContractProcess_InOut_ID"));
                } else if (this.is_ValueChanged("JP_ContractProcess_Inv_ID")) {
                    msg = msg.append(" ").append(Msg.getElement((Properties)this.getCtx(), (String)"JP_ContractProcess_Inv_ID"));
                }
                this.log.saveError("Error", msg.toString());
                return false;
            }
            if (!this.checkPeriodContractInfo(newRecord)) {
                return false;
            }
        }
        if (this.getParent().getParent().getJP_ContractType().equals("STC")) {
            this.setNullCreateBaseDocLineInfo();
            this.setNullCreateDerivativeInOutInfo();
            this.setNullCreateDerivativeInvoiceInfo();
        }
        if (this.getC_BPartner_ID() == 0 || this.getC_BPartner_Location_ID() == 0) {
            this.setContentInfo();
        }
        if (this.m_M_PriceList_ID == 0) {
            this.setHeaderInfo();
        }
        if (this.getC_Charge_ID() != 0 && this.getM_Product_ID() != 0) {
            this.setM_Product_ID(0);
        }
        if (this.getM_Product_ID() == 0) {
            this.setM_AttributeSetInstance_ID(0);
        } else {
            boolean enforce;
            if (this.m_productPrice == null && Env.ZERO.compareTo(this.getPriceActual()) == 0 && Env.ZERO.compareTo(this.getPriceList()) == 0) {
                this.setPrice();
            }
            if (this.m_productPrice == null) {
                this.getProductPricing(this.m_M_PriceList_ID);
            }
            boolean bl = enforce = this.m_IsSOTrx && this.getParent().getM_PriceList().isEnforcePriceLimit();
            if (enforce && MRole.getDefault().isOverwritePriceLimit()) {
                enforce = false;
            }
            if (enforce && this.getPriceLimit() != Env.ZERO && this.getPriceActual().compareTo(this.getPriceLimit()) < 0) {
                this.log.saveError("UnderLimitPrice", "PriceEntered=" + this.getPriceEntered() + ", PriceLimit=" + this.getPriceLimit());
                return false;
            }
            if (!this.m_productPrice.isCalculated()) {
                throw new ProductNotOnPriceListException((IProductPricing)this.m_productPrice, this.getLine());
            }
        }
        if (this.getJP_CounterContractLine_ID() > 0 && (newRecord || this.is_ValueChanged("JP_CounterContractLine_ID"))) {
            MContractLine counterContractLine = new MContractLine(this.getCtx(), this.getJP_CounterContractLine_ID(), this.get_TrxName());
            if (this.getM_Product_ID() != counterContractLine.getM_Product_ID()) {
                String msg0 = String.valueOf(Msg.getElement((Properties)Env.getCtx(), (String)"JP_CounterContractLine_ID")) + " - " + Msg.getElement((Properties)Env.getCtx(), (String)"M_Product_ID");
                String msg1 = String.valueOf(Msg.getElement((Properties)Env.getCtx(), (String)"JP_ContractLine_ID")) + " - " + Msg.getElement((Properties)Env.getCtx(), (String)"M_Product_ID");
                this.log.saveError("Error", Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Different", (Object[])new Object[]{msg0, msg1}));
                return false;
            }
            if (this.getC_Charge_ID() != counterContractLine.getC_Charge_ID()) {
                String msg0 = String.valueOf(Msg.getElement((Properties)Env.getCtx(), (String)"JP_CounterContractLine_ID")) + " - " + Msg.getElement((Properties)Env.getCtx(), (String)"C_Charge_ID");
                String msg1 = String.valueOf(Msg.getElement((Properties)Env.getCtx(), (String)"JP_ContractLine_ID")) + " - " + Msg.getElement((Properties)Env.getCtx(), (String)"C_Charge_ID");
                this.log.saveError("Error", Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Different", (Object[])new Object[]{msg0, msg1}));
                return false;
            }
            if (this.getQtyEntered() != null && !this.getQtyEntered().equals(counterContractLine.getQtyEntered())) {
                String msg0 = String.valueOf(Msg.getElement((Properties)Env.getCtx(), (String)"JP_CounterContractLine_ID")) + " - " + Msg.getElement((Properties)Env.getCtx(), (String)"QtyEntered");
                String msg1 = String.valueOf(Msg.getElement((Properties)Env.getCtx(), (String)"JP_ContractLine_ID")) + " - " + Msg.getElement((Properties)Env.getCtx(), (String)"QtyEntered");
                this.log.saveError("Error", Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Different", (Object[])new Object[]{msg0, msg1}));
                return false;
            }
            if (this.getC_UOM_ID() != counterContractLine.getC_UOM_ID()) {
                String msg0 = String.valueOf(Msg.getElement((Properties)Env.getCtx(), (String)"JP_CounterContractLine_ID")) + " - " + Msg.getElement((Properties)Env.getCtx(), (String)"C_UOM_ID");
                String msg1 = String.valueOf(Msg.getElement((Properties)Env.getCtx(), (String)"JP_ContractLine_ID")) + " - " + Msg.getElement((Properties)Env.getCtx(), (String)"C_UOM_ID");
                this.log.saveError("Error", Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Different", (Object[])new Object[]{msg0, msg1}));
                return false;
            }
            if (this.getJP_DerivativeDocPolicy_InOut() != null && !this.getJP_DerivativeDocPolicy_InOut().equals(counterContractLine.getJP_DerivativeDocPolicy_InOut())) {
                String msg0 = String.valueOf(Msg.getElement((Properties)Env.getCtx(), (String)"JP_CounterContractLine_ID")) + " - " + Msg.getElement((Properties)Env.getCtx(), (String)"JP_DerivativeDocPolicy_InOut");
                String msg1 = String.valueOf(Msg.getElement((Properties)Env.getCtx(), (String)"JP_ContractLine_ID")) + " - " + Msg.getElement((Properties)Env.getCtx(), (String)"JP_DerivativeDocPolicy_InOut");
                this.log.saveError("Error", Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Different", (Object[])new Object[]{msg0, msg1}));
                return false;
            }
            if (this.getJP_ContractCalender_InOut_ID() != counterContractLine.getJP_ContractCalender_InOut_ID()) {
                String msg0 = String.valueOf(Msg.getElement((Properties)Env.getCtx(), (String)"JP_CounterContractLine_ID")) + " - " + Msg.getElement((Properties)Env.getCtx(), (String)"JP_ContractCalender_InOut_ID");
                String msg1 = String.valueOf(Msg.getElement((Properties)Env.getCtx(), (String)"JP_ContractLine_ID")) + " - " + Msg.getElement((Properties)Env.getCtx(), (String)"JP_ContractCalender_InOut_ID");
                this.log.saveError("Error", Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Different", (Object[])new Object[]{msg0, msg1}));
                return false;
            }
            if (this.getJP_ProcPeriod_Lump_InOut_ID() != counterContractLine.getJP_ProcPeriod_Lump_InOut_ID()) {
                String msg0 = String.valueOf(Msg.getElement((Properties)Env.getCtx(), (String)"JP_CounterContractLine_ID")) + " - " + Msg.getElement((Properties)Env.getCtx(), (String)"JP_ProcPeriod_Lump_InOut_ID");
                String msg1 = String.valueOf(Msg.getElement((Properties)Env.getCtx(), (String)"JP_ContractLine_ID")) + " - " + Msg.getElement((Properties)Env.getCtx(), (String)"JP_ProcPeriod_Lump_InOut_ID");
                this.log.saveError("Error", Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Different", (Object[])new Object[]{msg0, msg1}));
                return false;
            }
            if (this.getJP_ProcPeriod_Start_InOut_ID() != counterContractLine.getJP_ProcPeriod_Start_InOut_ID()) {
                String msg0 = String.valueOf(Msg.getElement((Properties)Env.getCtx(), (String)"JP_CounterContractLine_ID")) + " - " + Msg.getElement((Properties)Env.getCtx(), (String)"JP_ProcPeriod_Start_InOut_ID");
                String msg1 = String.valueOf(Msg.getElement((Properties)Env.getCtx(), (String)"JP_ContractLine_ID")) + " - " + Msg.getElement((Properties)Env.getCtx(), (String)"JP_ProcPeriod_Start_InOut_ID");
                this.log.saveError("Error", Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Different", (Object[])new Object[]{msg0, msg1}));
                return false;
            }
            if (this.getJP_ProcPeriod_End_InOut_ID() != counterContractLine.getJP_ProcPeriod_End_InOut_ID()) {
                String msg0 = String.valueOf(Msg.getElement((Properties)Env.getCtx(), (String)"JP_CounterContractLine_ID")) + " - " + Msg.getElement((Properties)Env.getCtx(), (String)"JP_ProcPeriod_End_InOut_ID");
                String msg1 = String.valueOf(Msg.getElement((Properties)Env.getCtx(), (String)"JP_ContractLine_ID")) + " - " + Msg.getElement((Properties)Env.getCtx(), (String)"JP_ProcPeriod_End_InOut_ID");
                this.log.saveError("Error", Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Different", (Object[])new Object[]{msg0, msg1}));
                return false;
            }
            if (this.getMovementQty() != null && !this.getMovementQty().equals(counterContractLine.getMovementQty())) {
                String msg0 = String.valueOf(Msg.getElement((Properties)Env.getCtx(), (String)"JP_CounterContractLine_ID")) + " - " + Msg.getElement((Properties)Env.getCtx(), (String)"MovementQty");
                String msg1 = String.valueOf(Msg.getElement((Properties)Env.getCtx(), (String)"JP_ContractLine_ID")) + " - " + Msg.getElement((Properties)Env.getCtx(), (String)"MovementQty");
                this.log.saveError("Error", Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Different", (Object[])new Object[]{msg0, msg1}));
                return false;
            }
            if (this.getJP_DerivativeDocPolicy_Inv() != null && !this.getJP_DerivativeDocPolicy_Inv().equals(counterContractLine.getJP_DerivativeDocPolicy_Inv())) {
                String msg0 = String.valueOf(Msg.getElement((Properties)Env.getCtx(), (String)"JP_CounterContractLine_ID")) + " - " + Msg.getElement((Properties)Env.getCtx(), (String)"JP_DerivativeDocPolicy_Inv");
                String msg1 = String.valueOf(Msg.getElement((Properties)Env.getCtx(), (String)"JP_ContractLine_ID")) + " - " + Msg.getElement((Properties)Env.getCtx(), (String)"JP_DerivativeDocPolicy_Inv");
                this.log.saveError("Error", Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Different", (Object[])new Object[]{msg0, msg1}));
                return false;
            }
            if (this.getJP_ContractCalender_Inv_ID() != counterContractLine.getJP_ContractCalender_Inv_ID()) {
                String msg0 = String.valueOf(Msg.getElement((Properties)Env.getCtx(), (String)"JP_CounterContractLine_ID")) + " - " + Msg.getElement((Properties)Env.getCtx(), (String)"JP_ContractCalender_Inv_ID");
                String msg1 = String.valueOf(Msg.getElement((Properties)Env.getCtx(), (String)"JP_ContractLine_ID")) + " - " + Msg.getElement((Properties)Env.getCtx(), (String)"JP_ContractCalender_Inv_ID");
                this.log.saveError("Error", Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Different", (Object[])new Object[]{msg0, msg1}));
                return false;
            }
            if (this.getJP_ProcPeriod_Lump_Inv_ID() != counterContractLine.getJP_ProcPeriod_Lump_Inv_ID()) {
                String msg0 = String.valueOf(Msg.getElement((Properties)Env.getCtx(), (String)"JP_CounterContractLine_ID")) + " - " + Msg.getElement((Properties)Env.getCtx(), (String)"JP_ProcPeriod_Lump_Inv_ID");
                String msg1 = String.valueOf(Msg.getElement((Properties)Env.getCtx(), (String)"JP_ContractLine_ID")) + " - " + Msg.getElement((Properties)Env.getCtx(), (String)"JP_ProcPeriod_Lump_Inv_ID");
                this.log.saveError("Error", Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Different", (Object[])new Object[]{msg0, msg1}));
                return false;
            }
            if (this.getJP_ProcPeriod_Start_Inv_ID() != counterContractLine.getJP_ProcPeriod_Start_Inv_ID()) {
                String msg0 = String.valueOf(Msg.getElement((Properties)Env.getCtx(), (String)"JP_CounterContractLine_ID")) + " - " + Msg.getElement((Properties)Env.getCtx(), (String)"JP_ProcPeriod_Start_Inv_ID");
                String msg1 = String.valueOf(Msg.getElement((Properties)Env.getCtx(), (String)"JP_ContractLine_ID")) + " - " + Msg.getElement((Properties)Env.getCtx(), (String)"JP_ProcPeriod_Start_Inv_ID");
                this.log.saveError("Error", Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Different", (Object[])new Object[]{msg0, msg1}));
                return false;
            }
            if (this.getJP_ProcPeriod_End_Inv_ID() != counterContractLine.getJP_ProcPeriod_End_Inv_ID()) {
                String msg0 = String.valueOf(Msg.getElement((Properties)Env.getCtx(), (String)"JP_CounterContractLine_ID")) + " - " + Msg.getElement((Properties)Env.getCtx(), (String)"JP_ProcPeriod_End_Inv_ID");
                String msg1 = String.valueOf(Msg.getElement((Properties)Env.getCtx(), (String)"JP_ContractLine_ID")) + " - " + Msg.getElement((Properties)Env.getCtx(), (String)"JP_ProcPeriod_End_Inv_ID");
                this.log.saveError("Error", Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Different", (Object[])new Object[]{msg0, msg1}));
                return false;
            }
            if (this.getQtyInvoiced() != null && !this.getQtyInvoiced().equals(counterContractLine.getQtyInvoiced())) {
                String msg0 = String.valueOf(Msg.getElement((Properties)Env.getCtx(), (String)"JP_CounterContractLine_ID")) + " - " + Msg.getElement((Properties)Env.getCtx(), (String)"QtyInvoiced");
                String msg1 = String.valueOf(Msg.getElement((Properties)Env.getCtx(), (String)"JP_ContractLine_ID")) + " - " + Msg.getElement((Properties)Env.getCtx(), (String)"QtyInvoiced");
                this.log.saveError("Error", Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Different", (Object[])new Object[]{msg0, msg1}));
                return false;
            }
        }
        return true;
    }

    public void setContentInfo() {
        this.m_parent = this.getParent();
        this.setC_BPartner_ID(this.m_parent.getC_BPartner_ID());
        this.setC_BPartner_Location_ID(this.m_parent.getC_BPartner_Location_ID());
        this.setDateOrdered(this.m_parent.getDateOrdered());
        this.setDatePromised(this.m_parent.getDatePromised());
        this.setHeaderInfo();
    }

    public void setHeaderInfo() {
        this.m_parent = this.getParent();
        this.m_precision = this.m_parent.getPrecision();
        this.m_M_PriceList_ID = this.m_parent.getM_PriceList_ID();
        this.m_IsSOTrx = this.m_parent.isSOTrx();
        this.m_DateDoc = this.m_parent.getDateDoc();
    }

    public void setPrice() {
        if (this.getM_Product_ID() == 0) {
            return;
        }
        if (this.m_M_PriceList_ID == 0) {
            throw new IllegalStateException("PriceList unknown!");
        }
        this.setPrice(this.m_M_PriceList_ID);
    }

    public void setPrice(int M_PriceList_ID) {
        if (this.getM_Product_ID() == 0) {
            return;
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine(String.valueOf(this.toString()) + " - M_PriceList_ID=" + M_PriceList_ID);
        }
        this.getProductPricing(M_PriceList_ID);
        this.setPriceActual(this.m_productPrice.getPriceStd());
        this.setPriceList(this.m_productPrice.getPriceList());
        this.setPriceLimit(this.m_productPrice.getPriceLimit());
        if (this.getQtyEntered().compareTo(this.getQtyOrdered()) == 0) {
            this.setPriceEntered(this.getPriceActual());
        } else {
            this.setPriceEntered(this.getPriceActual().multiply(this.getQtyOrdered().divide(this.getQtyEntered(), 12, RoundingMode.HALF_UP)));
        }
        this.setDiscount(this.m_productPrice.getDiscount());
        this.setC_UOM_ID(this.m_productPrice.getC_UOM_ID());
    }

    protected MProductPricing getProductPricing(int M_PriceList_ID) {
        this.m_productPrice = new MProductPricing(this.getM_Product_ID(), this.getC_BPartner_ID(), this.getQtyOrdered(), this.m_IsSOTrx, this.get_TrxName());
        this.m_productPrice.setM_PriceList_ID(M_PriceList_ID);
        this.m_productPrice.setPriceDate(this.m_DateDoc);
        this.m_productPrice.calculatePrice();
        return this.m_productPrice;
    }

    protected boolean afterSave(boolean newRecord, boolean success) {
        String sql;
        int no;
        if (!success) {
            return success;
        }
        if (this.getParent().isProcessed()) {
            return success;
        }
        if ((newRecord || this.is_ValueChanged("LineNetAmt")) && (no = DB.executeUpdate((String)(sql = "UPDATE JP_ContractContent cc SET TotalLines = (SELECT COALESCE(SUM(LineNetAmt),0) FROM JP_ContractLine cl WHERE cc.JP_ContractContent_ID=cl.JP_ContractContent_ID)WHERE JP_ContractContent_ID=?"), (Object[])new Object[]{this.getJP_ContractContent_ID()}, (boolean)false, (String)this.get_TrxName(), (int)0)) != 1) {
            this.log.warning("(1) #" + no);
            return false;
        }
        return success;
    }

    public MOrderLine[] getOrderLineByContractPeriod(Properties ctx, int JP_ContractProcPeriod_ID, String trxName) {
        ArrayList<MOrderLine> list;
        block6: {
            list = new ArrayList<MOrderLine>();
            String sql = "SELECT ol.* FROM C_OrderLine ol  INNER JOIN  C_Order o ON(o.C_Order_ID = ol.C_Order_ID)  WHERE ol.JP_ContractLine_ID=? AND ol.JP_ContractProcPeriod_ID=? AND o.DocStatus NOT IN ('VO','RE')";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)"SELECT ol.* FROM C_OrderLine ol  INNER JOIN  C_Order o ON(o.C_Order_ID = ol.C_Order_ID)  WHERE ol.JP_ContractLine_ID=? AND ol.JP_ContractProcPeriod_ID=? AND o.DocStatus NOT IN ('VO','RE')", (String)trxName);
                    pstmt.setInt(1, this.get_ID());
                    pstmt.setInt(2, JP_ContractProcPeriod_ID);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        list.add(new MOrderLine(this.getCtx(), rs, trxName));
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, "SELECT ol.* FROM C_OrderLine ol  INNER JOIN  C_Order o ON(o.C_Order_ID = ol.C_Order_ID)  WHERE ol.JP_ContractLine_ID=? AND ol.JP_ContractProcPeriod_ID=? AND o.DocStatus NOT IN ('VO','RE')", (Throwable)e);
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        MOrderLine[] iLines = new MOrderLine[list.size()];
        list.toArray(iLines);
        return iLines;
    }

    public MInOutLine[] getInOutLineByContractPeriod(Properties ctx, int JP_ContractProcPeriod_ID, String trxName) {
        ArrayList<MInOutLine> list;
        block6: {
            list = new ArrayList<MInOutLine>();
            String sql = "SELECT iol.* FROM M_InOutLine iol  INNER JOIN  M_InOut io ON(io.M_InOut_ID = iol.M_InOut_ID)  WHERE iol.JP_ContractLine_ID=? AND iol.JP_ContractProcPeriod_ID=? AND io.DocStatus NOT IN ('VO','RE')";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)"SELECT iol.* FROM M_InOutLine iol  INNER JOIN  M_InOut io ON(io.M_InOut_ID = iol.M_InOut_ID)  WHERE iol.JP_ContractLine_ID=? AND iol.JP_ContractProcPeriod_ID=? AND io.DocStatus NOT IN ('VO','RE')", (String)trxName);
                    pstmt.setInt(1, this.get_ID());
                    pstmt.setInt(2, JP_ContractProcPeriod_ID);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        list.add(new MInOutLine(this.getCtx(), rs, trxName));
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, "SELECT iol.* FROM M_InOutLine iol  INNER JOIN  M_InOut io ON(io.M_InOut_ID = iol.M_InOut_ID)  WHERE iol.JP_ContractLine_ID=? AND iol.JP_ContractProcPeriod_ID=? AND io.DocStatus NOT IN ('VO','RE')", (Throwable)e);
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        MInOutLine[] iLines = new MInOutLine[list.size()];
        list.toArray(iLines);
        return iLines;
    }

    public MInvoiceLine[] getInvoiceLineByContractPeriod(Properties ctx, int JP_ContractProcPeriod_ID, String trxName) {
        ArrayList<MInvoiceLine> list;
        block6: {
            list = new ArrayList<MInvoiceLine>();
            String sql = "SELECT il.* FROM C_InvoiceLine il  INNER JOIN  C_Invoice i ON(i.C_Invoice_ID = il.C_Invoice_ID)  WHERE il.JP_ContractLine_ID=? AND il.JP_ContractProcPeriod_ID=? AND i.DocStatus NOT IN ('VO','RE')";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)"SELECT il.* FROM C_InvoiceLine il  INNER JOIN  C_Invoice i ON(i.C_Invoice_ID = il.C_Invoice_ID)  WHERE il.JP_ContractLine_ID=? AND il.JP_ContractProcPeriod_ID=? AND i.DocStatus NOT IN ('VO','RE')", (String)trxName);
                    pstmt.setInt(1, this.get_ID());
                    pstmt.setInt(2, JP_ContractProcPeriod_ID);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        list.add(new MInvoiceLine(this.getCtx(), rs, trxName));
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, "SELECT il.* FROM C_InvoiceLine il  INNER JOIN  C_Invoice i ON(i.C_Invoice_ID = il.C_Invoice_ID)  WHERE il.JP_ContractLine_ID=? AND il.JP_ContractProcPeriod_ID=? AND i.DocStatus NOT IN ('VO','RE')", (Throwable)e);
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        MInvoiceLine[] iLines = new MInvoiceLine[list.size()];
        list.toArray(iLines);
        return iLines;
    }

    public MRecognitionLine[] getRecognitionLineByContractPeriod(Properties ctx, int JP_ContractProcPeriod_ID, String trxName) {
        ArrayList<MRecognitionLine> list;
        block6: {
            list = new ArrayList<MRecognitionLine>();
            String sql = "SELECT rl.* FROM JP_RecognitionLine rl  INNER JOIN  JP_Recognition r ON(r.JP_Recognition_ID = rl.JP_Recognition_ID)  WHERE rl.JP_ContractLine_ID=? AND rl.JP_ContractProcPeriod_ID=? AND r.DocStatus NOT IN ('VO','RE')";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)"SELECT rl.* FROM JP_RecognitionLine rl  INNER JOIN  JP_Recognition r ON(r.JP_Recognition_ID = rl.JP_Recognition_ID)  WHERE rl.JP_ContractLine_ID=? AND rl.JP_ContractProcPeriod_ID=? AND r.DocStatus NOT IN ('VO','RE')", (String)trxName);
                    pstmt.setInt(1, this.get_ID());
                    pstmt.setInt(2, JP_ContractProcPeriod_ID);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        list.add(new MRecognitionLine(this.getCtx(), rs, trxName));
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, "SELECT rl.* FROM JP_RecognitionLine rl  INNER JOIN  JP_Recognition r ON(r.JP_Recognition_ID = rl.JP_Recognition_ID)  WHERE rl.JP_ContractLine_ID=? AND rl.JP_ContractProcPeriod_ID=? AND r.DocStatus NOT IN ('VO','RE')", (Throwable)e);
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        MRecognitionLine[] iLines = new MRecognitionLine[list.size()];
        list.toArray(iLines);
        return iLines;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("JP_ContractLine_ID[").append(this.get_ID()).append("]");
        return sb.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean checkPeriodContractInfo(boolean newRecord) {
        if (Util.isEmpty((String)this.getParent().getJP_CreateDerivativeDocPolicy()) && !this.getParent().getDocBaseType().equals("API") && !this.getParent().getDocBaseType().equals("ARI")) {
            if (!this.getParent().getOrderType().equals("SO")) return true;
            Object[] objs = new Object[]{Msg.getElement((Properties)Env.getCtx(), (String)"JP_CreateDerivativeDocPolicy")};
            String msg = Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Mandatory", (Object[])objs);
            this.log.saveError("Error", msg);
            return false;
        }
        if (this.getParent().getDocBaseType().equals("SOO") || this.getParent().getDocBaseType().equals("POO")) {
            if (this.getParent().getJP_CreateDerivativeDocPolicy().equals("MA")) {
                if (!this.checkCreateBaseDocLineInfo(newRecord)) {
                    return false;
                }
                this.setNullCreateDerivativeInOutInfo();
                this.setNullCreateDerivativeInvoiceInfo();
                return true;
            }
            if (this.getParent().getJP_CreateDerivativeDocPolicy().equals("BT")) {
                this.setNullCreateBaseDocLineInfo();
                if (!this.checkCreateDerivativeInOutInfo(newRecord)) {
                    return false;
                }
                if (!this.checkCreateDerivativeInvoiceInfo(newRecord)) {
                    return false;
                }
                if (this.checkDerivativeDocPeriodCorrespondence(newRecord)) return true;
                return false;
            }
            if (this.getParent().getJP_CreateDerivativeDocPolicy().equals("IO")) {
                this.setNullCreateBaseDocLineInfo();
                if (!this.checkCreateDerivativeInOutInfo(newRecord)) {
                    return false;
                }
                this.setNullCreateDerivativeInvoiceInfo();
                if (this.checkDerivativeInOutAndBaseDocPeriodCorrespondence(newRecord)) return true;
                return false;
            }
            if (!this.getParent().getJP_CreateDerivativeDocPolicy().equals("IV")) {
                Object[] objs = new Object[]{Msg.getElement((Properties)Env.getCtx(), (String)"JP_ContractDerivativeDocPolicy_ID")};
                String msg = String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"JP_InCaseOfPeriodContract")) + Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Mandatory", (Object[])objs);
                this.log.saveError("Error", msg);
                return false;
            }
            this.setNullCreateBaseDocLineInfo();
            this.setNullCreateDerivativeInOutInfo();
            if (!this.checkCreateDerivativeInvoiceInfo(newRecord)) {
                return false;
            }
            if (this.checkDerivativeInvoiceAndBaseDocPeriodCorrespondence(newRecord)) return true;
            return false;
        }
        if (!this.checkCreateBaseDocLineInfo(newRecord)) {
            return false;
        }
        this.setNullCreateDerivativeInOutInfo();
        this.setNullCreateDerivativeInvoiceInfo();
        return true;
    }

    private void setNullCreateBaseDocLineInfo() {
        this.setJP_BaseDocLinePolicy(null);
        this.setJP_ProcPeriod_Lump_ID(0);
        this.setJP_ProcPeriod_Lump_Date(null);
        this.setJP_ProcPeriod_Start_ID(0);
        this.setJP_ProcPeriod_Start_Date(null);
        this.setJP_ProcPeriod_End_ID(0);
        this.setJP_ProcPeriod_End_Date(null);
    }

    private void setNullCreateDerivativeInOutInfo() {
        this.setJP_DerivativeDocPolicy_InOut(null);
        this.setJP_ContractCalender_InOut_ID(0);
        this.setJP_ProcPeriod_Lump_InOut_ID(0);
        this.setJP_ProcPeriod_Lump_InOut_Date(null);
        this.setJP_ProcPeriod_Start_InOut_ID(0);
        this.setJP_ProcPeriod_Start_InOut_Date(null);
        this.setJP_ProcPeriod_End_InOut_ID(0);
        this.setJP_ProcPeriod_End_InOut_Date(null);
        this.setJP_ContractProcess_InOut_ID(0);
    }

    private void setNullCreateDerivativeInvoiceInfo() {
        this.setJP_DerivativeDocPolicy_Inv(null);
        this.setJP_ContractCalender_Inv_ID(0);
        this.setJP_ProcPeriod_Lump_Inv_ID(0);
        this.setJP_ProcPeriod_Lump_Inv_Date(null);
        this.setJP_ProcPeriod_Start_Inv_ID(0);
        this.setJP_ProcPeriod_Start_Inv_Date(null);
        this.setJP_ProcPeriod_End_Inv_ID(0);
        this.setJP_ProcPeriod_End_Inv_Date(null);
        this.setJP_ContractProcess_Inv_ID(0);
    }

    private boolean checkCreateBaseDocLineInfo(boolean newRecord) {
        if (Util.isEmpty((String)this.getJP_BaseDocLinePolicy())) {
            this.log.saveError("Error", Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Mandatory", (Object[])new Object[]{Msg.getElement((Properties)Env.getCtx(), (String)"JP_BaseDocLinePolicy")}));
            return false;
        }
        if (this.getJP_BaseDocLinePolicy().equals("LP") || this.getJP_BaseDocLinePolicy().equals("PS") || this.getJP_BaseDocLinePolicy().equals("PE") || this.getJP_BaseDocLinePolicy().equals("PB")) {
            MContractProcPeriod period;
            if (this.getJP_BaseDocLinePolicy().equals("LP")) {
                if (!newRecord && this.getJP_ProcPeriod_Lump_ID() == 0) {
                    this.log.saveError("Error", Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Mandatory", (Object[])new Object[]{Msg.getElement((Properties)Env.getCtx(), (String)"JP_ProcPeriod_Lump_ID")}));
                    return false;
                }
                if (!newRecord || this.getJP_ProcPeriod_Lump_ID() != 0) {
                    period = MContractProcPeriod.get(this.getCtx(), this.getJP_ProcPeriod_Lump_ID());
                    if (!this.checkContainContractProcDate(period)) {
                        this.log.saveError("Error", String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"JP_OutsideContractProcessPeriod")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"JP_ProcPeriod_Lump_ID"));
                        return false;
                    }
                    if (this.getJP_ProcPeriod_Lump_Date() != null && !this.checkContainContractProcDate(this.getJP_ProcPeriod_Lump_Date())) {
                        this.log.saveError("Error", String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"JP_OutsideContractProcessPeriod")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"JP_ProcPeriod_Lump_Date"));
                        return false;
                    }
                    if (period.getJP_ContractCalender_ID() != this.getParent().getJP_ContractCalender_ID()) {
                        this.log.saveError("Error", Msg.getMsg((Properties)this.getCtx(), (String)"JP_Inconsistency", (Object[])new Object[]{Msg.getElement((Properties)Env.getCtx(), (String)"JP_ContractCalender_ID"), Msg.getElement((Properties)Env.getCtx(), (String)"JP_ProcPeriod_Lump_ID")}));
                        return false;
                    }
                }
                this.setJP_ProcPeriod_Start_ID(0);
                this.setJP_ProcPeriod_Start_Date(null);
                this.setJP_ProcPeriod_End_ID(0);
                this.setJP_ProcPeriod_End_Date(null);
            }
            if (this.getJP_BaseDocLinePolicy().equals("PS") || this.getJP_BaseDocLinePolicy().equals("PB")) {
                if (!newRecord && this.getJP_ProcPeriod_Start_ID() == 0) {
                    this.log.saveError("Error", Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Mandatory", (Object[])new Object[]{Msg.getElement((Properties)Env.getCtx(), (String)"JP_ProcPeriod_Start_ID")}));
                    return false;
                }
                if (!newRecord || this.getJP_ProcPeriod_Start_ID() != 0) {
                    period = MContractProcPeriod.get(this.getCtx(), this.getJP_ProcPeriod_Start_ID());
                    if (!this.checkContainContractProcDate(period)) {
                        this.log.saveError("Error", String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"JP_OutsideContractProcessPeriod")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"JP_ProcPeriod_Start_ID"));
                        return false;
                    }
                    if (this.getJP_ProcPeriod_Start_Date() != null && !this.checkContainContractProcDate(this.getJP_ProcPeriod_Start_Date())) {
                        this.log.saveError("Error", String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"JP_OutsideContractProcessPeriod")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"JP_ProcPeriod_Start_Date"));
                        return false;
                    }
                    if (period.getJP_ContractCalender_ID() != this.getParent().getJP_ContractCalender_ID()) {
                        this.log.saveError("Error", Msg.getMsg((Properties)this.getCtx(), (String)"JP_Inconsistency", (Object[])new Object[]{Msg.getElement((Properties)Env.getCtx(), (String)"JP_ContractCalender_ID"), Msg.getElement((Properties)Env.getCtx(), (String)"JP_ProcPeriod_Start_ID")}));
                        return false;
                    }
                }
                this.setJP_ProcPeriod_Lump_ID(0);
                this.setJP_ProcPeriod_Lump_Date(null);
                if (this.getJP_BaseDocLinePolicy().equals("PS")) {
                    this.setJP_ProcPeriod_End_ID(0);
                    this.setJP_ProcPeriod_End_Date(null);
                }
            }
            if (this.getJP_BaseDocLinePolicy().equals("PE") || this.getJP_BaseDocLinePolicy().equals("PB")) {
                if (!newRecord && this.getJP_ProcPeriod_End_ID() == 0) {
                    this.log.saveError("Error", Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Mandatory", (Object[])new Object[]{Msg.getElement((Properties)Env.getCtx(), (String)"JP_ProcPeriod_End_ID")}));
                    return false;
                }
                if (!newRecord || this.getJP_ProcPeriod_End_ID() != 0) {
                    period = MContractProcPeriod.get(this.getCtx(), this.getJP_ProcPeriod_End_ID());
                    if (!this.checkContainContractProcDate(period)) {
                        this.log.saveError("Error", String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"JP_OutsideContractProcessPeriod")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"JP_ProcPeriod_End_ID"));
                        return false;
                    }
                    if (this.getJP_ProcPeriod_End_Date() != null && !this.checkContainContractProcDate(this.getJP_ProcPeriod_End_Date())) {
                        this.log.saveError("Error", String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"JP_OutsideContractProcessPeriod")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"JP_ProcPeriod_End_Date"));
                        return false;
                    }
                    if (period.getJP_ContractCalender_ID() != this.getParent().getJP_ContractCalender_ID()) {
                        this.log.saveError("Error", Msg.getMsg((Properties)this.getCtx(), (String)"JP_Inconsistency", (Object[])new Object[]{Msg.getElement((Properties)Env.getCtx(), (String)"JP_ContractCalender_ID"), Msg.getElement((Properties)Env.getCtx(), (String)"JP_ProcPeriod_End_ID")}));
                        return false;
                    }
                }
                this.setJP_ProcPeriod_Lump_ID(0);
                this.setJP_ProcPeriod_Lump_Date(null);
                if (this.getJP_BaseDocLinePolicy().equals("PE")) {
                    this.setJP_ProcPeriod_Start_ID(0);
                    this.setJP_ProcPeriod_Start_Date(null);
                }
                if (this.getJP_BaseDocLinePolicy().equals("PB") && this.getJP_ProcPeriod_Start_ID() > 0 && this.getJP_ProcPeriod_End_ID() > 0) {
                    MContractProcPeriod startPeriod = MContractProcPeriod.get(this.getCtx(), this.getJP_ProcPeriod_Start_ID());
                    MContractProcPeriod endPeriod = MContractProcPeriod.get(this.getCtx(), this.getJP_ProcPeriod_End_ID());
                    if (startPeriod.getStartDate().compareTo(endPeriod.getStartDate()) > 0) {
                        this.log.saveError("Error", String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"Invalid")) + " " + Msg.getElement((Properties)this.getCtx(), (String)"JP_ProcPeriod_Start_ID") + " > " + Msg.getElement((Properties)this.getCtx(), (String)"JP_ProcPeriod_End_ID"));
                        return false;
                    }
                }
            }
        } else {
            this.setJP_ProcPeriod_Lump_ID(0);
            this.setJP_ProcPeriod_Lump_Date(null);
            this.setJP_ProcPeriod_Start_ID(0);
            this.setJP_ProcPeriod_Start_Date(null);
            this.setJP_ProcPeriod_End_ID(0);
            this.setJP_ProcPeriod_End_Date(null);
        }
        return true;
    }

    private boolean checkCreateDerivativeInOutInfo(boolean newRecord) {
        if (Util.isEmpty((String)this.getJP_DerivativeDocPolicy_InOut())) {
            this.log.saveError("Error", Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Mandatory", (Object[])new Object[]{Msg.getElement((Properties)Env.getCtx(), (String)"JP_DerivativeDocPolicy_InOut")}));
            return false;
        }
        if (!newRecord && this.getJP_ContractCalender_InOut_ID() == 0) {
            this.log.saveError("Error", Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Mandatory", (Object[])new Object[]{Msg.getElement((Properties)Env.getCtx(), (String)"JP_ContractCalender_InOut_ID")}));
            return false;
        }
        if (this.getMovementQty().signum() != 0 && this.getQtyOrdered().signum() != this.getMovementQty().signum()) {
            this.log.saveError("Error", Msg.getMsg((Properties)this.getCtx(), (String)"JP_Inconsistency", (Object[])new Object[]{Msg.getElement((Properties)Env.getCtx(), (String)"MovementQty"), Msg.getElement((Properties)Env.getCtx(), (String)"QtyOrdered")}));
            return false;
        }
        if (this.getMovementQty().abs().compareTo(this.getQtyOrdered().abs()) > 0) {
            this.log.saveError("Error", Msg.getMsg((Properties)this.getCtx(), (String)"JP_Inconsistency", (Object[])new Object[]{Msg.getElement((Properties)Env.getCtx(), (String)"MovementQty"), Msg.getElement((Properties)Env.getCtx(), (String)"QtyOrdered")}));
            return false;
        }
        int parentJP_ContractCalender_ID = this.getParent().getJP_ContractCalender_ID();
        if (this.getJP_DerivativeDocPolicy_InOut().equals("LP") || this.getJP_DerivativeDocPolicy_InOut().equals("PS") || this.getJP_DerivativeDocPolicy_InOut().equals("PE") || this.getJP_DerivativeDocPolicy_InOut().equals("PB")) {
            MContractProcPeriod period;
            if (this.getJP_DerivativeDocPolicy_InOut().equals("LP")) {
                if (!newRecord && this.getJP_ProcPeriod_Lump_InOut_ID() == 0) {
                    this.log.saveError("Error", Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Mandatory", (Object[])new Object[]{Msg.getElement((Properties)Env.getCtx(), (String)"JP_ProcPeriod_Lump_InOut_ID")}));
                    return false;
                }
                if (!newRecord || this.getJP_ProcPeriod_Lump_InOut_ID() != 0 && parentJP_ContractCalender_ID != 0) {
                    period = MContractProcPeriod.get(this.getCtx(), this.getJP_ProcPeriod_Lump_InOut_ID());
                    if (!this.checkContainContractProcDate(period)) {
                        this.log.saveError("Error", String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"JP_OutsideContractProcessPeriod")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"JP_ProcPeriod_Lump_InOut_ID"));
                        return false;
                    }
                    if (this.getJP_ProcPeriod_Lump_InOut_Date() != null && !this.checkContainContractProcDate(this.getJP_ProcPeriod_Lump_InOut_Date())) {
                        this.log.saveError("Error", String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"JP_OutsideContractProcessPeriod")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"JP_ProcPeriod_Lump_InOut_Date"));
                        return false;
                    }
                    if (period.getJP_ContractCalender_ID() != this.getJP_ContractCalender_InOut_ID()) {
                        this.log.saveError("Error", Msg.getMsg((Properties)this.getCtx(), (String)"JP_Inconsistency", (Object[])new Object[]{Msg.getElement((Properties)Env.getCtx(), (String)"JP_ContractCalender_InOut_ID"), Msg.getElement((Properties)Env.getCtx(), (String)"JP_ProcPeriod_Lump_InOut_ID")}));
                        return false;
                    }
                }
                this.setJP_ProcPeriod_Start_InOut_ID(0);
                this.setJP_ProcPeriod_Start_InOut_Date(null);
                this.setJP_ProcPeriod_End_InOut_ID(0);
                this.setJP_ProcPeriod_End_InOut_Date(null);
            }
            if (this.getJP_DerivativeDocPolicy_InOut().equals("PS") || this.getJP_DerivativeDocPolicy_InOut().equals("PB")) {
                if (!newRecord && this.getJP_ProcPeriod_Start_InOut_ID() == 0) {
                    this.log.saveError("Error", Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Mandatory", (Object[])new Object[]{Msg.getElement((Properties)Env.getCtx(), (String)"JP_ProcPeriod_Start_InOut_ID")}));
                    return false;
                }
                if (!newRecord || this.getJP_ProcPeriod_Start_InOut_ID() != 0 && parentJP_ContractCalender_ID != 0) {
                    period = MContractProcPeriod.get(this.getCtx(), this.getJP_ProcPeriod_Start_InOut_ID());
                    if (!this.checkContainContractProcDate(period)) {
                        this.log.saveError("Error", String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"JP_OutsideContractProcessPeriod")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"JP_ProcPeriod_Start_InOut_ID"));
                        return false;
                    }
                    if (this.getJP_ProcPeriod_Start_InOut_Date() != null && !this.checkContainContractProcDate(this.getJP_ProcPeriod_Start_InOut_Date())) {
                        this.log.saveError("Error", String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"JP_OutsideContractProcessPeriod")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"JP_ProcPeriod_Start_InOut_Date"));
                        return false;
                    }
                    if (period.getJP_ContractCalender_ID() != this.getJP_ContractCalender_InOut_ID()) {
                        this.log.saveError("Error", Msg.getMsg((Properties)this.getCtx(), (String)"JP_Inconsistency", (Object[])new Object[]{Msg.getElement((Properties)Env.getCtx(), (String)"JP_ContractCalender_InOut_ID"), Msg.getElement((Properties)Env.getCtx(), (String)"JP_ProcPeriod_Start_InOut_ID")}));
                        return false;
                    }
                }
                this.setJP_ProcPeriod_Lump_InOut_ID(0);
                this.setJP_ProcPeriod_Lump_InOut_Date(null);
                if (this.getJP_DerivativeDocPolicy_InOut().equals("PS")) {
                    this.setJP_ProcPeriod_End_InOut_ID(0);
                    this.setJP_ProcPeriod_End_InOut_Date(null);
                }
            }
            if (this.getJP_DerivativeDocPolicy_InOut().equals("PE") || this.getJP_DerivativeDocPolicy_InOut().equals("PB")) {
                if (!newRecord && this.getJP_ProcPeriod_End_InOut_ID() == 0) {
                    this.log.saveError("Error", Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Mandatory", (Object[])new Object[]{Msg.getElement((Properties)Env.getCtx(), (String)"JP_ProcPeriod_End_InOut_ID")}));
                    return false;
                }
                if (!newRecord || this.getJP_ProcPeriod_End_InOut_ID() != 0 && parentJP_ContractCalender_ID != 0) {
                    period = MContractProcPeriod.get(this.getCtx(), this.getJP_ProcPeriod_End_InOut_ID());
                    if (!this.checkContainContractProcDate(period)) {
                        this.log.saveError("Error", String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"JP_OutsideContractProcessPeriod")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"JP_ProcPeriod_End_InOut_ID"));
                        return false;
                    }
                    if (this.getJP_ProcPeriod_End_InOut_Date() != null && !this.checkContainContractProcDate(this.getJP_ProcPeriod_End_InOut_Date())) {
                        this.log.saveError("Error", String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"JP_OutsideContractProcessPeriod")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"JP_ProcPeriod_End_InOut_Date"));
                        return false;
                    }
                    if (period.getJP_ContractCalender_ID() != this.getJP_ContractCalender_InOut_ID()) {
                        this.log.saveError("Error", Msg.getMsg((Properties)this.getCtx(), (String)"JP_Inconsistency", (Object[])new Object[]{Msg.getElement((Properties)Env.getCtx(), (String)"JP_ContractCalender_InOut_ID"), Msg.getElement((Properties)Env.getCtx(), (String)"JP_ProcPeriod_End_InOut_ID")}));
                        return false;
                    }
                }
                this.setJP_ProcPeriod_Lump_InOut_ID(0);
                this.setJP_ProcPeriod_Lump_InOut_Date(null);
                if (this.getJP_DerivativeDocPolicy_InOut().equals("PE")) {
                    this.setJP_ProcPeriod_Start_InOut_ID(0);
                    this.setJP_ProcPeriod_Start_InOut_Date(null);
                }
                if (this.getJP_DerivativeDocPolicy_InOut().equals("PB") && this.getJP_ProcPeriod_Start_InOut_ID() > 0 && this.getJP_ProcPeriod_End_InOut_ID() > 0) {
                    MContractProcPeriod startPeriod = MContractProcPeriod.get(this.getCtx(), this.getJP_ProcPeriod_Start_InOut_ID());
                    MContractProcPeriod endPeriod = MContractProcPeriod.get(this.getCtx(), this.getJP_ProcPeriod_End_InOut_ID());
                    if (startPeriod.getStartDate().compareTo(endPeriod.getStartDate()) > 0) {
                        this.log.saveError("Error", String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"Invalid")) + " " + Msg.getElement((Properties)this.getCtx(), (String)"JP_ProcPeriod_Start_InOut_ID") + " > " + Msg.getElement((Properties)this.getCtx(), (String)"JP_ProcPeriod_End_InOut_ID"));
                        return false;
                    }
                }
            }
        } else {
            this.setJP_ProcPeriod_Lump_InOut_ID(0);
            this.setJP_ProcPeriod_Lump_InOut_Date(null);
            this.setJP_ProcPeriod_Start_InOut_ID(0);
            this.setJP_ProcPeriod_Start_InOut_Date(null);
            this.setJP_ProcPeriod_End_InOut_ID(0);
            this.setJP_ProcPeriod_End_InOut_Date(null);
            if (!newRecord || parentJP_ContractCalender_ID != 0) {
                MContractProcPeriod inout_End_ProcPeriod;
                MContractCalender inOut_Calender = MContractCalender.get(this.getCtx(), this.getJP_ContractCalender_InOut_ID());
                MContractProcPeriod inOut_Start_ProcPeriod = inOut_Calender.getContractProcessPeriod(this.getCtx(), this.getParent().getJP_ContractProcDate_From());
                if (inOut_Start_ProcPeriod == null) {
                    this.log.saveError("Error", String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"NotFound")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"JP_ContractCalender_InOut_ID") + " - " + Msg.getElement((Properties)this.getCtx(), (String)"JP_ContractProcPeriod_ID") + " - " + Msg.getElement((Properties)this.getCtx(), (String)"JP_ContractProcDate_From"));
                    return false;
                }
                if (this.getParent().getJP_ContractProcDate_To() != null && (inout_End_ProcPeriod = inOut_Calender.getContractProcessPeriod(this.getCtx(), this.getParent().getJP_ContractProcDate_To())) == null) {
                    this.log.saveError("Error", String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"NotFound")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"JP_ContractCalender_InOut_ID") + " - " + Msg.getElement((Properties)this.getCtx(), (String)"JP_ContractProcPeriod_ID") + " - " + Msg.getElement((Properties)this.getCtx(), (String)"JP_ContractProcDate_To"));
                    return false;
                }
            }
        }
        if (!newRecord && this.getJP_ContractProcess_InOut_ID() == 0) {
            this.log.saveError("Error", Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Mandatory", (Object[])new Object[]{Msg.getElement((Properties)Env.getCtx(), (String)"JP_ContractProcess_InOut_ID")}));
            return false;
        }
        return true;
    }

    private boolean checkCreateDerivativeInvoiceInfo(boolean newRecord) {
        if (Util.isEmpty((String)this.getJP_DerivativeDocPolicy_Inv())) {
            this.log.saveError("Error", Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Mandatory", (Object[])new Object[]{Msg.getElement((Properties)Env.getCtx(), (String)"JP_DerivativeDocPolicy_Inv")}));
            return false;
        }
        if (!newRecord && this.getJP_ContractCalender_Inv_ID() == 0) {
            this.log.saveError("Error", Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Mandatory", (Object[])new Object[]{Msg.getElement((Properties)Env.getCtx(), (String)"JP_ContractCalender_Inv_ID")}));
            return false;
        }
        if (this.getQtyInvoiced().signum() != 0 && this.getQtyOrdered().signum() != this.getQtyInvoiced().signum()) {
            this.log.saveError("Error", Msg.getMsg((Properties)this.getCtx(), (String)"JP_Inconsistency", (Object[])new Object[]{Msg.getElement((Properties)Env.getCtx(), (String)"QtyInvoiced"), Msg.getElement((Properties)Env.getCtx(), (String)"QtyOrdered")}));
            return false;
        }
        if (this.getQtyInvoiced().abs().compareTo(this.getQtyOrdered().abs()) > 0) {
            this.log.saveError("Error", Msg.getMsg((Properties)this.getCtx(), (String)"JP_Inconsistency", (Object[])new Object[]{Msg.getElement((Properties)Env.getCtx(), (String)"QtyInvoiced"), Msg.getElement((Properties)Env.getCtx(), (String)"QtyOrdered")}));
            return false;
        }
        int parentJP_ContractCalender_ID = this.getParent().getJP_ContractCalender_ID();
        if (this.getJP_DerivativeDocPolicy_Inv().equals("LP") || this.getJP_DerivativeDocPolicy_Inv().equals("PS") || this.getJP_DerivativeDocPolicy_Inv().equals("PE") || this.getJP_DerivativeDocPolicy_Inv().equals("PB")) {
            MContractProcPeriod period;
            if (this.getJP_DerivativeDocPolicy_Inv().equals("LP")) {
                if (!newRecord && this.getJP_ProcPeriod_Lump_Inv_ID() == 0) {
                    this.log.saveError("Error", Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Mandatory", (Object[])new Object[]{Msg.getElement((Properties)Env.getCtx(), (String)"JP_ProcPeriod_Lump_Inv_ID")}));
                    return false;
                }
                if (!newRecord || this.getJP_ProcPeriod_Lump_Inv_ID() != 0 && parentJP_ContractCalender_ID != 0) {
                    period = MContractProcPeriod.get(this.getCtx(), this.getJP_ProcPeriod_Lump_Inv_ID());
                    if (!this.checkContainContractProcDate(period)) {
                        this.log.saveError("Error", String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"JP_OutsideContractProcessPeriod")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"JP_ProcPeriod_Lump_Inv_ID"));
                        return false;
                    }
                    if (this.getJP_ProcPeriod_Lump_Inv_Date() != null && !this.checkContainContractProcDate(this.getJP_ProcPeriod_Lump_Inv_Date())) {
                        this.log.saveError("Error", String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"JP_OutsideContractProcessPeriod")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"JP_ProcPeriod_Lump_Inv_Date"));
                        return false;
                    }
                    if (period.getJP_ContractCalender_ID() != this.getJP_ContractCalender_Inv_ID()) {
                        this.log.saveError("Error", Msg.getMsg((Properties)this.getCtx(), (String)"JP_Inconsistency", (Object[])new Object[]{Msg.getElement((Properties)Env.getCtx(), (String)"JP_ContractCalender_Inv_ID"), Msg.getElement((Properties)Env.getCtx(), (String)"JP_ProcPeriod_Lump_Inv_ID")}));
                        return false;
                    }
                }
                this.setJP_ProcPeriod_Start_Inv_ID(0);
                this.setJP_ProcPeriod_Start_Inv_Date(null);
                this.setJP_ProcPeriod_End_Inv_ID(0);
                this.setJP_ProcPeriod_End_Inv_Date(null);
            }
            if (this.getJP_DerivativeDocPolicy_Inv().equals("PS") || this.getJP_DerivativeDocPolicy_Inv().equals("PB")) {
                if (!newRecord && this.getJP_ProcPeriod_Start_Inv_ID() == 0) {
                    this.log.saveError("Error", Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Mandatory", (Object[])new Object[]{Msg.getElement((Properties)Env.getCtx(), (String)"JP_ProcPeriod_Start_Inv_ID")}));
                    return false;
                }
                if (!newRecord || this.getJP_ProcPeriod_Start_Inv_ID() != 0 && parentJP_ContractCalender_ID != 0) {
                    period = MContractProcPeriod.get(this.getCtx(), this.getJP_ProcPeriod_Start_Inv_ID());
                    if (!this.checkContainContractProcDate(period)) {
                        this.log.saveError("Error", String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"JP_OutsideContractProcessPeriod")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"JP_ProcPeriod_Start_Inv_ID"));
                        return false;
                    }
                    if (this.getJP_ProcPeriod_Start_Inv_Date() != null && !this.checkContainContractProcDate(this.getJP_ProcPeriod_Start_Inv_Date())) {
                        this.log.saveError("Error", String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"JP_OutsideContractProcessPeriod")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"JP_ProcPeriod_Start_Inv_Date"));
                        return false;
                    }
                    if (period.getJP_ContractCalender_ID() != this.getJP_ContractCalender_Inv_ID()) {
                        this.log.saveError("Error", Msg.getMsg((Properties)this.getCtx(), (String)"JP_Inconsistency", (Object[])new Object[]{Msg.getElement((Properties)Env.getCtx(), (String)"JP_ContractCalender_Inv_ID"), Msg.getElement((Properties)Env.getCtx(), (String)"JP_ProcPeriod_Start_Inv_ID")}));
                        return false;
                    }
                }
                this.setJP_ProcPeriod_Lump_Inv_ID(0);
                this.setJP_ProcPeriod_Lump_Inv_Date(null);
                if (this.getJP_DerivativeDocPolicy_Inv().equals("PS")) {
                    this.setJP_ProcPeriod_End_Inv_ID(0);
                    this.setJP_ProcPeriod_End_Inv_Date(null);
                }
            }
            if (this.getJP_DerivativeDocPolicy_Inv().equals("PE") || this.getJP_DerivativeDocPolicy_Inv().equals("PB")) {
                if (!newRecord && this.getJP_ProcPeriod_End_Inv_ID() == 0) {
                    this.log.saveError("Error", Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Mandatory", (Object[])new Object[]{Msg.getElement((Properties)Env.getCtx(), (String)"JP_ProcPeriod_End_Inv_ID")}));
                    return false;
                }
                if (!newRecord || this.getJP_ProcPeriod_End_Inv_ID() != 0 && parentJP_ContractCalender_ID != 0) {
                    period = MContractProcPeriod.get(this.getCtx(), this.getJP_ProcPeriod_End_Inv_ID());
                    if (!this.checkContainContractProcDate(period)) {
                        this.log.saveError("Error", String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"JP_OutsideContractProcessPeriod")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"JP_ProcPeriod_End_Inv_ID"));
                        return false;
                    }
                    if (this.getJP_ProcPeriod_End_Inv_Date() != null && !this.checkContainContractProcDate(this.getJP_ProcPeriod_End_Inv_Date())) {
                        this.log.saveError("Error", String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"JP_OutsideContractProcessPeriod")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"JP_ProcPeriod_End_Inv_Date"));
                        return false;
                    }
                    if (period.getJP_ContractCalender_ID() != this.getJP_ContractCalender_Inv_ID()) {
                        this.log.saveError("Error", Msg.getMsg((Properties)this.getCtx(), (String)"JP_Inconsistency", (Object[])new Object[]{Msg.getElement((Properties)Env.getCtx(), (String)"JP_ContractCalender_Inv_ID"), Msg.getElement((Properties)Env.getCtx(), (String)"JP_ProcPeriod_End_Inv_ID")}));
                        return false;
                    }
                }
                this.setJP_ProcPeriod_Lump_Inv_ID(0);
                this.setJP_ProcPeriod_Lump_Inv_Date(null);
                if (this.getJP_DerivativeDocPolicy_Inv().equals("PE")) {
                    this.setJP_ProcPeriod_Start_Inv_ID(0);
                    this.setJP_ProcPeriod_Start_Inv_Date(null);
                }
                if (this.getJP_DerivativeDocPolicy_Inv().equals("PB") && this.getJP_ProcPeriod_Start_Inv_ID() > 0 && this.getJP_ProcPeriod_End_Inv_ID() > 0) {
                    MContractProcPeriod startPeriod = MContractProcPeriod.get(this.getCtx(), this.getJP_ProcPeriod_Start_Inv_ID());
                    MContractProcPeriod endPeriod = MContractProcPeriod.get(this.getCtx(), this.getJP_ProcPeriod_End_Inv_ID());
                    if (startPeriod.getStartDate().compareTo(endPeriod.getStartDate()) > 0) {
                        this.log.saveError("Error", String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"Invalid")) + " " + Msg.getElement((Properties)this.getCtx(), (String)"JP_ProcPeriod_Start_Inv_ID") + " > " + Msg.getElement((Properties)this.getCtx(), (String)"JP_ProcPeriod_End_Inv_ID"));
                        return false;
                    }
                }
            }
        } else {
            this.setJP_ProcPeriod_Lump_Inv_ID(0);
            this.setJP_ProcPeriod_Lump_Inv_Date(null);
            this.setJP_ProcPeriod_Start_Inv_ID(0);
            this.setJP_ProcPeriod_Start_Inv_Date(null);
            this.setJP_ProcPeriod_End_Inv_ID(0);
            this.setJP_ProcPeriod_End_Inv_Date(null);
            if (!newRecord || parentJP_ContractCalender_ID != 0) {
                MContractProcPeriod inv_End_ProcPeriod;
                MContractCalender inv_Calender = MContractCalender.get(this.getCtx(), this.getJP_ContractCalender_Inv_ID());
                MContractProcPeriod inv_Start_ProcPeriod = inv_Calender.getContractProcessPeriod(this.getCtx(), this.getParent().getJP_ContractProcDate_From());
                if (inv_Start_ProcPeriod == null) {
                    this.log.saveError("Error", String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"NotFound")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"JP_ContractCalender_Inv_ID") + " - " + Msg.getElement((Properties)this.getCtx(), (String)"JP_ContractProcPeriod_ID") + " - " + Msg.getElement((Properties)this.getCtx(), (String)"JP_ContractProcDate_From"));
                    return false;
                }
                if (this.getParent().getJP_ContractProcDate_To() != null && (inv_End_ProcPeriod = inv_Calender.getContractProcessPeriod(this.getCtx(), this.getParent().getJP_ContractProcDate_To())) == null) {
                    this.log.saveError("Error", String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"NotFound")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"JP_ContractCalender_Inv_ID") + " - " + Msg.getElement((Properties)this.getCtx(), (String)"JP_ContractProcPeriod_ID") + " - " + Msg.getElement((Properties)this.getCtx(), (String)"JP_ContractProcDate_To"));
                    return false;
                }
            }
        }
        if (!newRecord && this.getJP_ContractProcess_Inv_ID() == 0) {
            this.log.saveError("Error", Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Mandatory", (Object[])new Object[]{Msg.getElement((Properties)Env.getCtx(), (String)"JP_ContractProcess_Inv_ID")}));
            return false;
        }
        return true;
    }

    private boolean checkDerivativeDocPeriodCorrespondence(boolean newRecord) {
        int parentJP_ContractCalender_ID = this.getParent().getJP_ContractCalender_ID();
        if (this.getJP_DerivativeDocPolicy_InOut().equals("LP") && this.getJP_DerivativeDocPolicy_Inv().equals("LP") || this.getJP_DerivativeDocPolicy_InOut().equals("LP") && this.getJP_DerivativeDocPolicy_Inv().equals("PB") || this.getJP_DerivativeDocPolicy_InOut().equals("PB") && this.getJP_DerivativeDocPolicy_Inv().equals("LP")) {
            MContractCalender order_Calender = MContractCalender.get(this.getCtx(), parentJP_ContractCalender_ID);
            if (this.getJP_DerivativeDocPolicy_InOut().equals("LP")) {
                if (newRecord && (this.getJP_ProcPeriod_Lump_InOut_ID() == 0 || parentJP_ContractCalender_ID == 0)) {
                    return true;
                }
                MContractProcPeriod inout_ProcPeriod = MContractProcPeriod.get(this.getCtx(), this.getJP_ProcPeriod_Lump_InOut_ID());
                MContractProcPeriod order_Start_ProcPeriod = order_Calender.getContractProcessPeriod(this.getCtx(), inout_ProcPeriod.getStartDate());
                MContractProcPeriod order_End_ProcPeriod = order_Calender.getContractProcessPeriod(this.getCtx(), inout_ProcPeriod.getEndDate());
                if (order_Start_ProcPeriod.getJP_ContractProcPeriod_ID() != order_End_ProcPeriod.getJP_ContractProcPeriod_ID()) {
                    this.log.saveError("Error", Msg.getMsg((Properties)this.getCtx(), (String)"JP_StepOverBaseDocContractProcessPeriod"));
                    return false;
                }
                int inout_Order_ProcPeriod_ID = order_Start_ProcPeriod.getJP_ContractProcPeriod_ID();
                if (this.getJP_DerivativeDocPolicy_Inv().equals("LP")) {
                    MContractProcPeriod inv_ProcPeriod = MContractProcPeriod.get(this.getCtx(), this.getJP_ProcPeriod_Lump_Inv_ID());
                    order_Start_ProcPeriod = order_Calender.getContractProcessPeriod(this.getCtx(), inv_ProcPeriod.getStartDate());
                    order_End_ProcPeriod = order_Calender.getContractProcessPeriod(this.getCtx(), inv_ProcPeriod.getEndDate());
                    if (order_Start_ProcPeriod.getJP_ContractProcPeriod_ID() != order_End_ProcPeriod.getJP_ContractProcPeriod_ID()) {
                        this.log.saveError("Error", Msg.getMsg((Properties)this.getCtx(), (String)"JP_StepOverBaseDocContractProcessPeriod"));
                        return false;
                    }
                    int inv_Order_ProcPeriod_ID = order_Start_ProcPeriod.getJP_ContractProcPeriod_ID();
                    if (inout_Order_ProcPeriod_ID != inv_Order_ProcPeriod_ID) {
                        this.log.saveError("Error", Msg.getMsg((Properties)this.getCtx(), (String)"JP_InconsistencyContractProcPeriodBetweenDerivativeDoc"));
                        return false;
                    }
                } else if (this.getJP_DerivativeDocPolicy_Inv().equals("PB")) {
                    MContractProcPeriod procPeriod_Start_inv = MContractProcPeriod.get(this.getCtx(), this.getJP_ProcPeriod_Start_Inv_ID());
                    MContractProcPeriod procPeriod_End_inv = MContractProcPeriod.get(this.getCtx(), this.getJP_ProcPeriod_End_Inv_ID());
                    order_Start_ProcPeriod = order_Calender.getContractProcessPeriod(this.getCtx(), procPeriod_Start_inv.getStartDate());
                    order_End_ProcPeriod = order_Calender.getContractProcessPeriod(this.getCtx(), procPeriod_End_inv.getEndDate());
                    if (order_Start_ProcPeriod.getJP_ContractProcPeriod_ID() != order_End_ProcPeriod.getJP_ContractProcPeriod_ID()) {
                        this.log.saveError("Error", Msg.getMsg((Properties)this.getCtx(), (String)"JP_StepOverBaseDocContractProcessPeriod"));
                        return false;
                    }
                    int inv_Order_ProcPeriod_ID = order_Start_ProcPeriod.getJP_ContractProcPeriod_ID();
                    if (inv_Order_ProcPeriod_ID != inout_Order_ProcPeriod_ID) {
                        this.log.saveError("Error", Msg.getMsg((Properties)this.getCtx(), (String)"JP_InconsistencyContractProcPeriodBetweenDerivativeDoc"));
                        return false;
                    }
                }
            } else if (this.getJP_DerivativeDocPolicy_InOut().equals("PB")) {
                if (newRecord && (this.getJP_ProcPeriod_Lump_Inv_ID() == 0 || parentJP_ContractCalender_ID == 0)) {
                    return true;
                }
                if (this.getJP_DerivativeDocPolicy_Inv().equals("LP")) {
                    MContractProcPeriod inv_ProcPeriod = MContractProcPeriod.get(this.getCtx(), this.getJP_ProcPeriod_Lump_Inv_ID());
                    MContractProcPeriod order_Start_ProcPeriod = order_Calender.getContractProcessPeriod(this.getCtx(), inv_ProcPeriod.getStartDate());
                    MContractProcPeriod order_End_ProcPeriod = order_Calender.getContractProcessPeriod(this.getCtx(), inv_ProcPeriod.getEndDate());
                    if (order_Start_ProcPeriod.getJP_ContractProcPeriod_ID() != order_End_ProcPeriod.getJP_ContractProcPeriod_ID()) {
                        this.log.saveError("Error", Msg.getMsg((Properties)this.getCtx(), (String)"JP_StepOverBaseDocContractProcessPeriod"));
                        return false;
                    }
                    int inv_Order_ProcPeriod_ID = order_Start_ProcPeriod.getJP_ContractProcPeriod_ID();
                    MContractProcPeriod procPeriod_Start_inout = MContractProcPeriod.get(this.getCtx(), this.getJP_ProcPeriod_Start_InOut_ID());
                    MContractProcPeriod procPeriod_End_inout = MContractProcPeriod.get(this.getCtx(), this.getJP_ProcPeriod_End_InOut_ID());
                    order_Start_ProcPeriod = order_Calender.getContractProcessPeriod(this.getCtx(), procPeriod_Start_inout.getStartDate());
                    order_End_ProcPeriod = order_Calender.getContractProcessPeriod(this.getCtx(), procPeriod_End_inout.getEndDate());
                    if (order_Start_ProcPeriod.getJP_ContractProcPeriod_ID() != order_End_ProcPeriod.getJP_ContractProcPeriod_ID()) {
                        this.log.saveError("Error", Msg.getMsg((Properties)this.getCtx(), (String)"JP_StepOverBaseDocContractProcessPeriod"));
                        return false;
                    }
                    int inout_Order_ProcPeriod_ID = order_Start_ProcPeriod.getJP_ContractProcPeriod_ID();
                    if (inv_Order_ProcPeriod_ID != inout_Order_ProcPeriod_ID) {
                        this.log.saveError("Error", Msg.getMsg((Properties)this.getCtx(), (String)"JP_InconsistencyContractProcPeriodBetweenDerivativeDoc"));
                        return false;
                    }
                }
            }
        } else if (this.getJP_DerivativeDocPolicy_InOut().equals("PB") && this.getJP_DerivativeDocPolicy_Inv().equals("PB")) {
            if (newRecord && (this.getJP_ProcPeriod_Start_InOut_ID() == 0 && this.getJP_ProcPeriod_Start_Inv_ID() == 0 && this.getJP_ProcPeriod_End_InOut_ID() == 0 && this.getJP_ProcPeriod_End_Inv_ID() == 0 || parentJP_ContractCalender_ID == 0)) {
                return true;
            }
            MContractCalender order_Calender = MContractCalender.get(this.getCtx(), this.getParent().getJP_ContractCalender_ID());
            MContractProcPeriod inout_ProcPeriod = MContractProcPeriod.get(this.getCtx(), this.getJP_ProcPeriod_Start_InOut_ID());
            MContractProcPeriod order_Start_ProcPeriod_InOut = order_Calender.getContractProcessPeriod(this.getCtx(), inout_ProcPeriod.getStartDate());
            MContractProcPeriod invoice_ProcPeriod = MContractProcPeriod.get(this.getCtx(), this.getJP_ProcPeriod_Start_Inv_ID());
            MContractProcPeriod order_Start_ProcPeriod_Inv = order_Calender.getContractProcessPeriod(this.getCtx(), invoice_ProcPeriod.getStartDate());
            if (order_Start_ProcPeriod_InOut.getJP_ContractProcPeriod_ID() != order_Start_ProcPeriod_Inv.getJP_ContractProcPeriod_ID()) {
                this.log.saveError("Error", Msg.getMsg((Properties)this.getCtx(), (String)"JP_InconsistencyStartProcPeriodBetweenDerivativeDoc"));
                return false;
            }
            inout_ProcPeriod = MContractProcPeriod.get(this.getCtx(), this.getJP_ProcPeriod_End_InOut_ID());
            MContractProcPeriod order_End_ProcPeriod_InOut = order_Calender.getContractProcessPeriod(this.getCtx(), inout_ProcPeriod.getEndDate());
            invoice_ProcPeriod = MContractProcPeriod.get(this.getCtx(), this.getJP_ProcPeriod_End_Inv_ID());
            MContractProcPeriod order_End_ProcPeriod_Inv = order_Calender.getContractProcessPeriod(this.getCtx(), invoice_ProcPeriod.getEndDate());
            if (order_End_ProcPeriod_InOut.getJP_ContractProcPeriod_ID() != order_End_ProcPeriod_Inv.getJP_ContractProcPeriod_ID()) {
                this.log.saveError("Error", Msg.getMsg((Properties)this.getCtx(), (String)"JP_InconsistencyEndProcPeriodBetweenDerivativeDoc"));
                return false;
            }
        } else if (this.getJP_DerivativeDocPolicy_InOut().equals("PS") && this.getJP_DerivativeDocPolicy_Inv().equals("PS")) {
            if (newRecord && (this.getJP_ProcPeriod_Start_InOut_ID() == 0 && this.getJP_ProcPeriod_Start_Inv_ID() == 0 || parentJP_ContractCalender_ID == 0)) {
                return true;
            }
            MContractCalender order_Calender = MContractCalender.get(this.getCtx(), this.getParent().getJP_ContractCalender_ID());
            MContractProcPeriod inout_ProcPeriod = MContractProcPeriod.get(this.getCtx(), this.getJP_ProcPeriod_Start_InOut_ID());
            MContractProcPeriod order_Start_ProcPeriod_InOut = order_Calender.getContractProcessPeriod(this.getCtx(), inout_ProcPeriod.getStartDate());
            MContractProcPeriod invoice_ProcPeriod = MContractProcPeriod.get(this.getCtx(), this.getJP_ProcPeriod_Start_Inv_ID());
            MContractProcPeriod order_Start_ProcPeriod_Inv = order_Calender.getContractProcessPeriod(this.getCtx(), invoice_ProcPeriod.getStartDate());
            if (order_Start_ProcPeriod_InOut.getJP_ContractProcPeriod_ID() != order_Start_ProcPeriod_Inv.getJP_ContractProcPeriod_ID()) {
                this.log.saveError("Error", Msg.getMsg((Properties)this.getCtx(), (String)"JP_InconsistencyStartProcPeriodBetweenDerivativeDoc"));
                return false;
            }
        } else if (this.getJP_DerivativeDocPolicy_InOut().equals("PE") && this.getJP_DerivativeDocPolicy_Inv().equals("PE")) {
            if (newRecord && (this.getJP_ProcPeriod_End_InOut_ID() == 0 && this.getJP_ProcPeriod_End_Inv_ID() == 0 || parentJP_ContractCalender_ID == 0)) {
                return true;
            }
            MContractCalender order_Calender = MContractCalender.get(this.getCtx(), this.getParent().getJP_ContractCalender_ID());
            MContractProcPeriod inout_ProcPeriod = MContractProcPeriod.get(this.getCtx(), this.getJP_ProcPeriod_End_InOut_ID());
            MContractProcPeriod order_End_ProcPeriod_InOut = order_Calender.getContractProcessPeriod(this.getCtx(), inout_ProcPeriod.getEndDate());
            MContractProcPeriod invoice_ProcPeriod = MContractProcPeriod.get(this.getCtx(), this.getJP_ProcPeriod_End_Inv_ID());
            MContractProcPeriod order_End_ProcPeriod_Inv = order_Calender.getContractProcessPeriod(this.getCtx(), invoice_ProcPeriod.getEndDate());
            if (order_End_ProcPeriod_InOut.getJP_ContractProcPeriod_ID() != order_End_ProcPeriod_Inv.getJP_ContractProcPeriod_ID()) {
                this.log.saveError("Error", Msg.getMsg((Properties)this.getCtx(), (String)"JP_InconsistencyEndProcPeriodBetweenDerivativeDoc"));
                return false;
            }
        } else if (!this.getJP_DerivativeDocPolicy_InOut().equals("DD") || !this.getJP_DerivativeDocPolicy_Inv().equals("DD")) {
            this.log.saveError("Error", Msg.getMsg((Properties)this.getCtx(), (String)"JP_Inconsistency", (Object[])new Object[]{Msg.getElement((Properties)Env.getCtx(), (String)"JP_DerivativeDocPolicy_InOut"), Msg.getElement((Properties)Env.getCtx(), (String)"JP_DerivativeDocPolicy_Inv")}));
            return false;
        }
        return true;
    }

    private boolean checkDerivativeInOutAndBaseDocPeriodCorrespondence(boolean newRecord) {
        if (this.getJP_DerivativeDocPolicy_InOut().equals("LP")) {
            if (newRecord && this.getJP_ProcPeriod_Lump_InOut_ID() == 0) {
                return true;
            }
            MContractCalender order_Calender = MContractCalender.get(this.getCtx(), this.getParent().getJP_ContractCalender_ID());
            MContractProcPeriod inout_ProcPeriod = MContractProcPeriod.get(this.getCtx(), this.getJP_ProcPeriod_Lump_InOut_ID());
            MContractProcPeriod order_Start_ProcPeriod = order_Calender.getContractProcessPeriod(this.getCtx(), inout_ProcPeriod.getStartDate());
            MContractProcPeriod order_End_ProcPeriod = order_Calender.getContractProcessPeriod(this.getCtx(), inout_ProcPeriod.getEndDate());
            if (order_Start_ProcPeriod.getJP_ContractProcPeriod_ID() != order_End_ProcPeriod.getJP_ContractProcPeriod_ID()) {
                this.log.saveError("Error", Msg.getMsg((Properties)this.getCtx(), (String)"JP_StepOverBaseDocContractProcessPeriod"));
                return false;
            }
        }
        return true;
    }

    private boolean checkDerivativeInvoiceAndBaseDocPeriodCorrespondence(boolean newRecord) {
        if (this.getJP_DerivativeDocPolicy_Inv().equals("LP")) {
            if (newRecord && this.getJP_ProcPeriod_Lump_Inv_ID() == 0) {
                return true;
            }
            MContractCalender order_Calender = MContractCalender.get(this.getCtx(), this.getParent().getJP_ContractCalender_ID());
            MContractProcPeriod inv_ProcPeriod = MContractProcPeriod.get(this.getCtx(), this.getJP_ProcPeriod_Lump_Inv_ID());
            MContractProcPeriod order_Start_ProcPeriod = order_Calender.getContractProcessPeriod(this.getCtx(), inv_ProcPeriod.getStartDate());
            MContractProcPeriod order_End_ProcPeriod = order_Calender.getContractProcessPeriod(this.getCtx(), inv_ProcPeriod.getEndDate());
            if (order_Start_ProcPeriod.getJP_ContractProcPeriod_ID() != order_End_ProcPeriod.getJP_ContractProcPeriod_ID()) {
                this.log.saveError("Error", Msg.getMsg((Properties)this.getCtx(), (String)"JP_StepOverBaseDocContractProcessPeriod"));
                return false;
            }
        }
        return true;
    }

    private boolean checkContainContractProcDate(MContractProcPeriod period) {
        if (this.getParent().getJP_ContractProcDate_To() == null) {
            return this.getParent().getJP_ContractProcDate_From().compareTo(period.getEndDate()) <= 0;
        }
        return this.getParent().getJP_ContractProcDate_From().compareTo(period.getEndDate()) <= 0 && this.getParent().getJP_ContractProcDate_To().compareTo(period.getStartDate()) >= 0;
    }

    private boolean checkContainContractProcDate(Timestamp date) {
        if (this.getParent().getJP_ContractProcDate_To() == null) {
            return this.getParent().getJP_ContractProcDate_From().compareTo(date) <= 0;
        }
        return this.getParent().getJP_ContractProcDate_From().compareTo(date) <= 0 && this.getParent().getJP_ContractProcDate_To().compareTo(date) >= 0;
    }
}

