/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.model;

import java.sql.ResultSet;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.Properties;
import jpiere.base.plugin.org.adempiere.model.X_JP_ContractExtendPeriod;
import org.compiere.util.CCache;
import org.compiere.util.Msg;

public class MContractExtendPeriod
extends X_JP_ContractExtendPeriod {
    private static CCache<Integer, MContractExtendPeriod> s_cache = new CCache("JP_ContractExtendPeriod", 20);

    public MContractExtendPeriod(Properties ctx, int JP_ContractExtendPeriod_ID, String trxName) {
        super(ctx, JP_ContractExtendPeriod_ID, trxName);
    }

    public MContractExtendPeriod(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    protected boolean beforeSave(boolean newRecord) {
        if ((newRecord || this.is_ValueChanged("JP_Day") || this.is_ValueChanged("IsDueFixed")) && this.isDueFixed() && (this.getJP_Day() > 31 || this.getJP_Day() <= 0)) {
            this.log.saveError("Error", String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Invalid")) + Msg.getElement((Properties)this.getCtx(), (String)"JP_Day"));
            return false;
        }
        return true;
    }

    public static MContractExtendPeriod get(Properties ctx, int JP_ContractExxtendPeriod_ID) {
        Integer ii = JP_ContractExxtendPeriod_ID;
        MContractExtendPeriod retValue = (MContractExtendPeriod)s_cache.get((Object)ii);
        if (retValue != null) {
            return retValue;
        }
        retValue = new MContractExtendPeriod(ctx, JP_ContractExxtendPeriod_ID, null);
        if (retValue.get_ID() != 0) {
            s_cache.put((Object)JP_ContractExxtendPeriod_ID, (Object)retValue);
        }
        return retValue;
    }

    public Timestamp calculateNewPeriodEndDate(Timestamp old_PeriodEndDate) {
        return this.calculateNewPeriodEndDate(old_PeriodEndDate.toLocalDateTime());
    }

    public Timestamp calculateNewPeriodEndDate(LocalDateTime old_PeriodEndDate) {
        if (this.isDueFixed()) {
            old_PeriodEndDate = old_PeriodEndDate.plusYears(this.getJP_Year()).plusMonths(this.getJP_Month());
            if (this.getJP_Day() == 31) {
                return Timestamp.valueOf(old_PeriodEndDate.plusMonths(1L).withDayOfMonth(1).minusDays(1L));
            }
            if (this.getJP_Day() == 0) {
                return Timestamp.valueOf(old_PeriodEndDate);
            }
            return Timestamp.valueOf(old_PeriodEndDate.withDayOfMonth(this.getJP_Day()));
        }
        return Timestamp.valueOf(old_PeriodEndDate.plusYears(this.getJP_Year()).plusMonths(this.getJP_Month()).plusDays(this.getJP_Day()));
    }
}

