/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.base;

import java.util.List;
import java.util.Properties;
import org.compiere.model.MClient;
import org.compiere.model.MDocType;
import org.compiere.model.MMovement;
import org.compiere.model.MMovementLine;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.util.CLogger;

public class JPiereOrderModelValidator
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(JPiereOrderModelValidator.class);
    private int AD_Client_ID = -1;
    private int AD_Org_ID = -1;
    private int AD_Role_ID = -1;
    private int AD_User_ID = -1;

    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.AD_Client_ID = client.getAD_Client_ID();
        }
        engine.addModelChange("C_Order", (ModelValidator)this);
        engine.addDocValidate("C_Order", (ModelValidator)this);
    }

    public int getAD_Client_ID() {
        return this.AD_Client_ID;
    }

    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        this.AD_Org_ID = AD_Org_ID;
        this.AD_Role_ID = AD_Role_ID;
        this.AD_User_ID = AD_User_ID;
        return null;
    }

    public String modelChange(PO po, int type) throws Exception {
        if (type == 1 || type == 2 && po.is_ValueChanged("C_DocTypeTarget_ID") || type == 2 && po.is_ValueChanged("M_PriceList_ID")) {
            MOrder order = (MOrder)po;
            order.setIsSOTrx(order.getC_DocTypeTarget().isSOTrx());
            order.setIsTaxIncluded(order.getM_PriceList().isTaxIncluded());
            order.setC_Currency_ID(order.getM_PriceList().getC_Currency_ID());
        }
        return null;
    }

    public String docValidate(PO po, int timing) {
        MOrder order;
        MDocType docType;
        int JP_DocTypeMM_ID;
        if (timing == 9 && (JP_DocTypeMM_ID = (docType = MDocType.get((Properties)(order = (MOrder)po).getCtx(), (int)order.getC_DocTypeTarget_ID())).get_ValueAsInt("JP_DocTypeMM_ID")) > 0 && order.isSOTrx()) {
            MOrderLine[] oLines = order.getLines();
            MMovement mm = null;
            int i = 0;
            while (i < oLines.length) {
                int JP_LocatorFrom_ID = oLines[i].get_ValueAsInt("JP_LocatorFrom_ID");
                int JP_LocatorTo_ID = oLines[i].get_ValueAsInt("JP_LocatorTo_ID");
                int JP_MovementLine_ID = oLines[i].get_ValueAsInt("JP_MovementLine_ID");
                if (JP_LocatorFrom_ID > 0 && JP_LocatorTo_ID > 0 && JP_MovementLine_ID == 0) {
                    if (mm == null) {
                        mm = new MMovement(order.getCtx(), 0, order.get_TrxName());
                        mm.setAD_Org_ID(order.getAD_Org_ID());
                        mm.setC_DocType_ID(JP_DocTypeMM_ID);
                        mm.setMovementDate(order.getDateOrdered());
                        mm.setSalesRep_ID(order.getSalesRep_ID());
                        mm.setC_BPartner_ID(order.getC_BPartner_ID());
                        mm.setC_BPartner_Location_ID(order.getC_BPartner_Location_ID());
                        mm.setAD_User_ID(order.getAD_User_ID());
                        mm.setPOReference(order.getPOReference());
                        mm.setC_Project_ID(order.getC_Project_ID());
                        mm.setC_Activity_ID(order.getC_Activity_ID());
                        mm.setC_Campaign_ID(order.getC_Campaign_ID());
                        mm.set_ValueNoCheck("JP_Order_ID", (Object)order.getC_Order_ID());
                        mm.saveEx(order.get_TrxName());
                    }
                    MMovementLine line = new MMovementLine(mm);
                    line.setLine(oLines[i].getLine());
                    line.setDescription(oLines[i].getDescription());
                    line.setM_Product_ID(oLines[i].getM_Product_ID());
                    line.setM_Locator_ID(JP_LocatorFrom_ID);
                    line.setM_LocatorTo_ID(JP_LocatorTo_ID);
                    line.setM_AttributeSetInstance_ID(oLines[i].get_ValueAsInt("JP_ASI_From_ID"));
                    line.setM_AttributeSetInstanceTo_ID(oLines[i].get_ValueAsInt("JP_ASI_To_ID"));
                    line.setMovementQty(oLines[i].getQtyOrdered());
                    line.saveEx(order.get_TrxName());
                    oLines[i].set_ValueNoCheck("JP_MovementLine_ID", (Object)line.getM_MovementLine_ID());
                    oLines[i].saveEx(order.get_TrxName());
                }
                ++i;
            }
            if (mm != null) {
                mm.processIt("CO");
                mm.saveEx(order.get_TrxName());
                mm = null;
            }
        }
        if ((timing == 10 || timing == 14 || timing == 13) && (order = (MOrder)po).isSOTrx()) {
            String whereClause = "SELECT JP_Order_ID =? ";
            List list = new Query(order.getCtx(), "M_Movement", "SELECT JP_Order_ID =? ", order.get_TrxName()).setParameters(new Object[]{order.getC_Order_ID()}).list();
            for (MMovement mm : list) {
                if (!mm.getDocStatus().equals("CO")) continue;
                if (timing == 14) {
                    mm.processIt("RA");
                } else {
                    mm.processIt("RC");
                }
                mm.saveEx(order.get_TrxName());
            }
        }
        return null;
    }
}

