/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.base;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Properties;
import jpiere.base.plugin.org.adempiere.base.IJPiereTaxProvider;
import jpiere.base.plugin.org.adempiere.model.JPiereTaxProvider;
import jpiere.base.plugin.util.JPiereUtil;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MCharge;
import org.compiere.model.MClient;
import org.compiere.model.MCurrency;
import org.compiere.model.MDocType;
import org.compiere.model.MLocator;
import org.compiere.model.MOrderLine;
import org.compiere.model.MOrgInfo;
import org.compiere.model.MSysConfig;
import org.compiere.model.MTax;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.model.ProductCost;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class JPiereOrderLineModelValidator
implements ModelValidator {
    static final String PROHIBIT_CHANGE_QTY = "PCQ";
    static final String ALLOW_INCREASE_QTY = "AIQ";
    static final String ALLOW_CHANGE_QTY_WHEN_RESERVED = "ACR";
    static final String ALLOW_CHANGE_AMT_WHEN_NOT_INVOICED = "ANI";
    static final String NON = "NON";
    private int AD_Client_ID = -1;

    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.AD_Client_ID = client.getAD_Client_ID();
        }
        engine.addModelChange("C_OrderLine", (ModelValidator)this);
    }

    public int getAD_Client_ID() {
        return this.AD_Client_ID;
    }

    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        return null;
    }

    public String modelChange(PO po, int type) throws Exception {
        MOrderLine orderLine;
        MOrderLine oLine;
        MOrderLine ol;
        String sql;
        int no;
        MOrderLine ol2;
        if (type == 1 || type == 2 && (po.is_ValueChanged("LineNetAmt") || po.is_ValueChanged("C_Tax_ID"))) {
            MCharge charge;
            BigDecimal taxAmt = Env.ZERO;
            ol2 = (MOrderLine)po;
            MTax m_tax = MTax.get((Properties)Env.getCtx(), (int)ol2.getC_Tax_ID());
            if (m_tax == null) {
                return null;
            }
            IJPiereTaxProvider taxCalculater = JPiereUtil.getJPiereTaxProvider(m_tax);
            boolean isTaxIncluded = ol2.isTaxIncluded();
            if (ol2.getC_Charge_ID() != 0 && !(charge = MCharge.get((Properties)Env.getCtx(), (int)ol2.getC_Charge_ID())).isSameTax()) {
                isTaxIncluded = charge.isTaxIncluded();
            }
            taxAmt = taxCalculater != null ? taxCalculater.calculateTax(m_tax, ol2.getLineNetAmt(), isTaxIncluded, MCurrency.getStdPrecision((Properties)po.getCtx(), (int)ol2.getParent().getC_Currency_ID()), JPiereTaxProvider.getRoundingMode(ol2.getParent().getC_BPartner_ID(), ol2.getParent().isSOTrx(), m_tax.getC_TaxProvider())) : m_tax.calculateTax(ol2.getLineNetAmt(), isTaxIncluded, MCurrency.getStdPrecision((Properties)ol2.getCtx(), (int)ol2.getParent().getC_Currency_ID()));
            if (isTaxIncluded) {
                ol2.set_ValueNoCheck("JP_TaxBaseAmt", (Object)ol2.getLineNetAmt().subtract(taxAmt));
            } else {
                ol2.set_ValueNoCheck("JP_TaxBaseAmt", (Object)ol2.getLineNetAmt());
            }
            ol2.set_ValueOfColumn("JP_TaxAmt", (Object)taxAmt);
        }
        if (type == 1 || type == 2) {
            String config = MSysConfig.getValue((String)"JPIERE_SET_COST_TO_ORDER-LINE", (String)"NO", (int)Env.getAD_Client_ID((Properties)Env.getCtx()));
            ol2 = (MOrderLine)po;
            if (ol2.getM_Product_ID() != 0 && !config.equals("NO") && (type == 1 || ol2.is_ValueChanged("M_Product_ID") || ol2.is_ValueChanged("QtyOrdered") || ol2.is_ValueChanged("JP_ScheduledCost"))) {
                BigDecimal cost = (BigDecimal)ol2.get_Value("JP_ScheduledCost");
                if (cost == null) {
                    cost = Env.ZERO;
                }
                if (cost.compareTo(Env.ZERO) == 0 && type == 1 || type == 2 && ol2.is_ValueChanged("M_Product_ID") && !ol2.is_ValueChanged("JP_ScheduledCost")) {
                    if (config.equals("BT")) {
                        this.setScheduledCost(ol2);
                    } else if (config.equals("SO") && ol2.getParent().isSOTrx()) {
                        this.setScheduledCost(ol2);
                    } else if (config.equals("PO") && !ol2.getParent().isSOTrx()) {
                        this.setScheduledCost(ol2);
                    }
                    cost = (BigDecimal)ol2.get_Value("JP_ScheduledCost");
                }
                if (config.equals("BT")) {
                    ol2.set_ValueNoCheck("JP_ScheduledCostLineAmt", (Object)cost.multiply(ol2.getQtyOrdered()));
                } else if (config.equals("SO") && ol2.getParent().isSOTrx()) {
                    ol2.set_ValueNoCheck("JP_ScheduledCostLineAmt", (Object)cost.multiply(ol2.getQtyOrdered()));
                } else if (config.equals("PO") && !ol2.getParent().isSOTrx()) {
                    ol2.set_ValueNoCheck("JP_ScheduledCostLineAmt", (Object)cost.multiply(ol2.getQtyOrdered()));
                }
            } else if (ol2.getM_Product_ID() == 0) {
                ol2.set_ValueNoCheck("JP_ScheduledCost", (Object)Env.ZERO);
                ol2.set_ValueNoCheck("JP_ScheduledCostLineAmt", (Object)Env.ZERO);
            }
        } else if (type == 5 && po.is_ValueChanged("JP_ScheduledCost") && (no = DB.executeUpdate((String)(sql = "UPDATE C_Order i SET JP_ScheduledCostTotalLines = (SELECT COALESCE(SUM(JP_ScheduledCostLineAmt),0) FROM C_OrderLine il WHERE i.C_Order_ID=il.C_Order_ID)WHERE C_Order_ID = ?"), (Object[])new Object[]{new Integer((ol = (MOrderLine)po).getC_Order_ID())}, (boolean)false, (String)ol.get_TrxName(), (int)0)) != 1) {
            return "Error";
        }
        if (type == 2) {
            ol = (MOrderLine)po;
            boolean isSOTrx = ol.getParent().isSOTrx();
            String QTY_CHECK = NON;
            QTY_CHECK = isSOTrx ? MSysConfig.getValue((String)"JP_SO_REACTIVATE_QTY_CHECK", (String)NON, (int)ol.getAD_Client_ID(), (int)ol.getAD_Org_ID()) : MSysConfig.getValue((String)"JP_PO_REACTIVATE_QTY_CHECK", (String)NON, (int)ol.getAD_Client_ID(), (int)ol.getAD_Org_ID());
            if (!QTY_CHECK.equals(NON)) {
                if (QTY_CHECK.equals(PROHIBIT_CHANGE_QTY) || ol.get_ValueAsInt("JP_MovementLine_ID") > 0) {
                    if (!(!ol.is_ValueChanged("QtyOrdered") || ol.getParent().getDocAction().equals("VO") || ol.getParent().getDocAction().equals("CL") || ol.getQtyReserved().compareTo(Env.ZERO) == 0 && ol.getQtyDelivered().compareTo(Env.ZERO) == 0 && ol.getQtyInvoiced().compareTo(Env.ZERO) == 0)) {
                        if (ol.get_ValueAsInt("JP_MovementLine_ID") > 0) {
                            return Msg.getMsg((Properties)Env.getCtx(), (String)"JP_CanNotChangeQtyForMM");
                        }
                        if (isSOTrx) {
                            return Msg.getMsg((Properties)Env.getCtx(), (String)"JP_CanNotChangeAmountForQtyReservedSO");
                        }
                        return Msg.getMsg((Properties)Env.getCtx(), (String)"JP_CanNotChangeAmountForQtyReservedPO");
                    }
                } else if (QTY_CHECK.equals(ALLOW_INCREASE_QTY)) {
                    if (!(!ol.is_ValueChanged("QtyOrdered") || ol.getParent().getDocAction().equals("VO") || ol.getParent().getDocAction().equals("CL") || ol.getQtyOrdered().compareTo(ol.getQtyDelivered()) >= 0 && ol.getQtyOrdered().compareTo(ol.getQtyInvoiced()) >= 0)) {
                        return Msg.getMsg((Properties)Env.getCtx(), (String)"JP_CanNotChangeQtyLessThanQtyDeliveredOrQtyInvoiced");
                    }
                } else if (QTY_CHECK.equals(ALLOW_CHANGE_QTY_WHEN_RESERVED) && ol.is_ValueChanged("QtyOrdered") && !ol.getParent().getDocAction().equals("VO") && !ol.getParent().getDocAction().equals("CL") && (ol.getQtyDelivered().compareTo(Env.ZERO) != 0 || ol.getQtyInvoiced().compareTo(Env.ZERO) != 0)) {
                    return Msg.getMsg((Properties)Env.getCtx(), (String)"JP_CanNotChangeQtyForQtyDeliveredOrQtyInvoiced");
                }
            }
            String AMT_CHECK = NON;
            AMT_CHECK = isSOTrx ? MSysConfig.getValue((String)"JP_SO_REACTIVATE_AMT_CHECK", (String)NON, (int)ol.getAD_Client_ID(), (int)ol.getAD_Org_ID()) : MSysConfig.getValue((String)"JP_PO_REACTIVATE_AMT_CHECK", (String)NON, (int)ol.getAD_Client_ID(), (int)ol.getAD_Org_ID());
            if (!AMT_CHECK.equals(NON) && AMT_CHECK.equals(ALLOW_CHANGE_AMT_WHEN_NOT_INVOICED) && (ol.is_ValueChanged("PriceEntered") || ol.is_ValueChanged("C_Tax_ID")) && ol.getQtyInvoiced().compareTo(Env.ZERO) != 0 && !ol.getParent().getDocAction().equals("VO") && !ol.getParent().getDocAction().equals("CL")) {
                return Msg.getMsg((Properties)Env.getCtx(), (String)"JP_CanNotChangeAmountForQtyInvoiced");
            }
        }
        if (type == 1 || type == 2 && (po.is_ValueChanged("JP_LocatorFrom_ID") || po.is_ValueChanged("JP_LocatorTo_ID") || po.is_ValueChanged("JP_ASI_From_ID") || po.is_ValueChanged("JP_ASI_To_ID") || po.is_ValueChanged("M_Product_ID"))) {
            oLine = (MOrderLine)po;
            if (oLine.getM_Product_ID() == 0 || !oLine.getM_Product().getProductType().equals("I") || !oLine.getM_Product().isStocked()) {
                oLine.set_ValueNoCheck("JP_Locator_ID", null);
                oLine.set_ValueNoCheck("JP_LocatorFrom_ID", null);
                oLine.set_ValueNoCheck("JP_LocatorTo_ID", null);
                oLine.set_ValueNoCheck("JP_ASI_From_ID", null);
                oLine.set_ValueNoCheck("JP_ASI_To_ID", null);
            }
            int JP_LocatorFrom_ID = oLine.get_ValueAsInt("JP_LocatorFrom_ID");
            if (oLine.get_ValueAsInt("JP_LocatorFrom_ID") != 0 && (type == 1 || po.is_ValueChanged("JP_LocatorFrom_ID"))) {
                MLocator fromLocator = MLocator.get((Properties)oLine.getCtx(), (int)JP_LocatorFrom_ID);
                MOrgInfo fromLocatorOrgInfo = MOrgInfo.get((Properties)oLine.getCtx(), (int)fromLocator.getAD_Org_ID(), (String)oLine.get_TrxName());
                MOrgInfo lineOrgInfo = MOrgInfo.get((Properties)oLine.getCtx(), (int)oLine.getAD_Org_ID(), (String)oLine.get_TrxName());
                if (fromLocatorOrgInfo.get_ValueAsInt("JP_Corporation_ID") != lineOrgInfo.get_ValueAsInt("JP_Corporation_ID")) {
                    return Msg.getMsg((Properties)Env.getCtx(), (String)"JP_CanNotCreateMMForDiffCorp");
                }
            }
            int JP_LocatorTo_ID = oLine.get_ValueAsInt("JP_LocatorTo_ID");
            MDocType docType = MDocType.get((Properties)oLine.getCtx(), (int)oLine.getParent().getC_DocTypeTarget_ID());
            int JP_DocTypeMM_ID = docType.get_ValueAsInt("JP_DocTypeMM_ID");
            if (JP_DocTypeMM_ID > 0 && (JP_LocatorFrom_ID != 0 || JP_LocatorTo_ID != 0)) {
                if (oLine.get_ValueAsInt("JP_MovementLine_ID") > 0) {
                    return Msg.getMsg((Properties)Env.getCtx(), (String)"JP_CanNotChangeMMInfoForMM");
                }
                if (JP_LocatorFrom_ID > 0 && JP_LocatorTo_ID == 0) {
                    return String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"JP_PleaseInputToField")) + Msg.getElement((Properties)Env.getCtx(), (String)"JP_LocatorTo_ID");
                }
                if (JP_LocatorFrom_ID == 0 && JP_LocatorTo_ID > 0) {
                    return String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"JP_PleaseInputToField")) + Msg.getElement((Properties)Env.getCtx(), (String)"JP_LocatorFrom_ID");
                }
                if (JP_LocatorFrom_ID == JP_LocatorTo_ID) {
                    return Msg.getMsg((Properties)Env.getCtx(), (String)"JP_SameLocatorMM");
                }
                if (!MLocator.get((Properties)oLine.getCtx(), (int)JP_LocatorFrom_ID).get_Value("JP_PhysicalWarehouse_ID").equals(MLocator.get((Properties)oLine.getCtx(), (int)JP_LocatorTo_ID).get_Value("JP_PhysicalWarehouse_ID"))) {
                    return Msg.getMsg((Properties)Env.getCtx(), (String)"JP_CanNotCreateMMforDiffPhyWH");
                }
                if (!MLocator.get((Properties)oLine.getCtx(), (int)JP_LocatorFrom_ID).get_Value("M_LocatorType_ID").equals(MLocator.get((Properties)oLine.getCtx(), (int)JP_LocatorTo_ID).get_Value("M_LocatorType_ID"))) {
                    return Msg.getMsg((Properties)Env.getCtx(), (String)"JP_CanNotCreateMMforDiffLocatorType");
                }
            } else if (JP_LocatorFrom_ID != 0 || JP_LocatorTo_ID != 0) {
                return Msg.getMsg((Properties)Env.getCtx(), (String)"JP_CanNotCreateMMforDocType");
            }
        }
        if (type == 2 && (po.is_ValueChanged("JP_Locator_ID") || po.is_ValueChanged("QtyReserved"))) {
            oLine = (MOrderLine)po;
            int now_Locator_ID = oLine.get_ValueAsInt("JP_Locator_ID");
            int old_Locator_ID = oLine.get_ValueOldAsInt("JP_Locator_ID");
            Timestamp now_DateReserved = (Timestamp)oLine.get_Value("JP_DateReserved");
            Timestamp old_DateReserved = (Timestamp)oLine.get_ValueOld("JP_DateReserved");
            BigDecimal now_QtyReserved = oLine.getQtyReserved();
            BigDecimal old_QtyReserved = (BigDecimal)oLine.get_ValueOld("QtyReserved");
            if (now_Locator_ID <= 0) {
                oLine.set_ValueNoCheck("JP_DateReserved", null);
            } else if (now_QtyReserved.compareTo(Env.ZERO) != 0 && (now_DateReserved == null || old_Locator_ID != now_Locator_ID)) {
                oLine.set_ValueNoCheck("JP_DateReserved", (Object)new Timestamp(Calendar.getInstance().getTimeInMillis()));
            }
        }
        if (type == 2 && po.is_ValueChanged("QtyInvoiced") && ((ol = (MOrderLine)po).getParent().isSOTrx() && MSysConfig.getBooleanValue((String)"JP_CHECK_ORVER_QTYINVOICED_SO", (boolean)false, (int)ol.getAD_Client_ID(), (int)ol.getAD_Org_ID()) || !ol.getParent().isSOTrx() && MSysConfig.getBooleanValue((String)"JP_CHECK_ORVER_QTYINVOICED_PO", (boolean)false, (int)ol.getAD_Client_ID(), (int)ol.getAD_Org_ID()))) {
            BigDecimal qtyOrdered = ol.getQtyOrdered();
            BigDecimal qtyInvoiced = ol.getQtyInvoiced();
            if (qtyOrdered.signum() >= 0 ? qtyInvoiced.compareTo(qtyOrdered) > 0 : qtyInvoiced.compareTo(qtyOrdered) < 0) {
                return String.valueOf(Msg.getMsg((Properties)po.getCtx(), (String)"JP_Over_QtyInvoiced")) + " : " + ol.getParent().getDocumentNo() + " - " + ol.getLine();
            }
        }
        if (type == 2 && po.is_ValueChanged("QtyDelivered") && ((ol = (MOrderLine)po).getParent().isSOTrx() && MSysConfig.getBooleanValue((String)"JP_CHECK_ORVER_QTYDELIVERED_SO", (boolean)false, (int)ol.getAD_Client_ID(), (int)ol.getAD_Org_ID()) || !ol.getParent().isSOTrx() && MSysConfig.getBooleanValue((String)"JP_CHECK_ORVER_QTYDELIVERED_PO", (boolean)false, (int)ol.getAD_Client_ID(), (int)ol.getAD_Org_ID()))) {
            BigDecimal qtyOrdered = ol.getQtyOrdered();
            BigDecimal qtyDelivered = ol.getQtyDelivered();
            if (qtyOrdered.signum() >= 0 ? qtyDelivered.compareTo(qtyOrdered) > 0 : qtyDelivered.compareTo(qtyOrdered) < 0) {
                return String.valueOf(Msg.getMsg((Properties)po.getCtx(), (String)"JP_Over_QtyDelivered")) + " : " + ol.getParent().getDocumentNo() + " - " + ol.getLine();
            }
        }
        if (type == 2 && po.is_ValueChanged("JP_QtyRecognized") && ((ol = (MOrderLine)po).getParent().isSOTrx() && MSysConfig.getBooleanValue((String)"JP_CHECK_ORVER_QTYRECOGNIZED_SO", (boolean)false, (int)ol.getAD_Client_ID(), (int)ol.getAD_Org_ID()) || !ol.getParent().isSOTrx() && MSysConfig.getBooleanValue((String)"JP_CHECK_ORVER_QTYRECOGNIZED_PO", (boolean)false, (int)ol.getAD_Client_ID(), (int)ol.getAD_Org_ID()))) {
            BigDecimal qtyOrdered = ol.getQtyOrdered();
            BigDecimal qtyRecognized = (BigDecimal)ol.get_Value("JP_QtyRecognized");
            if (qtyOrdered.signum() >= 0 ? qtyRecognized.compareTo(qtyOrdered) > 0 : qtyRecognized.compareTo(qtyOrdered) < 0) {
                return String.valueOf(Msg.getMsg((Properties)po.getCtx(), (String)"JP_Over_QtyRecognized")) + " : " + ol.getParent().getDocumentNo() + " - " + ol.getLine();
            }
        }
        if ((type == 1 || type == 2) && (orderLine = (MOrderLine)po).getRef_OrderLine_ID() > 0) {
            MOrderLine counterOrderLine = new MOrderLine(po.getCtx(), orderLine.getRef_OrderLine_ID(), po.get_TrxName());
            orderLine.setPriceEntered(counterOrderLine.getPriceEntered());
            orderLine.setC_UOM_ID(counterOrderLine.getC_UOM_ID());
            orderLine.setPriceActual(counterOrderLine.getPriceActual());
        }
        return null;
    }

    public String docValidate(PO po, int timing) {
        return null;
    }

    private void setScheduledCost(MOrderLine ol) {
        MAcctSchema as = MAcctSchema.get((Properties)Env.getCtx(), (int)Env.getContextAsInt((Properties)Env.getCtx(), (String)"$C_AcctSchema_ID"));
        BigDecimal cost = this.getProductCosts(ol, as, ol.getAD_Org_ID(), true);
        ol.set_ValueNoCheck("JP_ScheduledCost", (Object)cost);
    }

    private BigDecimal getProductCosts(MOrderLine ol, MAcctSchema as, int AD_Org_ID, boolean zeroCostsOK) {
        ProductCost pc = new ProductCost(Env.getCtx(), ol.getM_Product_ID(), ol.getM_AttributeSetInstance_ID(), ol.get_TrxName());
        pc.setQty(Env.ONE);
        int C_OrderLine_ID = ol.getC_OrderLine_ID();
        String costingMethod = null;
        BigDecimal costs = pc.getProductCosts(as, AD_Org_ID, costingMethod, C_OrderLine_ID, zeroCostsOK);
        if (costs != null) {
            return costs;
        }
        return Env.ZERO;
    }
}

