/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.base;

import java.math.BigDecimal;
import java.util.Properties;
import jpiere.base.plugin.org.adempiere.model.MContract;
import jpiere.base.plugin.org.adempiere.model.MContractContent;
import jpiere.base.plugin.org.adempiere.model.MContractLine;
import jpiere.base.plugin.org.adempiere.model.MContractProcPeriod;
import org.adempiere.webui.window.FDialog;
import org.compiere.model.MClient;
import org.compiere.model.MColumn;
import org.compiere.model.MDocType;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MRefList;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.process.ProcessInfo;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class JPiereContractOrderValidator
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(JPiereContractOrderValidator.class);
    private int AD_Client_ID = -1;
    private int AD_Org_ID = -1;
    private int AD_Role_ID = -1;
    private int AD_User_ID = -1;

    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.AD_Client_ID = client.getAD_Client_ID();
        }
        engine.addModelChange("C_Order", (ModelValidator)this);
        engine.addModelChange("C_OrderLine", (ModelValidator)this);
        engine.addDocValidate("C_Order", (ModelValidator)this);
        engine.addDocValidate("C_OrderLine", (ModelValidator)this);
    }

    public int getAD_Client_ID() {
        return this.AD_Client_ID;
    }

    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        this.AD_Org_ID = AD_Org_ID;
        this.AD_Role_ID = AD_Role_ID;
        this.AD_User_ID = AD_User_ID;
        return null;
    }

    public String modelChange(PO po, int type) throws Exception {
        if (po.get_TableName().equals("C_Order")) {
            return this.orderValidate(po, type);
        }
        if (po.get_TableName().equals("C_OrderLine")) {
            return this.orderLineValidate(po, type);
        }
        return null;
    }

    public String docValidate(PO po, int timing) {
        if (timing == 1) {
            MOrder order = (MOrder)po;
            int JP_Contract_ID = order.get_ValueAsInt("JP_Contract_ID");
            if (JP_Contract_ID <= 0) {
                return null;
            }
            MContract contract = MContract.get(Env.getCtx(), JP_Contract_ID);
            if (contract.getJP_ContractType().equals("PDC")) {
                MOrderLine[] lines = order.getLines();
                int JP_ContractLine_ID = 0;
                int JP_ContractProcPeriod_ID = 0;
                int i = 0;
                while (i < lines.length) {
                    JP_ContractLine_ID = lines[i].get_ValueAsInt("JP_ContractLine_ID");
                    JP_ContractProcPeriod_ID = lines[i].get_ValueAsInt("JP_ContractProcPeriod_ID");
                    if (JP_ContractLine_ID > 0 && JP_ContractProcPeriod_ID <= 0) {
                        return String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"FillMandatory")) + Msg.getElement((Properties)Env.getCtx(), (String)"JP_ContractProcPeriod_ID") + " - " + Msg.getElement((Properties)Env.getCtx(), (String)"Line") + " : " + lines[i].getLine();
                    }
                    ++i;
                }
            }
        }
        return null;
    }

    private String orderValidate(PO po, int type) {
        MOrder counterOrder;
        MOrder order;
        if (type == 1 && (order = (MOrder)po).getRef_Order_ID() > 0 && (counterOrder = new MOrder(po.getCtx(), order.getRef_Order_ID(), po.get_TrxName())).get_ValueAsInt("JP_Contract_ID") > 0) {
            MContractContent counterContractContent;
            MContract counterContract = MContract.get(po.getCtx(), counterOrder.get_ValueAsInt("JP_Contract_ID"));
            if (counterContract != null && counterContract.getJP_Contract_ID() > 0 && counterContract.getJP_CounterContract_ID() > 0) {
                order.set_ValueNoCheck("JP_Contract_ID", (Object)counterContract.getJP_CounterContract_ID());
            }
            if (counterOrder.get_ValueAsInt("JP_ContractContent_ID") > 0 && (counterContractContent = MContractContent.get(po.getCtx(), counterOrder.get_ValueAsInt("JP_ContractContent_ID"))) != null && counterContractContent.getJP_ContractContent_ID() > 0 && counterContractContent.getJP_CounterContractContent_ID() > 0) {
                order.set_ValueNoCheck("JP_ContractContent_ID", (Object)counterContractContent.getJP_CounterContractContent_ID());
            }
            if (counterOrder.get_ValueAsInt("JP_ContractProcPeriod_ID") > 0) {
                order.set_ValueNoCheck("JP_ContractProcPeriod_ID", (Object)counterOrder.get_ValueAsInt("JP_ContractProcPeriod_ID"));
            }
        }
        if (type == 1 || type == 2 && (po.is_ValueChanged("JP_Contract_ID") || po.is_ValueChanged("JP_ContractContent_ID") || po.is_ValueChanged("JP_ContractProcPeriod_ID") || po.is_ValueChanged("C_DocTypeTarget_ID"))) {
            MOrderLine[] contractOrderLines;
            order = (MOrder)po;
            ProcessInfo pInfo = Env.getProcessInfo((Properties)Env.getCtx());
            int JP_Contract_ID = order.get_ValueAsInt("JP_Contract_ID");
            if (JP_Contract_ID <= 0) {
                if (order.get_ValueAsInt("JP_ContractContent_ID") != 0 || order.get_ValueAsInt("JP_ContractProcPeriod_ID") != 0) {
                    order.set_ValueNoCheck("JP_ContractContent_ID", null);
                    order.set_ValueNoCheck("JP_ContractProcPeriod_ID", null);
                    if (pInfo == null) {
                        String nonEnterable = Msg.getMsg((Properties)Env.getCtx(), (String)"JP_NON-ENTERABLE");
                        String contractContent = Msg.getElement((Properties)Env.getCtx(), (String)"JP_ContractContent_ID");
                        String contractPeriod = Msg.getElement((Properties)Env.getCtx(), (String)"JP_ContractProcPeriod_ID");
                        String toBeConfirmed = Msg.getMsg((Properties)Env.getCtx(), (String)"JP_ToBeConfirmed");
                        Object[] objs = new Object[]{Msg.getElement((Properties)Env.getCtx(), (String)"JP_Contract_ID")};
                        String message = Msg.getMsg((Properties)Env.getCtx(), (String)"JP_NOT-INOUT", (Object[])objs);
                        try {
                            FDialog.info((int)0, null, (String)"JP_ContractManagementInfo", (String)(String.valueOf(nonEnterable) + " " + contractContent + " , " + contractPeriod + " -> " + toBeConfirmed + " : " + message));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                return null;
            }
            MContract contract = MContract.get(Env.getCtx(), JP_Contract_ID);
            if (type == 2 && contract.getJP_ContractType().equals("PDC") && (contractOrderLines = order.getLines(" AND JP_ContractLine_ID IS NOT NULL ", " Line ")).length > 0) {
                String msg = Msg.getMsg((Properties)Env.getCtx(), (String)"JP_CannotChangeContractInfoForLines");
                return msg;
            }
            if (contract.getJP_ContractType().equals("PDC")) {
                int JP_ContractContent_ID = order.get_ValueAsInt("JP_ContractContent_ID");
                if (JP_ContractContent_ID <= 0) {
                    Object[] objs = new Object[]{Msg.getElement((Properties)Env.getCtx(), (String)"JP_ContractContent_ID")};
                    return String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"JP_InCaseOfPeriodContract")) + Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Mandatory", (Object[])objs);
                }
                MContractContent content = MContractContent.get(Env.getCtx(), JP_ContractContent_ID);
                if (contract.getJP_Contract_ID() != content.getJP_Contract_ID()) {
                    return Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Diff_ContractDocument");
                }
                if (content.getC_BPartner_ID() != order.getC_BPartner_ID()) {
                    return Msg.getMsg((Properties)Env.getCtx(), (String)"JP_DifferentBusinessPartner_ContractContent");
                }
                if (content.getJP_BaseDocDocType_ID() != order.getC_DocTypeTarget_ID()) {
                    MDocType docType = MDocType.get((Properties)Env.getCtx(), (int)content.getJP_BaseDocDocType_ID());
                    return String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"JP_SelectDocTypeSameAsContractContent")) + " -> " + docType.getNameTrl();
                }
                int JP_ContractProcPeriod_ID = order.get_ValueAsInt("JP_ContractProcPeriod_ID");
                if (JP_ContractProcPeriod_ID <= 0) {
                    Object[] objs = new Object[]{Msg.getElement((Properties)Env.getCtx(), (String)"JP_ContractProcPeriod_ID")};
                    return String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"JP_InCaseOfPeriodContract")) + Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Mandatory", (Object[])objs);
                }
                MContractProcPeriod docContractProcPeriod = MContractProcPeriod.get(Env.getCtx(), JP_ContractProcPeriod_ID);
                if (content.getJP_ContractCalender_ID() != docContractProcPeriod.getJP_ContractCalender_ID()) {
                    return Msg.getMsg((Properties)Env.getCtx(), (String)"JP_DifferentContractCalender");
                }
                if (content.getJP_ContractProcDate_To() == null) {
                    if (content.getJP_ContractProcDate_From().compareTo(docContractProcPeriod.getEndDate()) > 0) {
                        return String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"JP_OutsideContractProcessPeriod")) + " " + Msg.getMsg((Properties)Env.getCtx(), (String)"Invalid") + Msg.getElement((Properties)Env.getCtx(), (String)"JP_ContractProcPeriod_ID");
                    }
                } else if (content.getJP_ContractProcDate_From().compareTo(docContractProcPeriod.getEndDate()) > 0 || content.getJP_ContractProcDate_To().compareTo(docContractProcPeriod.getStartDate()) < 0) {
                    return String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"JP_OutsideContractProcessPeriod")) + " " + Msg.getMsg((Properties)Env.getCtx(), (String)"Invalid") + Msg.getElement((Properties)Env.getCtx(), (String)"JP_ContractProcPeriod_ID");
                }
            } else if (contract.getJP_ContractType().equals("STC")) {
                int JP_ContractContent_ID = order.get_ValueAsInt("JP_ContractContent_ID");
                if (JP_ContractContent_ID <= 0) {
                    Object[] objs = new Object[]{Msg.getElement((Properties)Env.getCtx(), (String)"JP_ContractContent_ID")};
                    return String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"JP_InCaseOfSpotContract")) + Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Mandatory", (Object[])objs);
                }
                MContractContent content = MContractContent.get(Env.getCtx(), JP_ContractContent_ID);
                if (contract.getJP_Contract_ID() != content.getJP_Contract_ID()) {
                    return Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Diff_ContractDocument");
                }
                if (content.getC_BPartner_ID() != order.getC_BPartner_ID()) {
                    return Msg.getMsg((Properties)Env.getCtx(), (String)"JP_DifferentBusinessPartner_ContractContent");
                }
                if (content.getJP_BaseDocDocType_ID() != order.getC_DocTypeTarget_ID()) {
                    MDocType docType = MDocType.get((Properties)Env.getCtx(), (int)content.getJP_BaseDocDocType_ID());
                    return String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"JP_SelectDocTypeSameAsContractContent")) + " -> " + docType.getNameTrl();
                }
                if (order.get_ValueAsInt("JP_ContractProcPeriod_ID") != 0) {
                    order.set_ValueNoCheck("JP_ContractProcPeriod_ID", null);
                    if (pInfo == null) {
                        String nonEnterable = Msg.getMsg((Properties)Env.getCtx(), (String)"JP_NON-ENTERABLE");
                        String contractPeriod = Msg.getElement((Properties)Env.getCtx(), (String)"JP_ContractProcPeriod_ID");
                        String toBeConfirmed = Msg.getMsg((Properties)Env.getCtx(), (String)"JP_ToBeConfirmed");
                        MColumn column = MColumn.get((Properties)Env.getCtx(), (String)"JP_Contract", (String)"JP_ContractType");
                        String spotContract = MRefList.getListName((Properties)Env.getCtx(), (int)column.getAD_Reference_Value_ID(), (String)"STC");
                        try {
                            FDialog.info((int)0, null, (String)"JP_ContractManagementInfo", (String)(String.valueOf(nonEnterable) + " " + contractPeriod + " -> " + toBeConfirmed + " : " + spotContract));
                        }
                        catch (Exception exception) {}
                    }
                }
            } else if (contract.getJP_ContractType().equals("GLC") && (order.get_ValueAsInt("JP_ContractContent_ID") != 0 || order.get_ValueAsInt("JP_ContractProcPeriod_ID") != 0)) {
                order.set_ValueNoCheck("JP_ContractContent_ID", null);
                order.set_ValueNoCheck("JP_ContractProcPeriod_ID", null);
                if (pInfo == null) {
                    String nonEnterable = Msg.getMsg((Properties)Env.getCtx(), (String)"JP_NON-ENTERABLE");
                    String contractContent = Msg.getElement((Properties)Env.getCtx(), (String)"JP_ContractContent_ID");
                    String contractPeriod = Msg.getElement((Properties)Env.getCtx(), (String)"JP_ContractProcPeriod_ID");
                    String toBeConfirmed = Msg.getMsg((Properties)Env.getCtx(), (String)"JP_ToBeConfirmed");
                    MColumn column = MColumn.get((Properties)Env.getCtx(), (String)"JP_Contract", (String)"JP_ContractType");
                    String generalContract = MRefList.getListName((Properties)Env.getCtx(), (int)column.getAD_Reference_Value_ID(), (String)"GLC");
                    try {
                        FDialog.info((int)0, null, (String)"JP_ContractManagementInfo", (String)(String.valueOf(nonEnterable) + " " + contractContent + " , " + contractPeriod + " -> " + toBeConfirmed + " : " + generalContract));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        return null;
    }

    private String orderLineValidate(PO po, int type) {
        MOrderLine oLine;
        MOrderLine orderLine;
        if (type == 1 && (orderLine = (MOrderLine)po).getRef_OrderLine_ID() > 0) {
            MContractLine counterContractLine;
            MOrderLine counterOrderLine = new MOrderLine(po.getCtx(), orderLine.getRef_OrderLine_ID(), po.get_TrxName());
            if (counterOrderLine.get_ValueAsInt("JP_ContractLine_ID") > 0 && (counterContractLine = MContractLine.get(po.getCtx(), counterOrderLine.get_ValueAsInt("JP_ContractLine_ID"))) != null && counterContractLine.getJP_ContractLine_ID() > 0 && counterContractLine.getJP_CounterContractLine_ID() > 0) {
                orderLine.set_ValueNoCheck("JP_ContractLine_ID", (Object)counterContractLine.getJP_CounterContractLine_ID());
            }
            if (counterOrderLine.get_ValueAsInt("JP_ContractProcPeriod_ID") > 0) {
                orderLine.set_ValueNoCheck("JP_ContractProcPeriod_ID", (Object)counterOrderLine.get_ValueAsInt("JP_ContractProcPeriod_ID"));
            }
        }
        if (type == 2 && po.is_ValueChanged("QtyInvoiced")) {
            oLine = (MOrderLine)po;
            int JP_ContractContent_ID = oLine.getParent().get_ValueAsInt("JP_ContractContent_ID");
            if (JP_ContractContent_ID == 0) {
                oLine.set_ValueNoCheck("JP_QtyRecognized", (Object)oLine.getQtyInvoiced());
            } else {
                MContractContent contractContent = MContractContent.get(Env.getCtx(), JP_ContractContent_ID);
                if (!contractContent.getJP_Contract_Acct().isPostingRecognitionDocJP()) {
                    oLine.set_ValueNoCheck("JP_QtyRecognized", (Object)oLine.getQtyInvoiced());
                }
            }
        }
        if (type == 2 && (po.is_ValueChanged("QtyOrdered") || po.is_ValueChanged("QtyDelivered") || po.is_ValueChanged("QtyInvoiced") || po.is_ValueChanged("JP_QtyRecognized"))) {
            BigDecimal qtyOrdered = (BigDecimal)po.get_Value("QtyOrdered");
            BigDecimal qtyDelivered = (BigDecimal)po.get_Value("QtyDelivered");
            BigDecimal qtyInvoiced = (BigDecimal)po.get_Value("QtyInvoiced");
            BigDecimal qtyRecognized = (BigDecimal)po.get_Value("JP_QtyRecognized");
            if (qtyOrdered.compareTo(qtyDelivered) == 0 && qtyOrdered.compareTo(qtyInvoiced) == 0 && qtyOrdered.compareTo(qtyRecognized) == 0) {
                po.set_ValueNoCheck("IsProcessingOrderJP", (Object)"N");
            } else {
                po.set_ValueNoCheck("IsProcessingOrderJP", (Object)"Y");
            }
            if (po.is_ValueChanged("QtyDelivered") || po.is_ValueChanged("QtyInvoiced") || po.is_ValueChanged("JP_QtyRecognized")) {
                return null;
            }
        }
        if (type == 1 || type == 2 && (po.is_ValueChanged("JP_ContractLine_ID") || po.is_ValueChanged("JP_ContractProcPeriod_ID"))) {
            oLine = (MOrderLine)po;
            ProcessInfo pInfo = Env.getProcessInfo((Properties)Env.getCtx());
            int JP_ContractLine_ID = oLine.get_ValueAsInt("JP_ContractLine_ID");
            if (JP_ContractLine_ID > 0) {
                MContractLine contractLine = MContractLine.get(Env.getCtx(), JP_ContractLine_ID);
                MContract contract = contractLine.getParent().getParent();
                if (contractLine.getJP_ContractContent_ID() != oLine.getParent().get_ValueAsInt("JP_ContractContent_ID")) {
                    return String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"Invalid")) + Msg.getElement((Properties)Env.getCtx(), (String)"JP_ContractLine_ID") + " : " + Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Diff_ContractContentLine");
                }
                if (contract.getJP_ContractType().equals("PDC")) {
                    int JP_ContractProcPeriod_ID = oLine.get_ValueAsInt("JP_ContractProcPeriod_ID");
                    int parent_ContractProcPeriod_ID = oLine.getParent().get_ValueAsInt("JP_ContractProcPeriod_ID");
                    if (JP_ContractProcPeriod_ID <= 0) {
                        oLine.set_ValueOfColumn("JP_ContractProcPeriod_ID", (Object)parent_ContractProcPeriod_ID);
                    } else if (JP_ContractProcPeriod_ID != parent_ContractProcPeriod_ID) {
                        return Msg.getMsg((Properties)Env.getCtx(), (String)"JP_DifferentContractProcPeriod");
                    }
                } else if (contract.getJP_ContractType().equals("STC")) {
                    if (oLine.get_ValueAsInt("JP_ContractProcPeriod_ID") != 0) {
                        oLine.set_ValueNoCheck("JP_ContractProcPeriod_ID", null);
                        if (pInfo == null) {
                            String nonEnterable = Msg.getMsg((Properties)Env.getCtx(), (String)"JP_NON-ENTERABLE");
                            String contractPeriod = Msg.getElement((Properties)Env.getCtx(), (String)"JP_ContractProcPeriod_ID");
                            String toBeConfirmed = Msg.getMsg((Properties)Env.getCtx(), (String)"JP_ToBeConfirmed");
                            MColumn column = MColumn.get((Properties)Env.getCtx(), (String)"JP_Contract", (String)"JP_ContractType");
                            String spotContract = MRefList.getListName((Properties)Env.getCtx(), (int)column.getAD_Reference_Value_ID(), (String)"STC");
                            try {
                                FDialog.info((int)0, null, (String)"JP_ContractManagementInfo", (String)(String.valueOf(nonEnterable) + " " + contractPeriod + " -> " + toBeConfirmed + " : " + spotContract));
                            }
                            catch (Exception exception) {}
                        }
                    }
                } else if (contract.getJP_ContractType().equals("GLC") && (oLine.get_ValueAsInt("JP_ContractLine_ID") != 0 || oLine.get_ValueAsInt("JP_ContractProcPeriod_ID") != 0)) {
                    oLine.set_ValueNoCheck("JP_ContractLine_ID", null);
                    oLine.set_ValueNoCheck("JP_ContractProcPeriod_ID", null);
                    if (pInfo == null) {
                        String nonEnterable = Msg.getMsg((Properties)Env.getCtx(), (String)"JP_NON-ENTERABLE");
                        String cLine = Msg.getElement((Properties)Env.getCtx(), (String)"JP_ContractLine_ID");
                        String contractPeriod = Msg.getElement((Properties)Env.getCtx(), (String)"JP_ContractProcPeriod_ID");
                        String toBeConfirmed = Msg.getMsg((Properties)Env.getCtx(), (String)"JP_ToBeConfirmed");
                        MColumn column = MColumn.get((Properties)Env.getCtx(), (String)"JP_Contract", (String)"JP_ContractType");
                        String generalContract = MRefList.getListName((Properties)Env.getCtx(), (int)column.getAD_Reference_Value_ID(), (String)"GLC");
                        try {
                            FDialog.info((int)0, null, (String)"JP_ContractManagementInfo", (String)(String.valueOf(nonEnterable) + " " + cLine + " , " + contractPeriod + " -> " + toBeConfirmed + " : " + generalContract));
                        }
                        catch (Exception exception) {}
                    }
                }
            } else if (oLine.get_ValueAsInt("JP_ContractProcPeriod_ID") != 0) {
                oLine.set_ValueNoCheck("JP_ContractProcPeriod_ID", null);
                if (pInfo == null) {
                    String nonEnterable = Msg.getMsg((Properties)Env.getCtx(), (String)"JP_NON-ENTERABLE");
                    String contractPeriod = Msg.getElement((Properties)Env.getCtx(), (String)"JP_ContractProcPeriod_ID");
                    String toBeConfirmed = Msg.getMsg((Properties)Env.getCtx(), (String)"JP_ToBeConfirmed");
                    Object[] objs = new Object[]{Msg.getElement((Properties)Env.getCtx(), (String)"JP_ContractLine_ID")};
                    String message = Msg.getMsg((Properties)Env.getCtx(), (String)"JP_NOT-INOUT", (Object[])objs);
                    try {
                        FDialog.info((int)0, null, (String)"JP_ContractManagementInfo", (String)(String.valueOf(nonEnterable) + " " + contractPeriod + " -> " + toBeConfirmed + " : " + message));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        return null;
    }
}

