/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.base;

import java.math.BigDecimal;
import java.util.List;
import java.util.Properties;
import jpiere.base.plugin.org.adempiere.base.AbstractContractValidator;
import jpiere.base.plugin.org.adempiere.model.MContract;
import jpiere.base.plugin.org.adempiere.model.MContractAcct;
import jpiere.base.plugin.org.adempiere.model.MContractContent;
import jpiere.base.plugin.org.adempiere.model.MContractLine;
import jpiere.base.plugin.org.adempiere.model.MContractProcPeriod;
import jpiere.base.plugin.org.adempiere.model.MRecognition;
import jpiere.base.plugin.org.adempiere.model.MRecognitionLine;
import org.adempiere.webui.window.FDialog;
import org.compiere.acct.Fact;
import org.compiere.acct.FactLine;
import org.compiere.model.FactsValidator;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MClient;
import org.compiere.model.MColumn;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MRMA;
import org.compiere.model.MRefList;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.process.ProcessInfo;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;

public class JPiereContractInvoiceValidator
extends AbstractContractValidator
implements ModelValidator,
FactsValidator {
    private static CLogger log = CLogger.getCLogger(JPiereContractInvoiceValidator.class);
    private int AD_Client_ID = -1;
    private int AD_Org_ID = -1;
    private int AD_Role_ID = -1;
    private int AD_User_ID = -1;

    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.AD_Client_ID = client.getAD_Client_ID();
        }
        engine.addModelChange("C_Invoice", (ModelValidator)this);
        engine.addModelChange("C_InvoiceLine", (ModelValidator)this);
        engine.addDocValidate("C_Invoice", (ModelValidator)this);
        engine.addFactsValidate("C_Invoice", (FactsValidator)this);
    }

    public int getAD_Client_ID() {
        return this.AD_Client_ID;
    }

    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        this.AD_Org_ID = AD_Org_ID;
        this.AD_Role_ID = AD_Role_ID;
        this.AD_User_ID = AD_User_ID;
        return null;
    }

    public String modelChange(PO po, int type) throws Exception {
        if (po.get_TableName().equals("C_Invoice")) {
            return this.invoiceValidate(po, type);
        }
        if (po.get_TableName().equals("C_InvoiceLine")) {
            return this.invoiceLineValidate(po, type);
        }
        return null;
    }

    public String docValidate(PO po, int timing) {
        MContractAcct acct;
        MContractContent content;
        int JP_Contract_Acct_ID;
        int JP_ContractContent_ID;
        int JP_ContractContent_ID2;
        MInvoice invoice;
        if (timing == 1) {
            invoice = (MInvoice)po;
            int JP_Contract_ID = invoice.get_ValueAsInt("JP_Contract_ID");
            if (JP_Contract_ID <= 0) {
                return null;
            }
            MContract contract = MContract.get(Env.getCtx(), JP_Contract_ID);
            if (contract.getJP_ContractType().equals("PDC")) {
                int JP_ContractContent_ID3 = invoice.get_ValueAsInt("JP_ContractContent_ID");
                MContractContent content2 = MContractContent.get(Env.getCtx(), JP_ContractContent_ID3);
                MInvoiceLine[] lines = invoice.getLines();
                int JP_ContractLine_ID = 0;
                int JP_ContractProcPeriod_ID = 0;
                int i = 0;
                while (i < lines.length) {
                    JP_ContractLine_ID = lines[i].get_ValueAsInt("JP_ContractLine_ID");
                    JP_ContractProcPeriod_ID = lines[i].get_ValueAsInt("JP_ContractProcPeriod_ID");
                    if (JP_ContractLine_ID > 0 && JP_ContractProcPeriod_ID <= 0 && (content2.getDocBaseType().equals("API") || content2.getDocBaseType().equals("ARI") || content2.getJP_CreateDerivativeDocPolicy() != null && (content2.getJP_CreateDerivativeDocPolicy().equals("IV") || content2.getJP_CreateDerivativeDocPolicy().equals("BT")))) {
                        return String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"FillMandatory")) + Msg.getElement((Properties)Env.getCtx(), (String)"JP_ContractProcPeriod_ID") + " - " + Msg.getElement((Properties)Env.getCtx(), (String)"Line") + " : " + lines[i].getLine();
                    }
                    ++i;
                }
            }
        }
        if ((timing == 10 || timing == 14 || timing == 13) && (JP_ContractContent_ID2 = (invoice = (MInvoice)po).get_ValueAsInt("JP_ContractContent_ID")) > 0) {
            MContractContent content3 = MContractContent.get(Env.getCtx(), JP_ContractContent_ID2);
            MContractAcct acctInfo = MContractAcct.get(Env.getCtx(), content3.getJP_Contract_Acct_ID());
            if (acctInfo.isPostingContractAcctJP() && acctInfo.isPostingContractAcctJP() && acctInfo.getJP_RecogToInvoicePolicy() != null && !acctInfo.getJP_RecogToInvoicePolicy().equals("NO")) {
                StringBuilder sql = new StringBuilder("UPDATE ").append("JP_Recognition").append(" SET C_Invoice_ID = null WHERE C_Invoice_ID=?");
                DB.executeUpdate((String)sql.toString(), (int)invoice.getC_Invoice_ID(), (String)po.get_TrxName());
                MInvoiceLine[] iLines = invoice.getLines();
                int i = 0;
                while (i < iLines.length) {
                    StringBuilder sqLine = new StringBuilder("UPDATE ").append("JP_RecognitionLine").append(" SET C_InvoiceLine_ID = null WHERE C_InvoiceLine_ID=?");
                    DB.executeUpdate((String)sqLine.toString(), (int)iLines[i].getC_InvoiceLine_ID(), (String)po.get_TrxName());
                    ++i;
                }
            }
        }
        if (timing == 3 && (JP_ContractContent_ID = po.get_ValueAsInt("JP_ContractContent_ID")) > 0 && (JP_Contract_Acct_ID = (content = MContractContent.get(Env.getCtx(), JP_ContractContent_ID)).getJP_Contract_Acct_ID()) > 0 && (acct = MContractAcct.get(Env.getCtx(), JP_Contract_Acct_ID)).isPostingContractAcctJP() && acct.isPostingRecognitionDocJP() && acct.getJP_RecogToInvoicePolicy() != null && acct.getJP_RecogToInvoicePolicy().equals("DD")) {
            int JP_Recognition_ID = po.get_ValueAsInt("JP_Recognition_ID");
            MRecognition recog = new MRecognition(Env.getCtx(), JP_Recognition_ID, po.get_TrxName());
            if (!recog.getDocStatus().equals("CL")) {
                String msg = Msg.getMsg((Properties)Env.getCtx(), (String)"JP_AfterRecognition_InvoiceDocStatusCloseError");
                return msg;
            }
        }
        return null;
    }

    private String invoiceValidate(PO po, int type) {
        int JP_ContractContent_ID;
        MInvoice counterInvoice;
        MInvoice invoice;
        if (type == 1 && (invoice = (MInvoice)po).getRef_Invoice_ID() > 0 && (counterInvoice = new MInvoice(po.getCtx(), invoice.getRef_Invoice_ID(), po.get_TrxName())).get_ValueAsInt("JP_Contract_ID") > 0) {
            MContractContent counterContractContent;
            MContract counterContract = MContract.get(po.getCtx(), counterInvoice.get_ValueAsInt("JP_Contract_ID"));
            if (counterContract != null && counterContract.getJP_Contract_ID() > 0 && counterContract.getJP_CounterContract_ID() > 0) {
                invoice.set_ValueNoCheck("JP_Contract_ID", (Object)counterContract.getJP_CounterContract_ID());
            }
            if (counterInvoice.get_ValueAsInt("JP_ContractContent_ID") > 0 && (counterContractContent = MContractContent.get(po.getCtx(), counterInvoice.get_ValueAsInt("JP_ContractContent_ID"))) != null && counterContractContent.getJP_ContractContent_ID() > 0 && counterContractContent.getJP_CounterContractContent_ID() > 0) {
                invoice.set_ValueNoCheck("JP_ContractContent_ID", (Object)counterContractContent.getJP_CounterContractContent_ID());
            }
            if (counterInvoice.get_ValueAsInt("JP_ContractProcPeriod_ID") > 0) {
                invoice.set_ValueNoCheck("JP_ContractProcPeriod_ID", (Object)counterInvoice.get_ValueAsInt("JP_ContractProcPeriod_ID"));
            }
        }
        if (po.get_ValueAsInt("C_Order_ID") > 0 || po.get_ValueAsInt("M_RMA_ID") > 0) {
            String msg = this.derivativeDocHeaderCommonCheck(po, type);
            if (!Util.isEmpty((String)msg)) {
                return msg;
            }
            return null;
        }
        if (type == 1 || type == 2 && (po.is_ValueChanged("JP_Contract_ID") || po.is_ValueChanged("JP_ContractContent_ID") || po.is_ValueChanged("JP_ContractProcPeriod_ID") || po.is_ValueChanged("C_DocTypeTarget_ID"))) {
            MColumn column;
            String toBeConfirmed;
            MContractContent content;
            MInvoiceLine[] contractInvoiceLines;
            invoice = (MInvoice)po;
            ProcessInfo pInfo = Env.getProcessInfo((Properties)Env.getCtx());
            int JP_Contract_ID = invoice.get_ValueAsInt("JP_Contract_ID");
            if (JP_Contract_ID <= 0) {
                if (invoice.get_ValueAsInt("JP_ContractContent_ID") != 0 || invoice.get_ValueAsInt("JP_ContractProcPeriod_ID") != 0) {
                    invoice.set_ValueNoCheck("JP_ContractContent_ID", null);
                    invoice.set_ValueNoCheck("JP_ContractProcPeriod_ID", null);
                    if (pInfo == null) {
                        String nonEnterable = Msg.getMsg((Properties)Env.getCtx(), (String)"JP_NON-ENTERABLE");
                        String contractContent = Msg.getElement((Properties)Env.getCtx(), (String)"JP_ContractContent_ID");
                        String contractPeriod = Msg.getElement((Properties)Env.getCtx(), (String)"JP_ContractProcPeriod_ID");
                        String toBeConfirmed2 = Msg.getMsg((Properties)Env.getCtx(), (String)"JP_ToBeConfirmed");
                        Object[] objs = new Object[]{Msg.getElement((Properties)Env.getCtx(), (String)"JP_Contract_ID")};
                        String message = Msg.getMsg((Properties)Env.getCtx(), (String)"JP_NOT-INOUT", (Object[])objs);
                        try {
                            FDialog.info((int)0, null, (String)"JP_ContractManagementInfo", (String)(String.valueOf(nonEnterable) + " " + contractContent + " , " + contractPeriod + " -> " + toBeConfirmed2 + " : " + message));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                return null;
            }
            MContract contract = MContract.get(Env.getCtx(), JP_Contract_ID);
            if (type == 2 && contract.getJP_ContractType().equals("PDC") && (contractInvoiceLines = this.getInvoiceLinesWithContractLine(invoice)).length > 0) {
                String msg = Msg.getMsg((Properties)Env.getCtx(), (String)"JP_CannotChangeContractInfoForLines");
                return msg;
            }
            if (contract.getJP_ContractType().equals("PDC")) {
                int JP_ContractContent_ID2 = invoice.get_ValueAsInt("JP_ContractContent_ID");
                if (JP_ContractContent_ID2 <= 0) {
                    Object[] objs = new Object[]{Msg.getElement((Properties)Env.getCtx(), (String)"JP_ContractContent_ID")};
                    return String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"JP_InCaseOfPeriodContract")) + Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Mandatory", (Object[])objs);
                }
                content = MContractContent.get(Env.getCtx(), JP_ContractContent_ID2);
                if (contract.getJP_Contract_ID() != content.getJP_Contract_ID()) {
                    return Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Diff_ContractDocument");
                }
                if (content.getC_BPartner_ID() != invoice.getC_BPartner_ID() && content.getBill_BPartner_ID() != invoice.getC_BPartner_ID()) {
                    return Msg.getMsg((Properties)Env.getCtx(), (String)"JP_DifferentBusinessPartner_ContractContent");
                }
                int JP_ContractProcPeriod_ID = invoice.get_ValueAsInt("JP_ContractProcPeriod_ID");
                if (JP_ContractProcPeriod_ID <= 0) {
                    Object[] objs = new Object[]{Msg.getElement((Properties)Env.getCtx(), (String)"JP_ContractProcPeriod_ID")};
                    return String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"JP_InCaseOfPeriodContract")) + Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Mandatory", (Object[])objs);
                }
                MContractProcPeriod docContractProcPeriod = MContractProcPeriod.get(Env.getCtx(), JP_ContractProcPeriod_ID);
                if (content.getJP_ContractCalender_ID() != docContractProcPeriod.getJP_ContractCalender_ID()) {
                    return Msg.getMsg((Properties)Env.getCtx(), (String)"JP_DifferentContractCalender");
                }
                if (content.getJP_ContractProcDate_To() == null) {
                    if (content.getJP_ContractProcDate_From().compareTo(docContractProcPeriod.getEndDate()) > 0) {
                        return String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"JP_OutsideContractProcessPeriod")) + " " + Msg.getMsg((Properties)Env.getCtx(), (String)"Invalid") + Msg.getElement((Properties)Env.getCtx(), (String)"JP_ContractProcPeriod_ID");
                    }
                } else if (content.getJP_ContractProcDate_From().compareTo(docContractProcPeriod.getEndDate()) > 0 || content.getJP_ContractProcDate_To().compareTo(docContractProcPeriod.getStartDate()) < 0) {
                    return String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"JP_OutsideContractProcessPeriod")) + " " + Msg.getMsg((Properties)Env.getCtx(), (String)"Invalid") + Msg.getElement((Properties)Env.getCtx(), (String)"JP_ContractProcPeriod_ID");
                }
            } else if (contract.getJP_ContractType().equals("STC")) {
                int JP_ContractContent_ID3 = invoice.get_ValueAsInt("JP_ContractContent_ID");
                if (JP_ContractContent_ID3 <= 0) {
                    Object[] objs = new Object[]{Msg.getElement((Properties)Env.getCtx(), (String)"JP_ContractContent_ID")};
                    return String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"JP_InCaseOfSpotContract")) + Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Mandatory", (Object[])objs);
                }
                content = MContractContent.get(Env.getCtx(), JP_ContractContent_ID3);
                if (contract.getJP_Contract_ID() != content.getJP_Contract_ID()) {
                    return Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Diff_ContractDocument");
                }
                if (content.getC_BPartner_ID() != invoice.getC_BPartner_ID() && content.getBill_BPartner_ID() != invoice.getC_BPartner_ID()) {
                    return Msg.getMsg((Properties)Env.getCtx(), (String)"JP_DifferentBusinessPartner_ContractContent");
                }
                if (invoice.get_ValueAsInt("JP_ContractProcPeriod_ID") != 0) {
                    invoice.set_ValueNoCheck("JP_ContractProcPeriod_ID", null);
                    if (pInfo == null) {
                        String nonEnterable = Msg.getMsg((Properties)Env.getCtx(), (String)"JP_NON-ENTERABLE");
                        String contractPeriod = Msg.getElement((Properties)Env.getCtx(), (String)"JP_ContractProcPeriod_ID");
                        toBeConfirmed = Msg.getMsg((Properties)Env.getCtx(), (String)"JP_ToBeConfirmed");
                        column = MColumn.get((Properties)Env.getCtx(), (String)"JP_Contract", (String)"JP_ContractType");
                        String spotContract = MRefList.getListName((Properties)Env.getCtx(), (int)column.getAD_Reference_Value_ID(), (String)"STC");
                        try {
                            FDialog.info((int)0, null, (String)"JP_ContractManagementInfo", (String)(String.valueOf(nonEnterable) + " " + contractPeriod + " -> " + toBeConfirmed + " : " + spotContract));
                        }
                        catch (Exception exception) {}
                    }
                }
            } else if (contract.getJP_ContractType().equals("GLC") && (invoice.get_ValueAsInt("JP_ContractContent_ID") != 0 || invoice.get_ValueAsInt("JP_ContractProcPeriod_ID") != 0)) {
                invoice.set_ValueNoCheck("JP_ContractContent_ID", null);
                invoice.set_ValueNoCheck("JP_ContractProcPeriod_ID", null);
                if (pInfo == null) {
                    String nonEnterable = Msg.getMsg((Properties)Env.getCtx(), (String)"JP_NON-ENTERABLE");
                    String contractContent = Msg.getElement((Properties)Env.getCtx(), (String)"JP_ContractContent_ID");
                    String contractPeriod = Msg.getElement((Properties)Env.getCtx(), (String)"JP_ContractProcPeriod_ID");
                    toBeConfirmed = Msg.getMsg((Properties)Env.getCtx(), (String)"JP_ToBeConfirmed");
                    column = MColumn.get((Properties)Env.getCtx(), (String)"JP_Contract", (String)"JP_ContractType");
                    String generalContract = MRefList.getListName((Properties)Env.getCtx(), (int)column.getAD_Reference_Value_ID(), (String)"GLC");
                    try {
                        FDialog.info((int)0, null, (String)"JP_ContractManagementInfo", (String)(String.valueOf(nonEnterable) + " " + contractContent + " , " + contractPeriod + " -> " + toBeConfirmed + " : " + generalContract));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        if (type == 6 && (JP_ContractContent_ID = (invoice = (MInvoice)po).get_ValueAsInt("JP_ContractContent_ID")) > 0) {
            MContractContent content = MContractContent.get(Env.getCtx(), JP_ContractContent_ID);
            MContractAcct acctInfo = MContractAcct.get(Env.getCtx(), content.getJP_Contract_Acct_ID());
            if (acctInfo.isPostingContractAcctJP() && acctInfo.isPostingContractAcctJP() && acctInfo.getJP_RecogToInvoicePolicy() != null && !acctInfo.getJP_RecogToInvoicePolicy().equals("NO")) {
                StringBuilder sql = new StringBuilder("UPDATE ").append("JP_Recognition").append(" SET C_Invoice_ID = null WHERE C_Invoice_ID=?");
                DB.executeUpdate((String)sql.toString(), (int)invoice.getC_Invoice_ID(), (String)po.get_TrxName());
                MInvoiceLine[] iLines = invoice.getLines();
                int i = 0;
                while (i < iLines.length) {
                    StringBuilder sqLine = new StringBuilder("UPDATE ").append("JP_RecognitionLine").append(" SET C_InvoiceLine_ID = null WHERE C_InvoiceLine_ID=?");
                    DB.executeUpdate((String)sqLine.toString(), (int)iLines[i].getC_InvoiceLine_ID(), (String)po.get_TrxName());
                    ++i;
                }
            }
        }
        return null;
    }

    private String invoiceLineValidate(PO po, int type) {
        MInvoiceLine iLine;
        MInvoice invoice;
        int JP_ContractContent_ID;
        int JP_RecognitionLine_ID;
        MInvoiceLine invoiceLine;
        if (type == 1 && (invoiceLine = (MInvoiceLine)po).getRef_InvoiceLine_ID() > 0) {
            MContractLine counterContractLine;
            MInvoiceLine counterInvoiceLine = new MInvoiceLine(po.getCtx(), invoiceLine.getRef_InvoiceLine_ID(), po.get_TrxName());
            if (counterInvoiceLine.get_ValueAsInt("JP_ContractLine_ID") > 0 && (counterContractLine = MContractLine.get(po.getCtx(), counterInvoiceLine.get_ValueAsInt("JP_ContractLine_ID"))) != null && counterContractLine.getJP_ContractLine_ID() > 0 && counterContractLine.getJP_CounterContractLine_ID() > 0) {
                invoiceLine.set_ValueNoCheck("JP_ContractLine_ID", (Object)counterContractLine.getJP_CounterContractLine_ID());
            }
            if (counterInvoiceLine.get_ValueAsInt("JP_ContractProcPeriod_ID") > 0) {
                invoiceLine.set_ValueNoCheck("JP_ContractProcPeriod_ID", (Object)counterInvoiceLine.get_ValueAsInt("JP_ContractProcPeriod_ID"));
            }
        }
        if (po.get_ValueAsInt("C_OrderLine_ID") > 0 || po.get_ValueAsInt("M_RMALine_ID") > 0) {
            String msg = this.derivativeDocLineCommonCheck(po, type);
            if (!Util.isEmpty((String)msg)) {
                return msg;
            }
            if (type == 1 || type == 2 && (po.is_ValueChanged("JP_ContractLine_ID") || po.is_ValueChanged("C_OrderLine_ID") || po.is_ValueChanged("M_RMALine_ID"))) {
                MInvoiceLine invoiceLine2 = (MInvoiceLine)po;
                int JP_Contract_ID = invoiceLine2.getParent().get_ValueAsInt("JP_Contract_ID");
                int JP_ContractContent_ID2 = invoiceLine2.getParent().get_ValueAsInt("JP_ContractContent_ID");
                int JP_ContractLine_ID = invoiceLine2.get_ValueAsInt("JP_ContractLine_ID");
                if (JP_Contract_ID <= 0) {
                    return null;
                }
                MContract contract = MContract.get(Env.getCtx(), JP_Contract_ID);
                if (!contract.getJP_ContractType().equals("PDC") && !contract.getJP_ContractType().equals("STC")) {
                    return null;
                }
                int C_OrderLine_ID = invoiceLine2.getC_OrderLine_ID();
                int M_RMALine_ID = invoiceLine2.getM_RMALine_ID();
                if (C_OrderLine_ID <= 0 && M_RMALine_ID <= 0) {
                    return null;
                }
                if (invoiceLine2.getParent().getC_Order_ID() > 0 && invoiceLine2.getC_OrderLine_ID() > 0) {
                    if (invoiceLine2.getC_OrderLine().getC_Order_ID() != invoiceLine2.getParent().getC_Order_ID()) {
                        return String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"JP_InCaseOfPeriodContractAndSpotContract")) + Msg.getMsg((Properties)Env.getCtx(), (String)"JP_CanNotBundleDifferentOrder");
                    }
                } else if (invoiceLine2.getParent().getM_RMA_ID() > 0 && invoiceLine2.getM_RMALine_ID() > 0 && invoiceLine2.getM_RMALine().getM_RMA_ID() != invoiceLine2.getParent().getM_RMA_ID()) {
                    return String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"JP_InCaseOfPeriodContractAndSpotContract")) + Msg.getMsg((Properties)Env.getCtx(), (String)"JP_CanNotBundleDifferentRMA");
                }
                if (JP_ContractLine_ID <= 0) {
                    return null;
                }
                MContractLine contractLine = MContractLine.get(Env.getCtx(), JP_ContractLine_ID);
                if (contractLine.getJP_ContractContent_ID() != JP_ContractContent_ID2) {
                    return String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"Invalid")) + " - " + Msg.getElement((Properties)Env.getCtx(), (String)"JP_ContractLine_ID") + Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Diff_ContractContentLine");
                }
                int invoiceLine_ContractProcPeriod_ID = invoiceLine2.get_ValueAsInt("JP_ContractProcPeriod_ID");
                MContractContent content = MContractContent.get(Env.getCtx(), JP_ContractContent_ID2);
                if (contract.getJP_ContractType().equals("PDC")) {
                    if (content.getJP_CreateDerivativeDocPolicy().equals("IV") || content.getJP_CreateDerivativeDocPolicy().equals("BT")) {
                        if (type == 2) {
                            if (invoiceLine_ContractProcPeriod_ID <= 0) {
                                Object[] objs = new Object[]{Msg.getElement((Properties)Env.getCtx(), (String)"JP_ContractProcPeriod_ID")};
                                return String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"JP_InCaseOfCreateDerivativeDocPolicy")) + Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Mandatory", (Object[])objs);
                            }
                            MContractProcPeriod invoiceLine_ContractProcPeriod = MContractProcPeriod.get(Env.getCtx(), invoiceLine_ContractProcPeriod_ID);
                            if (invoiceLine_ContractProcPeriod.getJP_ContractCalender_ID() != contractLine.getJP_ContractCalender_InOut_ID()) {
                                return Msg.getMsg((Properties)Env.getCtx(), (String)"JP_SelectContractProcPeriodBelongToContractLine");
                            }
                            MInvoice invoice2 = invoiceLine2.getParent();
                            MContractProcPeriod invoicePeriod = MContractProcPeriod.get(Env.getCtx(), invoice2.get_ValueAsInt("JP_ContractProcPeriod_ID"));
                            if (invoicePeriod.getStartDate().compareTo(invoiceLine_ContractProcPeriod.getStartDate()) > 0 || invoicePeriod.getEndDate() != null && invoicePeriod.getEndDate().compareTo(invoiceLine_ContractProcPeriod.getEndDate()) < 0) {
                                return String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"JP_OutsideContractProcessPeriod")) + " " + Msg.getMsg((Properties)Env.getCtx(), (String)"Invalid") + Msg.getElement((Properties)Env.getCtx(), (String)"JP_ContractProcPeriod_ID");
                            }
                        }
                    } else if (po.get_ValueAsInt("JP_ContractProcPeriod_ID") != 0) {
                        po.set_ValueNoCheck("JP_ContractProcPeriod_ID", null);
                        ProcessInfo pInfo = Env.getProcessInfo((Properties)Env.getCtx());
                        if (pInfo == null) {
                            String nonEnterable = Msg.getMsg((Properties)Env.getCtx(), (String)"JP_NON-ENTERABLE");
                            String contractPeriod = Msg.getElement((Properties)Env.getCtx(), (String)"JP_ContractProcPeriod_ID");
                            String toBeConfirmed = Msg.getMsg((Properties)Env.getCtx(), (String)"JP_ToBeConfirmed");
                            String createDerivativeDocPolicy = Msg.getElement((Properties)Env.getCtx(), (String)"JP_CreateDerivativeDocPolicy");
                            try {
                                FDialog.info((int)0, null, (String)"JP_ContractManagementInfo", (String)(String.valueOf(nonEnterable) + " " + contractPeriod + " -> " + toBeConfirmed + " : " + createDerivativeDocPolicy));
                            }
                            catch (Exception exception) {}
                        }
                    }
                }
            }
        } else if (type == 1 || type == 2 && (po.is_ValueChanged("JP_ContractLine_ID") || po.is_ValueChanged("JP_ContractProcPeriod_ID"))) {
            invoiceLine = (MInvoiceLine)po;
            ProcessInfo pInfo = Env.getProcessInfo((Properties)Env.getCtx());
            int JP_ContractLine_ID = invoiceLine.get_ValueAsInt("JP_ContractLine_ID");
            if (JP_ContractLine_ID > 0) {
                MContractLine contractLine = MContractLine.get(Env.getCtx(), JP_ContractLine_ID);
                MContract contract = contractLine.getParent().getParent();
                if (contractLine.getJP_ContractContent_ID() != invoiceLine.getParent().get_ValueAsInt("JP_ContractContent_ID")) {
                    return String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"Invalid")) + Msg.getElement((Properties)Env.getCtx(), (String)"JP_ContractLine_ID") + " : " + Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Diff_ContractContentLine");
                }
                if (contract.getJP_ContractType().equals("PDC")) {
                    int JP_ContractProcPeriod_ID = invoiceLine.get_ValueAsInt("JP_ContractProcPeriod_ID");
                    int parent_ContractProcPeriod_ID = invoiceLine.getParent().get_ValueAsInt("JP_ContractProcPeriod_ID");
                    if (JP_ContractProcPeriod_ID <= 0) {
                        invoiceLine.set_ValueOfColumn("JP_ContractProcPeriod_ID", (Object)parent_ContractProcPeriod_ID);
                    } else if (JP_ContractProcPeriod_ID != parent_ContractProcPeriod_ID) {
                        return Msg.getMsg((Properties)Env.getCtx(), (String)"JP_DifferentContractProcPeriod");
                    }
                } else if (contract.getJP_ContractType().equals("STC")) {
                    if (invoiceLine.get_ValueAsInt("JP_ContractProcPeriod_ID") != 0) {
                        invoiceLine.set_ValueNoCheck("JP_ContractProcPeriod_ID", null);
                        if (pInfo == null) {
                            String nonEnterable = Msg.getMsg((Properties)Env.getCtx(), (String)"JP_NON-ENTERABLE");
                            String contractPeriod = Msg.getElement((Properties)Env.getCtx(), (String)"JP_ContractProcPeriod_ID");
                            String toBeConfirmed = Msg.getMsg((Properties)Env.getCtx(), (String)"JP_ToBeConfirmed");
                            MColumn column = MColumn.get((Properties)Env.getCtx(), (String)"JP_Contract", (String)"JP_ContractType");
                            String spotContract = MRefList.getListName((Properties)Env.getCtx(), (int)column.getAD_Reference_Value_ID(), (String)"STC");
                            try {
                                FDialog.info((int)0, null, (String)"JP_ContractManagementInfo", (String)(String.valueOf(nonEnterable) + " " + contractPeriod + " -> " + toBeConfirmed + " : " + spotContract));
                            }
                            catch (Exception content) {}
                        }
                    }
                } else if (contract.getJP_ContractType().equals("GLC") && (invoiceLine.get_ValueAsInt("JP_ContractLine_ID") != 0 || invoiceLine.get_ValueAsInt("JP_ContractProcPeriod_ID") != 0)) {
                    invoiceLine.set_ValueNoCheck("JP_ContractLine_ID", null);
                    invoiceLine.set_ValueNoCheck("JP_ContractProcPeriod_ID", null);
                    if (pInfo == null) {
                        String nonEnterable = Msg.getMsg((Properties)Env.getCtx(), (String)"JP_NON-ENTERABLE");
                        String cLine = Msg.getElement((Properties)Env.getCtx(), (String)"JP_ContractLine_ID");
                        String contractPeriod = Msg.getElement((Properties)Env.getCtx(), (String)"JP_ContractProcPeriod_ID");
                        String toBeConfirmed = Msg.getMsg((Properties)Env.getCtx(), (String)"JP_ToBeConfirmed");
                        MColumn column = MColumn.get((Properties)Env.getCtx(), (String)"JP_Contract", (String)"JP_ContractType");
                        String generalContract = MRefList.getListName((Properties)Env.getCtx(), (int)column.getAD_Reference_Value_ID(), (String)"GLC");
                        try {
                            FDialog.info((int)0, null, (String)"JP_ContractManagementInfo", (String)(String.valueOf(nonEnterable) + " " + cLine + " , " + contractPeriod + " -> " + toBeConfirmed + " : " + generalContract));
                        }
                        catch (Exception exception) {}
                    }
                }
            } else if (invoiceLine.get_ValueAsInt("JP_ContractProcPeriod_ID") != 0) {
                invoiceLine.set_ValueNoCheck("JP_ContractProcPeriod_ID", null);
                if (pInfo == null) {
                    String nonEnterable = Msg.getMsg((Properties)Env.getCtx(), (String)"JP_NON-ENTERABLE");
                    String contractPeriod = Msg.getElement((Properties)Env.getCtx(), (String)"JP_ContractProcPeriod_ID");
                    String toBeConfirmed = Msg.getMsg((Properties)Env.getCtx(), (String)"JP_ToBeConfirmed");
                    Object[] objs = new Object[]{Msg.getElement((Properties)Env.getCtx(), (String)"JP_ContractLine_ID")};
                    String message = Msg.getMsg((Properties)Env.getCtx(), (String)"JP_NOT-INOUT", (Object[])objs);
                    try {
                        FDialog.info((int)0, null, (String)"JP_ContractManagementInfo", (String)(String.valueOf(nonEnterable) + " " + contractPeriod + " -> " + toBeConfirmed + " : " + message));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        if ((type == 1 || type == 2) && (JP_RecognitionLine_ID = po.get_ValueAsInt("JP_RecognitionLine_ID")) > 0 && (type == 1 || po.is_ValueChanged("QtyEntered") || po.is_ValueChanged("QtyInvoiced") || po.is_ValueChanged("JP_RecognitionLine_ID"))) {
            MInvoiceLine iLine2 = (MInvoiceLine)po;
            MRecognitionLine rLine = new MRecognitionLine(Env.getCtx(), JP_RecognitionLine_ID, po.get_TrxName());
            BigDecimal rLine_QtyInvoiced = rLine.getQtyInvoiced();
            BigDecimal iLine_QtyInvoiced = iLine2.getQtyInvoiced();
            if (rLine_QtyInvoiced.abs().compareTo(iLine_QtyInvoiced.abs()) != 0 && iLine_QtyInvoiced.compareTo(Env.ZERO) != 0) {
                String msg0 = String.valueOf(Msg.getElement((Properties)Env.getCtx(), (String)"C_InvoiceLine_ID")) + " - " + Msg.getElement((Properties)Env.getCtx(), (String)"QtyInvoiced");
                String msg1 = String.valueOf(Msg.getElement((Properties)Env.getCtx(), (String)"JP_RecognitionLine_ID")) + " - " + Msg.getElement((Properties)Env.getCtx(), (String)"JP_QtyRecognized");
                return Msg.getMsg((Properties)Env.getCtx(), (String)"JP_DifferentQty", (Object[])new Object[]{msg0, msg1});
            }
        }
        if (type == 6 && (JP_ContractContent_ID = (invoice = (iLine = (MInvoiceLine)po).getParent()).get_ValueAsInt("JP_ContractContent_ID")) > 0) {
            MContractContent content = MContractContent.get(Env.getCtx(), JP_ContractContent_ID);
            MContractAcct acctInfo = MContractAcct.get(Env.getCtx(), content.getJP_Contract_Acct_ID());
            if (acctInfo.isPostingContractAcctJP() && acctInfo.isPostingContractAcctJP() && acctInfo.getJP_RecogToInvoicePolicy() != null && !acctInfo.getJP_RecogToInvoicePolicy().equals("NO")) {
                StringBuilder sqLine = new StringBuilder("UPDATE ").append("JP_RecognitionLine").append(" SET C_InvoiceLine_ID = null WHERE C_InvoiceLine_ID=?");
                DB.executeUpdate((String)sqLine.toString(), (int)iLine.getC_InvoiceLine_ID(), (String)po.get_TrxName());
            }
        }
        return null;
    }

    private MInvoiceLine[] getInvoiceLinesWithContractLine(MInvoice invoice) {
        String whereClauseFinal = "C_Invoice_ID=? AND JP_ContractLine_ID IS NOT NULL ";
        List list = new Query(Env.getCtx(), "C_InvoiceLine", whereClauseFinal, invoice.get_TrxName()).setParameters(new Object[]{invoice.getC_Invoice_ID()}).setOrderBy("Line").list();
        return list.toArray(new MInvoiceLine[list.size()]);
    }

    public String factsValidate(MAcctSchema schema, List<Fact> facts, PO po) {
        int JP_ContractContent_ID;
        if (po.get_TableName().equals("C_Invoice") && (JP_ContractContent_ID = po.get_ValueAsInt("JP_ContractContent_ID")) > 0) {
            MInvoice invoice = (MInvoice)po;
            for (Fact fact : facts) {
                FactLine[] factLine = fact.getLines();
                int i = 0;
                while (i < factLine.length) {
                    if (invoice.getC_Order_ID() > 0) {
                        factLine[i].set_ValueNoCheck("JP_Order_ID", (Object)invoice.getC_Order_ID());
                    } else if (invoice.getM_RMA_ID() > 0) {
                        int M_RMA_ID = invoice.getM_RMA_ID();
                        MRMA rma = new MRMA(Env.getCtx(), M_RMA_ID, po.get_TrxName());
                        int JP_Order_ID = rma.get_ValueAsInt("JP_Order_ID");
                        if (JP_Order_ID > 0) {
                            factLine[i].set_ValueNoCheck("JP_Order_ID", (Object)JP_Order_ID);
                        }
                    }
                    factLine[i].set_ValueNoCheck("JP_ContractContent_ID", (Object)JP_ContractContent_ID);
                    ++i;
                }
            }
        }
        return null;
    }
}

