/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.base;

import java.sql.Timestamp;
import java.util.List;
import java.util.Properties;
import jpiere.base.plugin.org.adempiere.base.AbstractContractValidator;
import jpiere.base.plugin.org.adempiere.model.MContract;
import jpiere.base.plugin.org.adempiere.model.MContractContent;
import jpiere.base.plugin.org.adempiere.model.MContractLine;
import jpiere.base.plugin.org.adempiere.model.MContractPSInOutLine;
import jpiere.base.plugin.org.adempiere.model.MContractProcPeriod;
import jpiere.base.plugin.org.adempiere.model.MRecognition;
import jpiere.base.plugin.org.adempiere.model.MRecognitionLine;
import jpiere.base.plugin.org.adempiere.model.X_JP_Recognition;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.webui.window.FDialog;
import org.compiere.acct.Fact;
import org.compiere.acct.FactLine;
import org.compiere.model.FactsValidator;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MClient;
import org.compiere.model.MDocType;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.MOrder;
import org.compiere.model.MPeriod;
import org.compiere.model.MRMA;
import org.compiere.model.MRMALine;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.process.ProcessInfo;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;

public class JPiereContractInOutValidator
extends AbstractContractValidator
implements ModelValidator,
FactsValidator {
    private static CLogger log = CLogger.getCLogger(JPiereContractInOutValidator.class);
    private int AD_Client_ID = -1;
    private int AD_Org_ID = -1;
    private int AD_Role_ID = -1;
    private int AD_User_ID = -1;

    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.AD_Client_ID = client.getAD_Client_ID();
        }
        engine.addModelChange("M_InOut", (ModelValidator)this);
        engine.addModelChange("M_InOutLine", (ModelValidator)this);
        engine.addDocValidate("M_InOut", (ModelValidator)this);
        engine.addFactsValidate("M_InOut", (FactsValidator)this);
    }

    public int getAD_Client_ID() {
        return this.AD_Client_ID;
    }

    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        this.AD_Org_ID = AD_Org_ID;
        this.AD_Role_ID = AD_Role_ID;
        this.AD_User_ID = AD_User_ID;
        return null;
    }

    public String modelChange(PO po, int type) throws Exception {
        if (po.get_TableName().equals("M_InOut")) {
            return this.inOutValidate(po, type);
        }
        if (po.get_TableName().equals("M_InOutLine")) {
            return this.inOutLineValidate(po, type);
        }
        return null;
    }

    public String docValidate(PO po, int timing) {
        if (timing == 1) {
            MInOut inout = (MInOut)po;
            int JP_Contract_ID = inout.get_ValueAsInt("JP_Contract_ID");
            if (JP_Contract_ID <= 0) {
                return null;
            }
            MContract contract = MContract.get(Env.getCtx(), JP_Contract_ID);
            if (contract.getJP_ContractType().equals("PDC")) {
                int JP_ContractContent_ID = inout.get_ValueAsInt("JP_ContractContent_ID");
                MContractContent content = MContractContent.get(Env.getCtx(), JP_ContractContent_ID);
                MInOutLine[] lines = inout.getLines();
                int JP_ContractLine_ID = 0;
                int JP_ContractProcPeriod_ID = 0;
                int i = 0;
                while (i < lines.length) {
                    int ReversalLine_ID = lines[i].getReversalLine_ID();
                    if (ReversalLine_ID > 0) {
                        MInOutLine ReversalLine = new MInOutLine(Env.getCtx(), ReversalLine_ID, po.get_TrxName());
                        lines[i].set_ValueNoCheck("JP_ContractLine_ID", ReversalLine.get_Value("JP_ContractLine_ID"));
                        lines[i].set_ValueNoCheck("JP_ContractProcPeriod_ID", ReversalLine.get_Value("JP_ContractProcPeriod_ID"));
                        lines[i].saveEx(po.get_TrxName());
                    }
                    JP_ContractLine_ID = lines[i].get_ValueAsInt("JP_ContractLine_ID");
                    JP_ContractProcPeriod_ID = lines[i].get_ValueAsInt("JP_ContractProcPeriod_ID");
                    if (JP_ContractLine_ID > 0 && JP_ContractProcPeriod_ID <= 0 && (content.getJP_CreateDerivativeDocPolicy().equals("IO") || content.getJP_CreateDerivativeDocPolicy().equals("BT"))) {
                        return String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"FillMandatory")) + Msg.getElement((Properties)Env.getCtx(), (String)"JP_ContractProcPeriod_ID") + " - " + Msg.getElement((Properties)Env.getCtx(), (String)"Line") + " : " + lines[i].getLine();
                    }
                    ++i;
                }
            }
        }
        if (timing == 9) {
            int JP_Contract_ID = po.get_ValueAsInt("JP_Contract_ID");
            if (JP_Contract_ID <= 0) {
                return null;
            }
            MContract contract = MContract.get(Env.getCtx(), JP_Contract_ID);
            if (!contract.getJP_ContractType().equals("PDC") && !contract.getJP_ContractType().equals("STC")) {
                return null;
            }
            int JP_ContractContent_ID = po.get_ValueAsInt("JP_ContractContent_ID");
            if (JP_ContractContent_ID <= 0) {
                return null;
            }
            MContractContent content = MContractContent.get(Env.getCtx(), JP_ContractContent_ID);
            if (!content.getJP_Contract_Acct().isPostingRecognitionDocJP()) {
                return null;
            }
            MInOut io = (MInOut)po;
            String trxName = po.get_TrxName();
            boolean isReversal = io.isReversal();
            if (isReversal) {
                int original_InOut_ID = io.getReversal_ID();
                this.reversalRecognition(io, timing, true, original_InOut_ID);
            } else {
                MOrder order = null;
                X_JP_Recognition recognition = null;
                boolean isRMA = false;
                if (io.getC_Order_ID() > 0) {
                    order = new MOrder(po.getCtx(), io.getC_Order_ID(), trxName);
                    MDocType orderDocType = MDocType.get((Properties)po.getCtx(), (int)order.getC_DocTypeTarget_ID());
                    if (orderDocType.get_ValueAsInt("JP_DocTypeRecognition_ID") == 0) {
                        return null;
                    }
                    recognition = new MRecognition(order, orderDocType.get_ValueAsInt("JP_DocTypeRecognition_ID"), io.getDateAcct());
                } else if (io.getM_RMA_ID() > 0) {
                    isRMA = true;
                    MRMA rma = new MRMA(Env.getCtx(), io.getM_RMA_ID(), trxName);
                    int JP_Order_ID = rma.get_ValueAsInt("JP_Order_ID");
                    if (JP_Order_ID == 0) {
                        return null;
                    }
                    order = new MOrder(po.getCtx(), JP_Order_ID, trxName);
                    MDocType orderDocType = MDocType.get((Properties)po.getCtx(), (int)order.getC_DocTypeTarget_ID());
                    if (orderDocType.get_ValueAsInt("JP_DocTypeRecognition_ID") == 0) {
                        return null;
                    }
                    recognition = new MRecognition(order, orderDocType.get_ValueAsInt("JP_DocTypeRecognition_ID"), io.getDateAcct());
                    MDocType odt = MDocType.get((Properties)order.getCtx(), (int)rma.getC_DocType_ID());
                    if (odt != null) {
                        int C_DocTypeTarget_ID = odt.get_ValueAsInt("JP_DocTypeRecognition_ID");
                        if (C_DocTypeTarget_ID <= 0) {
                            throw new AdempiereException("@NotFound@ @C_DocTypeInvoice_ID@ - @C_DocType_ID@:" + odt.get_Translation("Name"));
                        }
                        recognition.setC_DocTypeTarget_ID(C_DocTypeTarget_ID);
                    }
                    recognition.setM_RMA_ID(io.getM_RMA_ID());
                }
                recognition.setM_InOut_ID(io.getM_InOut_ID());
                recognition.setMovementDate(io.getMovementDate());
                if (!recognition.save(trxName)) {
                    return String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"JP_CouldNotCreate")) + " " + Msg.getElement((Properties)Env.getCtx(), (String)"JP_Recognition_ID") + " : " + io.getDocumentInfo();
                }
                MInOutLine[] ioLines = io.getLines(false);
                int i = 0;
                while (i < ioLines.length) {
                    MInOutLine ioLine = ioLines[i];
                    MRecognitionLine rcogLine = new MRecognitionLine((MRecognition)recognition);
                    rcogLine.setRecogLine(ioLine);
                    if (isRMA) {
                        int M_RMALine_ID = ioLine.getM_RMALine_ID();
                        MRMALine rmaLine = new MRMALine(Env.getCtx(), M_RMALine_ID, trxName);
                        int JP_OrderLine_ID = rmaLine.get_ValueAsInt("JP_OrderLine_ID");
                        rcogLine.setC_OrderLine_ID(JP_OrderLine_ID);
                    }
                    rcogLine.set_ValueNoCheck("JP_ProductExplodeBOM_ID", ioLine.get_Value("JP_ProductExplodeBOM_ID"));
                    if (ioLine.sameOrderLineUOM()) {
                        rcogLine.setQtyEntered(ioLine.getQtyEntered());
                    } else {
                        rcogLine.setQtyEntered(ioLine.getMovementQty());
                    }
                    rcogLine.setQtyInvoiced(ioLine.getMovementQty());
                    rcogLine.setJP_QtyRecognized(ioLine.getMovementQty());
                    rcogLine.setJP_TargetQtyRecognized(ioLine.getMovementQty());
                    rcogLine.setJP_ContractLine_ID(ioLine.get_ValueAsInt("JP_ContractLine_ID"));
                    rcogLine.setJP_ContractProcPeriod_ID(ioLine.get_ValueAsInt("JP_ContractProcPeriod_ID"));
                    MContractPSInOutLine[] cpsIOLines = MContractPSInOutLine.getContractPSInOutLinebyInOutLine(po.getCtx(), ioLine.getM_InOutLine_ID(), po.get_TrxName());
                    if (cpsIOLines.length > 0) {
                        if (ioLine.getC_UOM_ID() == cpsIOLines[0].getC_UOM_ID()) {
                            rcogLine.setPriceEntered(cpsIOLines[0].getPriceEntered());
                            rcogLine.setPriceActual(cpsIOLines[0].getPriceActual());
                        } else {
                            rcogLine.setPriceEntered(cpsIOLines[0].getPriceActual());
                            rcogLine.setPriceActual(cpsIOLines[0].getPriceActual());
                        }
                    }
                    if (!rcogLine.save(trxName)) {
                        return String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"JP_CouldNotCreate")) + " " + Msg.getElement((Properties)Env.getCtx(), (String)"JP_RecognitionLine_ID") + " : " + ((MRecognition)recognition).getDocumentInfo();
                    }
                    ++i;
                }
                String docAction = content.getJP_Contract_Acct().getDocAction();
                if (docAction != null && !((MRecognition)recognition).processIt(docAction)) {
                    throw new AdempiereException("Failed when processing document - " + ((MRecognition)recognition).getProcessMsg());
                }
                if (!recognition.getDocStatus().equals("CO")) {
                    recognition.saveEx(trxName);
                }
            }
        }
        if (timing == 14 || timing == 14 || timing == 10) {
            MInOut io = (MInOut)po;
            this.reversalRecognition(io, timing, false, io.getM_InOut_ID());
        }
        return null;
    }

    private boolean reversalRecognition(MInOut io, int timing, boolean isReversal, int original_InOut_ID) {
        String trxName = io.get_TrxName();
        MRecognition[] recogs = MRecognition.getRecognitionsByInOut(Env.getCtx(), io.getM_InOut_ID(), isReversal, original_InOut_ID, trxName);
        int i = 0;
        while (i < recogs.length) {
            MRecognition recog = recogs[i];
            if (recog.getDocStatus().equals("CO")) {
                if (timing == 14) {
                    recog.processIt("RA");
                } else if (timing == 13) {
                    recog.processIt("RC");
                } else {
                    recog.processIt("RA");
                }
            } else if (!recog.getDocStatus().equals("CO")) {
                recog.processIt("VO");
            } else if (MPeriod.isOpen((Properties)Env.getCtx(), (Timestamp)recog.getDateAcct(), (String)recog.getC_DocType().getDocBaseType(), (int)io.getAD_Org_ID())) {
                recog.processIt("RC");
            } else {
                recog.processIt("RA");
            }
            recog.saveEx(trxName);
            ++i;
        }
        return true;
    }

    private String inOutValidate(PO po, int type) {
        MInOut io;
        int JP_Contract_ID;
        String msg;
        MInOut counterIO;
        MInOut io2;
        if (type == 1 && (io2 = (MInOut)po).getRef_InOut_ID() > 0 && (counterIO = new MInOut(po.getCtx(), io2.getRef_InOut_ID(), po.get_TrxName())).get_ValueAsInt("JP_Contract_ID") > 0) {
            MContractContent counterContractContent;
            MContract counterContract = MContract.get(po.getCtx(), counterIO.get_ValueAsInt("JP_Contract_ID"));
            if (counterContract != null && counterContract.getJP_Contract_ID() > 0 && counterContract.getJP_CounterContract_ID() > 0) {
                io2.set_ValueNoCheck("JP_Contract_ID", (Object)counterContract.getJP_CounterContract_ID());
            }
            if (counterIO.get_ValueAsInt("JP_ContractContent_ID") > 0 && (counterContractContent = MContractContent.get(po.getCtx(), counterIO.get_ValueAsInt("JP_ContractContent_ID"))) != null && counterContractContent.getJP_ContractContent_ID() > 0 && counterContractContent.getJP_CounterContractContent_ID() > 0) {
                io2.set_ValueNoCheck("JP_ContractContent_ID", (Object)counterContractContent.getJP_CounterContractContent_ID());
            }
            if (counterIO.get_ValueAsInt("JP_ContractProcPeriod_ID") > 0) {
                io2.set_ValueNoCheck("JP_ContractProcPeriod_ID", (Object)counterIO.get_ValueAsInt("JP_ContractProcPeriod_ID"));
            }
        }
        if (!Util.isEmpty((String)(msg = this.derivativeDocHeaderCommonCheck(po, type)))) {
            return msg;
        }
        if ((type == 1 || type == 2 && (po.is_ValueChanged("JP_Contract_ID") || po.is_ValueChanged("JP_ContractContent_ID") || po.is_ValueChanged("C_Order_ID") || po.is_ValueChanged("M_RMA_ID"))) && (JP_Contract_ID = (io = (MInOut)po).get_ValueAsInt("JP_Contract_ID")) > 0) {
            MInOutLine[] contractInvoiceLines;
            MContract contract = MContract.get(Env.getCtx(), JP_Contract_ID);
            if (type == 2 && contract.getJP_ContractType().equals("PDC") && (contractInvoiceLines = this.getInOutLinesWithContractLine(io)).length > 0) {
                return Msg.getMsg((Properties)Env.getCtx(), (String)"JP_CannotChangeContractInfoForLines");
            }
        }
        return null;
    }

    private String inOutLineValidate(PO po, int type) {
        String msg;
        MInOutLine ioLine;
        if (type == 1 && (ioLine = (MInOutLine)po).getRef_InOutLine_ID() > 0) {
            MContractLine counterContractLine;
            MInOutLine counterIOLine = new MInOutLine(po.getCtx(), ioLine.getRef_InOutLine_ID(), po.get_TrxName());
            if (counterIOLine.get_ValueAsInt("JP_ContractLine_ID") > 0 && (counterContractLine = MContractLine.get(po.getCtx(), counterIOLine.get_ValueAsInt("JP_ContractLine_ID"))) != null && counterContractLine.getJP_ContractLine_ID() > 0 && counterContractLine.getJP_CounterContractLine_ID() > 0) {
                ioLine.set_ValueNoCheck("JP_ContractLine_ID", (Object)counterContractLine.getJP_CounterContractLine_ID());
            }
            if (counterIOLine.get_ValueAsInt("JP_ContractProcPeriod_ID") > 0) {
                ioLine.set_ValueNoCheck("JP_ContractProcPeriod_ID", (Object)counterIOLine.get_ValueAsInt("JP_ContractProcPeriod_ID"));
            }
        }
        if (!Util.isEmpty((String)(msg = this.derivativeDocLineCommonCheck(po, type)))) {
            return msg;
        }
        if (type == 1 || type == 2 && (po.is_ValueChanged("JP_ContractLine_ID") || po.is_ValueChanged("C_OrderLine_ID") || po.is_ValueChanged("M_RMALine_ID") || po.is_ValueChanged("JP_ContractProcPeriod_ID"))) {
            MInOutLine ioLine2 = (MInOutLine)po;
            int JP_ContractLine_ID = ioLine2.get_ValueAsInt("JP_ContractLine_ID");
            int JP_ContractContent_ID = ioLine2.getParent().get_ValueAsInt("JP_ContractContent_ID");
            int JP_Contract_ID = ioLine2.getParent().get_ValueAsInt("JP_Contract_ID");
            if (JP_Contract_ID <= 0) {
                return null;
            }
            MContract contract = MContract.get(Env.getCtx(), JP_Contract_ID);
            if (!contract.getJP_ContractType().equals("PDC") && !contract.getJP_ContractType().equals("STC")) {
                return null;
            }
            int C_OrderLine_ID = ioLine2.getC_OrderLine_ID();
            int M_RMALine_ID = ioLine2.getM_RMALine_ID();
            if (C_OrderLine_ID <= 0 && M_RMALine_ID <= 0) {
                Object[] objs = new Object[]{String.valueOf(Msg.getElement((Properties)Env.getCtx(), (String)"C_OrderLine_ID")) + " or " + Msg.getElement((Properties)Env.getCtx(), (String)"M_RMALine_ID")};
                return String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"JP_InCaseOfPeriodContractAndSpotContract")) + Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Mandatory", (Object[])objs);
            }
            if (ioLine2.getC_OrderLine_ID() > 0) {
                if (ioLine2.getC_OrderLine().getC_Order_ID() != ioLine2.getParent().getC_Order_ID()) {
                    return String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"JP_InCaseOfPeriodContractAndSpotContract")) + Msg.getMsg((Properties)Env.getCtx(), (String)"JP_CanNotBundleDifferentOrder");
                }
            } else if (ioLine2.getM_RMALine_ID() > 0 && ioLine2.getM_RMALine().getM_RMA_ID() != ioLine2.getParent().getM_RMA_ID()) {
                return String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"JP_InCaseOfPeriodContractAndSpotContract")) + Msg.getMsg((Properties)Env.getCtx(), (String)"JP_CanNotBundleDifferentRMA");
            }
            if (JP_ContractLine_ID <= 0) {
                return null;
            }
            MContractLine contractLine = MContractLine.get(Env.getCtx(), JP_ContractLine_ID);
            if (contractLine.getJP_ContractContent_ID() != JP_ContractContent_ID) {
                return String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"Invalid")) + " - " + Msg.getElement((Properties)Env.getCtx(), (String)"JP_ContractLine_ID") + Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Diff_ContractContentLine");
            }
            int ioLine_ContractProcPeriod_ID = ioLine2.get_ValueAsInt("JP_ContractProcPeriod_ID");
            MContractContent content = MContractContent.get(Env.getCtx(), JP_ContractContent_ID);
            if (contract.getJP_ContractType().equals("PDC")) {
                if (content.getJP_CreateDerivativeDocPolicy().equals("IO") || content.getJP_CreateDerivativeDocPolicy().equals("BT")) {
                    if (type == 2) {
                        if (ioLine_ContractProcPeriod_ID <= 0) {
                            Object[] objs = new Object[]{Msg.getElement((Properties)Env.getCtx(), (String)"JP_ContractProcPeriod_ID")};
                            return String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"JP_InCaseOfCreateDerivativeDocPolicy")) + Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Mandatory", (Object[])objs);
                        }
                        MContractProcPeriod ioLine_ContractProcPeriod = MContractProcPeriod.get(Env.getCtx(), ioLine_ContractProcPeriod_ID);
                        if (ioLine_ContractProcPeriod.getJP_ContractCalender_ID() != contractLine.getJP_ContractCalender_InOut_ID()) {
                            return Msg.getMsg((Properties)Env.getCtx(), (String)"JP_SelectContractProcPeriodBelongToContractLine");
                        }
                        MInOut inOut = ioLine2.getParent();
                        MContractProcPeriod ioPeriod = MContractProcPeriod.get(Env.getCtx(), inOut.get_ValueAsInt("JP_ContractProcPeriod_ID"));
                        if (ioPeriod.getStartDate().compareTo(ioLine_ContractProcPeriod.getStartDate()) > 0 || ioPeriod.getEndDate() != null && ioPeriod.getEndDate().compareTo(ioLine_ContractProcPeriod.getEndDate()) < 0) {
                            return String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"JP_OutsideContractProcessPeriod")) + " " + Msg.getMsg((Properties)Env.getCtx(), (String)"Invalid") + Msg.getElement((Properties)Env.getCtx(), (String)"JP_ContractProcPeriod_ID");
                        }
                    }
                } else if (po.get_ValueAsInt("JP_ContractProcPeriod_ID") != 0) {
                    po.set_ValueNoCheck("JP_ContractProcPeriod_ID", null);
                    ProcessInfo pInfo = Env.getProcessInfo((Properties)Env.getCtx());
                    if (pInfo == null) {
                        String nonEnterable = Msg.getMsg((Properties)Env.getCtx(), (String)"JP_NON-ENTERABLE");
                        String contractPeriod = Msg.getElement((Properties)Env.getCtx(), (String)"JP_ContractProcPeriod_ID");
                        String toBeConfirmed = Msg.getMsg((Properties)Env.getCtx(), (String)"JP_ToBeConfirmed");
                        String createDerivativeDocPolicy = Msg.getElement((Properties)Env.getCtx(), (String)"JP_CreateDerivativeDocPolicy");
                        try {
                            FDialog.info((int)0, null, (String)"JP_ContractManagementInfo", (String)(String.valueOf(nonEnterable) + " " + contractPeriod + " -> " + toBeConfirmed + " : " + createDerivativeDocPolicy));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            }
        }
        return null;
    }

    private MInOutLine[] getInOutLinesWithContractLine(MInOut io) {
        String whereClauseFinal = "M_InOut_ID=? AND JP_ContractLine_ID IS NOT NULL ";
        List list = new Query(Env.getCtx(), "M_InOutLine", whereClauseFinal, io.get_TrxName()).setParameters(new Object[]{io.getM_InOut_ID()}).setOrderBy("Line").list();
        return list.toArray(new MInOutLine[list.size()]);
    }

    public String factsValidate(MAcctSchema schema, List<Fact> facts, PO po) {
        int JP_ContractContent_ID;
        if (po.get_TableName().equals("M_InOut") && (JP_ContractContent_ID = po.get_ValueAsInt("JP_ContractContent_ID")) > 0) {
            MInOut inOut = (MInOut)po;
            for (Fact fact : facts) {
                FactLine[] factLine = fact.getLines();
                int i = 0;
                while (i < factLine.length) {
                    if (inOut.getC_Order_ID() > 0) {
                        factLine[i].set_ValueNoCheck("JP_Order_ID", (Object)inOut.getC_Order_ID());
                    } else if (inOut.getM_RMA_ID() > 0) {
                        int M_RMA_ID = inOut.getM_RMA_ID();
                        MRMA rma = new MRMA(Env.getCtx(), M_RMA_ID, null);
                        int JP_Order_ID = rma.get_ValueAsInt("JP_Order_ID");
                        if (JP_Order_ID > 0) {
                            factLine[i].set_ValueNoCheck("JP_Order_ID", (Object)JP_Order_ID);
                        }
                    }
                    factLine[i].set_ValueNoCheck("JP_ContractContent_ID", (Object)JP_ContractContent_ID);
                    ++i;
                }
            }
        }
        return null;
    }
}

