/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.base;

import java.math.BigDecimal;
import java.util.Properties;
import jpiere.base.plugin.org.adempiere.model.JPiereBankStatementTaxProvider;
import jpiere.base.plugin.org.adempiere.model.MBankStatementTax;
import org.compiere.model.MBankAccount;
import org.compiere.model.MBankStatement;
import org.compiere.model.MBankStatementLine;
import org.compiere.model.MClient;
import org.compiere.model.MInvoice;
import org.compiere.model.MPayment;
import org.compiere.model.MTax;
import org.compiere.model.MTaxProvider;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class JPiereBankStatementLineModelValidator
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(JPiereBankStatementLineModelValidator.class);
    private int AD_Client_ID = -1;
    private int AD_Org_ID = -1;
    private int AD_Role_ID = -1;
    private int AD_User_ID = -1;

    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.AD_Client_ID = client.getAD_Client_ID();
        }
        engine.addModelChange("C_BankStatementLine", (ModelValidator)this);
    }

    public int getAD_Client_ID() {
        return this.AD_Client_ID;
    }

    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        this.AD_Org_ID = AD_Org_ID;
        this.AD_Role_ID = AD_Role_ID;
        this.AD_User_ID = AD_User_ID;
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String modelChange(PO po, int type) throws Exception {
        if (type == 1 || type == 2) {
            MBankStatementLine bsl = (MBankStatementLine)po;
            MBankAccount ba = MBankAccount.get((Properties)bsl.getCtx(), (int)bsl.getParent().getC_BankAccount_ID());
            if (bsl.getAD_Org_ID() != ba.getAD_Org_ID()) {
                return Msg.getMsg((Properties)bsl.getCtx(), (String)"JP_DifferentOrg");
            }
            if (bsl.getC_Currency_ID() != ba.getC_Currency_ID()) {
                return Msg.getMsg((Properties)bsl.getCtx(), (String)"JP_DifferentCurrency");
            }
            if (bsl.getChargeAmt().compareTo(Env.ZERO) != 0) return null;
            bsl.setC_Charge_ID(0);
            bsl.set_ValueNoCheck("C_Tax_ID", null);
            return null;
        } else {
            MBankStatementLine bsl;
            PO bst;
            if (type == 4 || type == 5) {
                MBankStatementLine bsl2 = (MBankStatementLine)po;
                if (type == 4 || bsl2.is_ValueChanged("C_Payment_ID")) {
                    int new_Payment_ID = bsl2.getC_Payment_ID();
                    int old_Payment_ID = bsl2.get_ValueOldAsInt("C_Payment_ID");
                    if (new_Payment_ID > 0) {
                        MPayment newPayment = new MPayment(bsl2.getCtx(), new_Payment_ID, bsl2.get_TrxName());
                        if (!newPayment.getDocStatus().equals("CO") && !newPayment.getDocStatus().equals("CL")) {
                            if (newPayment.getDocStatus().equals("VO") || newPayment.getDocStatus().equals("RE") || newPayment.getDocStatus().equals("IN")) {
                                return Msg.getMsg((Properties)bsl2.getCtx(), (String)"JP_NotValidDocStatus");
                            }
                            MBankStatement bs = bsl2.getParent();
                            if (bs.getDocStatus().equals("CO") || bs.getDocStatus().equals("CL")) {
                                return Msg.getMsg((Properties)bsl2.getCtx(), (String)"JP_NotMatchIncompletePaymentAndCompleteBS");
                            }
                        }
                        if (newPayment.isReconciled()) {
                            return Msg.getMsg((Properties)bsl2.getCtx(), (String)"JP_AlreadyReconciled");
                        }
                        if (bsl2.getC_BPartner_ID() != newPayment.getC_BPartner_ID()) {
                            return Msg.getMsg((Properties)bsl2.getCtx(), (String)"JP_DifferentBusinessPartner_Payment");
                        }
                        BigDecimal payAmt = newPayment.getPayAmt();
                        if (!newPayment.isReceipt()) {
                            payAmt = payAmt.negate();
                        }
                        if (bsl2.getTrxAmt().compareTo(payAmt) != 0) {
                            return Msg.getMsg((Properties)bsl2.getCtx(), (String)"JP_DifferentAmt");
                        }
                        MBankStatement bs = bsl2.getParent();
                        if (bs.getDocStatus().equals("CO") || bs.getDocStatus().equals("CL")) {
                            newPayment.setIsReconciled(true);
                            newPayment.saveEx(bsl2.get_TrxName());
                        }
                    }
                    if (old_Payment_ID > 0 && new_Payment_ID != old_Payment_ID) {
                        old_Payment_ID = bsl2.get_ValueOldAsInt("C_Payment_ID");
                        MPayment oldPayment = new MPayment(bsl2.getCtx(), old_Payment_ID, bsl2.get_TrxName());
                        oldPayment.setIsReconciled(false);
                        oldPayment.saveEx(bsl2.get_TrxName());
                    }
                }
                if (type == 4 || bsl2.is_ValueChanged("C_BPartner_ID")) {
                    MInvoice invoice;
                    MPayment payment;
                    int new_BPartner_ID = bsl2.getC_BPartner_ID();
                    int C_Payment_ID = bsl2.getC_Payment_ID();
                    if (C_Payment_ID > 0 && new_BPartner_ID != (payment = new MPayment(bsl2.getCtx(), C_Payment_ID, bsl2.get_TrxName())).getC_BPartner_ID()) {
                        return Msg.getMsg((Properties)bsl2.getCtx(), (String)"JP_DifferentBusinessPartner_Payment");
                    }
                    int C_Invoice_ID = bsl2.getC_Invoice_ID();
                    if (C_Invoice_ID > 0 && new_BPartner_ID != (invoice = new MInvoice(bsl2.getCtx(), C_Invoice_ID, bsl2.get_TrxName())).getC_BPartner_ID()) {
                        return Msg.getMsg((Properties)bsl2.getCtx(), (String)"JP_DifferentBusinessPartner_Invoice");
                    }
                }
                boolean newRecord = true;
                if (type == 5) {
                    newRecord = false;
                }
                if (bsl2.getChargeAmt().compareTo(Env.ZERO) == 0) {
                    PO bst2 = MBankStatementTax.get(bsl2.getCtx(), bsl2.getC_BankStatementLine_ID());
                    if (bst2 == null) return null;
                    bst2.deleteEx(false);
                    return null;
                }
                Object C_Tax_ID = po.get_Value("C_Tax_ID");
                if (C_Tax_ID == null) {
                    PO bst3 = MBankStatementTax.get(bsl2.getCtx(), bsl2.getC_BankStatementLine_ID());
                    if (bst3 == null) return null;
                    bst3.deleteEx(false);
                    return null;
                }
                MTax tax = new MTax(po.getCtx(), new Integer(C_Tax_ID.toString()).intValue(), po.get_TrxName());
                if (tax.getC_TaxProvider_ID() == 0) {
                    return Msg.getMsg((Properties)bsl2.getCtx(), (String)"JP_SetTaxProvider");
                }
                MTaxProvider provider = new MTaxProvider(tax.getCtx(), tax.getC_TaxProvider_ID(), tax.get_TrxName());
                if (!provider.getTaxProviderClass().equals("jpiere.base.plugin.org.adempiere.model.JPiereTaxProvider")) return Msg.getMsg((Properties)bsl2.getCtx(), (String)"JP_InvalidTaxProvider");
                Class<?> ppClass = Class.forName("jpiere.base.plugin.org.adempiere.model.JPiereBankStatementTaxProvider");
                JPiereBankStatementTaxProvider calculator = (JPiereBankStatementTaxProvider)ppClass.newInstance();
                boolean isCalculate = calculator.recalculateTax(provider, bsl2, newRecord);
                if (isCalculate) return null;
                return Msg.getMsg((Properties)bsl2.getCtx(), (String)"Error");
            }
            if (type != 6 || (bst = MBankStatementTax.get((bsl = (MBankStatementLine)po).getCtx(), bsl.getC_BankStatementLine_ID())) == null) return null;
            bst.deleteEx(false);
        }
        return null;
    }

    public String docValidate(PO po, int timing) {
        return null;
    }
}

