/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.base;

import java.util.Properties;
import jpiere.base.plugin.util.ZenginCheck;
import org.compiere.model.MBankAccount;
import org.compiere.model.MClient;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;

public class JPiereBankAccountModelValidator
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(JPiereBankAccountModelValidator.class);
    private int AD_Client_ID = -1;
    private int AD_Org_ID = -1;
    private int AD_Role_ID = -1;
    private int AD_User_ID = -1;

    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.AD_Client_ID = client.getAD_Client_ID();
        }
        engine.addModelChange("C_BankAccount", (ModelValidator)this);
    }

    public int getAD_Client_ID() {
        return this.AD_Client_ID;
    }

    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        this.AD_Org_ID = AD_Org_ID;
        this.AD_Role_ID = AD_Role_ID;
        this.AD_User_ID = AD_User_ID;
        return null;
    }

    public String modelChange(PO po, int type) throws Exception {
        MBankAccount bankAcct;
        String jp_RequesterName;
        if (!(type != 1 && type != 2 || Util.isEmpty((String)(jp_RequesterName = (String)(bankAcct = (MBankAccount)po).get_Value("JP_RequesterName"))))) {
            int i = 0;
            while (i < jp_RequesterName.length()) {
                if (!ZenginCheck.charCheck(jp_RequesterName.charAt(i))) {
                    Object[] objs = new Object[]{Character.valueOf(jp_RequesterName.charAt(i))};
                    return Msg.getMsg((Properties)Env.getCtx(), (String)"JP_CanNotUseChar", (Object[])objs);
                }
                ++i;
            }
            if (jp_RequesterName.length() > 40) {
                Object[] objs = new Object[]{Msg.getElement((Properties)Env.getCtx(), (String)"JP_BankName_Kana"), 40};
                return Msg.getMsg((Properties)Env.getCtx(), (String)"JP_LessThanChars", (Object[])objs);
            }
            String jp_RequesterCode = (String)bankAcct.get_Value("JP_RequesterCode");
            if (Util.isEmpty((String)jp_RequesterCode)) {
                Object[] objs = new Object[]{Msg.getElement((Properties)Env.getCtx(), (String)"JP_RequesterCode")};
                return Msg.getMsg((Properties)Env.getCtx(), (String)"JP_NOT-INOUT", (Object[])objs);
            }
            if (jp_RequesterCode.length() != 10) {
                Object[] objs = new Object[]{Msg.getElement((Properties)Env.getCtx(), (String)"JP_RequesterCode"), 10};
                return Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Characters", (Object[])objs);
            }
            if (!ZenginCheck.numStringCheck(jp_RequesterCode)) {
                Object[] objs = new Object[]{jp_RequesterCode};
                return String.valueOf(Msg.getElement((Properties)Env.getCtx(), (String)"JP_RequesterCode")) + " : " + Msg.getMsg((Properties)Env.getCtx(), (String)"JP_CanNotUseString", (Object[])objs);
            }
            String jp_BranchCode = (String)bankAcct.get_Value("JP_BranchCode");
            if (Util.isEmpty((String)jp_BranchCode)) {
                Object[] objs = new Object[]{Msg.getElement((Properties)Env.getCtx(), (String)"JP_BranchCode")};
                return Msg.getMsg((Properties)Env.getCtx(), (String)"JP_NOT-INOUT", (Object[])objs);
            }
            if (jp_BranchCode.length() != 3) {
                Object[] objs = new Object[]{Msg.getElement((Properties)Env.getCtx(), (String)"JP_BranchCode"), 3};
                return Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Characters", (Object[])objs);
            }
            if (!ZenginCheck.numStringCheck(jp_BranchCode)) {
                Object[] objs = new Object[]{jp_BranchCode};
                return String.valueOf(Msg.getElement((Properties)Env.getCtx(), (String)"JP_BranchCode")) + " : " + Msg.getMsg((Properties)Env.getCtx(), (String)"JP_CanNotUseString", (Object[])objs);
            }
            String jp_BranchName_Kana = (String)bankAcct.get_Value("JP_BranchName_Kana");
            if (Util.isEmpty((String)jp_BranchName_Kana)) {
                Object[] objs = new Object[]{Msg.getElement((Properties)Env.getCtx(), (String)"JP_BranchName_Kana")};
                return Msg.getMsg((Properties)Env.getCtx(), (String)"JP_NOT-INOUT", (Object[])objs);
            }
            int i2 = 0;
            while (i2 < jp_BranchName_Kana.length()) {
                if (!ZenginCheck.charCheck(jp_BranchName_Kana.charAt(i2))) {
                    Object[] objs = new Object[]{Character.valueOf(jp_BranchName_Kana.charAt(i2))};
                    return Msg.getMsg((Properties)Env.getCtx(), (String)"JP_CanNotUseChar", (Object[])objs);
                }
                ++i2;
            }
            if (jp_BranchName_Kana.length() > 15) {
                Object[] objs = new Object[]{Msg.getElement((Properties)Env.getCtx(), (String)"JP_BranchName_Kana"), 15};
                return Msg.getMsg((Properties)Env.getCtx(), (String)"JP_LessThanChars", (Object[])objs);
            }
            String accountNo = bankAcct.getAccountNo();
            if (Util.isEmpty((String)accountNo)) {
                Object[] objs = new Object[]{Msg.getElement((Properties)Env.getCtx(), (String)"AccountNo")};
                return Msg.getMsg((Properties)Env.getCtx(), (String)"JP_NOT-INOUT", (Object[])objs);
            }
            if (accountNo.length() != 7) {
                Object[] objs = new Object[]{Msg.getElement((Properties)Env.getCtx(), (String)"AccountNo"), 7};
                return Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Characters", (Object[])objs);
            }
            if (!ZenginCheck.numStringCheck(accountNo)) {
                Object[] objs = new Object[]{accountNo};
                return String.valueOf(Msg.getElement((Properties)Env.getCtx(), (String)"AccountNo")) + " : " + Msg.getMsg((Properties)Env.getCtx(), (String)"JP_CanNotUseString", (Object[])objs);
            }
            bankAcct.setPaymentExportClass("org.compiere.util.JapanPaymentExport");
        }
        return null;
    }

    public String docValidate(PO po, int timing) {
        return null;
    }
}

