/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.factory;

import java.util.logging.Level;
import org.adempiere.base.ITaxProviderFactory;
import org.adempiere.base.equinox.EquinoxExtensionLocator;
import org.adempiere.model.ITaxProvider;
import org.compiere.util.CLogger;

public class JPiereBasePluginTaxProviderFactory
implements ITaxProviderFactory {
    private static final CLogger s_log = CLogger.getCLogger(JPiereBasePluginTaxProviderFactory.class);

    public ITaxProvider newTaxProviderInstance(String className) {
        if (className.startsWith("jpiere.base.plugin")) {
            ITaxProvider myCalculator = (ITaxProvider)EquinoxExtensionLocator.instance().locate(ITaxProvider.class, className, null).getExtension();
            if (myCalculator == null) {
                try {
                    Class<?> ppClass = Class.forName(className);
                    if (ppClass != null) {
                        myCalculator = (ITaxProvider)ppClass.newInstance();
                    }
                }
                catch (Error e1) {
                    s_log.log(Level.SEVERE, String.valueOf(className) + " - Error=" + e1.getMessage());
                    return null;
                }
                catch (Exception e2) {
                    s_log.log(Level.SEVERE, className, (Throwable)e2);
                    return null;
                }
            }
            if (myCalculator == null) {
                s_log.log(Level.SEVERE, "Not found in extension registry and classpath");
                return null;
            }
            return myCalculator;
        }
        return null;
    }
}

