/*
 * Decompiled with CFR 0.152.
 */
package test.functional;

import java.util.Properties;
import org.compiere.model.MBPartner;
import org.compiere.model.MTest;
import org.compiere.model.POInfo;
import org.compiere.util.DB;
import test.AdempiereTestCase;

public class POTest
extends AdempiereTestCase {
    public void test_Changed() throws Exception {
        String[] testStrings = new String[]{"a", "test"};
        MTest testPO = new MTest(this.getCtx(), ((Object)((Object)this)).getClass().getName(), 1);
        testPO.set_TrxName(this.getTrxName());
        String[] stringArray = testStrings;
        int n = testStrings.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            testPO.setHelp(str);
            testPO.saveEx();
            String originalString = testPO.getHelp();
            String info = "testString=[" + str + "]" + ", originalString=[" + originalString + "]";
            POTest.assertFalse((String)info, (boolean)testPO.is_ValueChanged("Help"));
            POTest.assertFalse((String)info, (boolean)testPO.is_Changed());
            testPO.setHelp(originalString);
            POTest.assertFalse((String)info, (boolean)testPO.is_ValueChanged("Help"));
            POTest.assertFalse((String)info, (boolean)testPO.is_Changed());
            testPO.setHelp(String.valueOf(originalString) + "-changed");
            POTest.assertTrue((String)info, (boolean)testPO.is_ValueChanged("Help"));
            POTest.assertTrue((String)info, (boolean)testPO.is_Changed());
            testPO.setHelp(originalString);
            POTest.assertFalse((String)info, (boolean)testPO.is_ValueChanged("Help"));
            POTest.assertFalse((String)info, (boolean)testPO.is_Changed());
            ++n2;
        }
        testPO.delete(true, this.getTrxName());
    }

    public void testTruncatedStrings() {
        StringBuilder sb = new StringBuilder();
        int i = 1;
        while (i <= 1000) {
            sb.append("0123456789");
            ++i;
        }
        String bigString = sb.toString();
        MTest testPO = new MTest(this.getCtx(), ((Object)((Object)this)).getClass().getName(), 1);
        testPO.set_TrxName(this.getTrxName());
        POInfo info = POInfo.getPOInfo((Properties)this.getCtx(), (int)135);
        int maxLength = info.getFieldLength(info.getColumnIndex("Name"));
        testPO.set_ValueOfColumn("Name", (Object)bigString.substring(0, maxLength - 1));
        String resultString = (String)testPO.get_Value("Name");
        POTest.assertEquals((String)"String was not truncated correctly (1)", (int)(maxLength - 1), (int)resultString.length());
        testPO.setName(bigString.substring(0, maxLength - 1));
        POTest.assertEquals((String)"String was not truncated correctly (2)", (int)(maxLength - 1), (int)testPO.getName().length());
        testPO.set_ValueOfColumn("Name", (Object)bigString.substring(0, maxLength));
        resultString = (String)testPO.get_Value("Name");
        POTest.assertEquals((String)"String was not truncated correctly (3)", (int)maxLength, (int)resultString.length());
        testPO.setName(bigString.substring(0, maxLength));
        POTest.assertEquals((String)"String was not truncated correctly (4)", (int)maxLength, (int)testPO.getName().length());
        testPO.set_ValueOfColumn("Name", (Object)bigString);
        resultString = (String)testPO.get_Value("Name");
        POTest.assertEquals((String)"String was not truncated correctly (5)", (int)maxLength, (int)resultString.length());
        testPO.setName(bigString);
        POTest.assertEquals((String)"String was not truncated correctly (6)", (int)maxLength, (int)testPO.getName().length());
    }

    public void testAfterSaveError() {
        MyTestPO test = new MyTestPO(this.getCtx(), true, null);
        POTest.assertFalse((String)("Object should not be saved -- " + (Object)((Object)test)), (boolean)test.save());
        POTest.assertFalse((String)("Object should not be saved -- " + (Object)((Object)test)), (test.get_ID() <= 0 ? 1 : 0) != 0);
        POTest.assertFalse((String)("Object should not be saved(2) -- " + (Object)((Object)test)), (boolean)MyTestPO.exists(test.get_ID(), null));
        test = new MyTestPO(this.getCtx(), false, null);
        POTest.assertTrue((String)("Object *should* be saved -- " + (Object)((Object)test)), (boolean)test.save());
        MyTestPO test2 = new MyTestPO(this.getCtx(), test.get_ID(), null);
        POTest.assertEquals((String)"Object not found", (int)test.get_ID(), (int)test2.get_ID());
        test2.failOnSave = true;
        test2.setName(String.valueOf(test2.getName()) + "_2");
        POTest.assertFalse((String)("Object should not be saved -- " + (Object)((Object)test2)), (boolean)test2.save());
        String name = MyTestPO.getName(test2.get_ID(), null);
        POTest.assertEquals((String)("Object should not be modified(2) -- id=" + (Object)((Object)test2)), (String)test.getName(), (String)name);
    }

    public void testAfterSaveError_BF2849122() throws Exception {
        POTest.assertNotNull((String)"TrxName should not be null", (Object)this.getTrxName());
        MyTestPO t1 = new MyTestPO(this.getCtx(), false, this.getTrxName());
        t1.saveEx();
        POTest.assertTrue((String)("Object not found(1) - t1=" + (Object)((Object)t1)), (boolean)MyTestPO.exists(t1.get_ID(), this.getTrxName()));
        POTest.assertTrue((String)("Object not found(1) - t1(dep)=" + (Object)((Object)t1)), (boolean)MyTestPO.exists(t1.getDependent_ID(), this.getTrxName()));
        MyTestPO t2 = new MyTestPO(this.getCtx(), true, this.getTrxName());
        try {
            t2.saveEx();
        }
        catch (Exception exception) {
            // empty catch block
        }
        POTest.assertTrue((String)("Object not found(2) - t1=" + (Object)((Object)t1)), (boolean)MyTestPO.exists(t1.get_ID(), this.getTrxName()));
        POTest.assertTrue((String)("Object not found(2) - t1(dep)=" + (Object)((Object)t1)), (boolean)MyTestPO.exists(t1.getDependent_ID(), this.getTrxName()));
        POTest.assertFalse((String)("Object found(2) - t2=" + (Object)((Object)t2)), (boolean)MyTestPO.exists(t2.get_ID(), this.getTrxName()));
        POTest.assertFalse((String)("Object found(2) - t2(dep)=" + (Object)((Object)t2)), (boolean)MyTestPO.exists(t2.getDependent_ID(), this.getTrxName()));
        MyTestPO t3 = new MyTestPO(this.getCtx(), false, this.getTrxName());
        t3.saveEx();
        POTest.assertTrue((String)("Object not found(3) - t1=" + (Object)((Object)t1)), (boolean)MyTestPO.exists(t1.get_ID(), this.getTrxName()));
        POTest.assertTrue((String)("Object not found(3) - t1(dep)=" + (Object)((Object)t1)), (boolean)MyTestPO.exists(t1.getDependent_ID(), this.getTrxName()));
        POTest.assertFalse((String)("Object found(3) - t2=" + (Object)((Object)t2)), (boolean)MyTestPO.exists(t2.get_ID(), this.getTrxName()));
        POTest.assertFalse((String)("Object found(3) - t2(dep)=" + (Object)((Object)t2)), (boolean)MyTestPO.exists(t2.getDependent_ID(), this.getTrxName()));
        POTest.assertTrue((String)("Object not found(3) - t3=" + (Object)((Object)t3)), (boolean)MyTestPO.exists(t3.get_ID(), this.getTrxName()));
        POTest.assertTrue((String)("Object not found(3) - t3(dep)=" + (Object)((Object)t3)), (boolean)MyTestPO.exists(t3.getDependent_ID(), this.getTrxName()));
    }

    public void testAD_OrgBP_ID_Issue() throws Exception {
        int new_org_id;
        MBPartner bp = new MBPartner(this.getCtx(), 50004, this.getTrxName());
        int old_org_id = bp.getAD_OrgBP_ID_Int();
        if (old_org_id == (new_org_id = 50005)) {
            new_org_id = 12;
        }
        bp.setAD_OrgBP_ID(new_org_id);
        bp.getAD_OrgBP_ID_Int();
        bp.saveEx();
    }

    public static class MyTestPO
    extends MTest {
        private static final long serialVersionUID = -6861171283806782985L;
        protected boolean failOnSave = false;
        private MyTestPO m_parent = null;
        private MyTestPO m_dependentRecord = null;

        public static String getName(int Test_ID, String trxName) {
            String sql = "SELECT Name FROM Test WHERE Test_ID=?";
            return DB.getSQLValueStringEx((String)trxName, (String)sql, (Object[])new Object[]{Test_ID});
        }

        public static boolean exists(int Test_ID, String trxName) {
            String sql = "SELECT Test_ID FROM Test WHERE Test_ID=?";
            int id = DB.getSQLValueEx((String)trxName, (String)"SELECT Test_ID FROM Test WHERE Test_ID=?", (Object[])new Object[]{Test_ID});
            return id > 0 && id == Test_ID;
        }

        public MyTestPO(Properties ctx, boolean failOnSave, String trxName) {
            super(ctx, "Test_" + System.currentTimeMillis(), 10);
            this.set_TrxName(trxName);
            this.setDescription("" + ((Object)((Object)this)).getClass());
            this.failOnSave = failOnSave;
        }

        public MyTestPO(Properties ctx, int id, String trxName) {
            super(ctx, id, trxName);
        }

        protected boolean afterSave(boolean newRecord, boolean success) {
            if (this.m_parent == null) {
                this.m_dependentRecord = new MyTestPO(this.getCtx(), false, this.get_TrxName());
                this.m_dependentRecord.m_parent = this;
                this.m_dependentRecord.setName("D_" + this.getName());
                this.m_dependentRecord.saveEx();
            }
            if (this.failOnSave) {
                throw new RuntimeException("Never save this object [trxName=" + this.get_TrxName() + ", success=" + success + "]");
            }
            return true;
        }

        public int getDependent_ID() {
            return this.m_dependentRecord != null ? this.m_dependentRecord.get_ID() : -1;
        }
    }
}

