/*
 * Decompiled with CFR 0.152.
 */
package test.functional;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Properties;
import org.compiere.model.MLocator;
import org.compiere.model.MStorageOnHand;
import org.compiere.model.MStorageReservation;
import org.compiere.model.MWarehouse;
import org.compiere.util.Env;
import test.AdempiereTestCase;

public class MStorageTest
extends AdempiereTestCase {
    int product_id = 122;
    int location_id = 114;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        MStorageTest.assertEquals((String)"Client is not GardenWorld", (int)11, (int)Env.getAD_Client_ID((Properties)this.getCtx()));
    }

    private MLocator createLocator(MWarehouse wh, String locatorValue, double qtyOnHand) {
        MLocator loc = new MLocator(wh, String.valueOf(wh.getValue()) + "-" + locatorValue);
        loc.setXYZ("X" + locatorValue, "Y" + locatorValue, "Z" + locatorValue);
        loc.saveEx();
        BigDecimal targetQty = BigDecimal.valueOf(qtyOnHand).setScale(12, RoundingMode.HALF_UP);
        MStorageOnHand s1 = MStorageOnHand.getCreate((Properties)this.getCtx(), (int)loc.get_ID(), (int)this.product_id, (int)0, null, (String)this.getTrxName());
        s1.setQtyOnHand(targetQty);
        s1.saveEx();
        BigDecimal qty = MStorageReservation.getQtyAvailable((int)wh.get_ID(), (int)this.product_id, (int)0, (String)this.getTrxName()).setScale(12, RoundingMode.HALF_UP);
        MStorageTest.assertEquals((String)("Error on locator " + locatorValue), (Object)targetQty, (Object)qty);
        return loc;
    }

    private void assertWarehouseQty(MWarehouse wh, BigDecimal targetQty) {
        BigDecimal qty = MStorageReservation.getQtyAvailable((int)wh.get_ID(), (int)this.product_id, (int)0, (String)this.getTrxName());
        qty = qty.setScale(12, RoundingMode.HALF_UP);
        targetQty = targetQty.setScale(12, RoundingMode.HALF_UP);
        MStorageTest.assertEquals((Object)targetQty, (Object)qty);
    }

    public void testGetQtyAvailable() throws Exception {
        BigDecimal whQty = Env.ZERO;
        MWarehouse wh = new MWarehouse(this.getCtx(), 0, this.getTrxName());
        wh.setValue("test-wh");
        wh.setName("test-wh");
        wh.setC_Location_ID(this.location_id);
        wh.saveEx();
        this.assertWarehouseQty(wh, whQty);
        int i = 1;
        while (i <= 10) {
            this.createLocator(wh, "" + i, i);
            whQty = whQty.add(BigDecimal.valueOf(i));
            this.assertWarehouseQty(wh, whQty);
            ++i;
        }
    }
}

