/*
 * Decompiled with CFR 0.152.
 */
package test.functional;

import java.util.Arrays;
import java.util.Collection;
import org.compiere.util.EMail;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class EmailFormatValidatorTest {
    private String arg;
    private Boolean expectedValidation;

    public EmailFormatValidatorTest(String str, Boolean expectedValidation) {
        this.arg = str;
        this.expectedValidation = expectedValidation;
    }

    @BeforeClass
    public static void initialize() {
    }

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        Object[][] data = new Object[][]{{"javacodegeeks@gmail.com.2j", true}, {"java@java@oracle.com", false}, {"java!!!@example.com", true}, {"mysite@.com", false}, {"javacodegees.com", false}, {".javacodegees.com@at.com", true}, {"javacodegees..javacom@at.com", true}, {"javacodegeeks@gmail.com", true}, {"nikos+mylist@gmail.com", true}, {"abc.efg-900@gmail-list.com", true}, {"abc123@example.com.gr", true}, {"username+detail@example.com", true}, {"user@example.museum", true}, {"myemail+sketchysite@gmail.com", true}, {"micky.o'finnagan@wherever.com", true}, {"exampleemail@testing.info", true}, {"marcelo.calbucci%mandic@fapesp.com.br", true}, {"customer/department=shipping@example.com", true}, {"$A12345@example.com", true}, {"!def!xyz%abc@example.com", true}, {"_somename@example.com", true}, {"nu\u00f1ez@globalqss.com", false}, {"name@tld", true}, {"john@server.department.company.com", true}};
        return Arrays.asList(data);
    }

    @Test
    public void test() {
        Boolean res = EMail.validate((String)this.arg);
        String validv = res != false ? "valid" : "invalid";
        System.out.println("EMail " + this.arg + " is " + validv);
        Assert.assertEquals((String)"Result", (Object)this.expectedValidation, (Object)res);
    }
}

