/*
 * Decompiled with CFR 0.152.
 */
package test.functional;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import org.adempiere.exceptions.DBException;
import org.compiere.util.DB;
import org.compiere.util.KeyNamePair;
import org.compiere.util.TimeUtil;
import org.compiere.util.ValueNamePair;
import test.AdempiereTestCase;

public class DBTest
extends AdempiereTestCase {
    public void test_getSQLValueEx() throws Exception {
        int result = DB.getSQLValueEx(null, (String)"SELECT 10 FROM DUAL", (Object[])new Object[0]);
        DBTest.assertEquals((int)10, (int)result);
        result = DB.getSQLValue(null, (String)"SELECT 10 FROM AD_SYSTEM WHERE 1=2");
        DBTest.assertEquals((String)"No value should be returned", (int)-1, (int)result);
        DBException ex = null;
        try {
            result = DB.getSQLValueEx(null, (String)"SELECT 10 FROM INEXISTENT_TABLE", (Object[])new Object[0]);
        }
        catch (DBException e) {
            ex = e;
        }
        DBTest.assertNotNull((String)"No DBException Was Throwed", (Object)((Object)ex));
    }

    public void test_getSQLValue() throws Exception {
        int result = DB.getSQLValue(null, (String)"SELECT 10 FROM DUAL");
        DBTest.assertEquals((int)10, (int)result);
        result = DB.getSQLValue(null, (String)"SELECT 10 FROM AD_SYSTEM WHERE 1=2");
        DBTest.assertEquals((String)"No value should be returned", (int)-1, (int)result);
        result = DB.getSQLValue(null, (String)"SELECT 10 FROM INEXISTENT_TABLE");
        DBTest.assertEquals((String)"Error should be signaled", (int)-1, (int)result);
    }

    public void test_getSQLValueBDEx() throws Exception {
        BigDecimal result = DB.getSQLValueBDEx(null, (String)"SELECT 10 FROM DUAL", (Object[])new Object[0]);
        DBTest.assertEquals((Object)BigDecimal.TEN, (Object)result);
        result = DB.getSQLValueBD(null, (String)"SELECT 10 FROM AD_SYSTEM WHERE 1=2", (Object[])new Object[0]);
        DBTest.assertNull((String)"No value should be returned", (Object)result);
        DBException ex = null;
        try {
            result = DB.getSQLValueBDEx(null, (String)"SELECT 10 FROM INEXISTENT_TABLE", (Object[])new Object[0]);
        }
        catch (DBException e) {
            ex = e;
        }
        DBTest.assertNotNull((String)"No DBException Was Throwed", (Object)((Object)ex));
    }

    public void test_getSQLValueBD() throws Exception {
        BigDecimal result = DB.getSQLValueBD(null, (String)"SELECT 10 FROM DUAL", (Object[])new Object[0]);
        DBTest.assertEquals((Object)BigDecimal.TEN, (Object)result);
        result = DB.getSQLValueBD(null, (String)"SELECT 10 FROM AD_SYSTEM WHERE 1=2", (Object[])new Object[0]);
        DBTest.assertNull((String)"No value should be returned", (Object)result);
        result = DB.getSQLValueBD(null, (String)"SELECT 10 FROM INEXISTENT_TABLE", (Object[])new Object[0]);
        DBTest.assertNull((String)"Error should be signaled", (Object)result);
    }

    public void test_getSQLValueStringEx() throws Exception {
        String result = DB.getSQLValueStringEx(null, (String)"SELECT 'string' FROM DUAL", (Object[])new Object[0]);
        DBTest.assertEquals((String)"string", (String)result);
        result = DB.getSQLValueStringEx(null, (String)"SELECT 10 FROM AD_SYSTEM WHERE 1=2", (Object[])new Object[0]);
        DBTest.assertNull((String)"No value should be returned", (Object)result);
        DBException ex = null;
        try {
            result = DB.getSQLValueStringEx(null, (String)"SELECT 'string' FROM INEXISTENT_TABLE", (Object[])new Object[0]);
        }
        catch (DBException e) {
            ex = e;
        }
        DBTest.assertNotNull((String)"No DBException Was Throwed", (Object)((Object)ex));
    }

    public void test_getSQLValueString() throws Exception {
        String result = DB.getSQLValueString(null, (String)"SELECT 'string' FROM DUAL", (Object[])new Object[0]);
        DBTest.assertEquals((String)"string", (String)result);
        result = DB.getSQLValueString(null, (String)"SELECT 'string' FROM AD_SYSTEM WHERE 1=2", (Object[])new Object[0]);
        DBTest.assertNull((String)"No value should be returned", (Object)result);
        result = DB.getSQLValueString(null, (String)"SELECT 'string' FROM INEXISTENT_TABLE", (Object[])new Object[0]);
        DBTest.assertNull((String)"Error should be signaled", (Object)result);
    }

    public void test_getSQLValueTSEx() throws Exception {
        Timestamp target = TimeUtil.getDay((int)2008, (int)1, (int)1);
        Timestamp result = DB.getSQLValueTSEx(null, (String)"SELECT TO_DATE('2008-01-01','YYYY-MM-DD') FROM AD_SYSTEM", (Object[])new Object[0]);
        DBTest.assertEquals((Object)target, (Object)result);
        result = DB.getSQLValueTSEx(null, (String)"SELECT TO_DATE('2008-01-01','YYYY-MM-DD') FROM AD_SYSTEM WHERE 1=2", (Object[])new Object[0]);
        DBTest.assertNull((String)"No value should be returned", (Object)result);
        DBException ex = null;
        try {
            result = DB.getSQLValueTSEx(null, (String)"SELECT TO_DATE('2008-01-01','YYYY-MM-DD') FROM INEXISTENT_TABLE", (Object[])new Object[0]);
        }
        catch (DBException e) {
            ex = e;
        }
        DBTest.assertNotNull((String)"No DBException Was Throwed", (Object)((Object)ex));
    }

    public void test_getSQLValueTS() throws Exception {
        Timestamp target = TimeUtil.getDay((int)2008, (int)1, (int)1);
        Timestamp result = DB.getSQLValueTS(null, (String)"SELECT TO_DATE('2008-01-01','YYYY-MM-DD') FROM DUAL", (Object[])new Object[0]);
        DBTest.assertEquals((Object)target, (Object)result);
        result = DB.getSQLValueTS(null, (String)"SELECT TO_DATE('2008-01-01','YYYY-MM-DD') FROM AD_SYSTEM WHERE 1=2", (Object[])new Object[0]);
        DBTest.assertNull((String)"No value should be returned", (Object)result);
        result = DB.getSQLValueTS(null, (String)"SELECT TO_DATE('2008-01-01','YYYY-MM-DD') FROM INEXISTENT_TABLE", (Object[])new Object[0]);
        DBTest.assertNull((String)"Error should be signaled", (Object)result);
    }

    public void test_getValueNamePairs() throws Exception {
        ArrayList<Integer> params = new ArrayList<Integer>();
        params.add(5);
        String sql = "SELECT Value, Name FROM AD_Ref_List WHERE AD_Reference_ID=? ORDER BY Value";
        ValueNamePair[] arr = DB.getValueNamePairs((String)"SELECT Value, Name FROM AD_Ref_List WHERE AD_Reference_ID=? ORDER BY Value", (boolean)true, params);
        DBTest.assertEquals((String)"Invalid size", (int)7, (int)arr.length);
        DBTest.assertSame((String)"First value should be EMPTY", (Object)ValueNamePair.EMPTY, (Object)arr[0]);
        DBTest.assertEquals((String)arr[1].getValue(), (String)"1");
        DBTest.assertEquals((String)arr[2].getValue(), (String)"2");
        DBTest.assertEquals((String)arr[3].getValue(), (String)"3");
        DBTest.assertEquals((String)arr[4].getValue(), (String)"4");
        DBTest.assertEquals((String)arr[5].getValue(), (String)"6");
        DBTest.assertEquals((String)arr[6].getValue(), (String)"7");
        arr = DB.getValueNamePairs((String)"SELECT Value, Name FROM AD_Ref_List WHERE AD_Reference_ID=? ORDER BY Value", (boolean)false, params);
        DBTest.assertEquals((String)"Invalid size", (int)6, (int)arr.length);
        DBTest.assertEquals((String)arr[0].getValue(), (String)"1");
        DBTest.assertEquals((String)arr[1].getValue(), (String)"2");
        DBTest.assertEquals((String)arr[2].getValue(), (String)"3");
        DBTest.assertEquals((String)arr[3].getValue(), (String)"4");
        DBTest.assertEquals((String)arr[4].getValue(), (String)"6");
        DBTest.assertEquals((String)arr[5].getValue(), (String)"7");
    }

    public void test_getKeyNamePairs() throws Exception {
        ArrayList<Integer> params = new ArrayList<Integer>();
        params.add(5);
        String sql = "SELECT AD_Ref_List_ID, Value FROM AD_Ref_List WHERE AD_Reference_ID=? ORDER BY Value";
        KeyNamePair[] arr = DB.getKeyNamePairs((String)"SELECT AD_Ref_List_ID, Value FROM AD_Ref_List WHERE AD_Reference_ID=? ORDER BY Value", (boolean)true, params);
        DBTest.assertEquals((String)"Invalid size", (int)7, (int)arr.length);
        DBTest.assertSame((String)"First value should be EMPTY", (Object)KeyNamePair.EMPTY, (Object)arr[0]);
        DBTest.assertEquals((String)arr[1].getName(), (String)"1");
        DBTest.assertEquals((String)arr[2].getName(), (String)"2");
        DBTest.assertEquals((String)arr[3].getName(), (String)"3");
        DBTest.assertEquals((String)arr[4].getName(), (String)"4");
        DBTest.assertEquals((String)arr[5].getName(), (String)"6");
        DBTest.assertEquals((String)arr[6].getName(), (String)"7");
        arr = DB.getKeyNamePairs((String)"SELECT AD_Ref_List_ID, Value FROM AD_Ref_List WHERE AD_Reference_ID=? ORDER BY Value", (boolean)false, params);
        DBTest.assertEquals((String)"Invalid size", (int)6, (int)arr.length);
        DBTest.assertEquals((String)arr[0].getName(), (String)"1");
        DBTest.assertEquals((String)arr[1].getName(), (String)"2");
        DBTest.assertEquals((String)arr[2].getName(), (String)"3");
        DBTest.assertEquals((String)arr[3].getName(), (String)"4");
        DBTest.assertEquals((String)arr[4].getName(), (String)"6");
        DBTest.assertEquals((String)arr[5].getName(), (String)"7");
    }
}

