/*
 * Decompiled with CFR 0.152.
 */
package compiere.model;

import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MClient;
import org.compiere.model.MOrder;
import org.compiere.model.MRole;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.Env;

public class MyValidator
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(MyValidator.class);
    private int m_AD_Client_ID = -1;
    private int m_AD_User_ID = -1;
    private int m_AD_Role_ID = -1;

    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            if (log.isLoggable(Level.INFO)) {
                log.info(client.toString());
            }
        } else if (log.isLoggable(Level.INFO)) {
            log.info("Initializing global validator: " + this.toString());
        }
        engine.addModelChange("C_Order", (ModelValidator)this);
        engine.addDocValidate("C_Order", (ModelValidator)this);
    }

    public String modelChange(PO po, int type) throws Exception {
        if (po.get_TableName().equals("C_Order") && type == 2) {
            MOrder order = (MOrder)po;
            if (log.isLoggable(Level.INFO)) {
                log.info(po.toString());
            }
        }
        return null;
    }

    public String docValidate(PO po, int timing) {
        if (log.isLoggable(Level.INFO)) {
            log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        }
        if (timing == 9) {
            return null;
        }
        if (timing == 1 && po.get_TableName().equals("C_Order") && log.isLoggable(Level.INFO)) {
            log.info(po.toString());
        }
        return null;
    }

    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        if (log.isLoggable(Level.INFO)) {
            log.info("AD_User_ID=" + AD_User_ID);
        }
        this.m_AD_User_ID = AD_User_ID;
        this.m_AD_Role_ID = AD_Role_ID;
        return null;
    }

    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("MyValidator[Order@Gardenworld");
        sb.append("]");
        return sb.toString();
    }

    public void beforeSaveProperties() {
        if (this.m_AD_User_ID == 0 || this.m_AD_User_ID == 100 || this.m_AD_Role_ID == 0) {
            return;
        }
        log.info("Setting default Properties");
        MRole role = MRole.get((Properties)Env.getCtx(), (int)this.m_AD_Role_ID);
    }
}

