/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.install;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.InetAddress;
import java.security.Key;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.logging.Level;
import javax.swing.JFrame;
import org.compiere.Adempiere;
import org.compiere.install.KeyStoreDialog;
import org.compiere.util.CLogMgt;
import org.compiere.util.CLogger;
import sun.security.tools.keytool.Main;

public class KeyStoreMgt {
    private static CLogger log = CLogger.getCLogger(KeyStoreMgt.class);
    private File m_file = null;
    private char[] m_password = null;
    private KeyStore m_keyStore = null;
    private String organizationUnit;
    private String location;
    private String state;
    private String country;
    private String commonName;
    private String organization;
    public static String KEYSTORE_DIRECTORY = "jettyhome/etc";
    public static String KEYSTORE_NAME = "keystore";

    public KeyStoreMgt(String fileName, char[] password) {
        log.info(fileName);
        this.m_file = new File(fileName);
        this.m_password = password;
    }

    public String verify(JFrame parent, String alias) {
        KeyStore ks = null;
        try {
            ks = this.getKeyStore();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "get KeyStore", (Throwable)e);
            return e.getMessage();
        }
        if (ks == null) {
            this.createCertificate(alias, parent);
            try {
                ks = this.getKeyStore();
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "new KeyStore", (Throwable)e);
                return e.getMessage();
            }
        }
        if (ks == null) {
            return "No Key Store";
        }
        Certificate cert = null;
        try {
            cert = this.getCertificate(alias);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "certificate", (Throwable)e);
            return e.getMessage();
        }
        if (cert == null) {
            return "No Certificate found";
        }
        return null;
    }

    public KeyStore getKeyStore() throws Exception {
        block18: {
            try {
                this.m_keyStore = KeyStore.getInstance("JKS");
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Instance", (Throwable)e);
            }
            if (this.m_file.exists()) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine(this.m_file.toString());
                }
                FileInputStream is = null;
                try {
                    try {
                        is = new FileInputStream(this.m_file);
                        this.m_keyStore.load(is, this.m_password);
                        break block18;
                    }
                    catch (Exception e) {
                        log.log(Level.SEVERE, "load", (Throwable)e);
                        if (is != null) {
                            try {
                                ((InputStream)is).close();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            is = null;
                        }
                        return null;
                    }
                }
                finally {
                    if (is != null) {
                        try {
                            ((InputStream)is).close();
                        }
                        catch (Exception exception) {}
                        Object var1_2 = null;
                    }
                }
            }
            return null;
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("Provider=" + this.m_keyStore.getProvider() + " - Type=" + this.m_keyStore.getType());
        }
        return this.m_keyStore;
    }

    public Certificate getCertificate(String alias) throws Exception {
        Date date;
        if (log.isLoggable(Level.CONFIG)) {
            log.config("Alias=" + alias);
        }
        if ((date = this.m_keyStore.getCreationDate(alias)) == null) {
            return null;
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("Created=" + date);
        }
        Key key = this.m_keyStore.getKey(alias, this.m_password);
        if (CLogMgt.isLevelFinest()) {
            log.info("Key=" + key);
        } else if (log.isLoggable(Level.FINE)) {
            log.fine(key.getAlgorithm());
        }
        Certificate cert = this.m_keyStore.getCertificate(alias);
        if (CLogMgt.isLevelFinest()) {
            log.info("Certificate = " + cert);
        } else if (log.isLoggable(Level.FINE)) {
            log.fine(cert.getType());
        }
        return cert;
    }

    private void createCertificate(String alias, JFrame parent) {
        String dname;
        log.info("");
        try {
            File dir = this.m_file.getParentFile();
            if (!dir.exists()) {
                dir.mkdirs();
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "directory", (Throwable)e);
        }
        if ((dname = KeyStoreMgt.getDname(this, parent)) == null) {
            return;
        }
        try {
            KeyStoreMgt.genkey(alias, this.m_password, this.m_file.getAbsolutePath(), dname);
            KeyStoreMgt.selfcert(alias, this.m_password, this.m_file.getAbsolutePath(), dname);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "certificate", (Throwable)e);
        }
    }

    public void setCommonName(String cn) {
        this.commonName = cn;
    }

    public void setOrganization(String o) {
        this.organization = o;
    }

    public void setOrganizationUnit(String o) {
        this.organizationUnit = o;
    }

    public void setLocation(String l) {
        this.location = l;
    }

    public void setState(String s) {
        this.state = s;
    }

    public void setCountry(String c) {
        this.country = c;
    }

    public static String getDname(KeyStoreMgt mgt, JFrame parent) {
        String c;
        String cn = mgt.commonName;
        if (cn == null) {
            try {
                InetAddress address = InetAddress.getLocalHost();
                cn = address.getCanonicalHostName();
            }
            catch (Exception address) {
                // empty catch block
            }
        }
        String ou = mgt.organization != null ? mgt.organization : System.getProperty("user.name");
        String o = mgt.organizationUnit != null ? mgt.organizationUnit : "AdempiereUser";
        String l = mgt.location != null ? mgt.location : "MyTown";
        String s = mgt.state != null ? mgt.state : "";
        String string = c = mgt.country != null ? mgt.country : System.getProperty("user.country");
        if (parent != null) {
            KeyStoreDialog skd = new KeyStoreDialog(parent, cn, ou, o, l, s, c);
            if (!skd.isOK()) {
                return null;
            }
            cn = skd.getCN();
            ou = skd.getOU();
            o = skd.getO();
            l = skd.getL();
            s = skd.getS();
            c = skd.getC();
        }
        if (cn == null || cn.length() == 0) {
            log.warning("No Common Name (CN)");
            return null;
        }
        if (ou == null || ou.length() == 0) {
            log.warning("No Organization Unit (OU)");
            return null;
        }
        if (o == null || o.length() == 0) {
            log.warning("No Organization (O)");
            return null;
        }
        if (c == null || c.length() == 0) {
            log.warning("No Country (C)");
            return null;
        }
        StringBuilder dname = new StringBuilder();
        dname.append("CN=").append(KeyStoreMgt.escapeCommas(cn));
        dname.append(", OU=").append(KeyStoreMgt.escapeCommas(ou));
        dname.append(", O=").append(KeyStoreMgt.escapeCommas(o));
        if (l != null && l.length() > 0) {
            dname.append(", L=").append(KeyStoreMgt.escapeCommas(l));
        }
        if (s != null && s.length() > 0) {
            dname.append(", S=").append(KeyStoreMgt.escapeCommas(s));
        }
        dname.append(", C=").append(KeyStoreMgt.escapeCommas(c));
        return dname.toString();
    }

    public static String escapeCommas(String in) {
        if (in == null || in.indexOf(44) == -1) {
            return in;
        }
        StringBuilder out = new StringBuilder();
        char[] chars = in.toCharArray();
        int i = 0;
        while (i < chars.length) {
            if (chars[i] == ',') {
                out.append('\\').append(',');
            } else {
                out.append(chars[i]);
            }
            ++i;
        }
        return out.toString();
    }

    public static void genkey(String alias, char[] password, String fileName, String dname) {
        StringBuilder cmd = new StringBuilder("-genkey -keyalg rsa");
        cmd.append(" -alias ").append(alias);
        cmd.append(" -dname \"").append(dname).append("\"");
        cmd.append(" -keypass ").append(password).append(" -validity 999");
        if (fileName.indexOf(32) != -1) {
            cmd.append(" -keystore \"").append(fileName).append("\" -storepass ").append(password);
        } else {
            cmd.append(" -keystore ").append(fileName).append(" -storepass ").append(password);
        }
        KeyStoreMgt.keytool(cmd.toString());
    }

    public static void selfcert(String alias, char[] password, String fileName, String dname) {
        StringBuilder cmd = new StringBuilder("-selfcert");
        cmd.append(" -alias ").append(alias);
        cmd.append(" -dname \"").append(dname).append("\"");
        cmd.append(" -keypass ").append(password).append(" -validity 999");
        if (fileName.indexOf(32) != -1) {
            cmd.append(" -keystore \"").append(fileName).append("\" -storepass ").append(password);
        } else {
            cmd.append(" -keystore ").append(fileName).append(" -storepass ").append(password);
        }
        KeyStoreMgt.keytool(cmd.toString());
    }

    public static void keytool(String cmd) {
        if (log.isLoggable(Level.INFO)) {
            log.info("keytool " + cmd);
        }
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(cmd, " ");
        String quoteBuffer = null;
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (quoteBuffer == null) {
                if (token.startsWith("\"")) {
                    quoteBuffer = token.substring(1);
                } else {
                    list.add(token);
                }
            } else {
                quoteBuffer = String.valueOf(quoteBuffer) + " " + token;
            }
            if (!token.endsWith("\"")) continue;
            String str = quoteBuffer.substring(0, quoteBuffer.length() - 1);
            list.add(str);
            quoteBuffer = null;
        }
        String[] args = new String[list.size()];
        list.toArray(args);
        try {
            Main.main(args);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String getKeystoreFileName(String baseDir) {
        String fileName = baseDir;
        if (fileName == null) {
            fileName = "";
        } else if (!fileName.endsWith(File.separator)) {
            fileName = String.valueOf(fileName) + File.separator;
        }
        fileName = String.valueOf(fileName) + KEYSTORE_DIRECTORY + File.separator + KEYSTORE_NAME;
        return fileName;
    }

    public static void main(String[] args) {
        Adempiere.startupEnvironment((boolean)true);
        System.out.println(new KeyStoreMgt("C:/Adempiere/keystore/myKeystore2", "myPassword".toCharArray()).verify(null, "idempiere"));
    }
}

