/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.install;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import org.adempiere.install.DBConfigStatus;
import org.adempiere.install.IDBConfigMonitor;
import org.compiere.install.ConfigurationData;
import org.compiere.install.Setup_Help;
import org.compiere.install.util.SwingWorker;
import org.compiere.util.CLogger;

public class ConfigurationPanel
extends JPanel
implements ActionListener,
IDBConfigMonitor {
    private static final long serialVersionUID = -5113669370606054608L;
    private String m_errorString;
    private volatile boolean m_success = false;
    private volatile boolean m_testing = false;
    static ResourceBundle res = ResourceBundle.getBundle("org.compiere.install.SetupRes");
    private JLabel m_statusBar;
    private ConfigurationData m_data = new ConfigurationData(this);
    private static ImageIcon iOpen = new ImageIcon(ConfigurationPanel.class.getResource("openFile.gif"));
    private static ImageIcon iSave = new ImageIcon(ConfigurationPanel.class.getResource("images/Save16.gif"));
    private static ImageIcon iHelp = new ImageIcon(ConfigurationPanel.class.getResource("images/Help16.gif"));
    private GridBagLayout gridBagLayout = new GridBagLayout();
    private static final int FIELDLENGTH = 15;
    private JLabel lJavaHome = new JLabel();
    JTextField fJavaHome = new JTextField(15);
    JCheckBox okJavaHome = new JCheckBox();
    private JButton bJavaHome = new JButton(iOpen);
    private JLabel lAdempiereHome = new JLabel();
    JTextField fAdempiereHome = new JTextField(15);
    JCheckBox okAdempiereHome = new JCheckBox();
    private JButton bAdempiereHome = new JButton(iOpen);
    private JLabel lKeyStore = new JLabel();
    JPasswordField fKeyStore = new JPasswordField();
    JCheckBox okKeyStore = new JCheckBox();
    JLabel lAppsServer = new JLabel();
    JTextField fAppsServer = new JTextField(15);
    JCheckBox okAppsServer = new JCheckBox();
    private JLabel lWebPort = new JLabel();
    JTextField fWebPort = new JTextField(15);
    JCheckBox okWebPort = new JCheckBox();
    private JLabel lSSLPort = new JLabel();
    JTextField fSSLPort = new JTextField(15);
    JCheckBox okSSLPort = new JCheckBox();
    private JLabel lDatabaseType = new JLabel();
    JComboBox<Object> fDatabaseType = new JComboBox<String>(ConfigurationData.DBTYPE);
    JLabel lDatabaseServer = new JLabel();
    JLabel ldbExists = new JLabel();
    JTextField fDatabaseServer = new JTextField(15);
    private JLabel lDatabaseName = new JLabel();
    JTextField fDatabaseName = new JTextField(15);
    private JLabel lDatabaseDiscovered = new JLabel();
    JComboBox<Object> fDatabaseDiscovered = new JComboBox();
    private JLabel lDatabasePort = new JLabel();
    JTextField fDatabasePort = new JTextField(15);
    private JLabel lSystemPassword = new JLabel();
    JPasswordField fSystemPassword = new JPasswordField();
    private JLabel lDatabaseUser = new JLabel();
    JTextField fDatabaseUser = new JTextField(15);
    private JLabel lDatabasePassword = new JLabel();
    JPasswordField fDatabasePassword = new JPasswordField();
    public JCheckBox okDatabaseServer = new JCheckBox();
    public JCheckBox okDatabaseUser = new JCheckBox();
    public JCheckBox okDatabaseSystem = new JCheckBox();
    public JCheckBox okDatabaseSQL = new JCheckBox();
    public JCheckBox okdbExists = new JCheckBox();
    JLabel lMailServer = new JLabel();
    JTextField fMailServer = new JTextField(15);
    private JLabel lAdminEMail = new JLabel();
    JTextField fAdminEMail = new JTextField(15);
    private JLabel lMailUser = new JLabel();
    JTextField fMailUser = new JTextField(15);
    private JLabel lMailPassword = new JLabel();
    JPasswordField fMailPassword = new JPasswordField();
    JCheckBox okMailServer = new JCheckBox();
    JCheckBox okMailUser = new JCheckBox();
    private JButton bHelp = new JButton(iHelp);
    private JButton bTest = new JButton();
    private JButton bSave = new JButton(iSave);

    public ConfigurationPanel(JLabel statusBar) {
        this.m_statusBar = statusBar;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(this.gridBagLayout);
        Insets bInsets = new Insets(0, 5, 0, 5);
        TitledBorder titledBorder = new TitledBorder("dummy");
        this.lJavaHome.setToolTipText(res.getString("JavaHomeInfo"));
        this.lJavaHome.setText(res.getString("JavaHome"));
        this.fJavaHome.setText(".");
        this.okJavaHome.setEnabled(false);
        this.bJavaHome.setMargin(bInsets);
        this.bJavaHome.setToolTipText(res.getString("JavaHomeInfo"));
        JLabel sectionLabel = new JLabel("Java");
        sectionLabel.setForeground(titledBorder.getTitleColor());
        JSeparator separator = new JSeparator();
        this.add((Component)sectionLabel, new GridBagConstraints(0, 0, 7, 1, 0.0, 0.0, 17, 0, new Insets(15, 5, 0, 10), 0, 0));
        this.add((Component)separator, new GridBagConstraints(0, 1, 7, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 0, 10), 0, 0));
        this.add((Component)this.lJavaHome, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 2, 5), 0, 0));
        this.add((Component)this.fJavaHome, new GridBagConstraints(1, 2, 1, 1, 0.5, 0.0, 17, 1, new Insets(5, 5, 5, 0), 0, 0));
        this.add((Component)this.okJavaHome, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 2, 5), 0, 0));
        this.add((Component)this.bJavaHome, new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.lAdempiereHome.setToolTipText(res.getString("AdempiereHomeInfo"));
        this.lAdempiereHome.setText(res.getString("AdempiereHome"));
        this.fAdempiereHome.setText(".");
        this.okAdempiereHome.setEnabled(false);
        this.bAdempiereHome.setMargin(bInsets);
        this.bAdempiereHome.setToolTipText(res.getString("AdempiereHomeInfo"));
        this.lKeyStore.setText(res.getString("KeyStorePassword"));
        this.lKeyStore.setToolTipText(res.getString("KeyStorePasswordInfo"));
        this.fKeyStore.setText("");
        this.okKeyStore.setEnabled(false);
        sectionLabel = new JLabel("iDempiere");
        sectionLabel.setForeground(titledBorder.getTitleColor());
        separator = new JSeparator();
        this.add((Component)sectionLabel, new GridBagConstraints(0, 3, 7, 1, 0.0, 0.0, 17, 0, new Insets(15, 5, 0, 0), 0, 0));
        this.add((Component)separator, new GridBagConstraints(0, 4, 7, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 0, 10), 0, 0));
        this.add((Component)this.lAdempiereHome, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 2, 5), 0, 0));
        this.add((Component)this.fAdempiereHome, new GridBagConstraints(1, 5, 1, 1, 0.5, 0.0, 17, 1, new Insets(5, 5, 2, 0), 0, 0));
        this.add((Component)this.okAdempiereHome, new GridBagConstraints(2, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 2, 5), 0, 0));
        this.add((Component)this.bAdempiereHome, new GridBagConstraints(3, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.lKeyStore, new GridBagConstraints(4, 5, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.fKeyStore, new GridBagConstraints(5, 5, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 2, 0), 0, 0));
        this.add((Component)this.okKeyStore, new GridBagConstraints(6, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 2, 5), 0, 0));
        this.lAppsServer.setToolTipText(res.getString("AppsServerInfo"));
        this.lAppsServer.setText(res.getString("AppsServer"));
        this.lAppsServer.setFont(this.lAppsServer.getFont().deriveFont(1));
        this.fAppsServer.setText(".");
        this.okAppsServer.setEnabled(false);
        sectionLabel = new JLabel(res.getString("AppsServer"));
        sectionLabel.setForeground(titledBorder.getTitleColor());
        separator = new JSeparator();
        this.add((Component)sectionLabel, new GridBagConstraints(0, 6, 6, 1, 0.0, 0.0, 17, 0, new Insets(15, 5, 0, 0), 0, 0));
        this.add((Component)separator, new GridBagConstraints(0, 7, 7, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 0, 10), 0, 0));
        this.add((Component)this.lAppsServer, new GridBagConstraints(0, 8, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 2, 5), 0, 0));
        this.add((Component)this.fAppsServer, new GridBagConstraints(1, 8, 1, 1, 0.5, 0.0, 17, 1, new Insets(5, 5, 2, 0), 0, 0));
        this.add((Component)this.okAppsServer, new GridBagConstraints(2, 8, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 2, 5), 0, 0));
        this.lWebPort.setToolTipText(res.getString("WebPortInfo"));
        this.lWebPort.setText(res.getString("WebPort"));
        this.fWebPort.setText(".");
        this.okWebPort.setEnabled(false);
        this.lSSLPort.setText("SSL");
        this.fSSLPort.setText(".");
        this.okSSLPort.setEnabled(false);
        this.add((Component)this.lWebPort, new GridBagConstraints(0, 10, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 5, 2, 5), 0, 0));
        this.add((Component)this.fWebPort, new GridBagConstraints(1, 10, 1, 1, 0.5, 0.0, 17, 1, new Insets(2, 5, 2, 0), 0, 0));
        this.add((Component)this.okWebPort, new GridBagConstraints(2, 10, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 0, 2, 5), 0, 0));
        this.add((Component)this.lSSLPort, new GridBagConstraints(4, 10, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 5, 2, 5), 0, 0));
        this.add((Component)this.fSSLPort, new GridBagConstraints(5, 10, 1, 1, 0.0, 0.0, 17, 1, new Insets(2, 5, 2, 0), 0, 0));
        this.add((Component)this.okSSLPort, new GridBagConstraints(6, 10, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 0, 2, 5), 0, 0));
        this.lDatabaseServer.setToolTipText(res.getString("DatabaseServerInfo"));
        this.lDatabaseServer.setText(res.getString("DatabaseServer"));
        this.lDatabaseServer.setFont(this.lDatabaseServer.getFont().deriveFont(1));
        this.okDatabaseServer.setEnabled(false);
        this.lDatabaseType.setToolTipText(res.getString("DatabaseTypeInfo"));
        this.lDatabaseType.setText(res.getString("DatabaseType"));
        this.fDatabaseType.setPreferredSize(this.fDatabaseServer.getPreferredSize());
        sectionLabel = new JLabel(res.getString("DatabaseServer"));
        sectionLabel.setForeground(titledBorder.getTitleColor());
        separator = new JSeparator();
        this.ldbExists.setToolTipText(res.getString("DbExists"));
        this.ldbExists.setText(res.getString("DbExists"));
        this.add((Component)sectionLabel, new GridBagConstraints(0, 11, 6, 1, 0.0, 0.0, 17, 0, new Insets(15, 5, 0, 0), 0, 0));
        this.add((Component)separator, new GridBagConstraints(0, 12, 7, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 0, 10), 0, 0));
        this.add((Component)this.ldbExists, new GridBagConstraints(0, 13, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 2, 5), 0, 0));
        this.add((Component)this.okdbExists, new GridBagConstraints(1, 13, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 2, 5), 0, 0));
        this.add((Component)this.lDatabaseServer, new GridBagConstraints(0, 14, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 2, 5), 0, 0));
        this.add((Component)this.fDatabaseServer, new GridBagConstraints(1, 14, 1, 1, 0.5, 0.0, 17, 1, new Insets(5, 5, 2, 0), 0, 0));
        this.add((Component)this.okDatabaseServer, new GridBagConstraints(2, 14, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 2, 5), 0, 0));
        this.add((Component)this.lDatabaseType, new GridBagConstraints(4, 14, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 2, 5), 0, 0));
        this.add(this.fDatabaseType, new GridBagConstraints(5, 14, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 2, 0), 0, 0));
        this.lDatabaseName.setToolTipText(res.getString("DatabaseNameInfo"));
        this.lDatabaseName.setText(res.getString("DatabaseName"));
        this.fDatabaseName.setText(".");
        this.lDatabaseDiscovered.setToolTipText(res.getString("TNSNameInfo"));
        this.lDatabaseDiscovered.setText(res.getString("TNSName"));
        this.fDatabaseDiscovered.setEditable(true);
        this.fDatabaseDiscovered.setPreferredSize(this.fDatabaseName.getPreferredSize());
        this.okDatabaseSQL.setEnabled(false);
        this.add((Component)this.lDatabaseName, new GridBagConstraints(0, 15, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 5, 2, 5), 0, 0));
        this.add((Component)this.fDatabaseName, new GridBagConstraints(1, 15, 1, 1, 0.5, 0.0, 17, 1, new Insets(2, 5, 2, 0), 0, 0));
        this.add((Component)this.okDatabaseSQL, new GridBagConstraints(2, 15, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 0, 2, 5), 0, 0));
        this.add((Component)this.lDatabaseDiscovered, new GridBagConstraints(4, 15, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 0, 2, 5), 0, 0));
        this.add(this.fDatabaseDiscovered, new GridBagConstraints(5, 15, 1, 1, 0.5, 0.0, 17, 1, new Insets(2, 5, 2, 0), 0, 0));
        this.lDatabasePort.setToolTipText(res.getString("DatabasePortInfo"));
        this.lDatabasePort.setText(res.getString("DatabasePort"));
        this.fDatabasePort.setText(".");
        this.lSystemPassword.setToolTipText(res.getString("SystemPasswordInfo"));
        this.lSystemPassword.setText(res.getString("SystemPassword"));
        this.fSystemPassword.setText(".");
        this.okDatabaseSystem.setEnabled(false);
        this.add((Component)this.lDatabasePort, new GridBagConstraints(0, 16, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 5, 2, 5), 0, 0));
        this.add((Component)this.fDatabasePort, new GridBagConstraints(1, 16, 1, 1, 0.5, 0.0, 17, 1, new Insets(2, 5, 2, 0), 0, 0));
        this.add((Component)this.lSystemPassword, new GridBagConstraints(4, 16, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 5, 2, 5), 0, 0));
        this.add((Component)this.fSystemPassword, new GridBagConstraints(5, 16, 1, 1, 0.5, 0.0, 17, 2, new Insets(2, 5, 2, 0), 0, 0));
        this.add((Component)this.okDatabaseSystem, new GridBagConstraints(6, 16, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 0, 2, 5), 0, 0));
        this.lDatabaseUser.setToolTipText(res.getString("DatabaseUserInfo"));
        this.lDatabaseUser.setText(res.getString("DatabaseUser"));
        this.fDatabaseUser.setText(".");
        this.lDatabasePassword.setToolTipText(res.getString("DatabasePasswordInfo"));
        this.lDatabasePassword.setText(res.getString("DatabasePassword"));
        this.fDatabasePassword.setText(".");
        this.okDatabaseUser.setEnabled(false);
        this.add((Component)this.lDatabaseUser, new GridBagConstraints(0, 17, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 5, 2, 5), 0, 0));
        this.add((Component)this.fDatabaseUser, new GridBagConstraints(1, 17, 1, 1, 0.5, 0.0, 17, 1, new Insets(2, 5, 2, 0), 0, 0));
        this.add((Component)this.lDatabasePassword, new GridBagConstraints(4, 17, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 5, 2, 5), 0, 0));
        this.add((Component)this.fDatabasePassword, new GridBagConstraints(5, 17, 1, 1, 0.5, 0.0, 17, 2, new Insets(2, 5, 2, 0), 0, 0));
        this.add((Component)this.okDatabaseUser, new GridBagConstraints(6, 17, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 0, 2, 5), 0, 0));
        sectionLabel = new JLabel(res.getString("MailServer"));
        sectionLabel.setForeground(titledBorder.getTitleColor());
        separator = new JSeparator();
        this.add((Component)sectionLabel, new GridBagConstraints(0, 18, 6, 1, 0.0, 0.0, 17, 0, new Insets(15, 5, 0, 0), 0, 0));
        this.add((Component)separator, new GridBagConstraints(0, 19, 7, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 0, 10), 0, 0));
        this.lMailServer.setToolTipText(res.getString("MailServerInfo"));
        this.lMailServer.setText(res.getString("MailServer"));
        this.lMailServer.setFont(this.lMailServer.getFont().deriveFont(1));
        this.fMailServer.setText(".");
        this.lAdminEMail.setToolTipText(res.getString("AdminEMailInfo"));
        this.lAdminEMail.setText(res.getString("AdminEMail"));
        this.fAdminEMail.setText(".");
        this.okMailServer.setEnabled(false);
        this.add((Component)this.lMailServer, new GridBagConstraints(0, 20, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 2, 5), 0, 0));
        this.add((Component)this.fMailServer, new GridBagConstraints(1, 20, 1, 1, 0.5, 0.0, 17, 1, new Insets(5, 5, 2, 0), 0, 0));
        this.add((Component)this.okMailServer, new GridBagConstraints(2, 20, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 2, 5), 0, 0));
        this.add((Component)this.lAdminEMail, new GridBagConstraints(4, 20, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 2, 5), 0, 0));
        this.add((Component)this.fAdminEMail, new GridBagConstraints(5, 20, 1, 1, 0.5, 0.0, 17, 1, new Insets(5, 5, 2, 0), 0, 0));
        this.lMailUser.setToolTipText(res.getString("MailUserInfo"));
        this.lMailUser.setText(res.getString("MailUser"));
        this.fMailUser.setText(".");
        this.lMailPassword.setToolTipText(res.getString("MailPasswordInfo"));
        this.lMailPassword.setText(res.getString("MailPassword"));
        this.fMailPassword.setText(".");
        this.okMailUser.setEnabled(false);
        this.add((Component)this.lMailUser, new GridBagConstraints(0, 21, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 5, 2, 5), 0, 0));
        this.add((Component)this.fMailUser, new GridBagConstraints(1, 21, 1, 1, 0.5, 0.0, 17, 1, new Insets(2, 5, 2, 0), 0, 0));
        this.add((Component)this.lMailPassword, new GridBagConstraints(4, 21, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 5, 2, 5), 0, 0));
        this.add((Component)this.fMailPassword, new GridBagConstraints(5, 21, 1, 1, 0.5, 0.0, 17, 2, new Insets(2, 5, 2, 0), 0, 0));
        this.add((Component)this.okMailUser, new GridBagConstraints(6, 21, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 0, 2, 5), 0, 0));
        JPanel filler = new JPanel();
        filler.setOpaque(false);
        filler.setBorder(null);
        this.add((Component)filler, new GridBagConstraints(0, 22, 1, 1, 0.0, 1.0, 17, 3, new Insets(0, 0, 0, 0), 0, 0));
        this.bTest.setToolTipText(res.getString("TestInfo"));
        this.bTest.setText(res.getString("Test"));
        this.bSave.setToolTipText(res.getString("SaveInfo"));
        this.bSave.setText(res.getString("Save"));
        this.bHelp.setToolTipText(res.getString("HelpInfo"));
        this.add((Component)this.bTest, new GridBagConstraints(0, 23, 1, 1, 0.0, 0.0, 17, 0, new Insets(15, 5, 10, 5), 0, 0));
        this.add((Component)this.bHelp, new GridBagConstraints(3, 23, 2, 1, 0.0, 0.0, 17, 0, new Insets(15, 5, 10, 5), 0, 0));
        this.add((Component)this.bSave, new GridBagConstraints(5, 23, 2, 1, 0.0, 0.0, 13, 0, new Insets(15, 5, 10, 5), 0, 0));
        this.bAdempiereHome.addActionListener(this);
        this.bJavaHome.addActionListener(this);
        this.fDatabaseType.addActionListener(this);
        this.fDatabaseDiscovered.addActionListener(this);
        this.bHelp.addActionListener(this);
        this.bTest.addActionListener(this);
        this.bSave.addActionListener(this);
    }

    public boolean dynInit() {
        return this.m_data.load();
    }

    protected void setStatusBar(String text) {
        this.m_statusBar.setText(text);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.m_testing) {
            return;
        }
        if (e.getSource() == this.fDatabaseDiscovered) {
            String dbName = (String)this.fDatabaseDiscovered.getSelectedItem();
            if (dbName != null && dbName.length() > 0) {
                this.fDatabaseName.setText(this.m_data.resolveDatabaseName(dbName));
            }
        } else if (e.getSource() == this.fDatabaseType) {
            this.m_data.initDatabase("");
        } else if (e.getSource() == this.bJavaHome) {
            this.setPath(this.fJavaHome);
        } else if (e.getSource() == this.bAdempiereHome) {
            this.setPath(this.fAdempiereHome);
        } else if (e.getSource() == this.bHelp) {
            new Setup_Help((Frame)SwingUtilities.getWindowAncestor(this));
        } else if (e.getSource() == this.bTest) {
            this.startTest(false);
        } else if (e.getSource() == this.bSave) {
            this.startTest(true);
        }
    }

    private void setPath(JTextField field) {
        JFileChooser fc = new JFileChooser(field.getText());
        fc.setDialogType(0);
        fc.setFileSelectionMode(1);
        fc.setMultiSelectionEnabled(false);
        fc.setDialogTitle(field.getToolTipText());
        if (fc.showOpenDialog(this) == 0) {
            field.setText(fc.getSelectedFile().getAbsolutePath());
        }
    }

    private SwingWorker startTest(final boolean saveIt) {
        SwingWorker worker = new SwingWorker(){

            @Override
            public Object construct() {
                ConfigurationPanel.this.m_testing = true;
                ConfigurationPanel.this.setCursor(Cursor.getPredefinedCursor(3));
                ConfigurationPanel.this.bTest.setEnabled(false);
                ConfigurationPanel.this.m_success = false;
                ConfigurationPanel.this.m_errorString = null;
                try {
                    ConfigurationPanel.this.test();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    ConfigurationPanel.this.m_errorString = String.valueOf(ConfigurationPanel.this.m_errorString) + "\n" + ex.toString();
                }
                ConfigurationPanel.this.setCursor(Cursor.getDefaultCursor());
                if (ConfigurationPanel.this.m_errorString == null) {
                    ConfigurationPanel.this.m_success = true;
                }
                ConfigurationPanel.this.bTest.setEnabled(true);
                ConfigurationPanel.this.m_testing = false;
                return ConfigurationPanel.this.m_success;
            }

            @Override
            public void finished() {
                if (ConfigurationPanel.this.m_errorString != null) {
                    CLogger.get().severe(ConfigurationPanel.this.m_errorString);
                    JOptionPane.showConfirmDialog(ConfigurationPanel.this.m_statusBar.getParent(), ConfigurationPanel.this.m_errorString, res.getString("ServerError"), -1, 0);
                } else if (saveIt) {
                    ConfigurationPanel.this.save();
                }
            }
        };
        worker.start();
        return worker;
    }

    private void test() throws Exception {
        this.cleanSignalOk();
        Thread.sleep(1000L);
        this.bSave.setEnabled(false);
        if (!this.m_data.test(this)) {
            return;
        }
        this.m_statusBar.setText(res.getString("Ok"));
        this.bSave.setEnabled(true);
        this.m_errorString = null;
    }

    void signalOK(JCheckBox cb, String resString, boolean pass, boolean critical, String errorMsg) {
        this.m_errorString = res.getString(resString);
        cb.setSelected(pass);
        if (pass) {
            cb.setToolTipText(null);
        } else {
            cb.setToolTipText(errorMsg);
            this.m_errorString = String.valueOf(this.m_errorString) + " \n(" + errorMsg + ")";
        }
        if (!pass && critical) {
            cb.setBackground(Color.RED);
        } else {
            cb.setBackground(Color.GREEN);
        }
    }

    void cleanSignalOk() {
        this.okJavaHome.setBackground(null);
        this.okJavaHome.setSelected(false);
        this.okAdempiereHome.setBackground(null);
        this.okAdempiereHome.setSelected(false);
        this.okKeyStore.setBackground(null);
        this.okKeyStore.setSelected(false);
        this.okAppsServer.setBackground(null);
        this.okAppsServer.setSelected(false);
        this.okWebPort.setBackground(null);
        this.okWebPort.setSelected(false);
        this.okSSLPort.setBackground(null);
        this.okSSLPort.setSelected(false);
        this.okDatabaseServer.setBackground(null);
        this.okDatabaseServer.setSelected(false);
        this.okDatabaseUser.setBackground(null);
        this.okDatabaseUser.setSelected(false);
        this.okDatabaseSystem.setBackground(null);
        this.okDatabaseSystem.setSelected(false);
        this.okDatabaseSQL.setBackground(null);
        this.okDatabaseSQL.setSelected(false);
        this.okMailServer.setBackground(null);
        this.okMailServer.setSelected(false);
        this.okMailUser.setBackground(null);
        this.okMailUser.setSelected(false);
    }

    private void save() {
        if (!this.m_success) {
            return;
        }
        this.bSave.setEnabled(false);
        this.bTest.setEnabled(false);
        this.setCursor(Cursor.getPredefinedCursor(3));
        if (!this.m_data.save()) {
            return;
        }
        ((Frame)SwingUtilities.getWindowAncestor(this)).dispose();
    }

    @Override
    public void update(DBConfigStatus status) {
        if (status.getStatusType().equals("DATABASE_SERVER")) {
            this.signalOK(this.okDatabaseServer, status.getResourseString(), status.isPass(), status.isCritical(), status.getErrorMessage());
        } else if (status.getStatusType().equals("DATABASE_SYSTEM_PASSWORD")) {
            this.signalOK(this.okDatabaseSystem, status.getResourseString(), status.isPass(), status.isCritical(), status.getErrorMessage());
        } else if (status.getStatusType().equals("DATABASE_USER")) {
            this.signalOK(this.okDatabaseUser, status.getResourseString(), status.isPass(), status.isCritical(), status.getErrorMessage());
        } else if (status.getStatusType().equals("DATABASE_SQL_TEST")) {
            this.signalOK(this.okDatabaseSQL, status.getResourseString(), status.isPass(), status.isCritical(), status.getErrorMessage());
        }
    }
}

