/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.wstore;

import java.math.BigDecimal;
import org.compiere.util.Env;

public class WebBasketLine {
    private int m_line;
    private int m_M_Product_ID;
    private String m_Name;
    private BigDecimal m_Price;
    private BigDecimal m_Quantity;
    private BigDecimal m_Total;

    public WebBasketLine(int M_Product_ID, String Name, BigDecimal Qty, BigDecimal Price) {
        this.setM_Product_ID(M_Product_ID);
        this.setName(Name);
        this.setQuantity(Qty);
        this.setPrice(Price);
    }

    public String toStringX() {
        StringBuilder sb = new StringBuilder("WebBasketLine[");
        sb.append(this.m_line).append("-M_Product_ID=").append(this.m_M_Product_ID).append(",Qty=").append(this.m_Quantity).append(",Price=").append(this.m_Price).append(",Total=").append(this.getTotal()).append("]");
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.m_Quantity).append(" * ").append(this.m_Name).append(" = ").append(this.getTotal());
        return sb.toString();
    }

    public int getLine() {
        return this.m_line;
    }

    protected void setLine(int line) {
        this.m_line = line;
    }

    public int getM_Product_ID() {
        return this.m_M_Product_ID;
    }

    protected void setM_Product_ID(int M_Product_ID) {
        this.m_M_Product_ID = M_Product_ID;
    }

    public String getName() {
        if (this.m_Name == null) {
            return "-?-";
        }
        return this.m_Name;
    }

    protected void setName(String name) {
        this.m_Name = name;
    }

    public BigDecimal getPrice() {
        if (this.m_Price == null) {
            return Env.ZERO;
        }
        return this.m_Price;
    }

    protected void setPrice(BigDecimal price) {
        this.m_Price = price == null ? Env.ZERO : price;
        this.m_Total = null;
    }

    public BigDecimal getQuantity() {
        if (this.m_Quantity == null) {
            return Env.ZERO;
        }
        return this.m_Quantity;
    }

    public void setQuantity(BigDecimal quantity) {
        this.m_Quantity = quantity == null ? Env.ZERO : quantity;
        this.m_Total = null;
    }

    public BigDecimal addQuantity(BigDecimal addedQuantity) {
        if (addedQuantity == null) {
            return this.getQuantity();
        }
        this.m_Quantity = this.getQuantity();
        this.m_Quantity = this.m_Quantity.add(addedQuantity);
        this.m_Total = null;
        return this.m_Quantity;
    }

    public BigDecimal getTotal() {
        if (this.m_Total == null) {
            this.m_Total = this.getQuantity().multiply(this.getPrice());
        }
        return this.m_Total;
    }
}

