/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.wstore;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.Properties;
import java.util.logging.Level;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MClient;
import org.compiere.model.MPayment;
import org.compiere.model.MPaymentValidate;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.WebEnv;
import org.compiere.util.WebUser;
import org.compiere.util.WebUtil;
import org.compiere.wstore.JSPEnv;
import org.compiere.wstore.WebOrder;

@WebServlet(name="paymentServlet", urlPatterns={"/paymentServlet"})
public class PaymentServlet
extends HttpServlet {
    private static final long serialVersionUID = -4205866013703830396L;
    private static CLogger log = CLogger.getCLogger(PaymentServlet.class);
    public static final String ATTR_PAYMENT = "payment";

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        if (!WebEnv.initWeb((ServletConfig)config)) {
            throw new ServletException("PaymentServlet.init");
        }
    }

    public String getServletInfo() {
        return "Adempiere Payment Servlet";
    }

    public void destroy() {
        log.info("");
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (log.isLoggable(Level.INFO)) {
            log.info("Get from " + request.getRemoteHost() + " - " + request.getRemoteAddr());
        }
        Properties ctx = JSPEnv.getCtx(request);
        HttpSession session = request.getSession(true);
        session.removeAttribute("hdrMessage");
        WebUser wu = (WebUser)session.getAttribute("webUser");
        MPayment p2 = (MPayment)session.getAttribute(ATTR_PAYMENT);
        if (wu == null) {
            if (log.isLoggable(Level.INFO)) {
                log.info("No User");
            }
            String url = "/index.jsp";
            if (log.isLoggable(Level.INFO)) {
                log.info("Forward to " + url);
            }
            RequestDispatcher dispatcher = this.getServletContext().getRequestDispatcher(url);
            dispatcher.forward((ServletRequest)request, (ServletResponse)response);
        }
        session.removeAttribute("webOrder");
        String amtParam = WebUtil.getParameter((HttpServletRequest)request, (String)"Amt");
        if (amtParam == null || amtParam.length() == 0) {
            if (log.isLoggable(Level.INFO)) {
                log.info("No Payment Amount (" + amtParam + ")");
            }
            this.doPost(request, response);
            return;
        }
        char[] chars = amtParam.toCharArray();
        StringBuffer sb = new StringBuffer();
        boolean decimal = false;
        int i = chars.length - 1;
        while (i >= 0) {
            char c = chars[i];
            if (c == ',' || c == '.') {
                if (!decimal) {
                    sb.insert(0, '.');
                    decimal = true;
                }
            } else if (Character.isDigit(c)) {
                sb.insert(0, c);
            }
            --i;
        }
        BigDecimal amt = null;
        try {
            if (sb.length() > 0) {
                amt = new BigDecimal(sb.toString());
                amt = amt.abs();
            }
        }
        catch (Exception ex) {
            log.warning("Parsing Amount=" + amtParam + " (" + sb + ") - " + ex.toString());
        }
        if (amt == null || amt.compareTo(Env.ZERO) < 0) {
            if (log.isLoggable(Level.INFO)) {
                log.info("No valid Payment Amount (" + amtParam + ") - " + amt);
            }
            this.doPost(request, response);
            return;
        }
        String invoiceParam = WebUtil.getParameter((HttpServletRequest)request, (String)"C_Invoice_ID");
        int C_Invoice_ID = 0;
        try {
            if (invoiceParam != null) {
                C_Invoice_ID = Integer.parseInt(invoiceParam);
            }
        }
        catch (NumberFormatException ex) {
            log.warning("Parsing C_Invoice_ID=" + invoiceParam + " - " + ex.toString());
        }
        if (log.isLoggable(Level.INFO)) {
            log.info("Amt=" + amt + ", C_Invoice_ID=" + C_Invoice_ID);
        }
        p2 = new MPayment(ctx, 0, null);
        p2.setIsSelfService(true);
        p2.setAmount(0, amt);
        p2.setIsOnline(true);
        p2.setC_DocType_ID(true);
        p2.setTrxType("S");
        p2.setTenderType("C");
        p2.setC_Invoice_ID(C_Invoice_ID);
        p2.setBP_BankAccount(wu.getBankAccount());
        session.setAttribute(ATTR_PAYMENT, (Object)p2);
        String url = "/paymentInfo.jsp";
        if (log.isLoggable(Level.INFO)) {
            log.info("Forward to " + url);
        }
        RequestDispatcher dispatcher = this.getServletContext().getRequestDispatcher(url);
        dispatcher.forward((ServletRequest)request, (ServletResponse)response);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (log.isLoggable(Level.INFO)) {
            log.info("Post from " + request.getRemoteHost() + " - " + request.getRemoteAddr());
        }
        Properties ctx = JSPEnv.getCtx(request);
        HttpSession session = request.getSession(true);
        WebUser wu = (WebUser)session.getAttribute("webUser");
        MPayment p2 = (MPayment)session.getAttribute(ATTR_PAYMENT);
        WebOrder wo = (WebOrder)session.getAttribute("webOrder");
        String url = null;
        url = wu == null || p2 == null ? "/index.jsp" : (this.processPayment(request, ctx, p2, wu, wo) ? "/confirm.jsp" : "/paymentInfo.jsp");
        if (log.isLoggable(Level.INFO)) {
            log.info("Forward to " + url);
        }
        RequestDispatcher dispatcher = this.getServletContext().getRequestDispatcher(url);
        dispatcher.forward((ServletRequest)request, (ServletResponse)response);
    }

    private boolean processPayment(HttpServletRequest request, Properties ctx, MPayment payment, WebUser wu, WebOrder wo) {
        boolean ok = this.processParameter(request, ctx, payment, wu);
        if (ok) {
            if (payment.getPayAmt().compareTo(Env.ZERO) < 0) {
                payment.setPayAmt(payment.getPayAmt().abs());
            }
            if (ok = payment.processOnline()) {
                if (wo != null) {
                    if (!wo.isCompleted()) {
                        wo.process(payment);
                    }
                    if (!wo.isCompleted()) {
                        log.warning("Order not processed " + wo);
                    }
                } else {
                    log.warning("No Order");
                }
                if (!payment.processIt("CO")) {
                    throw new AdempiereException("Failed when processing document - " + payment.getProcessMsg());
                }
                payment.saveEx();
                this.sendThanksEMail(request, ctx, payment, wu, wo);
            } else {
                if (log.isLoggable(Level.FINE)) {
                    log.fine(payment.getErrorMessage());
                }
                String errMsg = payment.getErrorMessage();
                payment.saveEx();
                payment.setErrorMessage(errMsg);
                request.getSession().setAttribute("hdrMessage", (Object)errMsg);
                this.sendDeclineEMail(request, payment, wu, wo);
            }
        }
        return ok;
    }

    private boolean processParameter(HttpServletRequest request, Properties ctx, MPayment p2, WebUser wu) {
        String SavePayment;
        String SP;
        String aName;
        StringBuilder sb = new StringBuilder();
        p2.setTenderType("C");
        p2.setTrxType("S");
        p2.setA_EMail(wu.getEmail());
        String ccType = WebUtil.getParameter((HttpServletRequest)request, (String)"CreditCard");
        p2.setCreditCardType(ccType);
        String ccNumber = WebUtil.getParameter((HttpServletRequest)request, (String)"CreditCardNumber");
        p2.setCreditCardNumber(ccNumber);
        String AD_Message = MPaymentValidate.validateCreditCardNumber((String)ccNumber, (String)ccType);
        if (AD_Message.length() > 0) {
            sb.append(Msg.getMsg((Properties)ctx, (String)AD_Message)).append(" - ");
        }
        String ccVV = WebUtil.getParameter((HttpServletRequest)request, (String)"CreditCardVV");
        p2.setCreditCardVV(ccVV);
        if (ccVV != null && ccVV.length() > 0 && (AD_Message = MPaymentValidate.validateCreditCardVV((String)ccVV, (String)ccType)).length() > 0) {
            sb.append(Msg.getMsg((Properties)ctx, (String)AD_Message)).append(" - ");
        }
        int mm = WebUtil.getParameterAsInt((HttpServletRequest)request, (String)"CreditCardExpMM");
        p2.setCreditCardExpMM(mm);
        int yy = WebUtil.getParameterAsInt((HttpServletRequest)request, (String)"CreditCardExpYY");
        p2.setCreditCardExpYY(yy);
        AD_Message = MPaymentValidate.validateCreditCardExp((int)mm, (int)yy);
        if (AD_Message.length() > 0) {
            sb.append(Msg.getMsg((Properties)ctx, (String)AD_Message)).append(" - ");
        }
        if ((aName = WebUtil.getParameter((HttpServletRequest)request, (String)"A_Name")) == null || aName.length() == 0) {
            sb.append("Name - ");
        } else {
            p2.setA_Name(aName);
        }
        String aStreet = WebUtil.getParameter((HttpServletRequest)request, (String)"A_Street");
        p2.setA_Street(aStreet);
        String aCity = WebUtil.getParameter((HttpServletRequest)request, (String)"A_City");
        if (aCity == null || aCity.length() == 0) {
            sb.append("City - ");
        } else {
            p2.setA_City(aCity);
        }
        String aState = WebUtil.getParameter((HttpServletRequest)request, (String)"A_State");
        p2.setA_State(aState);
        String aZip = WebUtil.getParameter((HttpServletRequest)request, (String)"A_Zip");
        if (aZip == null || aZip.length() == 0) {
            sb.append("Zip - ");
        } else {
            p2.setA_Zip(aZip);
        }
        String aCountry = WebUtil.getParameter((HttpServletRequest)request, (String)"A_Country");
        p2.setA_Country(aCountry);
        boolean ok = sb.length() == 0;
        p2.setErrorMessage(sb.toString());
        if (ok && (SP = "SavePayment").equals(SavePayment = WebUtil.getParameter((HttpServletRequest)request, (String)SP))) {
            p2.saveToBP_BankAccount(wu.getBankAccount());
        }
        return ok;
    }

    private void sendThanksEMail(HttpServletRequest request, Properties ctx, MPayment p2, WebUser wu, WebOrder wo) {
        StringBuffer message = new StringBuffer().append(p2.getPayAmt()).append(" (").append(Msg.getElement((Properties)ctx, (String)"R_PnRef")).append("=").append(p2.getR_PnRef()).append(") ");
        if (wo != null) {
            message.append("\n").append(Msg.getElement((Properties)ctx, (String)"C_Order_ID")).append(": ").append(wo.getDocumentNo());
        }
        JSPEnv.sendEMail(request, wu, "PA", new Object[]{String.valueOf(p2.getDocumentNo()) + " (" + p2.getPayAmt() + ")", wu.getName(), message.toString()});
        if (wo != null && wo.getSalesRep_ID() != 0) {
            MClient client = MClient.get((Properties)ctx);
            client.sendEMail(wo.getSalesRep_ID(), "(CC) Payment: " + p2.getDocumentNo() + " (" + p2.getPayAmt() + ")", "Order: " + wo.getDocumentNo() + "\nUser: " + wu.getName() + " - " + wu.getEmail(), null);
        }
    }

    private void sendDeclineEMail(HttpServletRequest request, MPayment p2, WebUser wu, WebOrder wo) {
        StringBuffer message = new StringBuffer(p2.getErrorMessage()).append(" - ").append(p2.getCurrencyISO()).append(" ").append(p2.getPayAmt()).append(" (Reference=").append(p2.getR_PnRef()).append(") ");
        if (wo != null) {
            message.append("\nfor Order: ").append(wo.getDocumentNo());
        }
        JSPEnv.sendEMail(request, wu, "PE", new Object[]{String.valueOf(p2.getDocumentNo()) + " (" + p2.getCurrencyISO() + " " + p2.getPayAmt() + ")", wu.getName(), message.toString()});
    }
}

