/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.wstore;

import java.io.IOException;
import java.util.Properties;
import java.util.logging.Level;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.compiere.util.CLogger;
import org.compiere.util.WebEnv;
import org.compiere.util.WebLogin;
import org.compiere.util.WebUser;
import org.compiere.util.WebUtil;
import org.compiere.wstore.JSPEnv;

@WebServlet(name="loginServlet", urlPatterns={"/loginServlet"})
public class LoginServlet
extends HttpServlet {
    private static final long serialVersionUID = -7356209202584278247L;
    private CLogger log = CLogger.getCLogger(((Object)((Object)this)).getClass());
    public static final String NAME = "loginServlet";

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        if (!WebEnv.initWeb((ServletConfig)config)) {
            throw new ServletException("LoginServlet.init");
        }
    }

    public String getServletInfo() {
        return "Adempiere Web Login Servlet";
    }

    public void destroy() {
        this.log.fine("destroy");
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("From " + request.getRemoteHost() + " - " + request.getRemoteAddr());
        }
        HttpSession session = request.getSession(true);
        session.removeAttribute("hdrMessage");
        Properties ctx = JSPEnv.getCtx(request);
        WebLogin thisLogin = new WebLogin(request, response, ctx);
        thisLogin.init();
        if (WebUtil.getParameter((HttpServletRequest)request, (String)"Mode") == null && WebUtil.getParameter((HttpServletRequest)request, (String)"mode") != null) {
            thisLogin.setP_Action("mode");
        }
        thisLogin.action();
        if ("logout".equals(thisLogin.getMode())) {
            return;
        }
        String url = thisLogin.getLogin_RelURL();
        if (!url.startsWith("/")) {
            url = "/" + url;
        }
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("Forward to " + url);
        }
        RequestDispatcher dispatcher = this.getServletContext().getRequestDispatcher(url);
        dispatcher.forward((ServletRequest)request, (ServletResponse)response);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("From " + request.getRemoteHost() + " - " + request.getRemoteAddr());
        }
        Properties ctx = JSPEnv.getCtx(request);
        HttpSession session = request.getSession(true);
        session.removeAttribute("hdrMessage");
        WebLogin thisLogin = new WebLogin(request, response, ctx);
        thisLogin.init();
        String url = thisLogin.getForward();
        String salesRep = thisLogin.getSalesRep_ID();
        if (salesRep != null) {
            session.setAttribute(thisLogin.getP_SalesRep_ID(), (Object)salesRep);
        }
        boolean checkOut = "Y".equals(session.getAttribute("CheckOut"));
        boolean addressConfirm = "Y".equals(WebUtil.getParameter((HttpServletRequest)request, (String)"AddressConfirm"));
        if (checkOut) {
            url = addressConfirm ? "/orderServlet" : "/addressInfo.jsp";
        } else {
            addressConfirm = false;
        }
        if (url == null || url.length() == 0) {
            url = (String)session.getAttribute(thisLogin.getP_ForwardTo());
            if (url == null || url.length() == 0) {
                url = "/index.jsp";
            }
        } else {
            if (!url.startsWith("/")) {
                url = "/" + url;
            }
            session.setAttribute(thisLogin.getP_ForwardTo(), (Object)url);
        }
        if ((salesRep = (String)session.getAttribute(thisLogin.getP_SalesRep_ID())) != null) {
            url = String.valueOf(url) + "?SalesRep_ID=" + salesRep;
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("- targeting url=" + url);
        }
        WebUser wu = WebUser.get((HttpServletRequest)request);
        thisLogin.setForward(url);
        thisLogin.setAddressConfirm(addressConfirm);
        if (WebUtil.getParameter((HttpServletRequest)request, (String)"Mode") == null && WebUtil.getParameter((HttpServletRequest)request, (String)"mode") != null) {
            thisLogin.setP_Action("mode");
        }
        thisLogin.action();
        url = thisLogin.getForward();
        wu = thisLogin.getWebUser();
        session.setAttribute("webUser", (Object)wu);
        if (!url.startsWith("/")) {
            url = "/" + url;
        }
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("doPost - Forward to " + url);
        }
        if (url.startsWith("/orderServlet")) {
            response.sendRedirect(url.substring(1));
        } else {
            RequestDispatcher dispatcher = this.getServletContext().getRequestDispatcher(url);
            dispatcher.forward((ServletRequest)request, (ServletResponse)response);
        }
    }
}

