/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.wstore;

import java.io.IOException;
import java.util.Properties;
import java.util.logging.Level;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.compiere.util.CLogger;
import org.compiere.util.WebEnv;
import org.compiere.util.WebUser;
import org.compiere.util.WebUtil;
import org.compiere.wstore.JSPEnv;

@WebServlet(name="expenseServlet", urlPatterns={"/expenseServlet"})
public class ExpenseServlet
extends HttpServlet {
    private static final long serialVersionUID = -3162975286315508379L;
    private static CLogger log = CLogger.getCLogger(ExpenseServlet.class);
    public static final String NAME = "ExpenseServlet";
    public static String P_SubmitType_Name = "Submit";
    public static final String P_Expense_ID = "W_Expense_ID";

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        if (!WebEnv.initWeb((ServletConfig)config)) {
            throw new ServletException("ExpenseServlet.init");
        }
    }

    public String getServletInfo() {
        return "Adempiere Web Expense Servlet";
    }

    public void destroy() {
        log.fine("");
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (log.isLoggable(Level.INFO)) {
            log.info("Get from " + request.getRemoteHost() + " - " + request.getRemoteAddr() + " - forward to request.jsp");
        }
        if (!response.isCommitted()) {
            response.sendRedirect("expenses.jsp");
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (log.isLoggable(Level.INFO)) {
            log.info("Post from " + request.getRemoteHost() + " - " + request.getRemoteAddr());
        }
        HttpSession session = request.getSession(true);
        session.removeAttribute("hdrMessage");
        Properties ctx = JSPEnv.getCtx(request);
        WebUser wu = (WebUser)session.getAttribute("webUser");
        if (wu == null) {
            log.warning("No web user");
            response.sendRedirect("loginServlet?ForwardTo=expense.jsp");
            return;
        }
        int W_Expense_ID = WebUtil.getParameterAsInt((HttpServletRequest)request, (String)P_Expense_ID);
        String method = WebUtil.getParameter((HttpServletRequest)request, (String)P_SubmitType_Name);
        if (!method.startsWith("Save")) {
            method.startsWith("Submit");
        }
        WebUtil.createForwardPage((HttpServletResponse)response, (String)"Web Expense Under Construction", (String)"expenses.jsp", (int)0);
    }
}

