/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.wstore;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Properties;
import java.util.logging.Level;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.compiere.model.MClick;
import org.compiere.util.CLogger;
import org.compiere.util.WebEnv;
import org.compiere.util.WebUser;
import org.compiere.util.WebUtil;
import org.compiere.wstore.JSPEnv;

@WebServlet(name="clickServlet", urlPatterns={"/click"})
public class Click
extends HttpServlet {
    private static final long serialVersionUID = -5255937471697633035L;
    private CLogger log = CLogger.getCLogger(((Object)((Object)this)).getClass());
    public static final String NAME = "click";
    public static final String PARA_TARGET = "target";
    public static final String DEFAULT_TARGET = "http://www.adempiere.org/";

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        if (!WebEnv.initWeb((ServletConfig)config)) {
            throw new ServletException("Click.init");
        }
    }

    public String getServletInfo() {
        return "Adempiere Click Servlet";
    }

    public void destroy() {
        this.log.fine("destroy");
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        long time = System.currentTimeMillis();
        request.getSession(true);
        String url = this.getTargetURL(request);
        if (!response.isCommitted()) {
            response.sendRedirect(url);
        }
        response.flushBuffer();
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("redirect - " + url);
        }
        this.saveClick(request, url);
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine(String.valueOf(url) + " - " + (System.currentTimeMillis() - time) + "ms");
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    private String getTargetURL(HttpServletRequest request) {
        Enumeration e;
        String url = WebUtil.getParameter((HttpServletRequest)request, (String)PARA_TARGET);
        if ((url == null || url.length() == 0) && (e = request.getParameterNames()).hasMoreElements()) {
            url = (String)e.nextElement();
        }
        if ((url == null || url.length() == 0) && (url = request.getPathInfo()) != null) {
            url = url.substring(1);
        }
        if (url == null || url.length() == 0) {
            url = DEFAULT_TARGET;
        }
        if (url.indexOf("://") == -1) {
            url = "http://" + url;
        }
        return url;
    }

    private boolean saveClick(HttpServletRequest request, String url) {
        WebUser wu;
        Properties ctx = JSPEnv.getCtx(request);
        MClick mc = new MClick(ctx, url, null);
        mc.setRemote_Addr(request.getRemoteAddr());
        mc.setRemote_Host(request.getRemoteHost());
        String ref = request.getHeader("referer");
        if (ref == null || ref.length() == 0) {
            ref = request.getRequestURL().toString();
        }
        mc.setReferrer(ref);
        mc.setAcceptLanguage(request.getHeader("accept-language"));
        mc.setUserAgent(request.getHeader("user-agent"));
        HttpSession session = request.getSession(false);
        if (session != null && (wu = (WebUser)session.getAttribute("webUser")) != null) {
            mc.setEMail(wu.getEmail());
            mc.setAD_User_ID(wu.getAD_User_ID());
        }
        return mc.save();
    }
}

