/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.wstore;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.Enumeration;
import java.util.Properties;
import java.util.logging.Level;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.WebEnv;
import org.compiere.util.WebUtil;
import org.compiere.wstore.JSPEnv;
import org.compiere.wstore.PriceList;
import org.compiere.wstore.PriceListProduct;
import org.compiere.wstore.WebBasket;
import org.compiere.wstore.WebBasketLine;

@WebServlet(name="basketServlet", urlPatterns={"/basketServlet"})
public class BasketServlet
extends HttpServlet {
    private static final long serialVersionUID = 3636119916937667318L;
    private static CLogger log = CLogger.getCLogger(BasketServlet.class);
    public static final String NAME = "basketServlet";
    public static final String P_SalesRep_ID = "SalesRep_ID";
    public static final String P_Product_ID = "M_Product_ID";

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        if (!WebEnv.initWeb((ServletConfig)config)) {
            throw new ServletException("BasketServlet.init");
        }
    }

    public String getServletInfo() {
        return "Adempiere Web Basket";
    }

    public void destroy() {
        log.fine("");
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        PriceList pl;
        if (log.isLoggable(Level.INFO)) {
            log.info("From " + request.getRemoteHost() + " - " + request.getRemoteAddr() + " - " + request.getRequestURL());
        }
        Properties ctx = JSPEnv.getCtx(request);
        HttpSession session = request.getSession(true);
        session.removeAttribute("hdrMessage");
        WebBasket wb = (WebBasket)session.getAttribute("webBasket");
        if (wb == null) {
            wb = new WebBasket();
        }
        session.setAttribute("webBasket", (Object)wb);
        int SalesRep_ID = WebUtil.getParameterAsInt((HttpServletRequest)request, (String)P_SalesRep_ID);
        if (SalesRep_ID != 0) {
            wb.setSalesRep_ID(SalesRep_ID);
            if (log.isLoggable(Level.FINE)) {
                log.fine("SalesRep_ID=" + SalesRep_ID);
            }
        }
        if ((pl = (PriceList)session.getAttribute("priceList")) == null) {
            log.fine("No Price List in session");
            pl = (PriceList)request.getAttribute("priceList");
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("PL=" + pl);
        }
        this.deleteLine(request, wb);
        this.addLine(request, pl, wb);
        if (log.isLoggable(Level.INFO)) {
            log.info(wb.toString());
        }
        String url = "/basket.jsp";
        if (log.isLoggable(Level.INFO)) {
            log.info("Forward to " + url);
        }
        RequestDispatcher dispatcher = this.getServletContext().getRequestDispatcher(url);
        dispatcher.forward((ServletRequest)request, (ServletResponse)response);
    }

    private void addLine(HttpServletRequest request, PriceList pl, WebBasket wb) {
        PriceListProduct plp;
        Properties ctx = JSPEnv.getCtx(request);
        HttpSession session = request.getSession(true);
        int M_PriceList_ID = WebUtil.getParameterAsInt((HttpServletRequest)request, (String)"M_PriceList_ID");
        int M_PriceList_Version_ID = WebUtil.getParameterAsInt((HttpServletRequest)request, (String)"M_PriceList_Version_ID");
        wb.setM_PriceList_ID(M_PriceList_ID);
        wb.setM_PriceList_Version_ID(M_PriceList_Version_ID);
        int M_Product_ID = WebUtil.getParameterAsInt((HttpServletRequest)request, (String)P_Product_ID);
        String Name = WebUtil.getParameter((HttpServletRequest)request, (String)"Name");
        String sQuantity = WebUtil.getParameter((HttpServletRequest)request, (String)"Quantity");
        String sPrice = WebUtil.getParameter((HttpServletRequest)request, (String)"Price");
        Enumeration en = request.getParameterNames();
        while (M_Product_ID == 0 && en.hasMoreElements()) {
            String parameter = (String)en.nextElement();
            if (!parameter.startsWith("Add_") || !WebUtil.exists((HttpServletRequest)request, (String)parameter)) continue;
            try {
                M_Product_ID = Integer.parseInt(parameter.substring(4));
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Found Parameter=" + parameter + " -> " + M_Product_ID);
                }
                if (!WebUtil.exists((String)sQuantity)) {
                    sQuantity = WebUtil.getParameter((HttpServletRequest)request, (String)("Qty_" + M_Product_ID));
                }
                if (!WebUtil.exists((String)sPrice)) {
                    sPrice = WebUtil.getParameter((HttpServletRequest)request, (String)("Price_" + M_Product_ID));
                }
                if (!WebUtil.exists((String)Name)) {
                    Name = WebUtil.getParameter((HttpServletRequest)request, (String)("Name_" + M_Product_ID));
                }
                if (!log.isLoggable(Level.FINE)) continue;
                log.fine("Found Parameters " + Name + ",Qty=" + sQuantity + ",Price=" + sPrice);
            }
            catch (Exception ex) {
                log.warning("ParseError for " + parameter + " - " + ex.toString());
            }
        }
        if (M_Product_ID == 0) {
            return;
        }
        BigDecimal Qty = null;
        try {
            if (sQuantity != null && sQuantity.length() > 0) {
                Qty = new BigDecimal(sQuantity);
            }
        }
        catch (Exception ex1) {
            log.warning("(qty) - " + ex1.toString());
        }
        if (Qty == null) {
            Qty = Env.ONE;
        }
        BigDecimal Price = null;
        if (M_Product_ID != 0 && pl != null && (plp = pl.getPriceListProduct(M_Product_ID)) != null) {
            Price = plp.getPrice();
            Name = plp.getName();
            if (log.isLoggable(Level.FINE)) {
                log.fine("Found in PL = " + Name + " - " + Price);
            }
        }
        if (Price == null && (pl == null || pl.isNotAllPrices())) {
            int AD_Client_ID = Env.getContextAsInt((Properties)ctx, (String)"AD_Client_ID");
            pl = PriceList.get(ctx, AD_Client_ID, M_PriceList_ID, null, null, true);
            session.setAttribute("priceList", (Object)pl);
            PriceListProduct plp2 = pl.getPriceListProduct(M_Product_ID);
            if (plp2 != null) {
                Price = plp2.getPrice();
                Name = plp2.getName();
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Found in complete PL = " + Name + " - " + Price);
                }
            }
        }
        if (Price != null) {
            WebBasketLine wbl = wb.add(M_Product_ID, Name, Qty, Price);
            if (log.isLoggable(Level.FINE)) {
                log.fine(wbl.toString());
            }
        } else {
            log.warning("Product Price not found - M_Product_ID=" + M_Product_ID + ", Name=" + Name);
        }
    }

    private void deleteLine(HttpServletRequest request, WebBasket wb) {
        try {
            String enc = request.getCharacterEncoding();
            if (enc == null) {
                request.setCharacterEncoding("UTF-8");
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Set CharacterEncoding=UTF-8", (Throwable)e);
        }
        Enumeration en = request.getParameterNames();
        while (en.hasMoreElements()) {
            String parameter = (String)en.nextElement();
            if (!parameter.startsWith("Delete_")) continue;
            try {
                int line = Integer.parseInt(parameter.substring(7));
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Delete parameter=" + parameter + " -> " + line);
                }
                wb.delete(line);
            }
            catch (NumberFormatException ex) {
                log.warning("ParseError for " + parameter + " - " + ex.toString());
            }
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }
}

