/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.wstore;

import java.io.IOException;
import java.util.Properties;
import java.util.logging.Level;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.compiere.model.MAdvertisement;
import org.compiere.util.CLogger;
import org.compiere.util.WebEnv;
import org.compiere.util.WebUser;
import org.compiere.util.WebUtil;
import org.compiere.wstore.JSPEnv;

@WebServlet(name="advertisementServlet", urlPatterns={"/advertisementServlet"})
public class AdvertisementServlet
extends HttpServlet {
    private static final long serialVersionUID = -1795015577057042600L;
    private static CLogger log = CLogger.getCLogger(AdvertisementServlet.class);
    public static final String NAME = "AdvertisementServlet";
    public static final String P_ADVERTISEMENT_ID = "W_Advertisement_ID";

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        if (!WebEnv.initWeb((ServletConfig)config)) {
            throw new ServletException("AdvertisementServlet.init");
        }
    }

    public String getServletInfo() {
        return "Adempiere Web Avertisement Servlet";
    }

    public void destroy() {
        log.fine("");
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (log.isLoggable(Level.INFO)) {
            log.info("Get from " + request.getRemoteHost() + " - " + request.getRemoteAddr() + " - forward to request.jsp");
        }
        if (!response.isCommitted()) {
            response.sendRedirect("advertisements.jsp");
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String ClickTargetURL;
        String AdText;
        String Description;
        if (log.isLoggable(Level.INFO)) {
            log.info("Post from " + request.getRemoteHost() + " - " + request.getRemoteAddr());
        }
        HttpSession session = request.getSession(true);
        session.removeAttribute("hdrMessage");
        Properties ctx = JSPEnv.getCtx(request);
        WebUser wu = (WebUser)session.getAttribute("webUser");
        if (wu == null) {
            log.warning("No web user");
            if (!response.isCommitted()) {
                response.sendRedirect("loginServlet?ForwardTo=advertisement.jsp");
            }
            return;
        }
        int W_Advertisement_ID = WebUtil.getParameterAsInt((HttpServletRequest)request, (String)P_ADVERTISEMENT_ID);
        MAdvertisement ad = new MAdvertisement(ctx, W_Advertisement_ID, null);
        if (ad.get_ID() == 0) {
            WebUtil.createForwardPage((HttpServletResponse)response, (String)"Web Advertisement Not Found", (String)"advertisements.jsp", (int)0);
            return;
        }
        StringBuilder info = new StringBuilder();
        String Name = WebUtil.getParameter((HttpServletRequest)request, (String)"Name");
        if (Name != null && Name.length() > 0 && !Name.equals(ad.getName())) {
            ad.setName(Name);
            info.append("Name - ");
        }
        if ((Description = WebUtil.getParameter((HttpServletRequest)request, (String)"Description")) != null && Description.length() > 0 && !Description.equals(ad.getDescription())) {
            ad.setDescription(Description);
            info.append("Description - ");
        }
        if ((AdText = WebUtil.getParameter((HttpServletRequest)request, (String)"AdText")) != null && AdText.length() > 0 && !AdText.equals(ad.getAdText())) {
            ad.setAdText(AdText);
            info.append("AdText - ");
        }
        if ((ClickTargetURL = WebUtil.getParameter((HttpServletRequest)request, (String)"ClickTargetURL")) != null && ClickTargetURL.length() > 0 && !ClickTargetURL.equals(ad.getClickTargetURL())) {
            ad.setClickTargetURL(ClickTargetURL);
            info.append("ClickTargetURL - ");
        }
        if (info.length() > 0) {
            if (ad.save()) {
                WebUtil.createForwardPage((HttpServletResponse)response, (String)("Web Advertisement Updated: " + info.toString()), (String)"advertisements.jsp", (int)0);
            } else {
                WebUtil.createForwardPage((HttpServletResponse)response, (String)"Web Advertisement Update Error", (String)"advertisements.jsp", (int)0);
            }
        } else {
            WebUtil.createForwardPage((HttpServletResponse)response, (String)"Web Advertisement not changed", (String)"advertisements.jsp", (int)0);
        }
    }
}

