/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.CalloutEngine;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.util.Env;

public class CalloutProject
extends CalloutEngine {
    public String planned(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        BigDecimal PlannedAmt;
        BigDecimal PlannedPrice;
        if (this.isCalloutActive() || value == null) {
            return "";
        }
        int StdPrecision = Env.getContextAsInt((Properties)ctx, (int)WindowNo, (String)"StdPrecision");
        BigDecimal PlannedQty = (BigDecimal)mTab.getValue("PlannedQty");
        if (PlannedQty == null) {
            PlannedQty = Env.ONE;
        }
        if ((PlannedPrice = (BigDecimal)mTab.getValue("PlannedPrice")) == null) {
            PlannedPrice = Env.ZERO;
        }
        if ((PlannedAmt = PlannedQty.multiply(PlannedPrice)).scale() > StdPrecision) {
            PlannedAmt = PlannedAmt.setScale(StdPrecision, RoundingMode.HALF_UP);
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("PlannedQty=" + PlannedQty + " * PlannedPrice=" + PlannedPrice + " -> PlannedAmt=" + PlannedAmt + " (Precision=" + StdPrecision + ")");
        }
        mTab.setValue("PlannedAmt", (Object)PlannedAmt);
        return "";
    }
}

