/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.model;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Timestamp;
import java.util.Properties;
import org.adempiere.base.Core;
import org.adempiere.base.IProductPricing;
import org.compiere.model.CalloutEngine;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.model.MCharge;
import org.compiere.model.MInOutLine;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MRMA;
import org.compiere.model.Query;
import org.compiere.model.Tax;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class CalloutRMA
extends CalloutEngine {
    public String docType(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        Integer C_DocType_ID = (Integer)value;
        if (C_DocType_ID == null || C_DocType_ID == 0) {
            return "";
        }
        String sql = "SELECT d.IsSoTrx FROM C_DocType d WHERE C_DocType_ID=?";
        String docSOTrx = DB.getSQLValueString(null, (String)sql, (int)C_DocType_ID);
        boolean isSOTrx = "Y".equals(docSOTrx);
        mTab.setValue("IsSOTrx", (Object)isSOTrx);
        return "";
    }

    public String inoutline(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        Integer M_InOutLine_ID = (Integer)value;
        if (M_InOutLine_ID == null || M_InOutLine_ID == 0) {
            return "";
        }
        MInOutLine iol = new MInOutLine(ctx, M_InOutLine_ID.intValue(), null);
        int invoiceLine_ID = new Query(ctx, "C_InvoiceLine", "M_InOutLine_ID=?", null).setParameters(new Object[]{M_InOutLine_ID}).firstId();
        if (invoiceLine_ID <= 0) {
            invoiceLine_ID = 0;
        }
        if (invoiceLine_ID != 0) {
            MInvoiceLine invoiceLine = new MInvoiceLine(ctx, invoiceLine_ID, null);
            if (invoiceLine.getM_Product_ID() != 0) {
                mTab.setValue("M_Product_ID", (Object)invoiceLine.getM_Product_ID());
                mTab.setValue("C_Charge_ID", null);
            }
            if (invoiceLine.getC_Charge_ID() != 0) {
                mTab.setValue("C_Charge_ID", (Object)invoiceLine.getC_Charge_ID());
                mTab.setValue("M_Product_ID", null);
            }
            mTab.setValue("Qty", (Object)invoiceLine.getQtyEntered());
            mTab.setValue("Amt", (Object)invoiceLine.getPriceEntered());
            mTab.setValue("C_Tax_ID", (Object)invoiceLine.getC_Tax_ID());
            BigDecimal lineNetAmt = invoiceLine.getQtyEntered().multiply(invoiceLine.getPriceEntered());
            int precision = invoiceLine.getPrecision();
            if (lineNetAmt.scale() > precision) {
                lineNetAmt = lineNetAmt.setScale(precision, RoundingMode.HALF_UP);
            }
            mTab.setValue("LineNetAmt", (Object)lineNetAmt);
        } else if (iol.getC_OrderLine_ID() != 0) {
            MOrderLine orderLine = new MOrderLine(ctx, iol.getC_OrderLine_ID(), null);
            if (orderLine.getM_Product_ID() != 0) {
                mTab.setValue("M_Product_ID", (Object)orderLine.getM_Product_ID());
                mTab.setValue("C_Charge_ID", null);
            }
            if (orderLine.getC_Charge_ID() != 0) {
                mTab.setValue("C_Charge_ID", (Object)orderLine.getC_Charge_ID());
                mTab.setValue("M_Product_ID", null);
            }
            mTab.setValue("Qty", (Object)orderLine.getQtyEntered());
            mTab.setValue("Amt", (Object)orderLine.getPriceEntered());
            mTab.setValue("C_Tax_ID", (Object)orderLine.getC_Tax_ID());
            BigDecimal lineNetAmt = orderLine.getQtyEntered().multiply(orderLine.getPriceEntered());
            int precision = orderLine.getPrecision();
            if (lineNetAmt.scale() > precision) {
                lineNetAmt = lineNetAmt.setScale(precision, RoundingMode.HALF_UP);
            }
            mTab.setValue("LineNetAmt", (Object)lineNetAmt);
        }
        return "";
    }

    public String product(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        BigDecimal lineNetAmt;
        if (this.isCalloutActive() || value == null) {
            return "";
        }
        Integer M_Product_ID = (Integer)value;
        if (M_Product_ID == null || M_Product_ID == 0) {
            return "";
        }
        Integer M_RMA_ID = (Integer)mTab.getValue("M_RMA_ID");
        if (M_RMA_ID == null || M_RMA_ID == 0) {
            return "";
        }
        Integer AD_Org_ID = (Integer)mTab.getValue("AD_Org_ID");
        if (AD_Org_ID == null || AD_Org_ID == 0) {
            return "";
        }
        MRMA rma = new MRMA(ctx, M_RMA_ID.intValue(), null);
        IProductPricing pp = Core.getProductPricing();
        pp.setInitialValues(M_Product_ID.intValue(), rma.getC_BPartner_ID(), Env.ONE, rma.isSOTrx(), null);
        int taxId = 0;
        int precision = 0;
        MInvoice invoice = rma.getOriginalInvoice();
        if (invoice != null) {
            pp.setM_PriceList_ID(invoice.getM_PriceList_ID());
            pp.setPriceDate(invoice.getDateInvoiced());
            precision = invoice.getPrecision();
            taxId = Tax.get((Properties)ctx, (int)M_Product_ID, (int)0, (Timestamp)invoice.getDateInvoiced(), (Timestamp)invoice.getDateInvoiced(), (int)AD_Org_ID, (int)rma.getShipment().getM_Warehouse_ID(), (int)invoice.getC_BPartner_Location_ID(), (int)invoice.getC_BPartner_Location_ID(), (boolean)rma.isSOTrx(), null);
        } else {
            MOrder order = rma.getOriginalOrder();
            if (order != null) {
                pp.setM_PriceList_ID(order.getM_PriceList_ID());
                pp.setPriceDate(order.getDateOrdered());
                precision = order.getPrecision();
                taxId = Tax.get((Properties)ctx, (int)M_Product_ID, (int)0, (Timestamp)order.getDateOrdered(), (Timestamp)order.getDateOrdered(), (int)AD_Org_ID, (int)order.getM_Warehouse_ID(), (int)order.getC_BPartner_Location_ID(), (int)order.getC_BPartner_Location_ID(), (boolean)rma.isSOTrx(), null);
            } else {
                return "No Invoice/Order found the Shipment/Receipt associated";
            }
        }
        pp.calculatePrice();
        mTab.setValue("Qty", (Object)Env.ONE);
        mTab.setValue("Amt", (Object)pp.getPriceStd());
        if (taxId != 0) {
            mTab.setValue("C_Tax_ID", (Object)taxId);
        }
        if ((lineNetAmt = Env.ONE.multiply(pp.getPriceStd())).scale() > precision) {
            lineNetAmt = lineNetAmt.setScale(precision, RoundingMode.HALF_UP);
        }
        mTab.setValue("LineNetAmt", (Object)lineNetAmt);
        return "";
    }

    public String charge(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        if (this.isCalloutActive() || value == null) {
            return "";
        }
        Integer C_Charge_ID = (Integer)value;
        if (C_Charge_ID == null || C_Charge_ID == 0) {
            return "";
        }
        Integer M_RMA_ID = (Integer)mTab.getValue("M_RMA_ID");
        if (M_RMA_ID == null || M_RMA_ID == 0) {
            return "";
        }
        Integer AD_Org_ID = (Integer)mTab.getValue("AD_Org_ID");
        if (AD_Org_ID == null || AD_Org_ID == 0) {
            return "";
        }
        MCharge charge = MCharge.get((Properties)ctx, (int)C_Charge_ID);
        String sql = "SELECT C_Tax_ID FROM C_Tax WHERE AD_Client_ID=? AND IsActive='Y' AND IsTaxExempt='Y' AND ValidFrom < SYSDATE ORDER BY IsDefault DESC";
        int taxId = DB.getSQLValueEx(null, (String)sql, (Object[])new Object[]{Env.getAD_Client_ID((Properties)ctx)});
        mTab.setValue("Qty", (Object)Env.ONE);
        mTab.setValue("Amt", (Object)charge.getChargeAmt());
        if (taxId != 0) {
            mTab.setValue("C_Tax_ID", (Object)taxId);
        }
        MRMA rma = new MRMA(ctx, M_RMA_ID.intValue(), null);
        int precision = 0;
        MInvoice invoice = rma.getOriginalInvoice();
        if (invoice != null) {
            precision = invoice.getPrecision();
        } else {
            MOrder order = rma.getOriginalOrder();
            if (order != null) {
                precision = order.getPrecision();
            } else {
                return "No Invoice/Order found the Shipment/Receipt associated";
            }
        }
        BigDecimal lineNetAmt = Env.ONE.multiply(charge.getChargeAmt());
        if (lineNetAmt.scale() > precision) {
            lineNetAmt = lineNetAmt.setScale(precision, RoundingMode.HALF_UP);
        }
        mTab.setValue("LineNetAmt", (Object)lineNetAmt);
        return "";
    }
}

