/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.grid;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.grid.PaymentForm;
import org.compiere.model.GridTab;
import org.compiere.model.MBankAccountProcessor;
import org.compiere.model.MInvoice;
import org.compiere.model.MOrder;
import org.compiere.model.MPayment;
import org.compiere.model.MRole;
import org.compiere.model.PO;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;

public abstract class PaymentFormCheck
extends PaymentForm {
    private static final String PAYMENTRULE = "S";
    public int m_C_Payment_ID = 0;
    public MPayment m_mPayment = null;
    public MPayment m_mPaymentOriginal = null;
    public int m_C_BankAccount_ID = 0;
    public KeyNamePair selectedBankAccount;
    public String processMsg = null;

    public PaymentFormCheck(int windowNo, GridTab mTab) {
        super(windowNo, mTab);
    }

    @Override
    public void loadData() {
        if (this.getGridTab().getValue("C_Payment_ID") != null) {
            this.m_C_Payment_ID = (Integer)this.getGridTab().getValue("C_Payment_ID");
            if (this.m_C_Payment_ID != 0) {
                this.m_mPayment = new MPayment(Env.getCtx(), this.m_C_Payment_ID, null);
                this.m_mPaymentOriginal = new MPayment(Env.getCtx(), this.m_C_Payment_ID, null);
            }
        }
        if (this.m_mPayment == null) {
            this.m_mPayment = new MPayment(Env.getCtx(), 0, null);
            this.m_mPayment.setAD_Org_ID(this.m_AD_Org_ID);
            this.m_mPayment.setAmount(this.m_C_Currency_ID, this.m_Amount);
        }
        if (this.m_C_Payment_ID > 0 && this.m_mPayment != null) {
            this.m_C_BankAccount_ID = this.m_mPayment.getC_BankAccount_ID();
        }
    }

    public ArrayList<KeyNamePair> getBankAccountList() {
        ArrayList<KeyNamePair> list;
        block7: {
            this.selectedBankAccount = null;
            list = new ArrayList<KeyNamePair>();
            String SQL = MRole.getDefault().addAccessSQL("SELECT C_BankAccount_ID, ba.Name || ' ' || ba.AccountNo, ba.IsDefault FROM C_BankAccount ba INNER JOIN C_Bank b ON (ba.C_Bank_ID=b.C_Bank_ID) WHERE b.IsActive='Y' AND ba.IsActive='Y'", "ba", true, false);
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)SQL, null);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        int key = rs.getInt(1);
                        String name = rs.getString(2);
                        KeyNamePair pp = new KeyNamePair(key, name);
                        list.add(pp);
                        if (key == this.m_C_BankAccount_ID) {
                            this.selectedBankAccount = pp;
                        }
                        if (this.selectedBankAccount != null || !rs.getString(3).equals("Y")) continue;
                        this.selectedBankAccount = pp;
                    }
                }
                catch (SQLException ept) {
                    this.log.log(Level.SEVERE, SQL, (Throwable)ept);
                    DB.close((ResultSet)rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block7;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        return list;
    }

    @Override
    public boolean saveChanges() {
        boolean ok = super.saveChanges();
        if (this.m_mPayment != null) {
            this.m_mPayment.set_TrxName(null);
        }
        if (this.m_mPaymentOriginal != null) {
            this.m_mPaymentOriginal.set_TrxName(null);
        }
        return ok;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean save(int newC_BankAccount_ID, String routing, String number, String check, BigDecimal amount, String trxName) {
        String payTypes;
        if (this.m_mPayment != null) {
            this.m_mPayment.set_TrxName(trxName);
        }
        if (this.m_mPaymentOriginal != null) {
            this.m_mPaymentOriginal.set_TrxName(trxName);
        }
        this.processMsg = null;
        String string = payTypes = this.m_Cash_As_Payment ? "KTSDB" : "KTSD";
        if (!PAYMENTRULE.equals(this.m_PaymentRule)) {
            boolean ok;
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("Changed PaymentRule: " + this.m_PaymentRule + " -> " + PAYMENTRULE);
            }
            if (payTypes.indexOf(this.m_PaymentRule) != -1 && payTypes.indexOf(PAYMENTRULE) != -1 && this.m_mPaymentOriginal != null) {
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Old Payment(1) - " + this.m_mPaymentOriginal);
                }
                this.m_mPaymentOriginal.setDocAction("RC");
                ok = this.m_mPaymentOriginal.processIt("RC");
                this.m_mPaymentOriginal.saveEx();
                if (!ok) {
                    this.processMsg = String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"PaymentNotCancelled")) + " " + this.m_mPaymentOriginal.getDocumentNo();
                    throw new AdempiereException(this.processMsg);
                }
                if (this.log.isLoggable(Level.INFO)) {
                    this.log.info("Payment Cancelled - " + this.m_mPaymentOriginal);
                }
                this.m_mPayment.resetNew();
            } else if (payTypes.indexOf(this.m_PaymentRule) != -1 && payTypes.indexOf(PAYMENTRULE) == -1) {
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Old Payment(2) - " + this.m_mPaymentOriginal);
                }
                if (this.m_mPaymentOriginal != null) {
                    this.m_mPaymentOriginal.setDocAction("RC");
                    ok = this.m_mPaymentOriginal.processIt("RC");
                    this.m_mPaymentOriginal.saveEx();
                    if (!ok) {
                        this.processMsg = String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"PaymentNotCancelled")) + " " + this.m_mPayment.getDocumentNo();
                        throw new AdempiereException(this.processMsg);
                    }
                    if (this.log.isLoggable(Level.FINE)) {
                        this.log.fine("PaymentCancelled " + this.m_mPayment.getDocumentNo());
                    }
                    this.getGridTab().getTableModel().dataSave(true);
                    this.m_mPayment.resetNew();
                    this.m_mPayment.setAmount(this.m_C_Currency_ID, this.m_Amount);
                }
            }
        }
        int C_Order_ID = Env.getContextAsInt((Properties)Env.getCtx(), (int)this.getWindowNo(), (String)"C_Order_ID");
        int C_Invoice_ID = Env.getContextAsInt((Properties)Env.getCtx(), (int)this.getWindowNo(), (String)"C_Invoice_ID");
        if (C_Invoice_ID == 0 && this.m_DocStatus.equals("CO")) {
            C_Invoice_ID = this.getInvoiceID(C_Order_ID);
        }
        boolean negateAmt = false;
        MInvoice invoice = null;
        if (C_Invoice_ID != 0) {
            invoice = new MInvoice(Env.getCtx(), C_Invoice_ID, null);
            negateAmt = invoice.isCreditMemo();
        }
        MOrder order = null;
        if (invoice == null && C_Order_ID != 0) {
            order = new MOrder(Env.getCtx(), C_Order_ID, null);
        }
        BigDecimal payAmount = amount;
        if (negateAmt) {
            payAmount = amount.negate();
        }
        if (this.log.isLoggable(Level.CONFIG)) {
            this.log.config("C_Order_ID=" + C_Order_ID + ", C_Invoice_ID=" + C_Invoice_ID + ", NegateAmt=" + negateAmt);
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Payment - S");
        }
        this.m_mPayment.setAmount(this.m_C_Currency_ID, payAmount);
        this.m_mPayment.setBankCheck(newC_BankAccount_ID, this.m_isSOTrx, routing, number, check);
        this.m_mPayment.setC_BPartner_ID(this.m_C_BPartner_ID);
        this.m_mPayment.setC_Invoice_ID(C_Invoice_ID);
        if (order != null) {
            this.m_mPayment.setC_Order_ID(C_Order_ID);
            this.m_needSave = true;
        }
        this.m_mPayment.setDateTrx(this.m_DateAcct);
        this.m_mPayment.setDateAcct(this.m_DateAcct);
        this.setCustomizeValues((PO)this.m_mPayment);
        this.m_mPayment.saveEx();
        if (this.m_mPayment.get_ID() > 0 && "DR".equals(this.m_mPayment.getDocStatus())) {
            boolean ok = this.m_mPayment.processIt("CO");
            this.m_mPayment.saveEx();
            if (!ok) {
                this.processMsg = Msg.getMsg((Properties)Env.getCtx(), (String)"PaymentNotCreated");
                throw new AdempiereException(this.processMsg);
            }
            this.processMsg = this.m_mPayment.getDocumentNo();
        } else if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("NotDraft " + this.m_mPayment);
        }
        this.log.config("Saving changes");
        if (this.m_mPayment.getC_Payment_ID() == this.m_C_Payment_ID) return true;
        if (this.m_mPayment.getC_Payment_ID() == 0) {
            this.getGridTab().setValue("C_Payment_ID", null);
            return true;
        }
        this.getGridTab().setValue("C_Payment_ID", (Object)this.m_mPayment.getC_Payment_ID());
        return true;
    }

    public boolean isBankAccountProcessorExist(int C_Currency_ID, BigDecimal PayAmt) {
        return this.isBankAccountProcessorExist(Env.getCtx(), "K", "", Env.getAD_Client_ID((Properties)Env.getCtx()), C_Currency_ID, PayAmt, null);
    }

    public MBankAccountProcessor getBankAccountProcessor(int C_Currency_ID, BigDecimal PayAmt) {
        return this.getBankAccountProcessor(Env.getCtx(), "K", "", Env.getAD_Client_ID((Properties)Env.getCtx()), C_Currency_ID, PayAmt, null);
    }
}

