/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.grid;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import org.compiere.apps.IStatusBar;
import org.compiere.grid.CreateFrom;
import org.compiere.minigrid.IMiniTable;
import org.compiere.model.GridTab;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.MPackage;
import org.compiere.model.MPackageLine;
import org.compiere.model.MPackageMPS;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;

public abstract class CreateFromPackageShipment
extends CreateFrom {
    public CreateFromPackageShipment(GridTab gridTab) {
        super(gridTab);
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(gridTab.toString());
        }
    }

    @Override
    public boolean dynInit() throws Exception {
        this.log.config("");
        this.setTitle(String.valueOf(Msg.getElement((Properties)Env.getCtx(), (String)"M_PackageMPS_ID", (boolean)false)) + " .. " + Msg.translate((Properties)Env.getCtx(), (String)"CreateFrom"));
        return true;
    }

    protected Vector<Vector<Object>> getShipmentData(int M_InOut_ID) {
        Vector<Vector<Object>> data;
        block7: {
            if (this.log.isLoggable(Level.CONFIG)) {
                this.log.config("M_InOut_ID=" + M_InOut_ID);
            }
            data = new Vector<Vector<Object>>();
            StringBuilder sqlStmt = new StringBuilder();
            sqlStmt.append("SELECT M_InOutLine_ID, Line, Qty, M_Product_ID, ProductName, UOM ");
            sqlStmt.append("FROM M_PACKAGELINES_AVAIL_V ");
            sqlStmt.append("WHERE M_InOut_ID = ? ");
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sqlStmt.toString(), null);
                    pstmt.setInt(1, M_InOut_ID);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        Vector<Object> line = new Vector<Object>(6);
                        line.add(Boolean.FALSE);
                        KeyNamePair lineKNPair = new KeyNamePair(rs.getInt(1), rs.getString(2));
                        line.add(lineKNPair);
                        line.add(rs.getBigDecimal(3));
                        KeyNamePair productKNPair = new KeyNamePair(rs.getInt(4), rs.getString(5));
                        line.add(productKNPair);
                        line.add(rs.getString(6));
                        data.add(line);
                    }
                }
                catch (SQLException e) {
                    this.log.log(Level.SEVERE, sqlStmt.toString(), (Throwable)e);
                    DB.close((ResultSet)rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block7;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        return data;
    }

    @Override
    public void info(IMiniTable miniTable, IStatusBar statusBar) {
    }

    protected void configureMiniTable(IMiniTable miniTable) {
        miniTable.setColumnClass(0, Boolean.class, false);
        miniTable.setColumnClass(1, String.class, true);
        miniTable.setColumnClass(2, BigDecimal.class, false);
        miniTable.setColumnClass(3, String.class, true);
        miniTable.setColumnClass(4, String.class, true);
        miniTable.autoSize();
    }

    @Override
    public boolean save(IMiniTable miniTable, String trxName) {
        int M_PackageMPS_ID = (Integer)this.getGridTab().getValue("M_PackageMPS_ID");
        MPackageMPS packageMPS = new MPackageMPS(Env.getCtx(), M_PackageMPS_ID, null);
        MPackage mPackage = new MPackage(Env.getCtx(), packageMPS.getM_Package_ID(), null);
        MInOut shipment = new MInOut(Env.getCtx(), mPackage.getM_InOut_ID(), null);
        MInOutLine[] shipmentLines = shipment.getLines(false);
        HashMap<Integer, MInOutLine> lineMap = new HashMap<Integer, MInOutLine>();
        int k = 0;
        while (k < shipmentLines.length) {
            MInOutLine line = shipmentLines[k];
            lineMap.put(line.getM_InOutLine_ID(), line);
            ++k;
        }
        int i = 0;
        while (i < miniTable.getRowCount()) {
            if (((Boolean)miniTable.getValueAt(i, 0)).booleanValue()) {
                BigDecimal qty = (BigDecimal)miniTable.getValueAt(i, 2);
                KeyNamePair pp = (KeyNamePair)miniTable.getValueAt(i, 1);
                KeyNamePair prod = (KeyNamePair)miniTable.getValueAt(i, 3);
                int inOutLineId = pp.getKey();
                int productId = prod.getKey();
                MPackageLine packageLine = new MPackageLine(mPackage);
                packageLine.setInOutLine((MInOutLine)lineMap.get(inOutLineId));
                packageLine.setM_Product_ID(productId);
                packageLine.setQty(qty);
                packageLine.setM_PackageMPS_ID(M_PackageMPS_ID);
                if (!packageLine.save(mPackage.get_TrxName())) {
                    throw new IllegalStateException("Could not create Package Line");
                }
            }
            ++i;
        }
        return true;
    }

    protected Vector<String> getOISColumnNames() {
        Vector<String> columnNames = new Vector<String>(5);
        columnNames.add(Msg.getMsg((Properties)Env.getCtx(), (String)"Select"));
        columnNames.add(Msg.getMsg((Properties)Env.getCtx(), (String)"Line"));
        columnNames.add(Msg.translate((Properties)Env.getCtx(), (String)"Quantity"));
        columnNames.add(Msg.translate((Properties)Env.getCtx(), (String)"M_Product_ID"));
        columnNames.add(Msg.translate((Properties)Env.getCtx(), (String)"C_UOM_ID"));
        return columnNames;
    }
}

